/*
 * Decompiled with CFR 0.152.
 */
package org.argouml.model.euml;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.argouml.model.Model;
import org.argouml.model.UmlHelper;
import org.argouml.model.euml.EUMLModelImplementation;
import org.eclipse.emf.common.util.EList;
import org.eclipse.uml2.uml.Action;
import org.eclipse.uml2.uml.ActivityEdge;
import org.eclipse.uml2.uml.Behavior;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Enumeration;
import org.eclipse.uml2.uml.EnumerationLiteral;
import org.eclipse.uml2.uml.Extend;
import org.eclipse.uml2.uml.ExtensionPoint;
import org.eclipse.uml2.uml.Feature;
import org.eclipse.uml2.uml.Message;
import org.eclipse.uml2.uml.Operation;
import org.eclipse.uml2.uml.Parameter;
import org.eclipse.uml2.uml.ParameterSet;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.Relationship;
import org.eclipse.uml2.uml.Transition;
import org.eclipse.uml2.uml.UseCase;

class UmlHelperEUMLImpl
implements UmlHelper {
    private EUMLModelImplementation modelImpl;

    public UmlHelperEUMLImpl(EUMLModelImplementation implementation) {
        this.modelImpl = implementation;
    }

    public void addListenersToModel(Object model) {
    }

    public void deleteCollection(Collection col) {
        Iterator it = col.iterator();
        while (it.hasNext()) {
            this.modelImpl.getUmlFactory().delete(it.next());
        }
    }

    public Object getSource(Object relationship) {
        if (relationship instanceof Relationship) {
            return this.modelImpl.getCoreHelper().getSource(relationship);
        }
        if (relationship instanceof Transition) {
            return this.modelImpl.getStateMachinesHelper().getSource(relationship);
        }
        if (relationship instanceof ActivityEdge) {
            return ((ActivityEdge)relationship).getSource();
        }
        if (relationship instanceof Property) {
            return this.modelImpl.getCoreHelper().getSource(relationship);
        }
        if (relationship instanceof Message) {
            return this.modelImpl.getFacade().getSender(relationship);
        }
        throw new IllegalArgumentException("Getting source of this object is not implemented" + relationship);
    }

    public Object getDestination(Object relationship) {
        if (relationship instanceof Relationship) {
            return this.modelImpl.getCoreHelper().getDestination(relationship);
        }
        if (relationship instanceof ActivityEdge) {
            return ((ActivityEdge)relationship).getTarget();
        }
        if (relationship instanceof Transition) {
            return this.modelImpl.getStateMachinesHelper().getDestination(relationship);
        }
        if (relationship instanceof Property) {
            return this.modelImpl.getCoreHelper().getDestination(relationship);
        }
        if (relationship instanceof Message) {
            return this.modelImpl.getFacade().getReceiver(relationship);
        }
        throw new IllegalArgumentException("Getting destination of this object is not implemented" + relationship);
    }

    public void move(Object parent, Object element, UmlHelper.Direction direction) {
        if (element instanceof Feature) {
            Feature att = (Feature)element;
            Element cls = att.getOwner();
            List f = Model.getFacade().getFeatures(cls);
            int oldIndex = f.indexOf(att);
            int newIndex = this.newPosition(oldIndex, f.size(), direction);
            Model.getCoreHelper().removeFeature(cls, att);
            Model.getCoreHelper().addFeature(cls, newIndex, att);
        } else if (element instanceof Parameter && parent instanceof Behavior) {
            Parameter param = (Parameter)element;
            Behavior behavior = (Behavior)parent;
            EList f = behavior.getOwnedParameters();
            int oldIndex = f.indexOf(param);
            int newIndex = this.newPosition(oldIndex, f.size(), direction);
            f.remove(param);
            f.add(newIndex, param);
        } else if (element instanceof Parameter && parent instanceof ParameterSet) {
            Parameter param = (Parameter)element;
            ParameterSet set = (ParameterSet)parent;
            EList f = set.getParameters();
            int oldIndex = f.indexOf(param);
            int newIndex = this.newPosition(oldIndex, f.size(), direction);
            f.remove(param);
            f.add(newIndex, param);
        } else if (element instanceof Parameter) {
            Parameter param = (Parameter)element;
            Operation operation = param.getOperation();
            EList f = operation.getOwnedParameters();
            int oldIndex = f.indexOf(param);
            int newIndex = this.newPosition(oldIndex, f.size(), direction);
            f.remove(param);
            f.add(newIndex, param);
        } else if (element instanceof EnumerationLiteral) {
            EnumerationLiteral lit = (EnumerationLiteral)element;
            Enumeration enumeration = lit.getEnumeration();
            EList f = enumeration.getOwnedLiterals();
            int oldIndex = f.indexOf(lit);
            int newIndex = this.newPosition(oldIndex, f.size(), direction);
            f.remove(lit);
            f.add(newIndex, lit);
        } else if (element instanceof ExtensionPoint && parent instanceof Extend) {
            ExtensionPoint ep = (ExtensionPoint)element;
            Extend extend = (Extend)parent;
            EList f = extend.getExtensionLocations();
            int oldIndex = f.indexOf(ep);
            int newIndex = this.newPosition(oldIndex, f.size(), direction);
            f.remove(ep);
            f.add(newIndex, ep);
        } else if (element instanceof ExtensionPoint && parent instanceof UseCase) {
            ExtensionPoint ep = (ExtensionPoint)element;
            UseCase extend = ep.getUseCase();
            ArrayList<ExtensionPoint> f = new ArrayList<ExtensionPoint>(Model.getFacade().getExtensionPoints(extend));
            int oldIndex = f.indexOf(ep);
            int newIndex = this.newPosition(oldIndex, f.size(), direction);
            f.remove(ep);
            f.add(newIndex, ep);
            Model.getUseCasesHelper().setExtensionPoints(ep, f);
        }
    }

    private int newPosition(int index, int size, UmlHelper.Direction direction) {
        int posn = direction == UmlHelper.Direction.DOWN ? index + 1 : (direction == UmlHelper.Direction.UP ? index - 1 : (direction == UmlHelper.Direction.TOP ? 0 : (direction == UmlHelper.Direction.BOTTOM ? size : 0)));
        return posn;
    }

    public boolean isMovable(Object metaType) {
        Class[] movableMetaType = new Class[]{Action.class, EnumerationLiteral.class, Extend.class, ExtensionPoint.class, Operation.class, Parameter.class, Property.class};
        return Arrays.asList(movableMetaType).contains(metaType);
    }
}

