/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.mdr.storagemodel.transientimpl;

import java.lang.ref.ReferenceQueue;
import java.util.Collection;
import java.util.HashMap;
import java.util.Set;
import org.netbeans.mdr.persistence.MOFID;
import org.netbeans.mdr.persistence.SinglevaluedIndex;
import org.netbeans.mdr.persistence.Storage;
import org.netbeans.mdr.persistence.StorageBadRequestException;
import org.netbeans.mdr.persistence.StorageException;
import org.netbeans.mdr.storagemodel.transientimpl.CompensatingTransaction;
import org.netbeans.mdr.storagemodel.transientimpl.TransactionalIndex;
import org.netbeans.mdr.storagemodel.transientimpl.TransientIndex;

public class TransientObjectResolverIndex
extends TransactionalIndex
implements SinglevaluedIndex {
    public static final String NAME = "TRANSIENT_OBJECTS_RESOLVER";
    private HashMap map = new HashMap();
    private ReferenceQueue queue = new ReferenceQueue();

    public void add(Object key, Object value) throws StorageException {
        this.addNoTx(key, value);
        this.txlog.push(new CompensatingTransaction.AddCTx(key, value));
    }

    public void addNoTx(Object key, Object value) throws StorageException {
        this.map.put(key, new TransientIndex.KeyedReference(value, this.queue, (MOFID)key));
    }

    public boolean put(Object key, Object value) throws StorageException {
        throw new UnsupportedOperationException();
    }

    public void replace(Object key, Object value) throws StorageException {
        throw new UnsupportedOperationException();
    }

    public Object get(Object key) throws StorageException {
        Object result = this.getIfExists(key);
        if (result == null) {
            throw new StorageBadRequestException();
        }
        return result;
    }

    public Object getIfExists(Object key) throws StorageException {
        TransientIndex.KeyedReference entry = (TransientIndex.KeyedReference)this.map.get(key);
        if (entry == null) {
            return null;
        }
        return entry.get();
    }

    public Object getObjectIfExists(Object key, SinglevaluedIndex index) throws StorageException {
        TransientIndex.KeyedReference entry = (TransientIndex.KeyedReference)this.map.get(key);
        if (entry == null) {
            return null;
        }
        Object result = entry.get();
        if (result == null) {
            return null;
        }
        return index.get(result);
    }

    public Object getObject(Object key, SinglevaluedIndex index) throws StorageException {
        Object result = this.getObjectIfExists(key, index);
        if (result == null) {
            throw new StorageBadRequestException();
        }
        return result;
    }

    public Storage.EntryType getKeyType() throws StorageException {
        return Storage.EntryType.MOFID;
    }

    public String getName() throws StorageException {
        return NAME;
    }

    public Storage.EntryType getValueType() throws StorageException {
        return Storage.EntryType.STREAMABLE;
    }

    public Set keySet() throws StorageException {
        throw new UnsupportedOperationException();
    }

    public Collection values() throws StorageException {
        throw new UnsupportedOperationException();
    }

    public boolean remove(Object key) throws StorageException {
        Object result = this.removeNoTx(key, null);
        if (result != null) {
            this.txlog.push(new CompensatingTransaction.RemoveCTx(key, result));
            return true;
        }
        return false;
    }

    public Collection queryByKeyPrefix(Object prefix, SinglevaluedIndex repos) {
        throw new UnsupportedOperationException();
    }

    protected Object removeNoTx(Object key, Object value) throws StorageException {
        return this.map.remove(key);
    }
}

