/*
 * Decompiled with CFR 0.152.
 */
package org.anarres.cpp;

import java.io.IOException;
import java.util.Iterator;
import org.anarres.cpp.LexerException;
import org.anarres.cpp.Macro;
import org.anarres.cpp.Preprocessor;
import org.anarres.cpp.PreprocessorListener;
import org.anarres.cpp.SourceIterator;
import org.anarres.cpp.Token;
import org.anarres.cpp.Warning;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Source
implements Iterable<Token> {
    private Source parent = null;
    private boolean autopop = false;
    private PreprocessorListener listener;
    private boolean werror;

    void setParent(Source parent, boolean autopop) {
        this.parent = parent;
        this.autopop = autopop;
    }

    final Source getParent() {
        return this.parent;
    }

    void init(Preprocessor pp) {
        this.setListener(pp.getListener());
        this.werror = pp.getWarnings().contains((Object)Warning.ERROR);
    }

    public void setListener(PreprocessorListener pl) {
        this.listener = pl;
    }

    String getPath() {
        for (Source parent = this.getParent(); parent != null; parent = parent.getParent()) {
            String path = parent.getPath();
            if (path == null) continue;
            return path;
        }
        return null;
    }

    String getName() {
        for (Source parent = this.getParent(); parent != null; parent = parent.getParent()) {
            String name = parent.getName();
            if (name == null) continue;
            return name;
        }
        return null;
    }

    public int getLine() {
        Source parent = this.getParent();
        if (parent == null) {
            return 0;
        }
        return parent.getLine();
    }

    public int getColumn() {
        Source parent = this.getParent();
        if (parent == null) {
            return 0;
        }
        return parent.getColumn();
    }

    boolean isExpanding(Macro m) {
        Source parent = this.getParent();
        if (parent != null) {
            return parent.isExpanding(m);
        }
        return false;
    }

    boolean isAutopop() {
        return this.autopop;
    }

    boolean isNumbered() {
        return false;
    }

    public abstract Token token() throws IOException, LexerException;

    @Override
    public Iterator<Token> iterator() {
        return new SourceIterator(this);
    }

    public Token skipline(boolean white) throws IOException, LexerException {
        block5: while (true) {
            Token tok = this.token();
            switch (tok.getType()) {
                case 264: {
                    this.warning(tok.getLine(), tok.getColumn(), "No newline before end of file");
                    return tok;
                }
                case 283: {
                    return tok;
                }
                case 260: 
                case 292: {
                    continue block5;
                }
            }
            if (!white) continue;
            this.warning(tok.getLine(), tok.getColumn(), "Unexpected nonwhite token");
        }
    }

    protected void error(int line, int column, String msg) throws LexerException {
        if (this.listener == null) {
            throw new LexerException("Error at " + line + ":" + column + ": " + msg);
        }
        this.listener.handleError(this, line, column, msg);
    }

    protected void warning(int line, int column, String msg) throws LexerException {
        if (this.werror) {
            this.error(line, column, msg);
        } else if (this.listener != null) {
            this.listener.handleWarning(this, line, column, msg);
        } else {
            throw new LexerException("Warning at " + line + ":" + column + ": " + msg);
        }
    }
}

