/*
 * Decompiled with CFR 0.152.
 */
package org.anarres.cpp;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import org.anarres.cpp.Argument;
import org.anarres.cpp.Feature;
import org.anarres.cpp.FileLexerSource;
import org.anarres.cpp.FixedTokenSource;
import org.anarres.cpp.InternalException;
import org.anarres.cpp.JavaFileSystem;
import org.anarres.cpp.LexerException;
import org.anarres.cpp.LexerSource;
import org.anarres.cpp.Macro;
import org.anarres.cpp.MacroTokenSource;
import org.anarres.cpp.PreprocessorListener;
import org.anarres.cpp.Source;
import org.anarres.cpp.State;
import org.anarres.cpp.StringLexerSource;
import org.anarres.cpp.Token;
import org.anarres.cpp.VirtualFile;
import org.anarres.cpp.VirtualFileSystem;
import org.anarres.cpp.Warning;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Preprocessor {
    private static final boolean DEBUG = false;
    private static final Macro __LINE__ = new Macro("__LINE__");
    private static final Macro __FILE__ = new Macro("__FILE__");
    private Map<String, Macro> macros = new HashMap<String, Macro>();
    private Stack<State> states;
    private Source source;
    private List<String> quoteincludepath;
    private List<String> sysincludepath;
    private Set<Feature> features;
    private Set<Warning> warnings;
    private VirtualFileSystem filesystem;
    private PreprocessorListener listener;
    private Token source_token;
    private Token expr_token = null;
    private static final int PP_DEFINE = 1;
    private static final int PP_ELIF = 2;
    private static final int PP_ELSE = 3;
    private static final int PP_ENDIF = 4;
    private static final int PP_ERROR = 5;
    private static final int PP_IF = 6;
    private static final int PP_IFDEF = 7;
    private static final int PP_IFNDEF = 8;
    private static final int PP_INCLUDE = 9;
    private static final int PP_LINE = 10;
    private static final int PP_PRAGMA = 11;
    private static final int PP_UNDEF = 12;
    private static final int PP_WARNING = 13;
    private static final Map<String, Integer> ppcmds = new HashMap<String, Integer>();

    public Preprocessor() {
        this.macros.put(__LINE__.getName(), __LINE__);
        this.macros.put(__FILE__.getName(), __FILE__);
        this.states = new Stack();
        this.states.push(new State());
        this.source = null;
        this.quoteincludepath = new ArrayList<String>();
        this.sysincludepath = new ArrayList<String>();
        this.features = EnumSet.noneOf(Feature.class);
        this.warnings = EnumSet.noneOf(Warning.class);
        this.filesystem = new JavaFileSystem();
        this.listener = null;
    }

    public Preprocessor(Source initial) {
        this();
        this.addInput(initial);
    }

    public Preprocessor(File file) throws IOException {
        this(new FileLexerSource(file));
    }

    public void setFileSystem(VirtualFileSystem filesystem) {
        this.filesystem = filesystem;
    }

    public VirtualFileSystem getFileSystem() {
        return this.filesystem;
    }

    public void setListener(PreprocessorListener listener) {
        this.listener = listener;
        for (Source s = this.source; s != null; s = s.getParent()) {
            s.init(this);
        }
    }

    public PreprocessorListener getListener() {
        return this.listener;
    }

    public Set<Feature> getFeatures() {
        return this.features;
    }

    public void addFeature(Feature f) {
        this.features.add(f);
    }

    public void addFeatures(Collection<Feature> f) {
        this.features.addAll(f);
    }

    public boolean getFeature(Feature f) {
        return this.features.contains((Object)f);
    }

    public Set<Warning> getWarnings() {
        return this.warnings;
    }

    public void addWarning(Warning w) {
        this.warnings.add(w);
    }

    public void addWarnings(Collection<Warning> w) {
        this.warnings.addAll(w);
    }

    public boolean getWarning(Warning w) {
        return this.warnings.contains((Object)w);
    }

    public void addInput(Source source) {
        source.init(this);
        if (this.source == null) {
            this.source = source;
            if (this.features.contains((Object)Feature.LINEMARKERS)) {
                this.source_untoken(this.line_token(1, source.getName(), "\n"));
            }
        } else {
            Source s = this.source;
            Source p = source.getParent();
            while (p != null) {
                s = p;
                p = s.getParent();
            }
            s.setParent(source, true);
        }
    }

    public void addInput(File file) throws IOException {
        this.addInput(new FileLexerSource(file));
    }

    protected void error(int line, int column, String msg) throws LexerException {
        if (this.listener == null) {
            throw new LexerException("Error at " + line + ":" + column + ": " + msg);
        }
        this.listener.handleError(this.source, line, column, msg);
    }

    protected void error(Token tok, String msg) throws LexerException {
        this.error(tok.getLine(), tok.getColumn(), msg);
    }

    protected void warning(int line, int column, String msg) throws LexerException {
        if (this.warnings.contains((Object)Warning.ERROR)) {
            this.error(line, column, msg);
        } else if (this.listener != null) {
            this.listener.handleWarning(this.source, line, column, msg);
        } else {
            throw new LexerException("Warning at " + line + ":" + column + ": " + msg);
        }
    }

    protected void warning(Token tok, String msg) throws LexerException {
        this.warning(tok.getLine(), tok.getColumn(), msg);
    }

    public void addMacro(Macro m) throws LexerException {
        String name = m.getName();
        if ("defined".equals(name)) {
            throw new LexerException("Cannot redefine name 'defined'");
        }
        this.macros.put(m.getName(), m);
    }

    public void addMacro(String name, String value) throws LexerException {
        try {
            Token tok;
            Macro m = new Macro(name);
            StringLexerSource s = new StringLexerSource(value);
            while ((tok = s.token()).getType() != 264) {
                m.addToken(tok);
            }
            this.addMacro(m);
        }
        catch (IOException e) {
            throw new LexerException(e);
        }
    }

    public void addMacro(String name) throws LexerException {
        this.addMacro(name, "1");
    }

    public void setQuoteIncludePath(List<String> path) {
        this.quoteincludepath = path;
    }

    public List<String> getQuoteIncludePath() {
        return this.quoteincludepath;
    }

    public void setSystemIncludePath(List<String> path) {
        this.sysincludepath = path;
    }

    public List<String> getSystemIncludePath() {
        return this.sysincludepath;
    }

    protected Map<String, Macro> getMacros() {
        return this.macros;
    }

    public Macro getMacro(String name) {
        return this.macros.get(name);
    }

    private void push_state() {
        State top = this.states.peek();
        this.states.push(new State(top));
    }

    private void pop_state() throws LexerException {
        State s = this.states.pop();
        if (this.states.isEmpty()) {
            this.error(0, 0, "#endif without #if");
            this.states.push(s);
        }
    }

    private boolean isActive() {
        State state = this.states.peek();
        return state.isParentActive() && state.isActive();
    }

    protected Source getSource() {
        return this.source;
    }

    protected void push_source(Source source, boolean autopop) {
        source.init(this);
        source.setParent(this.source, autopop);
        if (this.listener != null) {
            this.listener.handleSourceChange(this.source, "suspend");
        }
        this.source = source;
        if (this.listener != null) {
            this.listener.handleSourceChange(this.source, "push");
        }
    }

    protected void pop_source() {
        if (this.listener != null) {
            this.listener.handleSourceChange(this.source, "pop");
        }
        this.source = this.source.getParent();
        if (this.listener != null && this.source != null) {
            this.listener.handleSourceChange(this.source, "resume");
        }
    }

    public void addSource(Source source) {
        this.push_source(source, true);
    }

    private Token line_token(int line, String name, String extra) {
        return new Token(297, line, 0, "#line " + line + " \"" + name + "\"" + extra, null);
    }

    private Token source_token() throws IOException, LexerException {
        Token tok;
        block3: {
            Source s;
            if (this.source_token != null) {
                Token tok2 = this.source_token;
                this.source_token = null;
                return tok2;
            }
            do {
                if (this.source == null) {
                    return new Token(264);
                }
                tok = this.source.token();
                if (tok.getType() != 264 || !this.source.isAutopop()) break block3;
                s = this.source;
                this.pop_source();
            } while (!this.features.contains((Object)Feature.LINEMARKERS) || !s.isNumbered());
            this.source_untoken(new Token(283, this.source.getLine(), 0, "\n"));
            return this.line_token(this.source.getLine(), this.source.getName(), "");
        }
        return tok;
    }

    private void source_untoken(Token tok) {
        if (this.source_token != null) {
            throw new IllegalStateException("Cannot return two tokens");
        }
        this.source_token = tok;
    }

    private boolean isWhite(Token tok) {
        int type = tok.getType();
        return type == 292 || type == 260;
    }

    private Token source_token_nonwhite() throws IOException, LexerException {
        Token tok;
        while (this.isWhite(tok = this.source_token())) {
        }
        return tok;
    }

    private Token source_skipline(boolean white) throws IOException, LexerException {
        return this.source.skipline(white);
    }

    private boolean macro(Macro m, Token orig) throws IOException, LexerException {
        ArrayList<Argument> args;
        if (m.isFunctionLike()) {
            Token tok;
            block15: while (true) {
                tok = this.source_token();
                switch (tok.getType()) {
                    case 260: 
                    case 283: 
                    case 292: {
                        continue block15;
                    }
                    case 40: {
                        break block15;
                    }
                    default: {
                        this.source_untoken(tok);
                        return false;
                    }
                }
                break;
            }
            tok = this.source_token_nonwhite();
            if (tok.getType() != 41 || m.getArgs() > 0) {
                args = new ArrayList<Argument>();
                Argument arg = new Argument();
                int depth = 0;
                boolean space = false;
                block16: while (true) {
                    switch (tok.getType()) {
                        case 264: {
                            this.error(tok, "EOF in macro args");
                            return false;
                        }
                        case 44: {
                            if (depth == 0) {
                                if (m.isVariadic() && args.size() == m.getArgs() - 1) {
                                    arg.addToken(tok);
                                } else {
                                    args.add(arg);
                                    arg = new Argument();
                                }
                            } else {
                                arg.addToken(tok);
                            }
                            space = false;
                            break;
                        }
                        case 41: {
                            if (depth == 0) {
                                args.add(arg);
                                break block16;
                            }
                            --depth;
                            arg.addToken(tok);
                            space = false;
                            break;
                        }
                        case 40: {
                            ++depth;
                            arg.addToken(tok);
                            space = false;
                            break;
                        }
                        case 260: 
                        case 292: {
                            space = true;
                            break;
                        }
                        default: {
                            if (space && !arg.isEmpty()) {
                                arg.addToken(Token.space);
                            }
                            arg.addToken(tok);
                            space = false;
                        }
                    }
                    tok = this.source_token();
                }
                if (args.size() != m.getArgs()) {
                    this.error(tok, "macro " + m.getName() + " has " + m.getArgs() + " parameters " + "but given " + args.size() + " args");
                    return false;
                }
                for (int i = 0; i < args.size(); ++i) {
                    ((Argument)args.get(i)).expand(this);
                }
            } else {
                args = null;
            }
        } else {
            args = null;
        }
        if (m == __LINE__) {
            this.push_source(new FixedTokenSource(new Token(271, orig.getLine(), orig.getColumn(), String.valueOf(orig.getLine()), orig.getLine())), true);
        } else if (m == __FILE__) {
            StringBuilder buf = new StringBuilder("\"");
            String name = this.source.getName();
            if (name == null) {
                name = "<no file>";
            }
            block18: for (int i = 0; i < name.length(); ++i) {
                char c = name.charAt(i);
                switch (c) {
                    case '\\': {
                        buf.append("\\\\");
                        continue block18;
                    }
                    case '\"': {
                        buf.append("\\\"");
                        continue block18;
                    }
                    default: {
                        buf.append(c);
                    }
                }
            }
            buf.append("\"");
            String text = buf.toString();
            this.push_source(new FixedTokenSource(new Token(290, orig.getLine(), orig.getColumn(), text, text)), true);
        } else {
            this.push_source(new MacroTokenSource(m, args), true);
        }
        return true;
    }

    List<Token> expand(List<Token> arg) throws IOException, LexerException {
        ArrayList<Token> expansion = new ArrayList<Token>();
        boolean space = false;
        this.push_source(new FixedTokenSource(arg), false);
        block4: while (true) {
            Token tok = this.expanded_token();
            switch (tok.getType()) {
                case 264: {
                    break block4;
                }
                case 260: 
                case 292: {
                    space = true;
                    continue block4;
                }
                default: {
                    if (space && !expansion.isEmpty()) {
                        expansion.add(Token.space);
                    }
                    expansion.add(tok);
                    space = false;
                    continue block4;
                }
            }
            break;
        }
        this.pop_source();
        return expansion;
    }

    private Token define() throws IOException, LexerException {
        List<String> args;
        Token tok = this.source_token_nonwhite();
        if (tok.getType() != 269) {
            this.error(tok, "Expected identifier");
            return this.source_skipline(false);
        }
        String name = tok.getText();
        if ("defined".equals(name)) {
            this.error(tok, "Cannot redefine name 'defined'");
            return this.source_skipline(false);
        }
        Macro m = new Macro(name);
        tok = this.source_token();
        if (tok.getType() == 40) {
            block33: {
                tok = this.source_token_nonwhite();
                if (tok.getType() != 41) {
                    args = new ArrayList();
                    while (true) {
                        switch (tok.getType()) {
                            case 269: {
                                args.add(tok.getText());
                                break;
                            }
                            case 264: 
                            case 283: {
                                this.error(tok, "Unterminated macro parameter list");
                                break block33;
                            }
                            default: {
                                this.source_skipline(false);
                                this.error(tok, "error in macro parameters: " + tok.getText());
                                break block33;
                            }
                        }
                        tok = this.source_token_nonwhite();
                        switch (tok.getType()) {
                            case 44: {
                                break;
                            }
                            case 41: {
                                tok = this.source_token_nonwhite();
                                break block33;
                            }
                            case 263: {
                                tok = this.source_token_nonwhite();
                                if (tok.getType() != 41) {
                                    this.error(tok, "ellipsis must be on last argument");
                                }
                                m.setVariadic(true);
                                tok = this.source_token_nonwhite();
                                break block33;
                            }
                            case 264: 
                            case 283: {
                                this.error(tok, "Unterminated macro definition");
                                break block33;
                            }
                            default: {
                                this.source_skipline(false);
                                this.error(tok, "bad token in macro parameters: " + tok.getText());
                                break block33;
                            }
                        }
                        tok = this.source_token_nonwhite();
                    }
                }
                tok = this.source_token_nonwhite();
                args = Collections.emptyList();
            }
            m.setArgs(args);
        } else {
            args = Collections.emptyList();
            if (tok.getType() == 260 || tok.getType() == 292) {
                tok = this.source_token_nonwhite();
            }
        }
        boolean space = false;
        boolean paste = false;
        if (this.isWhite(tok)) {
            tok = this.source_token_nonwhite();
        }
        block19: while (true) {
            switch (tok.getType()) {
                case 264: {
                    break block19;
                }
                case 283: {
                    break block19;
                }
                case 260: 
                case 292: {
                    if (paste) break;
                    space = true;
                    break;
                }
                case 285: {
                    space = false;
                    paste = true;
                    m.addPaste(new Token(295, tok.getLine(), tok.getColumn(), "##", null));
                    break;
                }
                case 35: {
                    int idx;
                    if (space) {
                        m.addToken(Token.space);
                    }
                    space = false;
                    Token la = this.source_token_nonwhite();
                    if (la.getType() == 269 && (idx = args.indexOf(la.getText())) != -1) {
                        m.addToken(new Token(296, la.getLine(), la.getColumn(), "#" + la.getText(), idx));
                        break;
                    }
                    m.addToken(tok);
                    this.source_untoken(la);
                    break;
                }
                case 269: {
                    if (space) {
                        m.addToken(Token.space);
                    }
                    space = false;
                    paste = false;
                    int idx = args.indexOf(tok.getText());
                    if (idx == -1) {
                        m.addToken(tok);
                        break;
                    }
                    m.addToken(new Token(294, tok.getLine(), tok.getColumn(), tok.getText(), idx));
                    break;
                }
                default: {
                    if (space) {
                        m.addToken(Token.space);
                    }
                    space = false;
                    paste = false;
                    m.addToken(tok);
                }
            }
            tok = this.source_token();
        }
        this.addMacro(m);
        return tok;
    }

    private Token undef() throws IOException, LexerException {
        Token tok = this.source_token_nonwhite();
        if (tok.getType() != 269) {
            this.error(tok, "Expected identifier, not " + tok.getText());
            if (tok.getType() == 283 || tok.getType() == 264) {
                return tok;
            }
        } else {
            Macro m = this.macros.get(tok.getText());
            if (m != null) {
                this.macros.remove(m.getName());
            }
        }
        return this.source_skipline(true);
    }

    private boolean include(VirtualFile file) throws IOException, LexerException {
        if (!file.isFile()) {
            return false;
        }
        this.push_source(file.getSource(), true);
        return true;
    }

    private boolean include(Iterable<String> path, String name) throws IOException, LexerException {
        for (String dir : path) {
            VirtualFile file = this.filesystem.getFile(dir, name);
            if (!this.include(file)) continue;
            return true;
        }
        return false;
    }

    private void include(String parent, int line, String name, boolean quoted) throws IOException, LexerException {
        if (quoted) {
            VirtualFile pfile = this.filesystem.getFile(parent);
            VirtualFile dir = pfile.getParentFile();
            VirtualFile ifile = dir.getChildFile(name);
            if (this.include(ifile)) {
                return;
            }
            if (this.include(this.quoteincludepath, name)) {
                return;
            }
        }
        if (this.include(this.sysincludepath, name)) {
            return;
        }
        StringBuilder buf = new StringBuilder();
        if (quoted) {
            buf.append(" .");
            for (String dir : this.quoteincludepath) {
                buf.append(" ").append(dir);
            }
        }
        for (String dir : this.sysincludepath) {
            buf.append(" ").append(dir);
        }
        this.error(line, 0, "File not found: " + name + " in" + buf);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Token include() throws IOException, LexerException {
        LexerSource lexer = (LexerSource)this.source;
        try {
            Token token;
            boolean quoted;
            String name;
            lexer.setInclude(true);
            Token tok = this.token_nonwhite();
            if (tok.getType() == 290) {
                StringBuilder buf = new StringBuilder((String)tok.getValue());
                block14: while (true) {
                    tok = this.token_nonwhite();
                    switch (tok.getType()) {
                        case 290: {
                            buf.append((String)tok.getValue());
                            continue block14;
                        }
                        case 264: 
                        case 283: {
                            break block14;
                        }
                        default: {
                            this.warning(tok, "Unexpected token on #include line");
                            Token token2 = this.source_skipline(false);
                            return token2;
                        }
                    }
                    break;
                }
                name = buf.toString();
                quoted = true;
            } else if (tok.getType() == 268) {
                name = (String)tok.getValue();
                quoted = false;
                tok = this.source_skipline(true);
            } else {
                this.error(tok, "Expected string or header, not " + tok.getText());
                switch (tok.getType()) {
                    case 264: 
                    case 283: {
                        Token token3 = tok;
                        return token3;
                    }
                }
                Token token4 = this.source_skipline(false);
                return token4;
            }
            this.include(this.source.getPath(), tok.getLine(), name, quoted);
            if (this.features.contains((Object)Feature.LINEMARKERS)) {
                this.source_untoken(tok);
                token = this.line_token(1, name, "");
                return token;
            }
            token = tok;
            return token;
        }
        finally {
            lexer.setInclude(false);
        }
    }

    protected void pragma(Token name, List<Token> value) throws IOException, LexerException {
        this.warning(name, "Unknown #pragma: " + name.getText());
    }

    private Token pragma() throws IOException, LexerException {
        Token name;
        Token tok;
        block12: while (true) {
            tok = this.token();
            switch (tok.getType()) {
                case 264: {
                    this.warning(tok, "End of file in #pragma");
                    return tok;
                }
                case 283: {
                    this.warning(tok, "Empty #pragma");
                    return tok;
                }
                case 260: 
                case 292: {
                    continue block12;
                }
                case 269: {
                    name = tok;
                    break block12;
                }
                default: {
                    return this.source_skipline(false);
                }
            }
            break;
        }
        ArrayList<Token> value = new ArrayList<Token>();
        block13: while (true) {
            tok = this.token();
            switch (tok.getType()) {
                case 264: {
                    this.warning(tok, "End of file in #pragma");
                    break block13;
                }
                case 283: {
                    break block13;
                }
                case 260: {
                    continue block13;
                }
                case 292: {
                    value.add(tok);
                    continue block13;
                }
                default: {
                    value.add(tok);
                    continue block13;
                }
            }
            break;
        }
        this.pragma(name, value);
        return tok;
    }

    private void error(Token pptok, boolean is_error) throws IOException, LexerException {
        StringBuilder buf = new StringBuilder();
        buf.append('#').append(pptok.getText()).append(' ');
        Token tok = this.source_token_nonwhite();
        block3: while (true) {
            switch (tok.getType()) {
                case 264: 
                case 283: {
                    break block3;
                }
                default: {
                    buf.append(tok.getText());
                    tok = this.source_token();
                    continue block3;
                }
            }
            break;
        }
        if (is_error) {
            this.error(pptok, buf.toString());
        } else {
            this.warning(pptok, buf.toString());
        }
    }

    private Token expanded_token() throws IOException, LexerException {
        Token tok;
        while ((tok = this.source_token()).getType() == 269) {
            Macro m = this.macros.get(tok.getText());
            if (m == null) {
                return tok;
            }
            if (this.source.isExpanding(m)) {
                return tok;
            }
            if (this.macro(m, tok)) continue;
        }
        return tok;
    }

    private Token expanded_token_nonwhite() throws IOException, LexerException {
        Token tok;
        while (this.isWhite(tok = this.expanded_token())) {
        }
        return tok;
    }

    private Token expr_token() throws IOException, LexerException {
        Token tok = this.expr_token;
        if (tok != null) {
            this.expr_token = null;
        } else {
            tok = this.expanded_token_nonwhite();
            if (tok.getType() == 269 && tok.getText().equals("defined")) {
                Token la = this.source_token_nonwhite();
                boolean paren = false;
                if (la.getType() == 40) {
                    paren = true;
                    la = this.source_token_nonwhite();
                }
                if (la.getType() != 269) {
                    this.error(la, "defined() needs identifier, not " + la.getText());
                    tok = new Token(271, la.getLine(), la.getColumn(), "0", 0);
                } else {
                    tok = this.macros.containsKey(la.getText()) ? new Token(271, la.getLine(), la.getColumn(), "1", 1) : new Token(271, la.getLine(), la.getColumn(), "0", 0);
                }
                if (paren && (la = this.source_token_nonwhite()).getType() != 41) {
                    this.expr_untoken(la);
                    this.error(la, "Missing ) in defined()");
                }
            }
        }
        return tok;
    }

    private void expr_untoken(Token tok) throws LexerException {
        if (this.expr_token != null) {
            throw new InternalException("Cannot unget two expression tokens.");
        }
        this.expr_token = tok;
    }

    private int expr_priority(Token op) {
        switch (op.getType()) {
            case 47: {
                return 11;
            }
            case 37: {
                return 11;
            }
            case 42: {
                return 11;
            }
            case 43: {
                return 10;
            }
            case 45: {
                return 10;
            }
            case 278: {
                return 9;
            }
            case 288: {
                return 9;
            }
            case 60: {
                return 8;
            }
            case 62: {
                return 8;
            }
            case 274: {
                return 8;
            }
            case 266: {
                return 8;
            }
            case 265: {
                return 7;
            }
            case 282: {
                return 7;
            }
            case 38: {
                return 6;
            }
            case 94: {
                return 5;
            }
            case 124: {
                return 4;
            }
            case 272: {
                return 3;
            }
            case 276: {
                return 2;
            }
            case 63: {
                return 1;
            }
        }
        return 0;
    }

    private long expr(int priority) throws IOException, LexerException {
        Token op;
        long lhs;
        block33: {
            Token tok = this.expr_token();
            switch (tok.getType()) {
                case 40: {
                    lhs = this.expr(0);
                    tok = this.expr_token();
                    if (tok.getType() == 41) break;
                    this.expr_untoken(tok);
                    this.error(tok, "missing ) in expression");
                    return 0L;
                }
                case 126: {
                    lhs = this.expr(11) ^ 0xFFFFFFFFFFFFFFFFL;
                    break;
                }
                case 33: {
                    lhs = this.expr(11) == 0L ? 1L : 0L;
                    break;
                }
                case 45: {
                    lhs = -this.expr(11);
                    break;
                }
                case 271: {
                    lhs = ((Number)tok.getValue()).longValue();
                    break;
                }
                case 259: {
                    lhs = ((Character)tok.getValue()).charValue();
                    break;
                }
                case 269: {
                    if (this.warnings.contains((Object)Warning.UNDEF)) {
                        this.warning(tok, "Undefined token '" + tok.getText() + "' encountered in conditional.");
                    }
                    lhs = 0L;
                    break;
                }
                default: {
                    this.expr_untoken(tok);
                    this.error(tok, "Bad token in expression: " + tok.getText());
                    return 0L;
                }
            }
            block29: while (true) {
                int pri;
                if ((pri = this.expr_priority(op = this.expr_token())) == 0 || priority >= pri) break block33;
                long rhs = this.expr(pri);
                switch (op.getType()) {
                    case 47: {
                        if (rhs == 0L) {
                            this.error(op, "Division by zero");
                            lhs = 0L;
                            continue block29;
                        }
                        lhs /= rhs;
                        continue block29;
                    }
                    case 37: {
                        if (rhs == 0L) {
                            this.error(op, "Modulus by zero");
                            lhs = 0L;
                            continue block29;
                        }
                        lhs %= rhs;
                        continue block29;
                    }
                    case 42: {
                        lhs *= rhs;
                        continue block29;
                    }
                    case 43: {
                        lhs += rhs;
                        continue block29;
                    }
                    case 45: {
                        lhs -= rhs;
                        continue block29;
                    }
                    case 60: {
                        lhs = lhs < rhs ? 1L : 0L;
                        continue block29;
                    }
                    case 62: {
                        lhs = lhs > rhs ? 1L : 0L;
                        continue block29;
                    }
                    case 38: {
                        lhs &= rhs;
                        continue block29;
                    }
                    case 94: {
                        lhs ^= rhs;
                        continue block29;
                    }
                    case 124: {
                        lhs |= rhs;
                        continue block29;
                    }
                    case 278: {
                        lhs <<= (int)rhs;
                        continue block29;
                    }
                    case 288: {
                        lhs >>= (int)rhs;
                        continue block29;
                    }
                    case 274: {
                        lhs = lhs <= rhs ? 1L : 0L;
                        continue block29;
                    }
                    case 266: {
                        lhs = lhs >= rhs ? 1L : 0L;
                        continue block29;
                    }
                    case 265: {
                        lhs = lhs == rhs ? 1L : 0L;
                        continue block29;
                    }
                    case 282: {
                        lhs = lhs != rhs ? 1L : 0L;
                        continue block29;
                    }
                    case 272: {
                        lhs = lhs != 0L && rhs != 0L ? 1L : 0L;
                        continue block29;
                    }
                    case 276: {
                        lhs = lhs != 0L || rhs != 0L ? 1L : 0L;
                        continue block29;
                    }
                }
                break;
            }
            this.error(op, "Unexpected operator " + op.getText());
            return 0L;
        }
        this.expr_untoken(op);
        return lhs;
    }

    private Token toWhitespace(Token tok) {
        String text = tok.getText();
        int len = text.length();
        boolean cr = false;
        int nls = 0;
        block5: for (int i = 0; i < len; ++i) {
            char c = text.charAt(i);
            switch (c) {
                case '\r': {
                    cr = true;
                    ++nls;
                    continue block5;
                }
                case '\n': {
                    if (cr) {
                        cr = false;
                        continue block5;
                    }
                }
                case '\u000b': 
                case '\f': 
                case '\u0085': 
                case '\u2028': 
                case '\u2029': {
                    cr = false;
                    ++nls;
                }
            }
        }
        char[] cbuf = new char[nls];
        Arrays.fill(cbuf, '\n');
        return new Token(292, tok.getLine(), tok.getColumn(), new String(cbuf));
    }

    private final Token _token() throws IOException, LexerException {
        block33: while (true) {
            Token tok;
            block54: {
                block53: {
                    if (this.isActive()) break block53;
                    tok = this.source_token();
                    switch (tok.getType()) {
                        case 264: 
                        case 267: 
                        case 283: {
                            break block54;
                        }
                        case 260: 
                        case 292: {
                            return this.toWhitespace(tok);
                        }
                        default: {
                            return this.source_skipline(false);
                        }
                    }
                }
                tok = this.source_token();
            }
            block4 : switch (tok.getType()) {
                case 264: {
                    return tok;
                }
                case 283: 
                case 292: {
                    return tok;
                }
                case 260: {
                    return tok;
                }
                case 33: 
                case 37: 
                case 38: 
                case 40: 
                case 41: 
                case 42: 
                case 43: 
                case 44: 
                case 45: 
                case 46: 
                case 47: 
                case 58: 
                case 59: 
                case 60: 
                case 61: 
                case 62: 
                case 63: 
                case 91: 
                case 93: 
                case 94: 
                case 123: 
                case 124: 
                case 125: 
                case 126: 
                case 257: 
                case 258: 
                case 259: 
                case 261: 
                case 262: 
                case 263: 
                case 265: 
                case 266: 
                case 268: 
                case 270: 
                case 272: 
                case 274: 
                case 276: 
                case 278: 
                case 279: 
                case 280: 
                case 281: 
                case 282: 
                case 284: 
                case 286: 
                case 287: 
                case 288: 
                case 289: 
                case 290: 
                case 291: 
                case 293: {
                    return tok;
                }
                case 271: {
                    return tok;
                }
                case 269: {
                    Macro m = this.macros.get(tok.getText());
                    if (m == null) {
                        return tok;
                    }
                    if (this.source.isExpanding(m)) {
                        return tok;
                    }
                    if (this.macro(m, tok)) continue block33;
                    return tok;
                }
                case 297: {
                    if (!this.features.contains((Object)Feature.LINEMARKERS)) continue block33;
                    return tok;
                }
                case 298: {
                    return tok;
                }
                default: {
                    throw new InternalException("Bad token " + tok);
                }
                case 267: {
                    tok = this.source_token_nonwhite();
                    switch (tok.getType()) {
                        case 283: {
                            continue block33;
                        }
                        case 269: {
                            break;
                        }
                        default: {
                            this.error(tok, "Preprocessor directive not a word " + tok.getText());
                            return this.source_skipline(false);
                        }
                    }
                    Integer _ppcmd = ppcmds.get(tok.getText());
                    if (_ppcmd == null) {
                        this.error(tok, "Unknown preprocessor directive " + tok.getText());
                        return this.source_skipline(false);
                    }
                    int ppcmd = _ppcmd;
                    switch (ppcmd) {
                        case 1: {
                            if (!this.isActive()) {
                                return this.source_skipline(false);
                            }
                            return this.define();
                        }
                        case 12: {
                            if (!this.isActive()) {
                                return this.source_skipline(false);
                            }
                            return this.undef();
                        }
                        case 9: {
                            if (!this.isActive()) {
                                return this.source_skipline(false);
                            }
                            return this.include();
                        }
                        case 5: 
                        case 13: {
                            if (!this.isActive()) {
                                return this.source_skipline(false);
                            }
                            this.error(tok, ppcmd == 5);
                            break block4;
                        }
                        case 6: {
                            this.push_state();
                            if (!this.isActive()) {
                                return this.source_skipline(false);
                            }
                            this.expr_token = null;
                            this.states.peek().setActive(this.expr(0) != 0L);
                            tok = this.expr_token();
                            if (tok.getType() == 283) {
                                return tok;
                            }
                            return this.source_skipline(true);
                        }
                        case 2: {
                            State state = this.states.peek();
                            if (state.sawElse()) {
                                this.error(tok, "#elif after #else");
                                return this.source_skipline(false);
                            }
                            if (!state.isParentActive()) {
                                return this.source_skipline(false);
                            }
                            if (state.isActive()) {
                                state.setParentActive(false);
                                state.setActive(false);
                                return this.source_skipline(false);
                            }
                            this.expr_token = null;
                            state.setActive(this.expr(0) != 0L);
                            tok = this.expr_token();
                            if (tok.getType() == 283) {
                                return tok;
                            }
                            return this.source_skipline(true);
                        }
                        case 3: {
                            State state = this.states.peek();
                            if (state.sawElse()) {
                                this.error(tok, "#else after #else");
                                return this.source_skipline(false);
                            }
                            state.setSawElse();
                            state.setActive(!state.isActive());
                            return this.source_skipline(this.warnings.contains((Object)Warning.ENDIF_LABELS));
                        }
                        case 7: {
                            this.push_state();
                            if (!this.isActive()) {
                                return this.source_skipline(false);
                            }
                            tok = this.source_token_nonwhite();
                            if (tok.getType() != 269) {
                                this.error(tok, "Expected identifier, not " + tok.getText());
                                return this.source_skipline(false);
                            }
                            String text = tok.getText();
                            boolean exists = this.macros.containsKey(text);
                            this.states.peek().setActive(exists);
                            return this.source_skipline(true);
                        }
                        case 8: {
                            String text;
                            boolean exists;
                            this.push_state();
                            if (!this.isActive()) {
                                return this.source_skipline(false);
                            }
                            tok = this.source_token_nonwhite();
                            if (tok.getType() != 269) {
                                this.error(tok, "Expected identifier, not " + tok.getText());
                                return this.source_skipline(false);
                            }
                            this.states.peek().setActive(!(exists = this.macros.containsKey(text = tok.getText())));
                            return this.source_skipline(true);
                        }
                        case 4: {
                            this.pop_state();
                            return this.source_skipline(this.warnings.contains((Object)Warning.ENDIF_LABELS));
                        }
                        case 10: {
                            return this.source_skipline(false);
                        }
                        case 11: {
                            if (!this.isActive()) {
                                return this.source_skipline(false);
                            }
                            return this.pragma();
                        }
                    }
                    throw new InternalException("Internal error: Unknown directive " + tok);
                }
            }
        }
    }

    private Token token_nonwhite() throws IOException, LexerException {
        Token tok;
        while (this.isWhite(tok = this._token())) {
        }
        return tok;
    }

    public Token token() throws IOException, LexerException {
        Token tok = this._token();
        return tok;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        for (Source s = this.getSource(); s != null; s = s.getParent()) {
            buf.append(" -> ").append(String.valueOf(s)).append("\n");
        }
        Map<String, Macro> macros = this.getMacros();
        ArrayList<String> keys = new ArrayList<String>(macros.keySet());
        Collections.sort(keys);
        for (String key : keys) {
            Macro macro = macros.get(key);
            buf.append("#").append("macro ").append(macro).append("\n");
        }
        return buf.toString();
    }

    static {
        ppcmds.put("define", 1);
        ppcmds.put("elif", 2);
        ppcmds.put("else", 3);
        ppcmds.put("endif", 4);
        ppcmds.put("error", 5);
        ppcmds.put("if", 6);
        ppcmds.put("ifdef", 7);
        ppcmds.put("ifndef", 8);
        ppcmds.put("include", 9);
        ppcmds.put("line", 10);
        ppcmds.put("pragma", 11);
        ppcmds.put("undef", 12);
        ppcmds.put("warning", 13);
    }
}

