/*
 * Decompiled with CFR 0.152.
 */
package tudresden.ocl.gui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JFrame;
import javax.swing.event.EventListenerList;
import tudresden.ocl.check.OclTypeException;
import tudresden.ocl.gui.ConstraintRepresentation;
import tudresden.ocl.gui.EditingUtilities;
import tudresden.ocl.gui.OCLEditor;
import tudresden.ocl.gui.OCLEditorModel;
import tudresden.ocl.gui.events.ConstraintChangeEvent;
import tudresden.ocl.gui.events.ConstraintChangeListener;
import tudresden.ocl.parser.OclParserException;

public class JOCLEditorApp
extends JFrame {
    private OCLEditor m_ocleEditor;

    public JOCLEditorApp() {
        this.initComponents();
        this.m_ocleEditor.setModel(new DefaultOCLEditorModel());
    }

    private void initComponents() {
        this.m_ocleEditor = new OCLEditor();
        this.setTitle("Dresden OCL Toolkit - Sample Standalone OCL Editor");
        this.setDefaultCloseOperation(2);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent evt) {
                JOCLEditorApp.this.exitForm(evt);
            }
        });
        this.getContentPane().add((Component)this.m_ocleEditor, "Center");
        this.pack();
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension dialogSize = this.getSize();
        ((Component)this).setSize(new Dimension(300, 200));
        ((Component)this).setLocation((screenSize.width - 300) / 2, (screenSize.height - 200) / 2);
    }

    private void exitForm(WindowEvent evt) {
        System.exit(0);
    }

    public static void main(String[] args) {
        ((Component)new JOCLEditorApp()).setVisible(true);
    }

    public static class DefaultOCLEditorModel
    implements OCLEditorModel {
        private List m_lcrConstraints = new ArrayList();
        private EventListenerList m_ellListeners = new EventListenerList();
        static /* synthetic */ Class class$tudresden$ocl$gui$events$ConstraintChangeListener;

        public int getConstraintCount() {
            return this.m_lcrConstraints.size();
        }

        public ConstraintRepresentation getConstraintAt(int nIdx) {
            return (ConstraintRepresentation)this.m_lcrConstraints.get(nIdx);
        }

        public void addConstraint() {
            this.m_lcrConstraints.add(new DefaultConstraintRepresentation(null, null));
            this.fireConstraintAdded();
        }

        public void removeConstraintAt(int nIdx) {
            ConstraintRepresentation cr = (ConstraintRepresentation)this.m_lcrConstraints.remove(nIdx);
            if (cr != null) {
                this.fireConstraintRemoved(cr, nIdx);
            }
        }

        public void addConstraintChangeListener(ConstraintChangeListener ccl) {
            this.m_ellListeners.add(class$tudresden$ocl$gui$events$ConstraintChangeListener == null ? (class$tudresden$ocl$gui$events$ConstraintChangeListener = DefaultOCLEditorModel.class$("tudresden.ocl.gui.events.ConstraintChangeListener")) : class$tudresden$ocl$gui$events$ConstraintChangeListener, ccl);
        }

        public void removeConstraintChangeListener(ConstraintChangeListener ccl) {
            this.m_ellListeners.remove(class$tudresden$ocl$gui$events$ConstraintChangeListener == null ? (class$tudresden$ocl$gui$events$ConstraintChangeListener = DefaultOCLEditorModel.class$("tudresden.ocl.gui.events.ConstraintChangeListener")) : class$tudresden$ocl$gui$events$ConstraintChangeListener, ccl);
        }

        protected void fireConstraintRemoved(ConstraintRepresentation cr, int nIdx) {
            Object[] listeners = this.m_ellListeners.getListenerList();
            ConstraintChangeEvent cce = null;
            int i = listeners.length - 2;
            while (i >= 0) {
                if (listeners[i] == (class$tudresden$ocl$gui$events$ConstraintChangeListener == null ? DefaultOCLEditorModel.class$("tudresden.ocl.gui.events.ConstraintChangeListener") : class$tudresden$ocl$gui$events$ConstraintChangeListener)) {
                    if (cce == null) {
                        cce = new ConstraintChangeEvent(this, nIdx, cr, null);
                    }
                    ((ConstraintChangeListener)listeners[i + 1]).constraintRemoved(cce);
                }
                i -= 2;
            }
        }

        protected void fireConstraintAdded() {
            Object[] listeners = this.m_ellListeners.getListenerList();
            ConstraintChangeEvent cce = null;
            int i = listeners.length - 2;
            while (i >= 0) {
                if (listeners[i] == (class$tudresden$ocl$gui$events$ConstraintChangeListener == null ? DefaultOCLEditorModel.class$("tudresden.ocl.gui.events.ConstraintChangeListener") : class$tudresden$ocl$gui$events$ConstraintChangeListener)) {
                    if (cce == null) {
                        int nIdx = this.m_lcrConstraints.size() - 1;
                        cce = new ConstraintChangeEvent(this, nIdx, null, this.getConstraintAt(nIdx));
                    }
                    ((ConstraintChangeListener)listeners[i + 1]).constraintAdded(cce);
                }
                i -= 2;
            }
        }

        protected void fireConstraintDataChanged(int nIdx, String sOldConstraint, ConstraintRepresentation crNew) {
            Object[] listeners = this.m_ellListeners.getListenerList();
            ConstraintChangeEvent cce = null;
            int i = listeners.length - 2;
            while (i >= 0) {
                if (listeners[i] == (class$tudresden$ocl$gui$events$ConstraintChangeListener == null ? DefaultOCLEditorModel.class$("tudresden.ocl.gui.events.ConstraintChangeListener") : class$tudresden$ocl$gui$events$ConstraintChangeListener)) {
                    if (cce == null) {
                        cce = new ConstraintChangeEvent(this, nIdx, new DefaultConstraintRepresentation(crNew.getName(), sOldConstraint), crNew);
                    }
                    ((ConstraintChangeListener)listeners[i + 1]).constraintDataChanged(cce);
                }
                i -= 2;
            }
        }

        protected void fireConstraintNameChanged(int nIdx, String sOldName, ConstraintRepresentation crNew) {
            Object[] listeners = this.m_ellListeners.getListenerList();
            ConstraintChangeEvent cce = null;
            int i = listeners.length - 2;
            while (i >= 0) {
                if (listeners[i] == (class$tudresden$ocl$gui$events$ConstraintChangeListener == null ? DefaultOCLEditorModel.class$("tudresden.ocl.gui.events.ConstraintChangeListener") : class$tudresden$ocl$gui$events$ConstraintChangeListener)) {
                    if (cce == null) {
                        cce = new ConstraintChangeEvent(this, nIdx, new DefaultConstraintRepresentation(sOldName, crNew.getData()), crNew);
                    }
                    ((ConstraintChangeListener)listeners[i + 1]).constraintNameChanged(cce);
                }
                i -= 2;
            }
        }

        static /* synthetic */ Class class$(String x0) {
            try {
                return Class.forName(x0);
            }
            catch (ClassNotFoundException x1) {
                throw new NoClassDefFoundError(x1.getMessage());
            }
        }

        public class DefaultConstraintRepresentation
        implements ConstraintRepresentation {
            private String m_sName;
            private String m_sData;

            public DefaultConstraintRepresentation(String sName, String sData) {
                this.m_sName = sName;
                this.m_sData = sData;
            }

            public String getData() {
                return this.m_sData != null ? this.m_sData : "";
            }

            public String getName() {
                return this.m_sName != null ? this.m_sName : "new_constraint";
            }

            public void setData(String sData, EditingUtilities euHelper) throws IllegalStateException, OclParserException, OclTypeException {
                String sOldData = this.m_sData;
                this.m_sData = sData;
                DefaultOCLEditorModel.this.fireConstraintDataChanged(DefaultOCLEditorModel.this.m_lcrConstraints.indexOf(this), sOldData, this);
            }

            public void setName(String sName, EditingUtilities euHelper) throws IllegalStateException, IllegalArgumentException {
                if (this.m_sData == null) {
                    throw new IllegalStateException("Please specify a constraint body first.");
                }
                if (!euHelper.isValidConstraintName(sName)) {
                    throw new IllegalArgumentException("Please specify a valid name.");
                }
                String sOldName = this.getName();
                this.m_sName = sName;
                DefaultOCLEditorModel.this.fireConstraintNameChanged(DefaultOCLEditorModel.this.m_lcrConstraints.indexOf(this), sOldName, this);
            }
        }
    }
}

