/*
 * Decompiled with CFR 0.152.
 */
package tudresden.ocl.codegen;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.ListIterator;
import tudresden.ocl.OclException;
import tudresden.ocl.check.TypeChecker;
import tudresden.ocl.check.types.Any;
import tudresden.ocl.check.types.Basic;
import tudresden.ocl.check.types.Collection;
import tudresden.ocl.check.types.OclType;
import tudresden.ocl.check.types.Type;
import tudresden.ocl.codegen.NodeNameMap;
import tudresden.ocl.codegen.ProceduralCodeGenerator;
import tudresden.ocl.codegen.StringStringMap;
import tudresden.ocl.parser.node.AActualParameterList;
import tudresden.ocl.parser.node.AActualParameterListTail;
import tudresden.ocl.parser.node.AAdditiveExpression;
import tudresden.ocl.parser.node.AAdditiveExpressionTail;
import tudresden.ocl.parser.node.AAndLogicalOperator;
import tudresden.ocl.parser.node.AArrowPostfixExpressionTailBegin;
import tudresden.ocl.parser.node.ABooleanLiteral;
import tudresden.ocl.parser.node.AConstraintBody;
import tudresden.ocl.parser.node.ADivMultiplyOperator;
import tudresden.ocl.parser.node.AEnumLiteral;
import tudresden.ocl.parser.node.AEqualRelationalOperator;
import tudresden.ocl.parser.node.AExpression;
import tudresden.ocl.parser.node.AExpressionListOrRange;
import tudresden.ocl.parser.node.AExpressionListTail;
import tudresden.ocl.parser.node.AFeatureCall;
import tudresden.ocl.parser.node.AFeatureCallParameters;
import tudresden.ocl.parser.node.AFeaturePrimaryExpression;
import tudresden.ocl.parser.node.AGtRelationalOperator;
import tudresden.ocl.parser.node.AGteqRelationalOperator;
import tudresden.ocl.parser.node.AIfExpression;
import tudresden.ocl.parser.node.AIfPrimaryExpression;
import tudresden.ocl.parser.node.AImpliesLogicalOperator;
import tudresden.ocl.parser.node.AIntegerLiteral;
import tudresden.ocl.parser.node.AIterateDeclarator;
import tudresden.ocl.parser.node.ALetExpression;
import tudresden.ocl.parser.node.AListExpressionListOrRangeTail;
import tudresden.ocl.parser.node.ALitColPrimaryExpression;
import tudresden.ocl.parser.node.ALiteralPrimaryExpression;
import tudresden.ocl.parser.node.ALogicalExpression;
import tudresden.ocl.parser.node.ALogicalExpressionTail;
import tudresden.ocl.parser.node.ALtRelationalOperator;
import tudresden.ocl.parser.node.ALteqRelationalOperator;
import tudresden.ocl.parser.node.AMinusAddOperator;
import tudresden.ocl.parser.node.AMinusUnaryOperator;
import tudresden.ocl.parser.node.AMultMultiplyOperator;
import tudresden.ocl.parser.node.AMultiplicativeExpression;
import tudresden.ocl.parser.node.AMultiplicativeExpressionTail;
import tudresden.ocl.parser.node.ANEqualRelationalOperator;
import tudresden.ocl.parser.node.ANotUnaryOperator;
import tudresden.ocl.parser.node.AOrLogicalOperator;
import tudresden.ocl.parser.node.AParenthesesPrimaryExpression;
import tudresden.ocl.parser.node.APlusAddOperator;
import tudresden.ocl.parser.node.APostfixExpression;
import tudresden.ocl.parser.node.APostfixExpressionTail;
import tudresden.ocl.parser.node.APostfixUnaryExpression;
import tudresden.ocl.parser.node.AQualifiers;
import tudresden.ocl.parser.node.ARangeExpressionListOrRangeTail;
import tudresden.ocl.parser.node.ARealLiteral;
import tudresden.ocl.parser.node.ARelationalExpression;
import tudresden.ocl.parser.node.ARelationalExpressionTail;
import tudresden.ocl.parser.node.AStandardDeclarator;
import tudresden.ocl.parser.node.AStringLiteral;
import tudresden.ocl.parser.node.AUnaryUnaryExpression;
import tudresden.ocl.parser.node.AXorLogicalOperator;
import tudresden.ocl.parser.node.Node;
import tudresden.ocl.parser.node.PExpression;
import tudresden.ocl.parser.node.PExpressionListOrRangeTail;
import tudresden.ocl.parser.node.PLogicalOperator;
import tudresden.ocl.parser.node.PRelationalExpression;
import tudresden.ocl.parser.node.PRelationalOperator;

public class JavaCodeGenerator
extends ProceduralCodeGenerator {
    String instanceName;
    String javaResult;
    private String oclLibPackage = "tudresden.ocl.lib.";
    NodeNameMap operatorCode = new NodeNameMap();
    StringStringMap varMap = new StringStringMap();
    static HashSet oclAnyOperations = new HashSet();

    public JavaCodeGenerator(String instanceName, String resultName) {
        this.instanceName = instanceName;
        this.javaResult = resultName;
    }

    public JavaCodeGenerator(String instanceName, String resultName, String oclLibPackage) {
        this.instanceName = instanceName;
        this.javaResult = resultName;
        this.oclLibPackage = oclLibPackage;
    }

    public JavaCodeGenerator(String instanceName) {
        this(instanceName, null);
    }

    public JavaCodeGenerator() {
        this("this");
    }

    protected String getTransferCode(String var, String type) {
        StringBuffer ret = new StringBuffer();
        int i = 0;
        while (i < this.indent) {
            ret.append(' ');
            ++i;
        }
        ret.append(this.oclLibPackage + type + ' ' + var + ";\n");
        return ret.toString();
    }

    protected void requireTreeInvariants() {
        this.tree.requireInvariant("context AExpression inv : letExpression -> forAll ( le | not self . parent . boundNames -> includes ( le . name ) )  ");
        this.tree.requireInvariant("context AStandardDeclarator : not parent . parent . boundNames -> includes ( name.toString() )");
        this.tree.requireInvariant("context AIterateDeclarator : let ppb = parent . parent . boundNames in not ( ppb -> includes ( iterator.toString() ) or ppb -> includes( accumulator.toString() ) )");
        this.tree.requireInvariant("context AStandardDeclarator inv : declaratorTail -> isEmpty");
        this.tree.requireInvariant("context ANamePathNameBegin inv : boundNames -> includes ( name )");
        this.tree.requireInvariant("context AFeatureCall inv : let iteratingMethodNames : Set ( String ) = Set { 'collect', 'exists' , 'forAll' , 'isUnique' , 'reject' , 'select' , 'sortedBy' } in iteratingMethodNames -> includes ( self . pathName . toString ( ) ) implies ( self . featureCallParameters . declarator -> size = 1 and self . featureCallParameters . declarator . oclType = AStandardDeclarator )");
        this.tree.requireInvariant("context ANamePathNameBegin inv : defaultContext <> '' implies boundNames -> includes ( defaultContext )");
        this.tree.requireInvariant("context AConstraintBody inv : name -> size = 1");
    }

    private String createDecl(String type, String variable) {
        if (this.preVarTypes.containsKey(variable)) {
            return variable + '=';
        }
        if (type.indexOf(46) < 0) {
            return "final " + this.oclLibPackage + type + ' ' + variable + '=';
        }
        return "final " + type + ' ' + variable + '=';
    }

    private String qualifyType(String type) {
        return type.indexOf(46) < 0 ? this.oclLibPackage + type : type;
    }

    public void inAConstraintBody(AConstraintBody cb) {
        Type oclReturnType;
        this.varMap.clear();
        this.appendCode(this.createDecl("OclAnyImpl", this.getVariable(cb)) + this.oclLibPackage + "Ocl.toOclAnyImpl( " + this.oclLibPackage + "Ocl.getFor(" + this.instanceName + ") );\n");
        this.varMap.put("self", this.getVariable(cb));
        if (this.parameters != null) {
            int i = 0;
            while (i < this.parameters.length) {
                Type oclParamType = this.tree.getTypeFor(this.parameters[i][0], cb);
                String javaParamType = this.getJavaType(oclParamType);
                String javaParamName = this.tree.getNameCreator().getUniqueName("OpPar");
                this.appendCode(this.createDecl(javaParamType, javaParamName) + this.oclLibPackage + "Ocl.to" + javaParamType + "( " + this.oclLibPackage + "Ocl.getFor(" + this.parameters[i][0] + ") );\n");
                this.varMap.put(this.parameters[i][0], javaParamName);
                ++i;
            }
        }
        if (this.topOfStack.getKind() == 21 && (oclReturnType = this.tree.getTypeFor("result", cb.getExpression())) != null && !oclReturnType.equals(Any.VOID)) {
            if (this.javaResult == null) {
                throw new OclException("tried to generate code for post condition without setting Java code for result");
            }
            String javaType = this.getJavaType(oclReturnType);
            String result = this.tree.getNameCreator().getUniqueName("Result");
            this.varMap.put("result", result);
            this.writeToStandardCodeOnly();
            this.appendCode(this.createDecl(javaType, result) + this.oclLibPackage + "Ocl.to" + javaType + "( " + this.oclLibPackage + "Ocl.getFor(" + this.javaResult + ") );\n");
            this.writeToPreCodeOnly();
            this.appendCode(this.createDecl(javaType, result) + "new " + this.oclLibPackage + javaType + "(0,\"created by JavaCodeGenerator\");\n");
            this.writeToBothCodes();
        }
    }

    public void outAExpression(AExpression e) {
        this.reachThrough(e, e.getLogicalExpression());
    }

    public void outAIfExpression(AIfExpression ie) {
        String javaType = this.getJavaType(this.tree.getNodeType(ie));
        this.appendCode(this.createDecl(javaType, this.getVariable(ie)) + '(' + this.getVariable(ie.getIfBranch()) + ".isTrue()) ? (");
        this.appendCode(this.getVariable(ie.getThenBranch()) + ") : (" + this.getVariable(ie.getElseBranch()) + ");\n");
    }

    public void outALogicalExpression(ALogicalExpression le) {
        if (le.getLogicalExpressionTail().isEmpty()) {
            this.reachThrough(le, le.getRelationalExpression());
        } else {
            int tailElements = le.getLogicalExpressionTail().size();
            PRelationalExpression[] relExprs = new PRelationalExpression[tailElements + 1];
            PLogicalOperator[] logOps = new PLogicalOperator[tailElements];
            boolean[] opIsImplies = new boolean[tailElements];
            Iterator iter = le.getLogicalExpressionTail().iterator();
            int index = 0;
            relExprs[0] = le.getRelationalExpression();
            while (iter.hasNext()) {
                ALogicalExpressionTail let = (ALogicalExpressionTail)iter.next();
                logOps[index] = let.getLogicalOperator();
                opIsImplies[index] = logOps[index] instanceof AImpliesLogicalOperator;
                relExprs[++index] = let.getRelationalExpression();
            }
            this.appendCode(this.createDecl("OclBoolean", this.getVariable(le)));
            int lastNonImplies = 0;
            boolean foundImplies = false;
            int i = 0;
            while (i < tailElements) {
                if (opIsImplies[i]) {
                    int from = lastNonImplies;
                    int to = i;
                    this.appendAndOrLogExpr(relExprs, logOps, from, to);
                    lastNonImplies = to + 1;
                    if (foundImplies) {
                        this.appendCode(")");
                    }
                    this.appendCode(".implies(");
                    foundImplies = true;
                }
                ++i;
            }
            this.appendAndOrLogExpr(relExprs, logOps, lastNonImplies, tailElements);
            if (foundImplies) {
                this.appendCode(")");
            }
            this.appendCode(";\n");
        }
    }

    protected void appendAndOrLogExpr(PRelationalExpression[] relExprs, PLogicalOperator[] logOps, int from, int to) {
        this.appendCode(this.getVariable(relExprs[from]));
        int i = from + 1;
        while (i <= to) {
            this.appendCode(".");
            this.appendCode(this.operatorCode.get(logOps[i - 1]));
            this.appendCode("(" + this.getVariable(relExprs[i]) + ")");
            ++i;
        }
    }

    public void outARelationalExpression(ARelationalExpression re) {
        if (re.getRelationalExpressionTail() == null) {
            this.reachThrough(re, re.getAdditiveExpression());
        } else {
            ARelationalExpressionTail ret = (ARelationalExpressionTail)re.getRelationalExpressionTail();
            PRelationalOperator relOp = ret.getRelationalOperator();
            boolean comparison = true;
            if (relOp instanceof AEqualRelationalOperator || relOp instanceof ANEqualRelationalOperator) {
                comparison = false;
            }
            this.appendCode(this.createDecl("OclBoolean", this.getVariable(re)));
            this.appendCode(this.getVariable(re.getAdditiveExpression()));
            this.appendCode("." + this.operatorCode.get(ret.getRelationalOperator()) + "(");
            this.appendCode(this.getVariable(ret.getAdditiveExpression()));
            this.appendCode(");\n");
        }
    }

    public void outAAdditiveExpression(AAdditiveExpression ae) {
        if (ae.getAdditiveExpressionTail().isEmpty()) {
            this.reachThrough(ae, ae.getMultiplicativeExpression());
        } else {
            Type nodeType = this.tree.getNodeType(ae);
            String javaType = this.getJavaType(nodeType);
            this.appendCode(this.createDecl(javaType, this.getVariable(ae)));
            this.appendCode(this.getVariable(ae.getMultiplicativeExpression()));
            Iterator iter = ae.getAdditiveExpressionTail().iterator();
            while (iter.hasNext()) {
                AAdditiveExpressionTail aet = (AAdditiveExpressionTail)iter.next();
                this.appendCode("." + this.operatorCode.get(aet.getAddOperator()) + "(");
                this.appendCode(this.getVariable(aet.getMultiplicativeExpression()));
                this.appendCode(")");
            }
            this.appendCode(";\n");
        }
    }

    public void outAMultiplicativeExpression(AMultiplicativeExpression me) {
        if (me.getMultiplicativeExpressionTail().isEmpty()) {
            this.reachThrough(me, me.getUnaryExpression());
        } else {
            String javaType = this.getJavaType(this.tree.getNodeType(me));
            this.appendCode(this.createDecl(javaType, this.getVariable(me)));
            this.appendCode(this.oclLibPackage + "Ocl.to" + this.getJavaType(this.tree.getNodeType(me.getUnaryExpression())) + "(");
            this.appendCode(this.getVariable(me.getUnaryExpression()));
            this.appendCode(")");
            Iterator iter = me.getMultiplicativeExpressionTail().iterator();
            while (iter.hasNext()) {
                AMultiplicativeExpressionTail met = (AMultiplicativeExpressionTail)iter.next();
                javaType = this.getJavaType(this.tree.getNodeType(met.getUnaryExpression()));
                this.appendCode("." + this.operatorCode.get(met.getMultiplyOperator()) + "(");
                this.appendCode(this.getVariable(met.getUnaryExpression()) + ")");
            }
            this.appendCode(";\n");
        }
    }

    public void outAUnaryUnaryExpression(AUnaryUnaryExpression uue) {
        Type oclType = this.tree.getNodeType(uue);
        String javaType = this.getJavaType(oclType);
        this.appendCode(this.createDecl(javaType, this.getVariable(uue)));
        if (oclType == Basic.INTEGER) {
            this.appendCode(this.oclLibPackage + "Ocl.toOclInteger(");
        }
        this.appendCode(this.getVariable(uue.getPostfixExpression()) + "." + this.operatorCode.get(uue.getUnaryOperator()) + "()");
        if (oclType == Basic.INTEGER) {
            this.appendCode(")");
        }
        this.appendCode(";\n");
    }

    public void outAPostfixUnaryExpression(APostfixUnaryExpression pue) {
        this.reachThrough(pue, pue.getPostfixExpression());
    }

    public void outAPostfixExpression(APostfixExpression pe) {
        if (pe.getPostfixExpressionTail().isEmpty()) {
            this.reachThrough(pe, pe.getPrimaryExpression());
        } else {
            APostfixExpressionTail last = (APostfixExpressionTail)pe.getPostfixExpressionTail().getLast();
            this.reachThrough(pe, last);
        }
    }

    public void outAFeaturePrimaryExpression(AFeaturePrimaryExpression pe) {
        Type oclType = this.tree.getNodeType(pe);
        if (oclType instanceof OclType) {
            this.appendCode(this.createDecl("OclType", this.getVariable(pe)) + this.oclLibPackage + "OclType.getOclTypeFor(" + this.instanceName + ", \"" + pe.toString().trim() + "\");\n");
        } else {
            this.setVariable(pe, this.varMap.get(pe.toString().trim()));
        }
    }

    public void inALitColPrimaryExpression(ALitColPrimaryExpression lcpe) {
        String javaType = this.getJavaType(this.tree.getNodeType(lcpe));
        this.appendCode(this.createDecl(javaType, this.getVariable(lcpe)) + this.oclLibPackage + javaType + ".getEmpty" + javaType + "();\n");
    }

    public void outALiteralPrimaryExpression(ALiteralPrimaryExpression lpe) {
        this.reachThrough(lpe, lpe.getLiteral());
    }

    public void outAParenthesesPrimaryExpression(AParenthesesPrimaryExpression lpe) {
        this.reachThrough(lpe, lpe.getExpression());
    }

    public void outAIfPrimaryExpression(AIfPrimaryExpression ipe) {
        this.reachThrough(ipe, ipe.getIfExpression());
    }

    public void outAExpressionListOrRange(AExpressionListOrRange elor) {
        String collectionVar = this.getVariable(elor.parent().parent());
        PExpressionListOrRangeTail tail = elor.getExpressionListOrRangeTail();
        if (tail == null) {
            this.addExpressionToCollection(elor.getExpression(), collectionVar);
        } else if (tail instanceof AListExpressionListOrRangeTail) {
            AListExpressionListOrRangeTail list = (AListExpressionListOrRangeTail)tail;
            this.addExpressionToCollection(elor.getExpression(), collectionVar);
            Iterator iter = list.getExpressionListTail().iterator();
            while (iter.hasNext()) {
                AExpressionListTail next = (AExpressionListTail)iter.next();
                this.addExpressionToCollection(next.getExpression(), collectionVar);
            }
        } else {
            ARangeExpressionListOrRangeTail range = (ARangeExpressionListOrRangeTail)tail;
            this.appendCode(collectionVar + ".setToRange(" + this.getVariable(elor.getExpression()) + ", " + this.getVariable(range.getExpression()) + ");\n");
        }
    }

    public void caseAPostfixExpressionTail(APostfixExpressionTail pet) {
        Node appliedTo = this.getPreviousNode(pet);
        Type appliedType = this.tree.getNodeType(appliedTo);
        AFeatureCall fc = (AFeatureCall)pet.getFeatureCall();
        if (fc.getTimeExpression() != null) {
            this.addPreVariable(this.getVariable(pet), this.getJavaType(this.tree.getNodeType(pet)));
            this.assurePreCode();
            this.writeToPreCodeOnly();
        }
        if (pet.getPostfixExpressionTailBegin() instanceof AArrowPostfixExpressionTailBegin) {
            this.appendPostfixArrowOp(pet, appliedTo, appliedType);
        } else if (appliedType instanceof Basic) {
            this.appendPostfixBasic(pet, appliedTo, (Basic)appliedType);
        } else {
            String featurePathName = fc.getPathName().toString().trim();
            if (oclAnyOperations.contains(featurePathName)) {
                this.appendPostfixBasic(pet, appliedTo, appliedType);
            } else {
                this.appendPostfixDotOp(pet, appliedTo, appliedType);
            }
        }
        if (fc.getTimeExpression() != null) {
            this.writeToBothCodes();
        }
    }

    protected void appendPostfixBasic(APostfixExpressionTail pet, Node appliedTo, Type appliedType) {
        boolean insertCastToOclAnyImpl;
        super.caseAPostfixExpressionTail(pet);
        Type oclType = this.tree.getNodeType(pet);
        String javaType = this.getJavaType(oclType);
        AFeatureCall fc = (AFeatureCall)pet.getFeatureCall();
        String featureName = fc.getPathName().toString().trim();
        if (featureName.equals("oclIsNew")) {
            throw new OclException("JavaCodeGenerator does not support the OclAny property \"oclIsNew\"");
        }
        this.appendCode(this.createDecl(javaType, this.getVariable(pet)));
        boolean insertCastToInteger = featureName.equals("abs") && oclType == Basic.INTEGER;
        boolean bl = insertCastToOclAnyImpl = featureName.equals("oclAsType") && javaType.equals("OclAnyImpl");
        if (insertCastToInteger) {
            this.appendCode(this.oclLibPackage + "Ocl.toOclInteger(");
        }
        if (insertCastToOclAnyImpl) {
            this.appendCode(this.oclLibPackage + "Ocl.toOclAnyImpl(");
        }
        this.appendCode(this.getVariable(appliedTo) + "." + featureName + "(");
        if (fc.getFeatureCallParameters() != null) {
            AFeatureCallParameters fcp = (AFeatureCallParameters)fc.getFeatureCallParameters();
            this.appendActualParameterList((AActualParameterList)fcp.getActualParameterList());
        }
        if (insertCastToInteger || insertCastToOclAnyImpl) {
            this.appendCode(")");
        }
        this.appendCode(");\n");
    }

    protected void appendPostfixArrowOp(APostfixExpressionTail pet, Node appliedTo, Type appliedType) {
        String javaType = this.getJavaType(this.tree.getNodeType(pet));
        AFeatureCall fc = (AFeatureCall)pet.getFeatureCall();
        String featureName = fc.getPathName().toString().trim();
        AFeatureCallParameters fcp = (AFeatureCallParameters)fc.getFeatureCallParameters();
        AActualParameterList apl = null;
        if (fcp != null) {
            apl = (AActualParameterList)fcp.getActualParameterList();
        }
        if (featureName.equals("iterate")) {
            String appliedToVariable = appliedType instanceof Collection ? this.getVariable(appliedTo) : this.convertToCollection(appliedTo);
            AIterateDeclarator decl = (AIterateDeclarator)fcp.getDeclarator();
            String oclIter = decl.getIterator().toString().trim();
            String oclAccum = decl.getAccumulator().toString().trim();
            String javaIter = oclIter.startsWith(this.tree.getNameCreator().getPrefix()) ? oclIter : this.tree.getNameCreator().getUniqueName("Iter");
            String javaEvalName = this.tree.getNameCreator().getUniqueName("Eval");
            String javaCont = this.tree.getNameCreator().getUniqueName("Accu");
            String javaIterType = this.getJavaType(this.tree.getTypeFor(oclIter, apl.getExpression()));
            String javaContType = this.getJavaType(this.tree.getTypeFor(oclAccum, apl.getExpression()));
            this.varMap.put(oclIter, this.oclLibPackage + "Ocl.to" + javaIterType + "(" + javaIter + ".getValue())");
            this.varMap.put(oclAccum, this.oclLibPackage + "Ocl.to" + javaContType + "(" + javaCont + ".getValue())");
            decl.getExpression().apply(this);
            this.appendCode(this.createDecl("OclIterator", javaIter) + this.getVariable(appliedTo) + ".getIterator();\n");
            this.appendCode(this.createDecl("OclContainer", javaCont) + "new " + this.oclLibPackage + "OclContainer(" + this.getVariable(decl.getExpression()) + ");\n");
            this.appendCode(this.createDecl("OclRootEvaluatable", javaEvalName) + "new " + this.oclLibPackage + "OclRootEvaluatable() {\n");
            this.appendCode("  public " + this.oclLibPackage + "OclRoot evaluate() {\n");
            this.increaseIndent(4);
            apl.apply(this);
            this.decreaseIndent(4);
            this.appendCode("    return " + this.getVariable(apl.getExpression()) + ";\n");
            this.appendCode("  }\n");
            this.appendCode("};\n");
            this.appendCode(this.createDecl(javaType, this.getVariable(pet)));
            this.appendCode(this.oclLibPackage + "Ocl.to" + javaType + "(");
            this.appendCode(appliedToVariable + ".iterate(" + javaIter + ", " + javaCont + ", " + javaEvalName + "));\n");
        } else if (TypeChecker.setOfIteratingMethodNames.contains(featureName)) {
            String appliedVariable = appliedType instanceof Collection ? this.getVariable(appliedTo) : this.convertToCollection(appliedTo);
            AStandardDeclarator decl = (AStandardDeclarator)fcp.getDeclarator();
            String oclIter = decl.getName().toString().trim();
            String javaIter = oclIter.startsWith(this.tree.getNameCreator().getPrefix()) ? oclIter : this.tree.getNameCreator().getUniqueName("Iter");
            String javaEvalName = this.tree.getNameCreator().getUniqueName("Eval");
            String[] types = this.getEvaluatableTypes(featureName);
            String javaIterType = this.getJavaType(this.tree.getTypeFor(oclIter, apl.getExpression()));
            String javaEvalType = types[0];
            String javaEvalReturn = types[1];
            String javaIterReturn = types[2];
            this.appendCode(this.createDecl("OclIterator", javaIter) + this.getVariable(appliedTo) + ".getIterator();\n");
            this.appendCode(this.createDecl(javaEvalType, javaEvalName) + "new " + this.qualifyType(javaEvalType) + "() {\n");
            this.appendCode("  public " + this.qualifyType(javaEvalReturn) + " evaluate() {\n");
            this.varMap.put(oclIter, this.oclLibPackage + "Ocl.to" + javaIterType + "(" + javaIter + ".getValue())");
            this.increaseIndent(4);
            super.caseAPostfixExpressionTail(pet);
            this.decreaseIndent(4);
            this.appendCode("    return " + this.getVariable(apl.getExpression()) + ";\n");
            this.appendCode("  }\n");
            this.appendCode("};\n");
            this.appendCode(this.createDecl(javaType, this.getVariable(pet)));
            if (javaType != javaIterReturn) {
                this.appendCode(this.oclLibPackage + "Ocl.to" + javaType + "(");
            }
            this.appendCode(appliedVariable + "." + featureName + "(" + javaIter + ", " + javaEvalName + ")");
            if (javaType != javaIterReturn) {
                this.appendCode(")");
            }
            this.appendCode(";\n");
        } else {
            super.caseAPostfixExpressionTail(pet);
            String appliedVariable = appliedType instanceof Collection ? this.getVariable(appliedTo) : this.convertToCollection(appliedTo);
            boolean insertCast = false;
            if (featureName.equals("first") || featureName.equals("last") || featureName.equals("sum") || featureName.equals("at") || featureName.equals("including") || featureName.equals("excluding")) {
                insertCast = true;
            }
            this.appendCode(this.createDecl(javaType, this.getVariable(pet)));
            if (insertCast) {
                this.appendCode(this.oclLibPackage + "Ocl.to" + javaType + "(");
            }
            this.appendCode(appliedVariable + "." + featureName + "(");
            this.appendActualParameterList(apl);
            if (insertCast) {
                this.appendCode(")");
            }
            this.appendCode(");\n");
        }
    }

    protected String convertToCollection(Node appliedTo) {
        String name = this.tree.getNameCreator().getUniqueName("Set");
        this.appendCode(this.createDecl("OclSet", name) + this.oclLibPackage + "OclSet.getEmptyOclSet();\n");
        this.appendCode(name + ".setToInclude(" + this.getVariable(appliedTo) + ");\n");
        return name;
    }

    protected String[] getEvaluatableTypes(String featureName) {
        String[] ret = new String[3];
        if (featureName.equals("collect")) {
            ret[0] = "OclRootEvaluatable";
            ret[1] = "OclRoot";
            ret[2] = "OclCollection";
        } else if (featureName.equals("isUnique")) {
            ret[0] = "OclRootEvaluatable";
            ret[1] = "OclRoot";
            ret[2] = "OclBoolean";
        } else if (featureName.equals("sortedBy")) {
            ret[0] = "OclComparableEvaluatable";
            ret[1] = "java.lang.Comparable";
            ret[2] = "OclSequence";
        } else if (featureName.equals("exists")) {
            ret[0] = "OclBooleanEvaluatable";
            ret[1] = "OclBoolean";
            ret[2] = "OclBoolean";
        } else if (featureName.equals("forAll")) {
            ret[0] = "OclBooleanEvaluatable";
            ret[1] = "OclBoolean";
            ret[2] = "OclBoolean";
        } else if (featureName.equals("reject")) {
            ret[0] = "OclBooleanEvaluatable";
            ret[1] = "OclBoolean";
            ret[2] = "OclCollection";
        } else if (featureName.equals("select")) {
            ret[0] = "OclBooleanEvaluatable";
            ret[1] = "OclBoolean";
            ret[2] = "OclCollection";
        } else {
            throw new RuntimeException("Illegal iterating method name");
        }
        return ret;
    }

    protected void appendPostfixDotOp(APostfixExpressionTail pet, Node appliedTo, Type appliedType) {
        AActualParameterList apl;
        super.caseAPostfixExpressionTail(pet);
        String appliedVar = this.getVariable(appliedTo);
        String javaType = this.getJavaType(this.tree.getNodeType(pet));
        String paramVar = null;
        String qualifVar = null;
        AFeatureCall fc = (AFeatureCall)pet.getFeatureCall();
        if (fc.getFeatureCallParameters() != null) {
            AFeatureCallParameters fcp = (AFeatureCallParameters)fc.getFeatureCallParameters();
            apl = (AActualParameterList)fcp.getActualParameterList();
            if (apl == null) {
                paramVar = "null";
            } else {
                paramVar = this.tree.getNameCreator().getUniqueName("Param");
                ArrayList<PExpression> paramExpressions = new ArrayList<PExpression>();
                paramExpressions.add(apl.getExpression());
                Iterator iter = apl.getActualParameterListTail().iterator();
                while (iter.hasNext()) {
                    AActualParameterListTail aplt = (AActualParameterListTail)iter.next();
                    paramExpressions.add(aplt.getExpression());
                }
                this.appendCode("Object[] " + paramVar + "=new Object[" + paramExpressions.size() + "];\n");
                int i = 0;
                while (i < paramExpressions.size()) {
                    this.appendCode(paramVar + "[" + i + "]=" + this.oclLibPackage + "Ocl.reconvert(" + "null, " + this.getVariable((AExpression)paramExpressions.get(i)) + ");\n");
                    ++i;
                }
            }
        }
        if (fc.getQualifiers() != null) {
            AQualifiers aqs = (AQualifiers)fc.getQualifiers();
            apl = (AActualParameterList)aqs.getActualParameterList();
            LinkedList tail = apl.getActualParameterListTail();
            if (!tail.isEmpty()) {
                throw new RuntimeException("Java code generator can handle on qualifier only.");
            }
            AExpression theQualifier = (AExpression)apl.getExpression();
            qualifVar = this.tree.getNameCreator().getUniqueName("Qualif");
            this.appendCode("Object " + qualifVar + "=" + this.oclLibPackage + "Ocl.reconvert(" + "null, " + this.getVariable(theQualifier) + ");\n");
        }
        this.appendCode(this.createDecl(javaType, this.getVariable(pet)) + this.oclLibPackage + "Ocl.to" + javaType + "(" + appliedVar + ".getFeature" + (qualifVar != null ? "Qualified" : "") + "(\"" + fc.getPathName().toString().trim() + "\"");
        if (paramVar != null) {
            this.appendCode(", " + paramVar);
        }
        if (qualifVar != null) {
            this.appendCode(", " + qualifVar);
        }
        this.appendCode("));\n");
    }

    protected void appendActualParameterList(AActualParameterList apl) {
        if (apl != null) {
            this.appendCode(this.getVariable(apl.getExpression()));
            Iterator iter = apl.getActualParameterListTail().iterator();
            while (iter.hasNext()) {
                AActualParameterListTail aplt = (AActualParameterListTail)iter.next();
                this.appendCode(", " + this.getVariable(aplt.getExpression()));
            }
        }
    }

    public void outALetExpression(ALetExpression le) {
        this.reachThrough(le, le.getExpression());
        this.varMap.put(le.getName().toString().trim(), this.getVariable(le));
    }

    public void outAStringLiteral(AStringLiteral sl) {
        String lit = sl.toString().trim();
        lit = lit.substring(1, lit.length() - 1);
        this.appendCode(this.createDecl("OclString", this.getVariable(sl)) + "new " + this.oclLibPackage + "OclString(\"" + lit + "\");\n");
    }

    public void outARealLiteral(ARealLiteral rl) {
        String lit = rl.toString().trim();
        this.appendCode(this.createDecl("OclReal", this.getVariable(rl)) + "new " + this.oclLibPackage + "OclReal(" + lit + ");\n");
    }

    public void outAIntegerLiteral(AIntegerLiteral il) {
        String lit = il.toString().trim();
        this.appendCode(this.createDecl("OclInteger", this.getVariable(il)) + "new " + this.oclLibPackage + "OclInteger(" + lit + ");\n");
    }

    public void outABooleanLiteral(ABooleanLiteral bl) {
        String jc = bl.toString().trim().equals("true") ? this.oclLibPackage + "OclBoolean.TRUE" : this.oclLibPackage + "OclBoolean.FALSE";
        this.appendCode(this.createDecl("OclBoolean", this.getVariable(bl)) + jc + ";\n");
    }

    public void outAEnumLiteral(AEnumLiteral el) {
        throw new OclException("JavaCodeGenerator can not handle Enumeration type");
    }

    protected Node getPreviousNode(APostfixExpressionTail pet) {
        APostfixExpression pe = (APostfixExpression)pet.parent();
        ListIterator iter = pe.getPostfixExpressionTail().listIterator();
        while (iter.next() != pet) {
        }
        iter.previous();
        Node ret = iter.hasPrevious() ? (APostfixExpressionTail)iter.previous() : pe.getPrimaryExpression();
        return ret;
    }

    protected void addExpressionToCollection(PExpression e, String collVar) {
        this.appendCode(collVar + ".setToInclude(" + this.getVariable(e) + ");\n");
    }

    protected String getJavaType(Type t) {
        if (t instanceof Basic) {
            if (t == Basic.INTEGER) {
                return "OclInteger";
            }
            if (t == Basic.REAL) {
                return "OclReal";
            }
            if (t == Basic.BOOLEAN) {
                return "OclBoolean";
            }
            if (t == Basic.STRING) {
                return "OclString";
            }
            throw new RuntimeException("illegal basic type");
        }
        if (t instanceof Collection) {
            Collection c = (Collection)t;
            switch (c.getCollectionKind()) {
                case 47: {
                    return "OclSet";
                }
                case 97: {
                    return "OclBag";
                }
                case 690: {
                    return "OclSequence";
                }
                case 23: {
                    return "OclCollection";
                }
            }
            throw new RuntimeException("illegal collection type");
        }
        if (t instanceof OclType) {
            return "OclType";
        }
        return "OclAnyImpl";
    }

    public void inAAndLogicalOperator(AAndLogicalOperator lo) {
        this.operatorCode.put(lo, "and");
    }

    public void inAOrLogicalOperator(AOrLogicalOperator lo) {
        this.operatorCode.put(lo, "or");
    }

    public void inAXorLogicalOperator(AXorLogicalOperator lo) {
        this.operatorCode.put(lo, "xor");
    }

    public void inAImpliesLogicalOperator(AImpliesLogicalOperator lo) {
        this.operatorCode.put(lo, "implies");
    }

    public void inAEqualRelationalOperator(AEqualRelationalOperator ero) {
        this.operatorCode.put(ero, "isEqualTo");
    }

    public void inANEqualRelationalOperator(ANEqualRelationalOperator nero) {
        this.operatorCode.put(nero, "isNotEqualTo");
    }

    public void inAGtRelationalOperator(AGtRelationalOperator ro) {
        this.operatorCode.put(ro, "isGreaterThan");
    }

    public void inALtRelationalOperator(ALtRelationalOperator ro) {
        this.operatorCode.put(ro, "isLessThan");
    }

    public void inAGteqRelationalOperator(AGteqRelationalOperator ro) {
        this.operatorCode.put(ro, "isGreaterEqual");
    }

    public void inALteqRelationalOperator(ALteqRelationalOperator ro) {
        this.operatorCode.put(ro, "isLessEqual");
    }

    public void inAPlusAddOperator(APlusAddOperator pao) {
        this.operatorCode.put(pao, "add");
    }

    public void inAMinusAddOperator(AMinusAddOperator mao) {
        this.operatorCode.put(mao, "subtract");
    }

    public void inAMultMultiplyOperator(AMultMultiplyOperator mmo) {
        this.operatorCode.put(mmo, "multiply");
    }

    public void inADivMultiplyOperator(ADivMultiplyOperator dmo) {
        this.operatorCode.put(dmo, "divide");
    }

    public void inAMinusUnaryOperator(AMinusUnaryOperator muo) {
        this.operatorCode.put(muo, "negative");
    }

    public void inANotUnaryOperator(ANotUnaryOperator nuo) {
        this.operatorCode.put(nuo, "not");
    }

    static {
        oclAnyOperations.add("oclIsKindOf");
        oclAnyOperations.add("oclIsTypeOf");
        oclAnyOperations.add("oclAsType");
        oclAnyOperations.add("oclInState");
        oclAnyOperations.add("oclIsNew");
    }
}

