/*
 * Decompiled with CFR 0.152.
 */
package org.argouml.core.propertypanels.ui;

import java.awt.event.ActionEvent;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import javax.swing.Action;
import org.argouml.core.propertypanels.ui.UMLComboBox;
import org.argouml.core.propertypanels.ui.UMLComboBoxModel;
import org.argouml.i18n.Translator;
import org.argouml.model.Model;
import org.argouml.ui.UndoableAction;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class UMLMetaClassComboBoxModel
extends UMLComboBoxModel {
    private static final long serialVersionUID = 5941365798992694830L;
    private List<String> metaClasses;

    public UMLMetaClassComboBoxModel(String propertyName, Object target) {
        super(target, propertyName, true);
    }

    @Override
    protected Object getSelectedModelElement() {
        if (this.getTarget() != null) {
            return Model.getFacade().getType(this.getTarget());
        }
        return null;
    }

    @Override
    protected void buildModelList() {
        this.setElements(this.getMetaClassNames());
    }

    private List<String> getMetaClassNames() {
        if (this.metaClasses == null) {
            Collection tmpMetaClasses = Model.getCoreHelper().getAllMetatypeNames();
            this.metaClasses = tmpMetaClasses instanceof List ? (List<Object>)tmpMetaClasses : new LinkedList<String>(tmpMetaClasses);
            tmpMetaClasses.addAll(Model.getCoreHelper().getAllMetaDatatypeNames());
            try {
                Collections.sort(this.metaClasses);
            }
            catch (UnsupportedOperationException e) {
                this.metaClasses = new LinkedList<String>(tmpMetaClasses);
                Collections.sort(this.metaClasses);
            }
        }
        return this.metaClasses;
    }

    @Override
    protected boolean isValidElement(Object element) {
        return this.getMetaClassNames().contains(element);
    }

    @Override
    public Action getAction() {
        return new ActionSetTagDefinitionType();
    }

    private class ActionSetTagDefinitionType
    extends UndoableAction {
        protected ActionSetTagDefinitionType() {
            super(Translator.localize((String)"Set"), null);
            this.putValue("ShortDescription", Translator.localize((String)"Set"));
        }

        public void actionPerformed(ActionEvent e) {
            super.actionPerformed(e);
            Object source = e.getSource();
            String oldType = null;
            String newType = null;
            Object tagDef = null;
            UMLComboBox box = (UMLComboBox)source;
            Object t = box.getTarget();
            if (Model.getFacade().isATagDefinition(t)) {
                tagDef = t;
                oldType = (String)Model.getFacade().getType(tagDef);
            }
            if ((newType = (String)box.getSelectedItem()) != null && !newType.equals(oldType) && tagDef != null) {
                Model.getExtensionMechanismsHelper().setTagType(tagDef, newType);
            }
        }
    }
}

