/*
 * Decompiled with CFR 0.152.
 */
package org.argouml.core.propertypanels.ui;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import javax.swing.AbstractListModel;
import javax.swing.Action;
import javax.swing.ComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.SwingUtilities;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import org.apache.log4j.Logger;
import org.argouml.model.AddAssociationEvent;
import org.argouml.model.AssociationChangeEvent;
import org.argouml.model.DeleteInstanceEvent;
import org.argouml.model.InvalidElementException;
import org.argouml.model.Model;
import org.argouml.model.RemoveAssociationEvent;
import org.argouml.model.UmlChangeEvent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class UMLComboBoxModel
extends AbstractListModel
implements PropertyChangeListener,
ComboBoxModel,
PopupMenuListener {
    private static final long serialVersionUID = 6038919811554379037L;
    private static final Logger LOG = Logger.getLogger(UMLComboBoxModel.class);
    private Object target = null;
    private List objects = new LinkedList();
    private Object selectedObject = null;
    private boolean isClearable = false;
    private String propertySetName;
    private boolean fireListEvents = true;
    private boolean buildingModel = false;
    private boolean processingWillBecomeVisible = false;
    private boolean modelValid;
    private String filter;

    public UMLComboBoxModel(Object target, String name, boolean clearable) {
        if (name == null || name.equals("")) {
            throw new IllegalArgumentException("A property name must be provided");
        }
        if (target == null) {
            throw new IllegalArgumentException("Target cannot be null");
        }
        this.isClearable = clearable;
        this.propertySetName = name;
        this.modelValid = false;
        this.target = target;
        Model.getPump().addModelEventListener((PropertyChangeListener)this, target, this.propertySetName);
        this.addOtherModelEventListeners(target);
        this.buildingModel = true;
        this.buildMinimalModelList();
        this.setSelectedItem(this.getSelectedModelElement());
        this.buildingModel = false;
        if (this.getSize() > 0) {
            this.fireIntervalAdded(this, 0, this.getSize() - 1);
        }
        if (this.getSelectedItem() != null && this.isClearable) {
            this.addElement(null);
        }
    }

    @Override
    public final void propertyChange(PropertyChangeEvent pve) {
        if (pve instanceof UmlChangeEvent) {
            final UmlChangeEvent event = (UmlChangeEvent)pve;
            Runnable doWorkRunnable = new Runnable(){

                public void run() {
                    block2: {
                        try {
                            UMLComboBoxModel.this.modelChanged(event);
                        }
                        catch (InvalidElementException e) {
                            if (!LOG.isDebugEnabled()) break block2;
                            LOG.debug((Object)("event = " + event.getClass().getName()));
                            LOG.debug((Object)("source = " + event.getSource()));
                            LOG.debug((Object)("old = " + event.getOldValue()));
                            LOG.debug((Object)("name = " + event.getPropertyName()));
                            LOG.debug((Object)"updateLayout method accessed deleted element ", (Throwable)e);
                        }
                    }
                }
            };
            SwingUtilities.invokeLater(doWorkRunnable);
        }
    }

    public void modelChanged(UmlChangeEvent evt) {
        this.buildingModel = true;
        if (evt instanceof DeleteInstanceEvent) {
            if (this.contains(this.getChangedElement((PropertyChangeEvent)evt))) {
                Object o = this.getChangedElement((PropertyChangeEvent)evt);
                this.removeElement(o);
            }
        } else if (evt instanceof AddAssociationEvent) {
            if (this.getTarget() != null && this.isValidEvent((PropertyChangeEvent)evt)) {
                if (evt.getPropertyName().equals(this.propertySetName) && evt.getSource() == this.getTarget()) {
                    Object elem = evt.getNewValue();
                    if (elem != null && !this.contains(elem)) {
                        this.addElement(elem);
                    }
                    this.buildingModel = false;
                    this.setSelectedItem(elem);
                } else {
                    Object o = this.getChangedElement((PropertyChangeEvent)evt);
                    this.addElement(o);
                }
            }
        } else if (evt instanceof RemoveAssociationEvent && this.isValidEvent((PropertyChangeEvent)evt)) {
            if (evt.getPropertyName().equals(this.propertySetName) && evt.getSource() == this.getTarget()) {
                if (evt.getOldValue() == this.getSelectedItem()) {
                    this.setSelectedItem(evt.getNewValue());
                }
            } else {
                Object o = this.getChangedElement((PropertyChangeEvent)evt);
                if (this.contains(o)) {
                    this.removeElement(o);
                }
            }
        }
        this.buildingModel = false;
    }

    protected abstract boolean isValidElement(Object var1);

    protected abstract void buildModelList();

    protected String getName(Object obj) {
        try {
            String n = Model.getFacade().getName(obj);
            String name = n != null ? n : "";
            return name;
        }
        catch (InvalidElementException e) {
            return "<invalid>";
        }
    }

    protected void setElements(Collection elements) {
        if (elements != null) {
            ArrayList toBeRemoved = new ArrayList();
            for (Object o : this.objects) {
                if (elements.contains(o) || this.isClearable && (o == null || "".equals(o))) continue;
                toBeRemoved.add(o);
            }
            this.removeAll(toBeRemoved);
            this.addAll(elements);
            if (this.isClearable && !elements.contains(null)) {
                this.addElement(null);
            }
            if (!this.objects.contains(this.selectedObject)) {
                this.selectedObject = null;
            }
        } else {
            throw new IllegalArgumentException("In setElements: may not set elements to null collection");
        }
    }

    protected Object getTarget() {
        return this.target;
    }

    protected void removeAll(Collection col) {
        int first = -1;
        int last = -1;
        this.fireListEvents = false;
        for (Object o : col) {
            int index = this.getIndexOf(o);
            this.removeElement(o);
            if (first == -1) {
                first = index;
                last = index;
                continue;
            }
            if (index != last + 1) {
                this.fireListEvents = true;
                this.fireIntervalRemoved(this, first, last);
                this.fireListEvents = false;
                first = index;
                last = index;
                continue;
            }
            ++last;
        }
        this.fireListEvents = true;
    }

    protected void addAll(Collection col) {
        Object selected = this.getSelectedItem();
        this.fireListEvents = false;
        int oldSize = this.objects.size();
        for (Object o : col) {
            if (this.filter != null && this.filter.length() > 0) {
                if (!Model.getFacade().getName(o).toLowerCase().startsWith(this.filter.toLowerCase())) continue;
                this.addElement(o);
                continue;
            }
            this.addElement(o);
        }
        this.setSelectedItem(selected);
        this.fireListEvents = true;
        if (this.objects.size() != oldSize) {
            this.fireIntervalAdded(this, oldSize == 0 ? 0 : oldSize - 1, this.objects.size() - 1);
        }
    }

    protected Object getChangedElement(PropertyChangeEvent e) {
        if (e instanceof AssociationChangeEvent) {
            return ((AssociationChangeEvent)e).getChangedValue();
        }
        return e.getNewValue();
    }

    protected final void setTarget(Object theNewTarget) {
        assert (this.getTarget() == null);
        assert (theNewTarget != null);
        this.modelValid = false;
        LOG.debug((Object)("setTarget target :  " + theNewTarget));
        this.target = theNewTarget;
        Model.getPump().addModelEventListener((PropertyChangeListener)this, this.target, this.propertySetName);
        this.addOtherModelEventListeners(this.target);
        this.buildingModel = true;
        this.buildMinimalModelList();
        this.setSelectedItem(this.getSelectedModelElement());
        this.buildingModel = false;
        if (this.getSize() > 0) {
            this.fireIntervalAdded(this, 0, this.getSize() - 1);
        }
        if (this.getSelectedItem() != null && this.isClearable) {
            this.addElement(null);
        }
    }

    public void removeModelEventListener() {
        Model.getPump().removeModelEventListener((PropertyChangeListener)this, this.target, this.propertySetName);
        this.removeOtherModelEventListeners(this.target);
    }

    protected void buildMinimalModelList() {
        this.buildModelListTimed();
    }

    private void buildModelListTimed() {
        long startTime = System.currentTimeMillis();
        try {
            this.buildModelList();
            long endTime = System.currentTimeMillis();
            LOG.debug((Object)("buildModelList took " + (endTime - startTime) + " msec. for " + this.getClass().getName()));
        }
        catch (InvalidElementException e) {
            LOG.warn((Object)"buildModelList attempted to operate on deleted element");
        }
    }

    protected void removeOtherModelEventListeners(Object oldTarget) {
    }

    protected void addOtherModelEventListeners(Object newTarget) {
    }

    protected abstract Object getSelectedModelElement();

    @Override
    public Object getElementAt(int index) {
        if (index >= 0 && index < this.objects.size()) {
            return this.objects.get(index);
        }
        return null;
    }

    @Override
    public int getSize() {
        return this.objects.size();
    }

    public int getIndexOf(Object o) {
        return this.objects.indexOf(o);
    }

    public void addElement(Object o) {
        if (!this.objects.contains(o)) {
            this.objects.add(o);
            this.fireIntervalAdded(this, this.objects.size() - 1, this.objects.size() - 1);
        }
    }

    @Override
    public void setSelectedItem(Object o) {
        if (this.selectedObject != null && !this.selectedObject.equals(o) || this.selectedObject == null && o != null) {
            this.selectedObject = o;
            this.fireContentsChanged(this, -1, -1);
        }
    }

    public void removeElement(Object o) {
        int index = this.objects.indexOf(o);
        if (this.getElementAt(index) == this.selectedObject && !this.isClearable) {
            if (index == 0) {
                this.setSelectedItem(this.getSize() == 1 ? null : this.getElementAt(index + 1));
            } else {
                this.setSelectedItem(this.getElementAt(index - 1));
            }
        }
        if (index >= 0) {
            this.objects.remove(index);
            this.fireIntervalRemoved(this, index, index);
        }
    }

    public void removeAllElements() {
        int startIndex = 0;
        int endIndex = Math.max(0, this.objects.size() - 1);
        this.objects.clear();
        this.selectedObject = null;
        this.fireIntervalRemoved(this, startIndex, endIndex);
    }

    @Override
    public Object getSelectedItem() {
        return this.selectedObject;
    }

    public boolean contains(Object elem) {
        if (this.objects.contains(elem)) {
            return true;
        }
        if (elem instanceof Collection) {
            for (Object o : (Collection)elem) {
                if (this.objects.contains(o)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public void setFilter(String filter) {
        this.filter = filter;
        this.modelValid = false;
    }

    protected boolean isValidEvent(PropertyChangeEvent e) {
        boolean valid = false;
        if (!(this.getChangedElement(e) instanceof Collection)) {
            if (e.getNewValue() == null && e.getOldValue() != null || this.isValidElement(this.getChangedElement(e))) {
                valid = true;
            }
        } else {
            Collection col = (Collection)this.getChangedElement(e);
            if (!col.isEmpty()) {
                valid = true;
                for (Object o : col) {
                    if (this.isValidElement(o)) continue;
                    valid = false;
                    break;
                }
            } else if (e.getOldValue() instanceof Collection && !((Collection)e.getOldValue()).isEmpty()) {
                valid = true;
            }
        }
        return valid;
    }

    @Override
    protected void fireContentsChanged(Object source, int index0, int index1) {
        if (this.fireListEvents && !this.buildingModel) {
            super.fireContentsChanged(source, index0, index1);
        }
    }

    @Override
    protected void fireIntervalAdded(Object source, int index0, int index1) {
        if (this.fireListEvents && !this.buildingModel) {
            super.fireIntervalAdded(source, index0, index1);
        }
    }

    @Override
    protected void fireIntervalRemoved(Object source, int index0, int index1) {
        if (this.fireListEvents && !this.buildingModel) {
            super.fireIntervalRemoved(source, index0, index1);
        }
    }

    protected boolean isClearable() {
        return this.isClearable;
    }

    protected String getPropertySetName() {
        return this.propertySetName;
    }

    protected boolean isFireListEvents() {
        return this.fireListEvents;
    }

    protected void setFireListEvents(boolean events) {
        this.fireListEvents = events;
    }

    protected boolean isLazy() {
        return false;
    }

    protected void setModelInvalid() {
        assert (this.isLazy());
        this.modelValid = false;
    }

    @Override
    public void popupMenuCanceled(PopupMenuEvent e) {
    }

    @Override
    public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void popupMenuWillBecomeVisible(PopupMenuEvent ev) {
        if (this.isLazy() && !this.modelValid && !this.processingWillBecomeVisible) {
            Object selectedElement = this.getSelectedModelElement();
            this.buildModelListTimed();
            this.modelValid = true;
            JComboBox list = (JComboBox)ev.getSource();
            this.processingWillBecomeVisible = true;
            try {
                list.getUI().setPopupVisible(list, true);
            }
            finally {
                this.processingWillBecomeVisible = false;
            }
            if (selectedElement != null) {
                this.setSelectedItem(selectedElement);
            }
        }
    }

    public abstract Action getAction();

    public List<Action> getActions() {
        return Collections.emptyList();
    }
}

