/*
 * Decompiled with CFR 0.152.
 */
package org.argouml.core.propertypanels.model;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.log4j.Logger;
import org.argouml.core.propertypanels.model.CheckBoxData;
import org.argouml.core.propertypanels.model.ControlData;
import org.argouml.core.propertypanels.model.PanelData;
import org.argouml.model.Model;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MetaDataCache {
    private static final Logger LOG = Logger.getLogger(MetaDataCache.class);
    private Map<Class<?>, PanelData> cache = new HashMap();
    private Map<String, Class<?>> metaTypeByName;
    private Map<Class<?>, String> nameByMetaType;

    public MetaDataCache() throws Exception {
        Document doc = this.getDocument();
        NodeList nl = doc.getDocumentElement().getChildNodes();
        for (int i = 0; i < nl.getLength(); ++i) {
            Node n = nl.item(i);
            if (n.getNodeName().equals("classes")) {
                int size = n.getChildNodes().getLength();
                this.nameByMetaType = new HashMap(size);
                this.metaTypeByName = new HashMap(size);
                this.populateClassMaps((Element)n, this.nameByMetaType, this.metaTypeByName);
                continue;
            }
            if (!n.getNodeName().equals("panels")) continue;
            this.cache = this.getPanels((Element)n);
        }
    }

    public PanelData get(Class<?> clazz) {
        Class<?>[] interfaces;
        for (Class<?> interfaze : interfaces = clazz.getInterfaces()) {
            PanelData pd = this.cache.get(interfaze);
            if (pd == null) continue;
            return pd;
        }
        return null;
    }

    private Document getDocument() throws IOException, DOMException, ParserConfigurationException, SAXException {
        String filename = Model.getFacade().getUmlVersion().charAt(0) == '2' ? "org/argouml/core/propertypanels/model/metamodel2.xml" : "org/argouml/core/propertypanels/model/metamodel.xml";
        InputStream inputStream = this.getClass().getClassLoader().getResourceAsStream(filename);
        InputSource inputSource = new InputSource(inputStream);
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        DocumentBuilder db = dbf.newDocumentBuilder();
        return db.parse(inputSource);
    }

    private void populateClassMaps(Element classesNode, Map<Class<?>, String> nameByMetaType, Map<String, Class<?>> metaTypeByName) {
        NodeList nl = classesNode.getElementsByTagName("class");
        for (int i = 0; i < nl.getLength(); ++i) {
            Node classNode = nl.item(i);
            String className = classNode.getTextContent();
            try {
                String name = classNode.getAttributes().getNamedItem("name").getNodeValue();
                Class<?> clazz = Class.forName(className);
                metaTypeByName.put(name, clazz);
                nameByMetaType.put(clazz, name);
                continue;
            }
            catch (ClassNotFoundException e) {
                LOG.error((Object)("Class not found " + className), (Throwable)e);
            }
        }
    }

    private Map<Class<?>, PanelData> getPanels(Element panelsNode) {
        HashMap map = new HashMap();
        NodeList panelNodes = panelsNode.getElementsByTagName("panel");
        for (int i = 0; i < panelNodes.getLength(); ++i) {
            Element panelNode = (Element)panelNodes.item(i);
            String name = panelNode.getAttribute("name");
            Class<?> clazz = this.metaTypeByName.get(name);
            if (clazz == null) {
                LOG.warn((Object)("No class name translation found for panel: " + name));
                continue;
            }
            List<Class<?>> newChildTypes = this.stringToMetaTypes(panelNode.getAttribute("new-child"));
            List<Class<?>> newSiblingTypes = this.stringToMetaTypes(panelNode.getAttribute("new-sibling"));
            boolean siblingNavigation = "true".equals(panelNode.getAttribute("navigate-sibling"));
            PanelData pm = new PanelData(clazz, name, newChildTypes, newSiblingTypes, siblingNavigation);
            map.put(clazz, pm);
            NodeList controlNodes = panelNode.getElementsByTagName("*");
            for (int j = 0; j < controlNodes.getLength(); ++j) {
                Element controlNode = (Element)controlNodes.item(j);
                String propertyName = controlNode.getAttribute("name");
                String label = controlNode.getAttribute("label");
                ControlData controlData = new ControlData(controlNode.getTagName(), propertyName, label);
                List<Class<?>> types = this.stringToMetaTypes(controlNode.getAttribute("type"));
                for (Class<?> metaType : types) {
                    controlData.addType(metaType);
                }
                if (controlNode.getTagName().equals("checkgroup")) {
                    this.addCheckboxes(controlData, controlNode);
                }
                pm.addControlData(controlData);
            }
        }
        return map;
    }

    private List<Class<?>> stringToMetaTypes(String typesString) {
        ArrayList classes = new ArrayList();
        StringTokenizer st = new StringTokenizer(typesString, ",");
        while (st.hasMoreTokens()) {
            classes.add(this.metaTypeByName.get(st.nextToken()));
        }
        return classes;
    }

    private void addCheckboxes(ControlData controlData, Element controlElement) {
        NodeList checkBoxElements = controlElement.getElementsByTagName("checkbox");
        for (int i = 0; i < checkBoxElements.getLength(); ++i) {
            Element cbNode = (Element)checkBoxElements.item(i);
            String checkBoxType = cbNode.getAttributes().getNamedItem("type").getNodeValue();
            String checkBoxName = cbNode.getAttributes().getNamedItem("name").getNodeValue();
            CheckBoxData cbd = new CheckBoxData(this.metaTypeByName.get(checkBoxType), checkBoxName);
            controlData.addCheckbox(cbd);
        }
    }
}

