/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.gef.properties.ui;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.LayoutManager;

public class PropsGridLayout
implements LayoutManager {
    int hgap;
    int vgap;
    int _labelWidth = 100;
    int _labelHeight = 22;
    int _minPropWidth = 150;

    public PropsGridLayout(int hgap, int vgap) {
        this.hgap = hgap;
        this.vgap = vgap;
    }

    public void addLayoutComponent(String name, Component comp) {
    }

    public void removeLayoutComponent(Component comp) {
    }

    public Dimension preferredLayoutSize(Container parent) {
        Insets insets = parent.getInsets();
        int ncomponents = parent.getComponentCount();
        int w = this._labelWidth + this._minPropWidth + this.hgap;
        int h = 0;
        for (int i = 0; i < ncomponents; ++i) {
            Component comp = parent.getComponent(i);
            Dimension d = comp.getPreferredSize();
            h += d.height + this.vgap;
        }
        return new Dimension(insets.left + insets.right + w, insets.top + insets.bottom + h);
    }

    public Dimension minimumLayoutSize(Container parent) {
        Insets insets = parent.getInsets();
        int ncomponents = parent.getComponentCount();
        int w = this._labelWidth + this._minPropWidth + this.hgap;
        int h = 0;
        for (int i = 0; i < ncomponents; ++i) {
            Component comp = parent.getComponent(i);
            Dimension d = comp.getMinimumSize();
            h += d.height + this.vgap;
        }
        return new Dimension(insets.left + insets.right + w, insets.top + insets.bottom + h);
    }

    public void layoutContainer(Container parent) {
        Insets insets = parent.getInsets();
        int ncomponents = parent.getComponentCount();
        if (ncomponents == 0) {
            return;
        }
        int used = insets.left + insets.right + this.hgap + this._labelWidth;
        int propWidth = Math.max(parent.getSize().width - used, this._minPropWidth);
        Graphics g = parent.getGraphics();
        int h = 0;
        for (int i = 0; i < ncomponents; ++i) {
            Component comp = parent.getComponent(i);
            Dimension d = comp.getPreferredSize();
            if (i % 2 == 0) {
                comp.setBounds(0, h, this._labelWidth, this._labelHeight);
                continue;
            }
            comp.setLocation(this._labelWidth + this.hgap, h);
            comp.setSize(d);
            h += Math.max(d.height, this._labelHeight) + this.vgap;
        }
    }
}

