/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.gef.presentation;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Point;
import java.io.Serializable;

public abstract class Decoration
implements Serializable {
    private int arrowWidth = 7;
    private int arrowHeight = 12;
    private Color arrowLineColor = Color.black;
    private Color arrowFillColor = Color.black;

    public Decoration() {
    }

    public Decoration(Color line, Color fill) {
        this.setLineColor(line);
        this.setFillColor(fill);
    }

    public Color getLineColor() {
        return this.arrowLineColor;
    }

    public void setLineColor(Color newColor) {
        this.arrowLineColor = newColor;
    }

    public Color getFillColor() {
        return this.arrowFillColor;
    }

    public void setFillColor(Color newColor) {
        this.arrowFillColor = newColor;
    }

    public abstract void paint(Graphics var1, Point var2, Point var3, Color var4, Color var5);

    public int getLineLength(Point one, Point two) {
        int dxdx = (two.x - one.x) * (two.x - one.x);
        int dydy = (two.y - one.y) * (two.y - one.y);
        return (int)Math.sqrt(dxdx + dydy);
    }

    public Point pointAlongLine(Point one, Point two, int dist) {
        int len = this.getLineLength(one, two);
        int p = dist;
        if (len == 0) {
            return one;
        }
        return new Point(one.x + (two.x - one.x) * p / len, one.y + (two.y - one.y) * p / len);
    }

    public double dist(int x0, int y0, int x1, int y1) {
        double dx = x0 - x1;
        double dy = y0 - y1;
        return Math.sqrt(dx * dx + dy * dy);
    }

    public double dist(double dx, double dy) {
        return Math.sqrt(dx * dx + dy * dy);
    }

    public int getWidth() {
        return this.arrowWidth;
    }

    public int getHeight() {
        return this.arrowHeight;
    }

    public void setWidth(int w) {
        this.arrowWidth = w;
    }

    public void setHeight(int h) {
        this.arrowHeight = h;
    }
}

