/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.gef.base;

import java.awt.Graphics;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.tigris.gef.base.Layer;
import org.tigris.gef.presentation.Fig;
import org.tigris.gef.presentation.FigNode;
import org.tigris.gef.presentation.FigPainter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LayerDiagram
extends Layer {
    private static final long serialVersionUID = 6193765162314431069L;
    private List<Fig> contents = new ArrayList<Fig>();
    private static int nextLayerNumbered = 1;
    private static final Log LOG = LogFactory.getLog(LayerDiagram.class);

    public LayerDiagram() {
        this("Layer" + LayerDiagram.numberWordFor(nextLayerNumbered++));
    }

    public LayerDiagram(String name) {
        super(name);
        this.setOnMenu(true);
    }

    @Override
    public Enumeration elements() {
        return Collections.enumeration(this.contents);
    }

    protected static String numberWordFor(int n) {
        switch (n) {
            case 1: {
                return "One";
            }
            case 2: {
                return "Two";
            }
            case 3: {
                return "Three";
            }
            case 4: {
                return "Four";
            }
            case 5: {
                return "Five";
            }
            case 6: {
                return "Six";
            }
            case 7: {
                return "Seven";
            }
            case 8: {
                return "Eight";
            }
            case 9: {
                return "Nine";
            }
        }
        return "Layer " + n;
    }

    @Override
    public void add(Fig f) {
        if (f == null) {
            throw new IllegalArgumentException("Attempted to add a null fig to a LayerDiagram");
        }
        this.contents.remove(f);
        this.contents.add(f);
        f.setLayer(this);
        f.endTrans();
    }

    public void insertAt(Fig f, int index) {
        if (f == null) {
            throw new IllegalArgumentException("Attempted to insert a null fig to a LayerDiagram");
        }
        this.contents.remove(f);
        this.contents.add(index, f);
        f.setLayer(this);
        f.endTrans();
    }

    public int indexOf(Fig f) {
        if (f == null) {
            throw new IllegalArgumentException("Attempted to find the index of a null fig in a LayerDiagram");
        }
        return this.contents.indexOf(f);
    }

    @Override
    public void remove(Fig f) {
        this.contents.remove(f);
        f.endTrans();
        f.setLayer(null);
    }

    public boolean contains(Fig f) {
        return this.contents.contains(f);
    }

    @Override
    public List<Fig> getContents() {
        return Collections.unmodifiableList(this.contents);
    }

    @Override
    public List<? extends Fig> getContents(Class<? extends Fig> figClass) {
        ArrayList<Fig> list = new ArrayList<Fig>(this.contents.size());
        for (Fig f : this.contents) {
            if (!f.getClass().isAssignableFrom(figClass)) continue;
            list.add(f);
        }
        return Collections.unmodifiableList(list);
    }

    @Override
    public Fig hit(Rectangle r) {
        for (int i = this.contents.size() - 1; i >= 0; --i) {
            Fig f = this.contents.get(i);
            if (!f.hit(r)) continue;
            return f;
        }
        return null;
    }

    @Override
    public void removeAll() {
        for (int i = this.contents.size() - 1; i >= 0; --i) {
            Fig f = this.contents.get(i);
            f.setLayer(null);
        }
        this.contents.clear();
    }

    public FigNode getPortFig(Object port) {
        for (Fig f : this.getContents()) {
            FigNode fn;
            Fig port_fig;
            if (!(f instanceof FigNode) || (port_fig = (fn = (FigNode)f).getPortFig(port)) == null) continue;
            return fn;
        }
        return null;
    }

    @Override
    public Fig presentationFor(Object obj) {
        int figCount = this.contents.size();
        for (int figIndex = 0; figIndex < figCount; ++figIndex) {
            Fig fig = this.contents.get(figIndex);
            if (fig.getOwner() != obj) continue;
            return fig;
        }
        return null;
    }

    public List presentationsFor(Object obj) {
        ArrayList<Fig> presentations = new ArrayList<Fig>();
        int figCount = this.contents.size();
        for (int figIndex = 0; figIndex < figCount; ++figIndex) {
            Fig fig = this.contents.get(figIndex);
            if (fig.getOwner() != obj) continue;
            presentations.add(fig);
        }
        return presentations;
    }

    public int presentationCountFor(Object obj) {
        int count = 0;
        int figCount = this.contents.size();
        for (int figIndex = 0; figIndex < figCount; ++figIndex) {
            Fig fig = this.contents.get(figIndex);
            if (fig.getOwner() != obj) continue;
            ++count;
        }
        return count;
    }

    @Override
    public void paintContents(Graphics g) {
        this.paintContents(g, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void paintContents(Graphics g, FigPainter painter) {
        Iterator<Fig> figsIter;
        Rectangle clipBounds = g.getClipBounds();
        List<Fig> list = this.contents;
        synchronized (list) {
            figsIter = new ArrayList<Fig>(this.contents).iterator();
        }
        while (figsIter.hasNext()) {
            Fig fig = figsIter.next();
            if (clipBounds != null && !fig.intersects(clipBounds)) continue;
            if (painter == null) {
                fig.paint(g);
                continue;
            }
            painter.paint(g, fig);
        }
    }

    @Override
    public void sendToBack(Fig f) {
        this.contents.remove(f);
        this.contents.add(0, f);
    }

    @Override
    public void bringToFront(Fig f) {
        this.contents.remove(f);
        this.contents.add(f);
    }

    @Override
    public void sendBackward(Fig f) {
        int i = this.contents.indexOf(f);
        if (i == -1 || i == 0) {
            return;
        }
        Fig prevFig = this.contents.get(i - 1);
        this.contents.set(i, prevFig);
        this.contents.set(i - 1, f);
    }

    @Override
    public void bringForward(Fig f) {
        int i = this.contents.indexOf(f);
        if (i == -1 || i == this.contents.size() - 1) {
            return;
        }
        Fig nextFig = this.contents.get(i + 1);
        this.contents.set(i, nextFig);
        this.contents.set(i + 1, f);
    }

    @Override
    public void bringInFrontOf(Fig f1, Fig f2) {
        int i1 = this.contents.indexOf(f1);
        int i2 = this.contents.indexOf(f2);
        if (i1 == -1) {
            return;
        }
        if (i2 == -1) {
            return;
        }
        if (i1 >= i2) {
            return;
        }
        this.contents.remove(f1);
        this.contents.add(i2, f1);
    }

    @Override
    public void reorder(Fig f, int function) {
        switch (function) {
            case 1: {
                this.sendToBack(f);
                break;
            }
            case 2: {
                this.bringToFront(f);
                break;
            }
            case 3: {
                this.sendBackward(f);
                break;
            }
            case 4: {
                this.bringForward(f);
            }
        }
    }

    @Override
    public void preSave() {
        this.validate();
        for (int i = 0; i < this.contents.size(); ++i) {
            Fig f = this.contents.get(i);
            f.preSave();
        }
    }

    private boolean validate() {
        for (int i = this.contents.size() - 1; i >= 0; --i) {
            Fig f = this.contents.get(i);
            if (f.isRemoveStarted()) {
                LOG.error((Object)("A fig has been found that should have been removed " + f.toString()));
                this.contents.remove(i);
                return false;
            }
            if (f.getLayer() == this) continue;
            LOG.error((Object)("A fig has been found that doesn't refer back to the correct layer " + f.toString() + " - " + f.getLayer()));
            f.setLayer(this);
            return false;
        }
        return true;
    }

    @Override
    public void postSave() {
        for (int i = 0; i < this.contents.size(); ++i) {
            this.contents.get(i).postSave();
        }
    }

    @Override
    public void postLoad() {
        for (int i = 0; i < this.contents.size(); ++i) {
            this.contents.get(i).postLoad();
        }
    }
}

