/*
 * Decompiled with CFR 0.152.
 */
package org.argouml.language.php;

import java.util.ArrayList;
import java.util.GregorianCalendar;
import java.util.Iterator;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.TreeMap;
import org.apache.log4j.Logger;
import org.argouml.application.api.Argo;
import org.argouml.configuration.Configuration;
import org.argouml.configuration.ConfigurationKey;
import org.argouml.language.php.generator.NameGenerator;
import org.argouml.model.Model;

public final class PHPDocumentor {
    private static final int BLOCK_TYPE_CLASSIFIER = -4;
    private static final int BLOCK_TYPE_ATTRIBUTE = -3;
    private static final int BLOCK_TYPE_OPERATION = -2;
    private static final int BLOCK_TYPE_PACKAGE = -1;
    public static final int BLOCK_TYPE_UNKNOWN = 0;
    public static final int BLOCK_TYPE_FILE = 1;
    public static final int BLOCK_TYPE_INCLUDE = 2;
    private static final Logger LOG = Logger.getLogger(PHPDocumentor.class);
    private static String sArgoUserFullname = Configuration.getString((ConfigurationKey)Argo.KEY_USER_FULLNAME);
    private static String sArgoUserEmail = Configuration.getString((ConfigurationKey)Argo.KEY_USER_EMAIL);
    private DocBlock objDocBlock = null;
    private Object objModelElement = null;
    private int iDocBlockType = 0;
    private String sFilename = null;

    public PHPDocumentor() throws Exception {
        this.create(null);
    }

    public PHPDocumentor(Object object) throws Exception {
        this.create(object);
    }

    public PHPDocumentor(Object object, int n) throws Exception {
        this.create(object, n);
    }

    private void create(Object object) throws Exception {
        this.create(object, 0);
    }

    private void create(Object object, int n) throws Exception {
        switch (n) {
            case 0: {
                this.createUnknown(object);
                break;
            }
            case 1: {
                this.createFile(object);
                break;
            }
            case 2: {
                this.createInclude(object);
                break;
            }
            case -4: {
                this.createClassifier(object);
                break;
            }
            case -3: {
                this.createAttribute(object);
                break;
            }
            case -2: {
                this.createOperation(object);
                break;
            }
            case -1: {
                this.createPackage(object);
                break;
            }
            default: {
                throw new IllegalArgumentException(n + " is not a valid DocBlock type.");
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void createUnknown(Object object) throws Exception {
        if (object != null) {
            if (Model.getFacade().isAClassifier(object)) {
                this.createClassifier(object);
                return;
            } else if (Model.getFacade().isAAttribute(object)) {
                this.createAttribute(object);
                return;
            } else if (Model.getFacade().isAOperation(object)) {
                this.createOperation(object);
                return;
            } else {
                if (!Model.getFacade().isAPackage(object)) throw new IllegalArgumentException(object.getClass() + " is not a Classifier, Attribute or Operation.");
                this.createPackage(object);
            }
            return;
        } else {
            this.objDocBlock = new DocBlock();
            this.iDocBlockType = 0;
            this.objDocBlock.setDescription("UNKNOWN");
        }
    }

    private void createFile(Object object) throws Exception {
        if (!Model.getFacade().isAClassifier(object)) {
            throw new ClassCastException(object.getClass() + " has wrong object type, Classifier required");
        }
        this.objDocBlock = new DocBlock();
        this.objModelElement = object;
        this.iDocBlockType = 1;
        this.objDocBlock.enableTag(4);
        this.objDocBlock.enableTag(10);
        this.objDocBlock.disableTag(1);
        this.objDocBlock.disableTag(9);
        String string = NameGenerator.generatePackageName(object);
        if (string != null && string != "") {
            int n = string.indexOf("_");
            if (n == -1) {
                this.objDocBlock.setTag(4, string);
            } else {
                this.objDocBlock.setTag(4, string.substring(0, n));
                this.objDocBlock.setTag(10, string.substring(n + 1));
            }
        }
    }

    private final void updateFile(Object object) throws Exception {
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        int n = gregorianCalendar.get(5);
        int n2 = gregorianCalendar.get(2) + 1;
        int n3 = gregorianCalendar.get(1);
        int n4 = gregorianCalendar.get(11);
        int n5 = gregorianCalendar.get(12);
        int n6 = gregorianCalendar.get(13);
        String string = null;
        Object object2 = Model.getFacade().getRoot(object);
        if (object2 != null) {
            string = Model.getFacade().getName(object2);
        }
        String string2 = "";
        string2 = string2 + (n < 10 ? "0" + n + "." : n + ".");
        string2 = string2 + (n2 < 10 ? "0" + n2 + "." : n2 + ".");
        string2 = string2 + n3 + ", ";
        string2 = string2 + (n4 < 10 ? "0" + n4 + ":" : n4 + ":");
        string2 = string2 + (n5 < 10 ? "0" + n5 + ":" : n5 + ":");
        string2 = string2 + (n6 < 10 ? "0" + n6 : n6 + "");
        String string3 = "";
        if (this.sFilename != null && string != null) {
            string3 = string3 + string + " - " + this.sFilename + "\n\n";
        }
        string3 = string3 + "$Id$\n\n";
        if (string != null) {
            string3 = string3 + "This file is part of " + string + ".\n\n";
        }
        string3 = string3 + "Automatically generated on " + string2 + " with ArgoUML PHP module \n(last revised " + "$Date: 2010-01-12 20:14:42 +0100 (Tue, 12 Jan 2010) $)";
        this.objDocBlock.setDescription(string3);
        this.objDocBlock.setTags(Model.getFacade().getTaggedValues(object));
    }

    private final void createInclude(Object object) throws Exception {
        if (!Model.getFacade().isAClassifier(object)) {
            throw new ClassCastException(object.getClass() + " has wrong object type, Classifier required");
        }
        this.objDocBlock = new DocBlock();
        this.objModelElement = object;
        this.iDocBlockType = 2;
        this.objDocBlock.disableTag(1);
        this.objDocBlock.disableTag(9);
        this.objDocBlock.setDescription("include " + NameGenerator.generateClassifierName(object));
        this.objDocBlock.setTags(Model.getFacade().getTaggedValues(object));
    }

    private final void createClassifier(Object object) throws Exception {
        if (!Model.getFacade().isAClassifier(object)) {
            throw new ClassCastException(object.getClass() + " has wrong object type, Classifier required");
        }
        this.objDocBlock = new DocBlock();
        this.objModelElement = object;
        this.iDocBlockType = -4;
        this.objDocBlock.enableTag(4);
        this.objDocBlock.enableTag(10);
        this.objDocBlock.enableTag(9);
        this.objDocBlock.enableTag(13);
        this.objDocBlock.setDefaultDescription("Short description of class " + NameGenerator.generateClassifierName(object));
        this.objDocBlock.setTags(Model.getFacade().getTaggedValues(object));
        if (Model.getFacade().isAbstract(object)) {
            this.objDocBlock.setTag(13, "true");
        }
        if (Model.getFacade().isPublic(object)) {
            this.objDocBlock.setTag(1, "public");
        } else if (Model.getFacade().isProtected(object)) {
            this.objDocBlock.setTag(1, "protected");
        } else if (Model.getFacade().isPrivate(object)) {
            this.objDocBlock.setTag(1, "private");
        }
        String string = NameGenerator.generatePackageName(object);
        if (string != null && string != "") {
            int n = string.indexOf("_");
            if (n == -1) {
                this.objDocBlock.setTag(4, string);
            } else {
                this.objDocBlock.setTag(4, string.substring(0, n));
                this.objDocBlock.setTag(10, string.substring(n + 1));
            }
        }
    }

    private final void createAttribute(Object object) throws Exception {
        if (!Model.getFacade().isAAttribute(object)) {
            throw new ClassCastException(object.getClass() + " has wrong object type, Attribute required");
        }
        this.objDocBlock = new DocBlock();
        this.objModelElement = object;
        this.iDocBlockType = -3;
        this.objDocBlock.enableTag(9);
        this.objDocBlock.enableTag(11);
        this.objDocBlock.disableTag(2);
        this.objDocBlock.disableTag(12);
        this.objDocBlock.setDefaultDescription("Short description of attribute " + Model.getFacade().getName(object));
        this.objDocBlock.setTags(Model.getFacade().getTaggedValues(object));
        Object object2 = Model.getFacade().getType(object);
        if (object2 != null) {
            this.objDocBlock.setTag(11, Model.getFacade().getName(object2));
        }
        if (Model.getFacade().isPublic(object)) {
            this.objDocBlock.setTag(1, "public");
        } else if (Model.getFacade().isProtected(object)) {
            this.objDocBlock.setTag(1, "protected");
        } else if (Model.getFacade().isPrivate(object)) {
            this.objDocBlock.setTag(1, "private");
        }
    }

    private final void createOperation(Object object) throws Exception {
        if (!Model.getFacade().isAOperation(object)) {
            throw new ClassCastException(object.getClass() + " has wrong object type, Operation required");
        }
        this.objDocBlock = new DocBlock();
        this.objModelElement = object;
        this.iDocBlockType = -2;
        this.objDocBlock.enableTag(5);
        this.objDocBlock.enableTag(6);
        this.objDocBlock.enableTag(9);
        this.objDocBlock.enableTag(13);
        this.objDocBlock.setDefaultDescription("Short description of method " + Model.getFacade().getName(object));
        if (Model.getFacade().isPublic(object)) {
            this.objDocBlock.setTag(1, "public");
        } else if (Model.getFacade().isProtected(object)) {
            this.objDocBlock.setTag(1, "protected");
        } else if (Model.getFacade().isPrivate(object)) {
            this.objDocBlock.setTag(1, "private");
        }
        this.objDocBlock.setTags(Model.getFacade().getTaggedValues(object));
        if (Model.getFacade().isAbstract(object)) {
            this.objDocBlock.setTag(13, "true");
        }
        for (Object e : Model.getFacade().getParameters(object)) {
            String string;
            Object object2;
            Object object3;
            if (Model.getFacade().isReturn(e)) {
                object3 = Model.getFacade().getType(e);
                if (object3 != null) {
                    object2 = NameGenerator.generatePackageName(object3);
                    if (object2 != null && object2 != "") {
                        this.objDocBlock.setTag(6, (String)object2 + "_" + Model.getFacade().getName(object3));
                        continue;
                    }
                    this.objDocBlock.setTag(6, Model.getFacade().getName(object3));
                    continue;
                }
                this.objDocBlock.setTag(6, "mixed");
                continue;
            }
            object3 = new StringBuffer(" ");
            object2 = Model.getFacade().getType(e);
            if (object2 != null) {
                ((StringBuffer)object3).append(Model.getFacade().getName(object2));
            }
            ((StringBuffer)object3).append(" ");
            String string2 = Model.getFacade().getName(e);
            if (string2 != null) {
                ((StringBuffer)object3).append(string2);
            }
            if ((string = Model.getFacade().getTaggedValueValue(e, "documentation")) != null) {
                ((StringBuffer)object3).append(" ").append(string);
            }
            this.objDocBlock.addTag(5, ((StringBuffer)object3).toString());
        }
    }

    private void createPackage(Object object) throws Exception {
        if (!Model.getFacade().isAPackage(object)) {
            throw new ClassCastException(object.getClass() + " has wrong object type, Classifier required");
        }
        this.objDocBlock = new DocBlock();
        this.objModelElement = object;
        this.iDocBlockType = -1;
        this.objDocBlock.enableTag(4);
        this.objDocBlock.enableTag(10);
        this.objDocBlock.disableTag(1);
        this.objDocBlock.disableTag(9);
        this.objDocBlock.setDefaultDescription("Short description of package " + NameGenerator.generatePackageName(object));
        this.objDocBlock.setTags(Model.getFacade().getTaggedValues(object));
        String string = NameGenerator.generatePackageName(object);
        if (string != null && string != "") {
            int n = string.indexOf("_");
            if (n == -1) {
                this.objDocBlock.setTag(4, string);
            } else {
                this.objDocBlock.setTag(4, string.substring(0, n));
                this.objDocBlock.setTag(10, string.substring(n + 1));
            }
        }
    }

    public boolean setFilename(String string) {
        if (this.objDocBlock != null) {
            if (this.iDocBlockType == 1) {
                if (string != null && string.trim().length() > 0) {
                    this.sFilename = string.trim();
                    LOG.info((Object)("Set filename " + this.sFilename + " successfull."));
                    try {
                        this.updateFile(this.objModelElement);
                    }
                    catch (Exception exception) {
                        LOG.warn((Object)("Update file level DocBlock FAILED: " + exception.getMessage()));
                    }
                    return true;
                }
                throw new IllegalArgumentException("can not be empty");
            }
            LOG.error((Object)("method setFilename is only available for file level DocBlock, not for type " + this.iDocBlockType));
            return false;
        }
        return false;
    }

    public final String toString() {
        return this.toString("");
    }

    public final String toString(String string) {
        if (this.objDocBlock != null) {
            return this.objDocBlock.toString(string);
        }
        return null;
    }

    private final class VersionTag
    extends SimpleTag {
        public VersionTag() {
            super("version");
        }
    }

    private final class VarTag
    extends SimpleTag {
        public VarTag() {
            super("var");
        }
    }

    private final class SubpackageTag
    extends SimpleTag {
        public SubpackageTag() {
            super("subpackage");
        }
    }

    private final class StaticTag
    extends BooleanTag {
        public StaticTag() {
            super("static");
        }
    }

    private final class SinceTag
    extends SimpleTag {
        public SinceTag() {
            super("since");
        }
    }

    private final class SeeTag
    extends SimpleTag {
        public SeeTag() {
            super("see");
        }
    }

    private final class ReturnTag
    extends SimpleTag {
        public ReturnTag() {
            super("return");
        }
    }

    private final class ParamTag
    extends Tag {
        private String sType;
        private String sDescription;

        public ParamTag() {
            super("param");
            this.sType = "mixed";
            this.sDescription = null;
        }

        public boolean setType(String string) {
            if (string != null && string.trim() != "") {
                this.sType = string.trim();
                return true;
            }
            return false;
        }

        public boolean setDescription(String string) {
            if (string != null && string.trim() != "") {
                this.sDescription = string.trim();
                return true;
            }
            return false;
        }

        @Override
        public String getContent() {
            if (this.sDescription != null) {
                return this.sType + " " + this.sDescription;
            }
            return this.sType;
        }

        @Override
        public boolean setContent(String string) {
            if (string.indexOf(" ") != -1) {
                return this.setType(string.substring(0, string.indexOf(" "))) && this.setDescription(string.substring(string.indexOf(" ")));
            }
            return this.setType(string);
        }
    }

    private final class ParamList
    extends ArrayList<ParamTag>
    implements ITag {
        private ParamList() {
        }
    }

    private final class PackageTag
    extends SimpleTag {
        public PackageTag() {
            super("package");
        }
    }

    private final class DeprecatedTag
    extends BooleanTag {
        public DeprecatedTag() {
            super("deprecated");
        }
    }

    private final class AbstractTag
    extends BooleanTag {
        public AbstractTag() {
            super("abstract");
        }
    }

    private final class AuthorTag
    extends Tag {
        private String sName;
        private String sEmail;

        public AuthorTag() {
            super("author");
            this.sName = null;
            this.sEmail = null;
            if (this.setName(sArgoUserFullname)) {
                this.setEmail(sArgoUserEmail);
            } else {
                this.setName("firstname and lastname of author");
                this.setEmail("author@example.org");
            }
        }

        public boolean setName(String string) {
            if (string != null && string.trim().length() > 0) {
                this.sName = string.trim();
                this.sEmail = null;
                return true;
            }
            return false;
        }

        public boolean setEmail(String string) {
            if (string != null && string.trim().length() > 0) {
                this.sEmail = string.trim();
                return true;
            }
            return false;
        }

        @Override
        public String getContent() {
            if (this.sName != null) {
                if (this.sEmail != null) {
                    return this.sName + ", <" + this.sEmail + ">";
                }
                return this.sName;
            }
            return null;
        }

        @Override
        public boolean setContent(String string) {
            return this.setName(string);
        }
    }

    private final class AccessTag
    extends Tag {
        private boolean bPublic;
        private boolean bProtected;
        private boolean bPrivate;

        public AccessTag() {
            super("access");
            this.bPublic = true;
            this.bProtected = false;
            this.bPrivate = false;
        }

        public boolean setPublic() {
            this.bPublic = true;
            this.bProtected = false;
            this.bPrivate = false;
            return true;
        }

        public boolean setProtected() {
            this.bPublic = false;
            this.bProtected = true;
            this.bPrivate = false;
            return true;
        }

        public boolean setPrivate() {
            this.bPublic = false;
            this.bProtected = false;
            this.bPrivate = true;
            return true;
        }

        @Override
        public String getContent() {
            if (this.bPublic) {
                return "public";
            }
            if (this.bProtected) {
                return "protected";
            }
            if (this.bPrivate) {
                return "private";
            }
            return null;
        }

        @Override
        public boolean setContent(String string) {
            if (string != null && string.trim().length() > 0) {
                if (string.trim().equals("public")) {
                    return this.setPublic();
                }
                if (string.trim().equals("protected")) {
                    return this.setProtected();
                }
                if (string.trim().equals("private")) {
                    return this.setPrivate();
                }
                return false;
            }
            return false;
        }
    }

    private abstract class BooleanTag
    extends Tag {
        private boolean bContent;
        private String sReason;

        public BooleanTag(String string) {
            super(string);
            this.bContent = false;
            this.sReason = null;
        }

        @Override
        public final String getContent() {
            if (this.bContent) {
                if (this.sReason != null && this.sReason.length() > 0) {
                    return this.sReason;
                }
                return "";
            }
            return null;
        }

        @Override
        public final boolean setContent(String string) {
            if (string != null && string.trim().length() > 0) {
                if (string.trim().equals("true")) {
                    return this.setContent(true);
                }
                if (string.trim().equals("false")) {
                    return this.setContent(false);
                }
                this.sReason = string;
                return this.setContent(true);
            }
            return false;
        }

        public final boolean setContent(boolean bl) {
            this.bContent = bl;
            return true;
        }
    }

    private abstract class SimpleTag
    extends Tag {
        private String sContent;

        public SimpleTag(String string) {
            super(string);
            this.sContent = null;
        }

        @Override
        public final String getContent() {
            return this.sContent;
        }

        @Override
        public boolean setContent(String string) {
            if (string != null && string.trim().length() > 0) {
                this.sContent = string.trim();
                return true;
            }
            return false;
        }
    }

    private abstract class Tag
    implements ITag {
        private String sName = null;

        protected Tag(String string) {
            this.sName = string;
        }

        protected abstract String getContent();

        protected abstract boolean setContent(String var1);

        private final String getName() {
            return "@" + this.sName;
        }

        public final String getTag() {
            if (this.getContent() != null) {
                if (this.getContent().trim().length() > 0) {
                    return this.getName() + " " + this.getContent();
                }
                return this.getName();
            }
            return null;
        }
    }

    private static interface ITag {
    }

    private final class DocBlock {
        public static final int TAG_TYPE_ACCESS = 1;
        public static final int TAG_TYPE_AUTHOR = 2;
        public static final int TAG_TYPE_DEPRECATED = 3;
        public static final int TAG_TYPE_PACKAGE = 4;
        public static final int TAG_TYPE_PARAM = 5;
        public static final int TAG_TYPE_RETURN = 6;
        public static final int TAG_TYPE_SEE = 7;
        public static final int TAG_TYPE_SINCE = 8;
        public static final int TAG_TYPE_STATIC = 9;
        public static final int TAG_TYPE_SUBPACKAGE = 10;
        public static final int TAG_TYPE_VAR = 11;
        public static final int TAG_TYPE_VERSION = 12;
        public static final int TAG_TYPE_ABSTRACT = 13;
        private String sDefaultDescription = null;
        private String sDescription = null;
        private TreeMap<String, ITag> tmTags = new TreeMap();

        public DocBlock() {
            this.enableTag(1);
            this.enableTag(2);
            this.enableTag(3);
            this.enableTag(7);
            this.enableTag(8);
            this.enableTag(12);
        }

        public final String toString() {
            return this.toString("");
        }

        public final String toString(String string) {
            String string2 = "";
            if (this.sDescription == null || this.sDescription == "") {
                this.setDescription(this.sDefaultDescription);
            }
            string2 = string2 + string + "/**\n";
            string2 = string2 + this.wrapDescription(string, 80);
            for (Map.Entry<String, ITag> entry : this.tmTags.entrySet()) {
                ITag iTag;
                ITag iTag2 = entry.getValue();
                if (iTag2 instanceof ParamList) {
                    iTag = (ParamList)iTag2;
                    Iterator iterator = ((ArrayList)((Object)iTag)).iterator();
                    while (iterator.hasNext()) {
                        ParamTag paramTag = (ParamTag)iterator.next();
                        if (paramTag.getTag() == null) continue;
                        string2 = string2 + string + " * " + paramTag.getTag() + "\n";
                    }
                    continue;
                }
                iTag = (Tag)iTag2;
                if (((Tag)iTag).getContent() == null || ((Tag)iTag).getTag() == null) continue;
                string2 = string2 + string + " * " + ((Tag)iTag).getTag() + "\n";
            }
            string2 = string2 + string + " */\n";
            return string2;
        }

        private final String wrapDescription(String string, int n) {
            String string2 = "";
            if (this.sDescription != null && this.sDescription.trim() != "") {
                StringTokenizer stringTokenizer = new StringTokenizer(this.sDescription, "\n\r", true);
                while (stringTokenizer.hasMoreElements()) {
                    String string3 = stringTokenizer.nextToken();
                    if (!string3.equals("\n") && stringTokenizer.hasMoreElements()) {
                        stringTokenizer.nextToken();
                    } else if (string3.equals("\n")) {
                        string3 = "";
                    }
                    if (string3.length() > n - string.length() - 3) {
                        String string4 = "";
                        StringTokenizer stringTokenizer2 = new StringTokenizer(string3, " ");
                        while (stringTokenizer2.hasMoreElements()) {
                            String string5 = stringTokenizer2.nextToken();
                            int n2 = n - 4 - string.length();
                            if (string4.length() + string5.length() <= n2) {
                                string4 = string4 + (string4.trim() != "" ? " " : "");
                                string4 = string4 + string5;
                                continue;
                            }
                            if (string4.trim() != "") {
                                string2 = string2 + string + " * " + string4 + "\n";
                            }
                            string4 = "";
                        }
                        if (string4.trim() == "") continue;
                        string2 = string2 + string + " * " + string4 + "\n";
                        continue;
                    }
                    if (string3.trim() != "") {
                        string2 = string2 + string + " * " + string3 + "\n";
                        continue;
                    }
                    if (!stringTokenizer.hasMoreElements()) continue;
                    string2 = string2 + string + " *\n";
                }
                string2 = string2 + string + " *\n";
                return string2;
            }
            return "";
        }

        public final boolean setDescription(String string) {
            if (string != null && string.trim().length() > 0) {
                this.sDescription = string.trim();
                return true;
            }
            return false;
        }

        public final boolean setDefaultDescription(String string) {
            if (string != null && string.trim().length() > 0) {
                this.sDefaultDescription = string.trim();
                return true;
            }
            return false;
        }

        protected final void enableTag(int n) throws IllegalArgumentException {
            switch (n) {
                case 1: {
                    this.tmTags.put("access", new AccessTag());
                    break;
                }
                case 13: {
                    this.tmTags.put("abstract", new AbstractTag());
                    break;
                }
                case 2: {
                    this.tmTags.put("author", new AuthorTag());
                    break;
                }
                case 3: {
                    this.tmTags.put("deprecated", new DeprecatedTag());
                    break;
                }
                case 4: {
                    this.tmTags.put("package", new PackageTag());
                    break;
                }
                case 5: {
                    this.tmTags.put("param", new ParamList());
                    break;
                }
                case 6: {
                    this.tmTags.put("return", new ReturnTag());
                    break;
                }
                case 7: {
                    this.tmTags.put("see", new SeeTag());
                    break;
                }
                case 8: {
                    this.tmTags.put("since", new SinceTag());
                    break;
                }
                case 9: {
                    this.tmTags.put("static", new StaticTag());
                    break;
                }
                case 10: {
                    this.tmTags.put("subpackage", new SubpackageTag());
                    break;
                }
                case 11: {
                    this.tmTags.put("var", new VarTag());
                    break;
                }
                case 12: {
                    this.tmTags.put("version", new VersionTag());
                    break;
                }
                default: {
                    throw new IllegalArgumentException(n + " is not a valid tag type for add.");
                }
            }
        }

        protected final void disableTag(int n) throws IllegalArgumentException {
            switch (n) {
                case 1: {
                    this.tmTags.remove("access");
                    break;
                }
                case 2: {
                    this.tmTags.remove("author");
                    break;
                }
                case 9: {
                    this.tmTags.remove("static");
                    break;
                }
                case 12: {
                    this.tmTags.remove("version");
                    break;
                }
                default: {
                    throw new IllegalArgumentException(n + " is not a valid tag type for remove.");
                }
            }
        }

        public final boolean setTags(Iterator iterator) {
            if (iterator == null) {
                return false;
            }
            if (!iterator.hasNext()) {
                return true;
            }
            boolean bl = true;
            while (iterator.hasNext()) {
                if (this.setTag(iterator.next())) continue;
                bl = false;
            }
            return bl;
        }

        private final boolean setTag(Object object) {
            if (!Model.getFacade().isATaggedValue(object)) {
                return false;
            }
            boolean bl = false;
            try {
                bl = this.setTag(Model.getFacade().getTagOfTag(object), Model.getFacade().getValueOfTag(object));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                LOG.warn((Object)("setting tag FAILED: " + illegalArgumentException.getMessage()));
            }
            return bl;
        }

        public final boolean addTag(int n, String string) throws IllegalArgumentException {
            switch (n) {
                case 5: {
                    ParamList paramList = (ParamList)this.tmTags.get("param");
                    if (paramList == null) break;
                    ParamTag paramTag = new ParamTag();
                    if (paramTag.setContent(string)) {
                        return paramList.add(paramTag);
                    }
                    return false;
                }
                default: {
                    throw new IllegalArgumentException("Can not add a tag of type " + n + " with value '" + string + "' to the DocBlock");
                }
            }
            return false;
        }

        public final boolean setTag(int n, String string) throws IllegalArgumentException {
            Tag tag = null;
            switch (n) {
                case 1: {
                    tag = (AccessTag)this.tmTags.get("access");
                    break;
                }
                case 13: {
                    tag = (AbstractTag)this.tmTags.get("abstract");
                    break;
                }
                case 2: {
                    tag = (AuthorTag)this.tmTags.get("author");
                    break;
                }
                case 3: {
                    tag = (DeprecatedTag)this.tmTags.get("deprecated");
                    break;
                }
                case 4: {
                    tag = (PackageTag)this.tmTags.get("package");
                    break;
                }
                case 6: {
                    tag = (ReturnTag)this.tmTags.get("return");
                    break;
                }
                case 7: {
                    tag = (SeeTag)this.tmTags.get("see");
                    break;
                }
                case 8: {
                    tag = (SinceTag)this.tmTags.get("since");
                    break;
                }
                case 9: {
                    tag = (StaticTag)this.tmTags.get("static");
                    break;
                }
                case 10: {
                    tag = (SubpackageTag)this.tmTags.get("subpackage");
                    break;
                }
                case 11: {
                    tag = (VarTag)this.tmTags.get("var");
                    break;
                }
                case 12: {
                    tag = (VersionTag)this.tmTags.get("version");
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Can not set value '" + string + "' for tag type " + n);
                }
            }
            if (tag != null) {
                return tag.setContent(string);
            }
            return false;
        }

        private final boolean setTag(String string, String string2) throws IllegalArgumentException {
            if (string.equals("documentation")) {
                return this.setDescription(string2);
            }
            if (string.equals("access")) {
                return this.setTag(1, string2);
            }
            if (string.equals("abstract")) {
                return this.setTag(13, string2);
            }
            if (string.equals("author")) {
                return this.setTag(2, string2);
            }
            if (string.equals("deprecated")) {
                return this.setTag(3, string2);
            }
            if (string.equals("package")) {
                return this.setTag(4, string2);
            }
            if (string.equals("return")) {
                return this.setTag(6, string2);
            }
            if (string.equals("see")) {
                return this.setTag(7, string2);
            }
            if (string.equals("since")) {
                return this.setTag(8, string2);
            }
            if (string.equals("static")) {
                return this.setTag(9, string2);
            }
            if (string.equals("subpackage")) {
                return this.setTag(10, string2);
            }
            if (string.equals("var")) {
                return this.setTag(11, string2);
            }
            if (string.equals("version")) {
                return this.setTag(12, string2);
            }
            if (!(string.equals("src_lang") || string.equals("transient") || string.equals("volatile"))) {
                throw new IllegalArgumentException("Can not set value '" + string2 + "' for tag '" + string + "'");
            }
            return true;
        }
    }
}

