/*

Copyright (C) 2002  Gopal Narayanan <gopal@astro.umass.edu>

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307,
USA.

*/

/* print_trans.c
 */

#include <stdio.h>
#include <stdlib.h>
#include <time.h>
#include "transcalc.h"
extern void setup_label (short, trans_label *);
extern short transtype_int (void);


/* private stuff for print dialog */
GtkWidget *print_command;  /* Gtk Entry contains print command */
static gchar* print_command_text = "lpr";

/* The following adapted from Pan */
static gint
print_execute (const gchar *command, const gchar *text)
{
  FILE * fp = NULL;

  fp = popen (command, "w");
  if (fp == NULL) {
    fprintf (stderr,"print_execute(): error in popen()\n");
    perror("pipe");
    return -1;
  }

  /* dump the message to the pipe */
  fputs (text, fp);
  fflush (fp);
  fclose (fp);
  return 0;
}

gchar *
get_trans_text ()
{
  time_t date;
  gchar *retval = NULL;
  trans_label *tlabel;
  int i;
  gchar *newch1=NULL;
  const gchar *newch2 = NULL;
  gchar *tmpstr=NULL;
  GString *s = g_string_new (NULL);


  /* get current date and time */
  time(&date);
  g_string_sprintf (s,"TRANSCALC v%s\n",VERSION);
  g_string_sprintfa (s, "%s\n",ctime(&date));

  g_string_append (s, "Transmission Line Type: ");
  newch1 = gtk_entry_get_text (GTK_ENTRY (GTK_COMBO(transtype_combo)->entry));
  g_string_append (s, newch1);
  g_string_append (s, "\n\n\n");

/* allocate and setup labels */
  tlabel = g_malloc(sizeof(*tlabel));
  setup_label ((short) transtype_int (), tlabel);

  g_string_append (s, "Substrate Parameters: \n\n");
  
  /* print substrate parameters */
  for (i=0; i < NUMSUBPARS; i++) {
    newch1 = gtk_entry_get_text(GTK_ENTRY (twin->subparam_text[i]));
    /* if entry has some text do something - otherwise skip */
    if (newch1[0] != '\0') {
      newch2 = gtk_entry_get_text (GTK_ENTRY 
                                   (GTK_COMBO (twin->subparam_combo[i])->entry));
      g_string_sprintfa (s, "  %s = %s",tlabel->substrate_label_name[i],
			 newch1);
      if (strcmp(newch2,"NA")) 
	g_string_sprintfa (s, " %s ",newch2);
      g_string_sprintfa (s, "  (%s) \n", tlabel->stooltips_helptext[i]);
    }
  }

  g_string_append (s, "\nComponent Parameters: \n\n");

  /* print component parameters */
  for (i=0; i< NUMCOMPPARS; i++) {
    newch1 = gtk_entry_get_text (GTK_ENTRY (twin->component_param_text[i]));
    /* if entry has some text do something - otherwise skip */
    if (newch1[0] != '\0') {
      newch2 = gtk_entry_get_text (GTK_ENTRY 
                                   (GTK_COMBO (twin->component_param_combo[i])->entry));
      g_string_sprintfa (s, "  %s = %s",tlabel->component_label_name[i],
			 newch1);
      if (strcmp(newch2,"NA")) 
	g_string_sprintfa (s, " %s ",newch2);
      g_string_sprintfa (s, "  (%s) \n", tlabel->ctooltips_helptext[i]);
    }
  }    

  g_string_append (s, "\nPhysical Parameters: \n\n");

  /* print physical parameters */
  for (i=0; i< NUMPHYSPARS; i++) {
    newch1 = gtk_entry_get_text (GTK_ENTRY (twin->physical_param_text[i]));
    /* if entry has some text do something - otherwise skip */
    if (newch1[0] != '\0') {
      newch2 = gtk_entry_get_text (GTK_ENTRY 
                                   (GTK_COMBO (twin->physical_param_combo[i])->entry));
      g_string_sprintfa (s, "  %s = %s",tlabel->physical_label_name[i],
			 newch1);
      if (strcmp(newch2,"NA")) 
	g_string_sprintfa (s, " %s ",newch2);
      if (i < 2) {
	gtk_label_get(GTK_LABEL (GTK_BIN (twin->physical_param_fix[i])->child), 
		      &tmpstr);
	g_string_sprintfa (s, "<%s> ", tmpstr);
      }
      g_string_sprintfa (s, "  (%s) \n", tlabel->ptooltips_helptext[i]);
    }
  }    

  g_string_append (s, "\nElectrical Parameters: \n\n");

  /* print electrical parameters */
  for (i=0; i< NUMPHYSPARS; i++) {
    newch1 = gtk_entry_get_text (GTK_ENTRY (twin->electrical_param_text[i]));
    /* if entry has some text do something - otherwise skip */
    if (newch1[0] != '\0') {
      newch2 = gtk_entry_get_text (GTK_ENTRY 
                                   (GTK_COMBO (twin->electrical_param_combo[i])->entry));
      g_string_sprintfa (s, "  %s = %s",tlabel->electrical_label_name[i],
			 newch1);
      if (strcmp(newch2,"NA")) 
	g_string_sprintfa (s, " %s ",newch2);
      g_string_sprintfa (s, "  (%s) \n", tlabel->etooltips_helptext[i]);
    }
  }    

  g_string_append (s, "\nCalculated Results: \n\n");

  /* print calculated results */
  gtk_label_get (GTK_LABEL (twin->results_text), &newch1);
  g_string_sprintfa (s, "%s", newch1);
  
  /* write status */
  g_string_append (s, "\nStatus: \n\n");
  gtk_label_get(GTK_LABEL (twin->status), &newch1);
  g_string_sprintfa (s, "%s\n", newch1);
  

  free (tlabel);
  retval = s->str;
  g_string_free (s, FALSE);
  return retval;
}

  

void
print_ok (GtkWidget *widget, gpointer data)
{

  gchar *command;
  gchar *text;

  /* find out how to execute it */
  command = gtk_editable_get_chars (GTK_EDITABLE(print_command),0,-1);
  /* build the text */
  text = get_trans_text ();

  print_command_text = g_strdup (command);

  if (print_execute (command, text))
    fprintf(stderr, "Printing with command: %s failed \n", command); 
  /*  fprintf (stderr, "%s", text);*/
  g_free (text);
  g_free (command);
  gtk_widget_destroy (GTK_WIDGET (data));
}


void
print_cb (GtkWidget *widget, gpointer data)
{

  static GtkWidget *dialog=NULL;
  GtkWidget *button;
  GtkWidget *label, *labelbox;
  GtkWidget *hbox;
  GtkTooltips *tooltips;

  if (!dialog) {
    dialog = gtk_dialog_new ();
    gtk_signal_connect (GTK_OBJECT (dialog), "destroy",
                        GTK_SIGNAL_FUNC(gtk_widget_destroyed),
                        &dialog);
    gtk_window_set_title (GTK_WINDOW (dialog), "Print");
    gtk_container_set_border_width (GTK_CONTAINER (dialog), 10);
    gtk_window_position (GTK_WINDOW (dialog), GTK_WIN_POS_CENTER);

    hbox = gtk_hbox_new (FALSE, 25);
    gtk_box_pack_start (GTK_BOX (GTK_DIALOG (dialog)->vbox),
                        hbox, FALSE, FALSE, 0);

    tooltips = gtk_tooltips_new ();
    labelbox = gtk_event_box_new ();
    gtk_tooltips_set_tip (tooltips, labelbox, 
			  "Use 'cat > file' to print to file", NULL);

    label = gtk_label_new ("Print Command");
    gtk_container_add (GTK_CONTAINER (labelbox), label);
    gtk_box_pack_start (GTK_BOX (hbox),labelbox, FALSE, FALSE, 0);
    gtk_widget_show (label); gtk_widget_show (labelbox);



    print_command = gtk_entry_new ();
    gtk_box_pack_start (GTK_BOX (hbox), print_command, FALSE, FALSE, 0);
    gtk_widget_show (print_command); gtk_widget_show (hbox);
    gtk_entry_set_text (GTK_ENTRY (print_command), print_command_text);
    
    hbox = gtk_hbox_new (FALSE, 5);
    gtk_box_pack_start (GTK_BOX (GTK_DIALOG (dialog)->action_area),
                        hbox, TRUE, TRUE, 0);
    button = gtk_button_new_with_label ("Print");
    gtk_box_pack_start (GTK_BOX (hbox), button, TRUE, TRUE, 0);
    gtk_signal_connect (GTK_OBJECT (button), "clicked",
                        GTK_SIGNAL_FUNC (print_ok), dialog);
    gtk_widget_show (button);


    button = gtk_button_new_with_label ("Cancel");
    GTK_WIDGET_SET_FLAGS (button, GTK_CAN_DEFAULT);
    gtk_box_pack_start (GTK_BOX (hbox), button, TRUE, TRUE, 0);
    gtk_signal_connect_object (GTK_OBJECT (button), "clicked",
			       GTK_SIGNAL_FUNC (gtk_widget_destroy), 
			       GTK_OBJECT (dialog));
    gtk_widget_show (button);
    gtk_widget_grab_default (button);
    gtk_widget_show (hbox);

  }
  
  if (!GTK_WIDGET_VISIBLE (dialog)) 
    gtk_widget_show(dialog);
  else 
    gtk_widget_destroy (dialog);
}

