/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3;

import java.lang.reflect.Constructor;
import java.lang.reflect.Modifier;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.AbstractLangTest;
import org.apache.commons.lang3.Validate;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Nested;
import org.junit.jupiter.api.Test;

public class ValidateTest
extends AbstractLangTest {

    @Nested
    final class ValidState {
        ValidState() {
        }

        @Nested
        final class WitMessage {
            WitMessage() {
            }

            @Test
            void shouldNotThrowExceptionForValidIndex() {
                Validate.validState((boolean)true, (String)"The Message", (Object[])new Object[0]);
            }

            @Test
            void shouldThrowExceptionForTrueExpression() {
                Assertions.assertThrows(IllegalStateException.class, () -> Validate.validState((boolean)false, (String)"The Message", (Object[])new Object[0]));
            }
        }

        @Nested
        final class WithoutMessage {
            WithoutMessage() {
            }

            @Test
            void shouldNotThrowExceptionForTrueExpression() {
                Validate.validState((boolean)true);
            }

            @Test
            void shouldThrowExceptionForTrueExpression() {
                Assertions.assertThrows(IllegalStateException.class, () -> Validate.validState((boolean)false));
            }
        }
    }

    @Nested
    final class ValidIndex {
        ValidIndex() {
        }

        @Nested
        final class WithCollection {
            WithCollection() {
            }

            @Nested
            final class WithoutMessage {
                WithoutMessage() {
                }

                @Test
                void shouldNotThrowExceptionForValidIndex() {
                    Validate.validIndex(Collections.singleton("a"), (int)0);
                }

                @Test
                void shouldReturnSameInstance() {
                    Set<String> col = Collections.singleton("a");
                    Assertions.assertSame(col, (Object)Validate.validIndex(col, (int)0));
                }

                @Test
                void shouldThrowIndexOutOfBoundsExceptionWithDefaultMessageForIndexOutOfBounds() {
                    IndexOutOfBoundsException ex = (IndexOutOfBoundsException)Assertions.assertThrows(IndexOutOfBoundsException.class, () -> Validate.validIndex(Collections.singleton("a"), (int)1));
                    Assertions.assertEquals((Object)"The validated collection index is invalid: 1", (Object)ex.getMessage());
                }

                @Test
                void shouldThrowIndexOutOfBoundsExceptionWithDefaultMessageForNegativeIndex() {
                    IndexOutOfBoundsException ex = (IndexOutOfBoundsException)Assertions.assertThrows(IndexOutOfBoundsException.class, () -> Validate.validIndex(Collections.singleton("a"), (int)-1));
                    Assertions.assertEquals((Object)"The validated collection index is invalid: -1", (Object)ex.getMessage());
                }

                @Test
                void shouldThrowNullPointerExceptionWithDefaultForNullCollection() {
                    NullPointerException ex = (NullPointerException)Assertions.assertThrows(NullPointerException.class, () -> Validate.validIndex((Collection)null, (int)1));
                    Assertions.assertEquals((Object)"collection", (Object)ex.getMessage());
                }
            }

            @Nested
            final class WithMessage {
                WithMessage() {
                }

                @Test
                void shouldNotThrowExceptionForValidIndex() {
                    Validate.validIndex(Collections.singleton("a"), (int)0, (String)"MSG", (Object[])new Object[0]);
                }

                @Test
                void shouldReturnSameInstance() {
                    Set<String> col = Collections.singleton("a");
                    Assertions.assertSame(col, (Object)Validate.validIndex(col, (int)0, (String)"MSG", (Object[])new Object[0]));
                }

                @Test
                void shouldThrowIndexOutOfBoundsExceptionWithGivenMessageForIndexOutOfBounds() {
                    IndexOutOfBoundsException ex = (IndexOutOfBoundsException)Assertions.assertThrows(IndexOutOfBoundsException.class, () -> Validate.validIndex(Collections.singleton("a"), (int)1, (String)"MSG", (Object[])new Object[0]));
                    Assertions.assertEquals((Object)"MSG", (Object)ex.getMessage());
                }

                @Test
                void shouldThrowIndexOutOfBoundsExceptionWithGivenMessageForNegativeIndex() {
                    IndexOutOfBoundsException ex = (IndexOutOfBoundsException)Assertions.assertThrows(IndexOutOfBoundsException.class, () -> Validate.validIndex(Collections.singleton("a"), (int)-1, (String)"MSG", (Object[])new Object[0]));
                    Assertions.assertEquals((Object)"MSG", (Object)ex.getMessage());
                }

                @Test
                void shouldThrowNullPointerExceptionWithDefaultMessageForNullCollection() {
                    NullPointerException ex = (NullPointerException)Assertions.assertThrows(NullPointerException.class, () -> Validate.validIndex((Collection)null, (int)1, (String)"MSG", (Object[])new Object[0]));
                    Assertions.assertEquals((Object)"collection", (Object)ex.getMessage());
                }
            }
        }

        @Nested
        final class WithCharSequence {
            WithCharSequence() {
            }

            @Nested
            final class WithoutMessage {
                WithoutMessage() {
                }

                @Test
                void shouldNotThrowExceptionForValidIndex() {
                    Validate.validIndex((CharSequence)"a", (int)0);
                }

                @Test
                void shouldReturnSameInstance() {
                    String str = "a";
                    Assertions.assertSame((Object)"a", (Object)Validate.validIndex((CharSequence)"a", (int)0));
                }

                @Test
                void shouldThrowIndexOutOfBoundsExceptionWithDefaultMessageForIndexOutOfBounds() {
                    IndexOutOfBoundsException ex = (IndexOutOfBoundsException)Assertions.assertThrows(IndexOutOfBoundsException.class, () -> Validate.validIndex((CharSequence)"a", (int)1));
                    Assertions.assertEquals((Object)"The validated character sequence index is invalid: 1", (Object)ex.getMessage());
                }

                @Test
                void shouldThrowIndexOutOfBoundsExceptionWithDefaultMessageForNegativeIndex() {
                    IndexOutOfBoundsException ex = (IndexOutOfBoundsException)Assertions.assertThrows(IndexOutOfBoundsException.class, () -> Validate.validIndex((CharSequence)"a", (int)-1));
                    Assertions.assertEquals((Object)"The validated character sequence index is invalid: -1", (Object)ex.getMessage());
                }

                @Test
                void shouldThrowNullPointerExceptionWithDefaultForNullString() {
                    NullPointerException ex = (NullPointerException)Assertions.assertThrows(NullPointerException.class, () -> Validate.validIndex((CharSequence)null, (int)1));
                    Assertions.assertEquals((Object)"chars", (Object)ex.getMessage());
                }
            }

            @Nested
            final class WithMessage {
                WithMessage() {
                }

                @Test
                void shouldNotThrowExceptionForValidIndex() {
                    Validate.validIndex((CharSequence)"a", (int)0, (String)"MSG", (Object[])new Object[0]);
                }

                @Test
                void shouldReturnSameInstance() {
                    String str = "a";
                    Assertions.assertSame((Object)"a", (Object)Validate.validIndex((CharSequence)"a", (int)0, (String)"MSG", (Object[])new Object[0]));
                }

                @Test
                void shouldThrowIndexOutOfBoundsExceptionWithGivenMessageForIndexOutOfBounds() {
                    IndexOutOfBoundsException ex = (IndexOutOfBoundsException)Assertions.assertThrows(IndexOutOfBoundsException.class, () -> Validate.validIndex((CharSequence)"a", (int)1, (String)"MSG", (Object[])new Object[0]));
                    Assertions.assertEquals((Object)"MSG", (Object)ex.getMessage());
                }

                @Test
                void shouldThrowIndexOutOfBoundsExceptionWithGivenMessageForNegativeIndex() {
                    IndexOutOfBoundsException ex = (IndexOutOfBoundsException)Assertions.assertThrows(IndexOutOfBoundsException.class, () -> Validate.validIndex((CharSequence)"a", (int)-1, (String)"MSG", (Object[])new Object[0]));
                    Assertions.assertEquals((Object)"MSG", (Object)ex.getMessage());
                }

                @Test
                void shouldThrowNullPointerExceptionWithDefaultMessageForNullStr() {
                    NullPointerException ex = (NullPointerException)Assertions.assertThrows(NullPointerException.class, () -> Validate.validIndex((CharSequence)null, (int)1, (String)"MSG", (Object[])new Object[0]));
                    Assertions.assertEquals((Object)"chars", (Object)ex.getMessage());
                }
            }
        }

        @Nested
        final class WithArray {
            WithArray() {
            }

            @Nested
            final class WithoutMessage {
                WithoutMessage() {
                }

                @Test
                void shouldNotThrowExceptionForValidIndex() {
                    Validate.validIndex((Object[])new String[]{"a"}, (int)0);
                }

                @Test
                void shouldReturnSameInstance() {
                    Object[] array = new String[]{"a"};
                    Assertions.assertSame((Object)array, (Object)Validate.validIndex((Object[])array, (int)0));
                }

                @Test
                void shouldThrowIndexOutOfBoundsExceptionWithDefaultMessageForIndexOutOfBounds() {
                    IndexOutOfBoundsException ex = (IndexOutOfBoundsException)Assertions.assertThrows(IndexOutOfBoundsException.class, () -> Validate.validIndex((Object[])new String[]{"a"}, (int)1));
                    Assertions.assertEquals((Object)"The validated array index is invalid: 1", (Object)ex.getMessage());
                }

                @Test
                void shouldThrowIndexOutOfBoundsExceptionWithDefaultMessageForNegativeIndex() {
                    IndexOutOfBoundsException ex = (IndexOutOfBoundsException)Assertions.assertThrows(IndexOutOfBoundsException.class, () -> Validate.validIndex((Object[])new String[]{"a"}, (int)-1));
                    Assertions.assertEquals((Object)"The validated array index is invalid: -1", (Object)ex.getMessage());
                }

                @Test
                void shouldThrowNullPointerExceptionWithDefaultForNullArray() {
                    NullPointerException ex = (NullPointerException)Assertions.assertThrows(NullPointerException.class, () -> Validate.validIndex((Object[])null, (int)1));
                    Assertions.assertEquals((Object)"array", (Object)ex.getMessage());
                }
            }

            @Nested
            final class WithMessage {
                WithMessage() {
                }

                @Test
                void shouldNotThrowExceptionForValidIndex() {
                    Validate.validIndex((Object[])new String[]{"a"}, (int)0, (String)"MSG", (Object[])new Object[0]);
                }

                @Test
                void shouldReturnSameInstance() {
                    Object[] array = new String[]{"a"};
                    Assertions.assertSame((Object)array, (Object)Validate.validIndex((Object[])array, (int)0, (String)"MSG", (Object[])new Object[0]));
                }

                @Test
                void shouldThrowIndexOutOfBoundsExceptionWithGivenMessageForIndexOutOfBounds() {
                    IndexOutOfBoundsException ex = (IndexOutOfBoundsException)Assertions.assertThrows(IndexOutOfBoundsException.class, () -> Validate.validIndex((Object[])new String[]{"a"}, (int)1, (String)"MSG", (Object[])new Object[0]));
                    Assertions.assertEquals((Object)"MSG", (Object)ex.getMessage());
                }

                @Test
                void shouldThrowIndexOutOfBoundsExceptionWithGivenMessageForNegativeIndex() {
                    IndexOutOfBoundsException ex = (IndexOutOfBoundsException)Assertions.assertThrows(IndexOutOfBoundsException.class, () -> Validate.validIndex((Object[])new String[]{"a"}, (int)-1, (String)"MSG", (Object[])new Object[0]));
                    Assertions.assertEquals((Object)"MSG", (Object)ex.getMessage());
                }

                @Test
                void shouldThrowNullPointerExceptionWithDefaultMessageForNullArray() {
                    NullPointerException ex = (NullPointerException)Assertions.assertThrows(NullPointerException.class, () -> Validate.validIndex((Object[])null, (int)1, (String)"MSG", (Object[])new Object[0]));
                    Assertions.assertEquals((Object)"array", (Object)ex.getMessage());
                }
            }
        }
    }

    @Nested
    final class UtilClassConventions {
        UtilClassConventions() {
        }

        @Test
        void hasOnlyOnePublicConstructor() {
            Constructor<?>[] cons = Validate.class.getDeclaredConstructors();
            Assertions.assertEquals((int)1, (int)cons.length);
        }

        @Test
        void instancesCanBeConstrcuted() {
            Assertions.assertNotNull((Object)new Validate());
        }

        @Test
        void isNonFinalClass() {
            Assertions.assertFalse((boolean)Modifier.isFinal(Validate.class.getModifiers()));
        }

        @Test
        void isPublicClass() {
            Assertions.assertTrue((boolean)Modifier.isPublic(Validate.class.getModifiers()));
        }
    }

    @Nested
    final class NotNull {
        NotNull() {
        }

        @Nested
        final class WithoutMessage {
            WithoutMessage() {
            }

            @Test
            void shouldNotThrowForNonNullReference() {
                Validate.notNull((Object)new Object());
            }

            @Test
            void shouldReturnTheSameInstance() {
                Assertions.assertSame((Object)"Hi", (Object)Validate.notNull((Object)"Hi"));
            }

            @Test
            void shouldThrowExceptionWithDefaultMessageForNullReference() {
                NullPointerException ex = (NullPointerException)Assertions.assertThrows(NullPointerException.class, () -> Validate.notNull(null));
                Assertions.assertEquals((Object)"The validated object is null", (Object)ex.getMessage());
            }
        }

        @Nested
        final class WithMessage {
            WithMessage() {
            }

            @Test
            void shouldNotThrowForNonNullReference() {
                Validate.notNull((Object)new Object(), (String)"MSG", (Object[])new Object[0]);
            }

            @Test
            void shouldReturnTheSameInstance() {
                Assertions.assertSame((Object)"Hi", (Object)Validate.notNull((Object)"Hi", (String)"MSG", (Object[])new Object[0]));
            }

            @Test
            void shouldThrowExceptionWithGivenMessageForNullReference() {
                NullPointerException ex = (NullPointerException)Assertions.assertThrows(NullPointerException.class, () -> Validate.notNull(null, (String)"MSG", (Object[])new Object[0]));
                Assertions.assertEquals((Object)"MSG", (Object)ex.getMessage());
            }
        }
    }

    @Nested
    final class NotNaN {
        NotNaN() {
        }

        @Nested
        final class WithoutMessage {
            WithoutMessage() {
            }

            @Test
            void shouldNotThrowExceptionForNegativeInfinity() {
                Validate.notNaN((double)Double.NEGATIVE_INFINITY);
            }

            @Test
            void shouldNotThrowExceptionForNumber() {
                Validate.notNaN((double)0.0);
            }

            @Test
            void shouldNotThrowExceptionForPositiveInfinity() {
                Validate.notNaN((double)Double.POSITIVE_INFINITY);
            }

            @Test
            void shouldThrowIllegalArgumentExceptionWithDefaultMessageForNaN() {
                IllegalArgumentException ex = (IllegalArgumentException)Assertions.assertThrows(IllegalArgumentException.class, () -> Validate.notNaN((double)Double.NaN));
                Assertions.assertEquals((Object)"The validated value is not a number", (Object)ex.getMessage());
            }
        }

        @Nested
        final class WithMessage {
            WithMessage() {
            }

            @Test
            void shouldNotThrowExceptionForNegativeInfinity() {
                Validate.notNaN((double)Double.NEGATIVE_INFINITY, (String)"MSG", (Object[])new Object[0]);
            }

            @Test
            void shouldNotThrowExceptionForNumber() {
                Validate.notNaN((double)0.0, (String)"MSG", (Object[])new Object[0]);
            }

            @Test
            void shouldNotThrowExceptionForPositiveInfinity() {
                Validate.notNaN((double)Double.POSITIVE_INFINITY, (String)"MSG", (Object[])new Object[0]);
            }

            @Test
            void shouldThrowIllegalArgumentExceptionWithGivenMessageForNaN() {
                IllegalArgumentException ex = (IllegalArgumentException)Assertions.assertThrows(IllegalArgumentException.class, () -> Validate.notNaN((double)Double.NaN, (String)"MSG", (Object[])new Object[0]));
                Assertions.assertEquals((Object)"MSG", (Object)ex.getMessage());
            }
        }
    }

    @Nested
    final class NotEmpty {
        NotEmpty() {
        }

        @Nested
        final class WithMap {
            WithMap() {
            }

            @Nested
            final class WithoutMessage {
                WithoutMessage() {
                }

                @Test
                void shouldNotThrowExceptionForMapContainingNullMapping() {
                    Validate.notEmpty(Collections.singletonMap("key", null));
                }

                @Test
                void shouldReturnTheSameInstance() {
                    Map<String, String> singletonMap = Collections.singletonMap("key", "value");
                    Assertions.assertSame(singletonMap, (Object)Validate.notEmpty(singletonMap));
                }

                @Test
                void shouldThrowIllegalArgumentExceptionWithDefaultMessageForEmptyMap() {
                    IllegalArgumentException ex = (IllegalArgumentException)Assertions.assertThrows(IllegalArgumentException.class, () -> Validate.notEmpty(Collections.emptyMap()));
                    Assertions.assertEquals((Object)"The validated map is empty", (Object)ex.getMessage());
                }

                @Test
                void shouldThrowNullPointerExceptionWithDefaultMessageForNullMap() {
                    NullPointerException ex = (NullPointerException)Assertions.assertThrows(NullPointerException.class, () -> Validate.notEmpty((Map)null));
                    Assertions.assertEquals((Object)"The validated map is empty", (Object)ex.getMessage());
                }
            }

            @Nested
            final class WithMessage {
                WithMessage() {
                }

                @Test
                void shouldNotThrowExceptionForMapContainingNullMapping() {
                    Validate.notEmpty(Collections.singletonMap("key", null), (String)"MSG", (Object[])new Object[0]);
                }

                @Test
                void shouldReturnTheSameInstance() {
                    Map<String, String> singletonMap = Collections.singletonMap("key", "value");
                    Assertions.assertSame(singletonMap, (Object)Validate.notEmpty(singletonMap, (String)"MSG", (Object[])new Object[0]));
                }

                @Test
                void shouldThrowIllegalArgumentExceptionWithGivenMessageForEmptyMap() {
                    IllegalArgumentException ex = (IllegalArgumentException)Assertions.assertThrows(IllegalArgumentException.class, () -> Validate.notEmpty(Collections.emptyMap(), (String)"MSG", (Object[])new Object[0]));
                    Assertions.assertEquals((Object)"MSG", (Object)ex.getMessage());
                }

                @Test
                void shouldThrowNullPointerExceptionWithGivenMessageForNullMap() {
                    NullPointerException ex = (NullPointerException)Assertions.assertThrows(NullPointerException.class, () -> Validate.notEmpty((Map)null, (String)"MSG", (Object[])new Object[0]));
                    Assertions.assertEquals((Object)"MSG", (Object)ex.getMessage());
                }
            }
        }

        @Nested
        final class WithCollection {
            WithCollection() {
            }

            @Nested
            final class WithoutMessage {
                WithoutMessage() {
                }

                @Test
                void shouldNotThrowExceptionForCollectionContainingNullReference() {
                    Validate.notEmpty(Collections.singleton(null));
                }

                @Test
                void shouldReturnTheSameInstance() {
                    Set<String> singleton = Collections.singleton("Hi");
                    Assertions.assertSame(singleton, (Object)Validate.notEmpty(singleton));
                }

                @Test
                void shouldThrowIllegalArgumentExceptionWithDefaultMessageForEmptyCollection() {
                    IllegalArgumentException ex = (IllegalArgumentException)Assertions.assertThrows(IllegalArgumentException.class, () -> Validate.notEmpty(Collections.emptySet()));
                    Assertions.assertEquals((Object)"The validated collection is empty", (Object)ex.getMessage());
                }

                @Test
                void shouldThrowNullPointerExceptionWithDefaultMessageForNullCollection() {
                    NullPointerException ex = (NullPointerException)Assertions.assertThrows(NullPointerException.class, () -> Validate.notEmpty((Collection)null));
                    Assertions.assertEquals((Object)"The validated collection is empty", (Object)ex.getMessage());
                }
            }

            @Nested
            final class WithMessage {
                WithMessage() {
                }

                @Test
                void shouldNotThrowExceptionForCollectionContainingNullReference() {
                    Validate.notEmpty(Collections.singleton(null), (String)"MSG", (Object[])new Object[0]);
                }

                @Test
                void shouldReturnTheSameInstance() {
                    Set<String> singleton = Collections.singleton("Hi");
                    Assertions.assertSame(singleton, (Object)Validate.notEmpty(singleton, (String)"MSG", (Object[])new Object[0]));
                }

                @Test
                void shouldThrowIllegalArgumentExceptionWithGivenMessageForEmptyCollection() {
                    IllegalArgumentException ex = (IllegalArgumentException)Assertions.assertThrows(IllegalArgumentException.class, () -> Validate.notEmpty(Collections.emptySet(), (String)"MSG", (Object[])new Object[0]));
                    Assertions.assertEquals((Object)"MSG", (Object)ex.getMessage());
                }

                @Test
                void shouldThrowNullPointerExceptionWithGivenMessageForNullCollection() {
                    NullPointerException ex = (NullPointerException)Assertions.assertThrows(NullPointerException.class, () -> Validate.notEmpty((Collection)null, (String)"MSG", (Object[])new Object[0]));
                    Assertions.assertEquals((Object)"MSG", (Object)ex.getMessage());
                }
            }
        }

        @Nested
        final class WithCharSequence {
            WithCharSequence() {
            }

            @Nested
            final class WithoutMessage {
                WithoutMessage() {
                }

                @Test
                void shouldNotThrowExceptionForNonEmptyString() {
                    Validate.notEmpty((CharSequence)"Hi");
                }

                @Test
                void shouldReturnTheSameInstance() {
                    Assertions.assertSame((Object)"Hi", (Object)Validate.notEmpty((CharSequence)"Hi"));
                }

                @Test
                void shouldThrowIllegalArgumentExceptionWithDefaultMessageForEmptyString() {
                    IllegalArgumentException ex = (IllegalArgumentException)Assertions.assertThrows(IllegalArgumentException.class, () -> Validate.notEmpty((CharSequence)""));
                    Assertions.assertEquals((Object)"The validated character sequence is empty", (Object)ex.getMessage());
                }

                @Test
                void shouldThrowNullPointerExceptionWithDefaultMessageForNullCharSequence() {
                    NullPointerException ex = (NullPointerException)Assertions.assertThrows(NullPointerException.class, () -> Validate.notEmpty((CharSequence)null));
                    Assertions.assertEquals((Object)"The validated character sequence is empty", (Object)ex.getMessage());
                }
            }

            @Nested
            final class WithMessage {
                WithMessage() {
                }

                @Test
                void shouldNotThrowExceptionForNonEmptyString() {
                    Validate.notEmpty((CharSequence)"Hi", (String)"MSG", (Object[])new Object[0]);
                }

                @Test
                void shouldReturnTheSameInstance() {
                    Assertions.assertSame((Object)"Hi", (Object)Validate.notEmpty((CharSequence)"Hi", (String)"MSG", (Object[])new Object[0]));
                }

                @Test
                void shouldThrowIllegalArgumentExceptionWithGivenMessageForEmptyString() {
                    IllegalArgumentException ex = (IllegalArgumentException)Assertions.assertThrows(IllegalArgumentException.class, () -> Validate.notEmpty((CharSequence)"", (String)"MSG", (Object[])new Object[0]));
                    Assertions.assertEquals((Object)"MSG", (Object)ex.getMessage());
                }

                @Test
                void shouldThrowNullPointerExceptionWithGivenMessageForNullCharSequence() {
                    NullPointerException ex = (NullPointerException)Assertions.assertThrows(NullPointerException.class, () -> Validate.notEmpty((CharSequence)null, (String)"MSG", (Object[])new Object[0]));
                    Assertions.assertEquals((Object)"MSG", (Object)ex.getMessage());
                }
            }
        }

        @Nested
        final class WithArray {
            WithArray() {
            }

            @Nested
            final class WithoutMessage {
                WithoutMessage() {
                }

                @Test
                void shouldNotThrowExceptionForArrayContainingNullReference() {
                    Validate.notEmpty((Object[])new Object[]{null});
                }

                @Test
                void shouldReturnTheSameInstance() {
                    Object[] expected = new String[]{"hi"};
                    Assertions.assertSame((Object)expected, (Object)Validate.notEmpty((Object[])expected));
                }

                @Test
                void shouldThrowIllegalArgumentExceptionWithDefaultMessageForEmptyArray() {
                    IllegalArgumentException ex = (IllegalArgumentException)Assertions.assertThrows(IllegalArgumentException.class, () -> Validate.notEmpty((Object[])new Object[0]));
                    Assertions.assertEquals((Object)"The validated array is empty", (Object)ex.getMessage());
                }

                @Test
                void shouldThrowNullPointerExceptionWithDefaultMessageForNullArray() {
                    NullPointerException ex = (NullPointerException)Assertions.assertThrows(NullPointerException.class, () -> Validate.notEmpty((Object[])null));
                    Assertions.assertEquals((Object)"The validated array is empty", (Object)ex.getMessage());
                }
            }

            @Nested
            final class WithMessage {
                WithMessage() {
                }

                @Test
                void shouldNotThrowExceptionForArrayContainingNullReference() {
                    Validate.notEmpty((Object[])new Object[]{null}, (String)"MSG", (Object[])new Object[0]);
                }

                @Test
                void shouldReturnTheSameInstance() {
                    Object[] expected = new String[]{"hi"};
                    Assertions.assertSame((Object)expected, (Object)Validate.notEmpty((Object[])expected, (String)"MSG", (Object[])new Object[0]));
                }

                @Test
                void shouldThrowIllegalArgumentExceptionWithDefaultMessageForEmptyArray() {
                    IllegalArgumentException ex = (IllegalArgumentException)Assertions.assertThrows(IllegalArgumentException.class, () -> Validate.notEmpty((Object[])new Object[0], (String)"MSG", (Object[])new Object[0]));
                    Assertions.assertEquals((Object)"MSG", (Object)ex.getMessage());
                }

                @Test
                void shouldThrowNullPointerExceptionWithGivenMessageForNullArray() {
                    NullPointerException ex = (NullPointerException)Assertions.assertThrows(NullPointerException.class, () -> Validate.notEmpty((Object[])null, (String)"MSG", (Object[])new Object[0]));
                    Assertions.assertEquals((Object)"MSG", (Object)ex.getMessage());
                }
            }
        }
    }

    @Nested
    final class NotBlank {
        NotBlank() {
        }

        @Nested
        final class WithoutMessage {
            WithoutMessage() {
            }

            @Test
            void shouldNotThrowExceptionForNonEmptyString() {
                Validate.notBlank((CharSequence)"abc");
            }

            @Test
            void shouldNotThrowExceptionForNonEmptyStringContainingSpaces() {
                Validate.notBlank((CharSequence)"  abc   ");
            }

            @Test
            void shouldNotThrowExceptionForNonEmptyStringContainingWhitespaceChars() {
                Validate.notBlank((CharSequence)" \n \t abc \r \n ");
            }

            @Test
            void shouldReturnNonBlankValue() {
                Assertions.assertSame((Object)"abc", (Object)Validate.notBlank((CharSequence)"abc"));
            }

            @Test
            void shouldThrowIllegalArgumentExceptionWithDefaultMessageForBlankString() {
                IllegalArgumentException ex = (IllegalArgumentException)Assertions.assertThrows(IllegalArgumentException.class, () -> Validate.notBlank((CharSequence)"   "));
                Assertions.assertEquals((Object)"The validated character sequence is blank", (Object)ex.getMessage());
            }

            @Test
            void shouldThrowIllegalArgumentExceptionWithDefaultMessageForEmptyString() {
                IllegalArgumentException ex = (IllegalArgumentException)Assertions.assertThrows(IllegalArgumentException.class, () -> Validate.notBlank((CharSequence)""));
                Assertions.assertEquals((Object)"The validated character sequence is blank", (Object)ex.getMessage());
            }

            @Test
            void shouldThrowIllegalArgumentExceptionWithDefaultMessageForStringContainingOnlyWhitespaceChars() {
                IllegalArgumentException ex = (IllegalArgumentException)Assertions.assertThrows(IllegalArgumentException.class, () -> Validate.notBlank((CharSequence)" \n \t \r \n "));
                Assertions.assertEquals((Object)"The validated character sequence is blank", (Object)ex.getMessage());
            }

            @Test
            void shouldThrowNullPointerExceptionWithDefaultMessageForNullString() {
                NullPointerException ex = (NullPointerException)Assertions.assertThrows(NullPointerException.class, () -> Validate.notBlank(null));
                Assertions.assertEquals((Object)"The validated character sequence is blank", (Object)ex.getMessage());
            }
        }

        @Nested
        final class WithMessage {
            WithMessage() {
            }

            @Test
            void shouldNotThrowExceptionForNonEmptyString() {
                Validate.notBlank((CharSequence)"abc", (String)"MSG", (Object[])new Object[0]);
            }

            @Test
            void shouldNotThrowExceptionForNonEmptyStringContainingSpaces() {
                Validate.notBlank((CharSequence)"  abc   ", (String)"MSG", (Object[])new Object[0]);
            }

            @Test
            void shouldNotThrowExceptionForNonEmptyStringContainingWhitespaceChars() {
                Validate.notBlank((CharSequence)" \n \t abc \r \n ", (String)"MSG", (Object[])new Object[0]);
            }

            @Test
            void shouldReturnNonBlankValue() {
                Assertions.assertSame((Object)"abc", (Object)Validate.notBlank((CharSequence)"abc", (String)"MSG", (Object[])new Object[0]));
            }

            @Test
            void shouldThrowIllegalArgumentExceptionWithGivenMessageForBlankString() {
                IllegalArgumentException ex = (IllegalArgumentException)Assertions.assertThrows(IllegalArgumentException.class, () -> Validate.notBlank((CharSequence)"   ", (String)"MSG", (Object[])new Object[0]));
                Assertions.assertEquals((Object)"MSG", (Object)ex.getMessage());
            }

            @Test
            void shouldThrowIllegalArgumentExceptionWithGivenMessageForEmptyString() {
                IllegalArgumentException ex = (IllegalArgumentException)Assertions.assertThrows(IllegalArgumentException.class, () -> Validate.notBlank((CharSequence)"", (String)"MSG", (Object[])new Object[0]));
                Assertions.assertEquals((Object)"MSG", (Object)ex.getMessage());
            }

            @Test
            void shouldThrowIllegalArgumentExceptionWithGivenMessageForStringContainingOnlyWhitespaceChars() {
                IllegalArgumentException ex = (IllegalArgumentException)Assertions.assertThrows(IllegalArgumentException.class, () -> Validate.notBlank((CharSequence)" \n \t \r \n ", (String)"MSG", (Object[])new Object[0]));
                Assertions.assertEquals((Object)"MSG", (Object)ex.getMessage());
            }

            @Test
            void shouldThrowNullPointerExceptionWithGivenMessageForNullString() {
                NullPointerException ex = (NullPointerException)Assertions.assertThrows(NullPointerException.class, () -> Validate.notBlank(null, (String)"MSG", (Object[])new Object[0]));
                Assertions.assertEquals((Object)"MSG", (Object)ex.getMessage());
            }
        }
    }

    @Nested
    final class NoNullElements {
        NoNullElements() {
        }

        @Nested
        final class WithCollection {
            WithCollection() {
            }

            @Nested
            final class WithoutMessage {
                WithoutMessage() {
                }

                @Test
                void shouldNotThrowExceptionForNonEmptyCollection() {
                    Validate.noNullElements(Collections.singleton("a"));
                }

                @Test
                void shouldReturnSameInstance() {
                    Set<String> col = Collections.singleton("a");
                    Assertions.assertSame(col, (Object)Validate.noNullElements(col));
                }

                @Test
                void shouldThrowIllegalArgumentExceptionWithDefaultMessageForCollectionWithNullElement() {
                    IllegalArgumentException ex = (IllegalArgumentException)Assertions.assertThrows(IllegalArgumentException.class, () -> Validate.noNullElements(Collections.singleton(null)));
                    Assertions.assertEquals((Object)"The validated collection contains null element at index: 0", (Object)ex.getMessage());
                }

                @Test
                void shouldThrowNullPointerExceptionWithDefaultMessageForNullCollection() {
                    NullPointerException ex = (NullPointerException)Assertions.assertThrows(NullPointerException.class, () -> Validate.noNullElements((Iterable)null));
                    Assertions.assertEquals((Object)"iterable", (Object)ex.getMessage());
                }
            }

            @Nested
            final class WithMessage {
                WithMessage() {
                }

                @Test
                void shouldNotThrowExceptionForNonEmptyCollection() {
                    Validate.noNullElements(Collections.singleton("a"), (String)"MSG", (Object[])new Object[0]);
                }

                @Test
                void shouldReturnSameInstance() {
                    Set<String> col = Collections.singleton("a");
                    Assertions.assertSame(col, (Object)Validate.noNullElements(col, (String)"MSG", (Object[])new Object[0]));
                }

                @Test
                void shouldThrowIllegalArgumentExceptionWithGivenMessageForCollectionWithNullElement() {
                    IllegalArgumentException ex = (IllegalArgumentException)Assertions.assertThrows(IllegalArgumentException.class, () -> Validate.noNullElements(Collections.singleton(null), (String)"MSG", (Object[])new Object[0]));
                    Assertions.assertEquals((Object)"MSG", (Object)ex.getMessage());
                }

                @Test
                void shouldThrowNullPointerExceptionWithDefaultMessageForNullCollection() {
                    NullPointerException ex = (NullPointerException)Assertions.assertThrows(NullPointerException.class, () -> Validate.noNullElements((Iterable)null, (String)"MSG", (Object[])new Object[0]));
                    Assertions.assertEquals((Object)"iterable", (Object)ex.getMessage());
                }
            }
        }

        @Nested
        final class WithArray {
            WithArray() {
            }

            @Nested
            final class WithoutMessage {
                WithoutMessage() {
                }

                @Test
                void shouldNotThrowExceptionForNonEmptyArray() {
                    Validate.noNullElements((Object[])new String[]{"a", "b"});
                }

                @Test
                void shouldReturnSameInstance() {
                    Object[] expected = new String[]{"a", "b"};
                    Assertions.assertSame((Object)expected, (Object)Validate.noNullElements((Object[])expected));
                }

                @Test
                void shouldThrowIllegalArgumentExceptionWithDefaultMessageForArrayWithNullElement() {
                    IllegalArgumentException ex = (IllegalArgumentException)Assertions.assertThrows(IllegalArgumentException.class, () -> Validate.noNullElements((Object[])new String[]{"a", null}));
                    Assertions.assertEquals((Object)"The validated array contains null element at index: 1", (Object)ex.getMessage());
                }

                @Test
                void shouldThrowNullPointerExceptionWithDefaultMessageForNullArray() {
                    NullPointerException ex = (NullPointerException)Assertions.assertThrows(NullPointerException.class, () -> Validate.noNullElements((Object[])null));
                    Assertions.assertEquals((Object)"array", (Object)ex.getMessage());
                }
            }

            @Nested
            final class WithMessage {
                WithMessage() {
                }

                @Test
                void shouldNotThrowExceptionForNonEmptyArray() {
                    Validate.noNullElements((Object[])new String[]{"a", "b"}, (String)"MSG", (Object[])new Object[0]);
                }

                @Test
                void shouldReturnSameInstance() {
                    Object[] array = new String[]{"a", "b"};
                    Assertions.assertSame((Object)array, (Object)Validate.noNullElements((Object[])array, (String)"MSG", (Object[])new Object[0]));
                }

                @Test
                void shouldThrowIllegalArgumentExceptionWithGivenMessageForArrayWithNullElement() {
                    IllegalArgumentException ex = (IllegalArgumentException)Assertions.assertThrows(IllegalArgumentException.class, () -> Validate.noNullElements((Object[])new String[]{"a", null}, (String)"MSG", (Object[])new Object[0]));
                    Assertions.assertEquals((Object)"MSG", (Object)ex.getMessage());
                }

                @Test
                void shouldThrowNullPointerExceptionWithDefaultMessageForNullArray() {
                    NullPointerException ex = (NullPointerException)Assertions.assertThrows(NullPointerException.class, () -> Validate.noNullElements((Object[])null, (String)"MSG", (Object[])new Object[0]));
                    Assertions.assertEquals((Object)"array", (Object)ex.getMessage());
                }
            }
        }
    }

    @Nested
    final class MatchesPattern {
        MatchesPattern() {
        }

        @Nested
        final class WithoutMessage {
            WithoutMessage() {
            }

            @Test
            void shouldNotThrowExceptionWhenStringMatchesPattern() {
                Validate.matchesPattern((CharSequence)"hi", (String)"[a-z]*");
            }

            @Test
            void shouldThrowIllegalArgumentExceptionWithDefaultMessageWhenStringDoesNotMatchPattern() {
                IllegalArgumentException ex = (IllegalArgumentException)Assertions.assertThrows(IllegalArgumentException.class, () -> Validate.matchesPattern((CharSequence)"hi", (String)"[0-9]*"));
                Assertions.assertEquals((Object)"The string hi does not match the pattern [0-9]*", (Object)ex.getMessage());
            }
        }

        @Nested
        final class WithMessage {
            WithMessage() {
            }

            @Test
            void shouldNotThrowExceptionWhenStringMatchesPattern() {
                Validate.matchesPattern((CharSequence)"hi", (String)"[a-z]*", (String)"MSG", (Object[])new Object[0]);
            }

            @Test
            void shouldThrowIllegalArgumentExceptionWhenStringDoesNotMatchPattern() {
                IllegalArgumentException ex = (IllegalArgumentException)Assertions.assertThrows(IllegalArgumentException.class, () -> Validate.matchesPattern((CharSequence)"hi", (String)"[0-9]*", (String)"MSG", (Object[])new Object[0]));
                Assertions.assertEquals((Object)"MSG", (Object)ex.getMessage());
            }
        }
    }

    @Nested
    final class IsTrue {
        IsTrue() {
        }

        @Nested
        final class WithoutMessage {
            WithoutMessage() {
            }

            @Test
            void shouldNotThrowForTrueExpression() {
                Validate.isTrue((boolean)true);
            }

            @Test
            void shouldThrowExceptionWithDefaultMessageForFalseExpression() {
                IllegalArgumentException ex = (IllegalArgumentException)Assertions.assertThrows(IllegalArgumentException.class, () -> Validate.isTrue((boolean)false));
                Assertions.assertEquals((Object)"The validated expression is false", (Object)ex.getMessage());
            }
        }

        @Nested
        final class WithObjectTemplate {
            WithObjectTemplate() {
            }

            @Test
            void shouldNotThrowForTrueExpression() {
                Validate.isTrue((boolean)true, (String)"MSG", (Object[])new Object[]{"Object 1", "Object 2"});
            }

            @Test
            void shouldThrowExceptionWithDoubleInsertedIntoTemplateMessageForFalseExpression() {
                IllegalArgumentException ex = (IllegalArgumentException)Assertions.assertThrows(IllegalArgumentException.class, () -> Validate.isTrue((boolean)false, (String)"MSG %s %s", (Object[])new Object[]{"Object 1", "Object 2"}));
                Assertions.assertEquals((Object)"MSG Object 1 Object 2", (Object)ex.getMessage());
            }
        }

        @Nested
        final class WithMessage {
            WithMessage() {
            }

            @Test
            void shouldNotThrowForTrueExpression() {
                Validate.isTrue((boolean)true, (String)"MSG", (Object[])new Object[0]);
            }

            @Test
            void shouldThrowExceptionWithGivenMessageContainingSpecialCharacterForFalseExpression() {
                IllegalArgumentException ex = (IllegalArgumentException)Assertions.assertThrows(IllegalArgumentException.class, () -> Validate.isTrue((boolean)false, (String)"%", (Object[])new Object[0]));
                Assertions.assertEquals((Object)"%", (Object)ex.getMessage());
            }

            @Test
            void shouldThrowExceptionWithGivenMessageForFalseExpression() {
                IllegalArgumentException ex = (IllegalArgumentException)Assertions.assertThrows(IllegalArgumentException.class, () -> Validate.isTrue((boolean)false, (String)"MSG", (Object[])new Object[0]));
                Assertions.assertEquals((Object)"MSG", (Object)ex.getMessage());
            }
        }

        @Nested
        final class WithLongTemplate {
            WithLongTemplate() {
            }

            @Test
            void shouldNotThrowForTrueExpression() {
                Validate.isTrue((boolean)true, (String)"MSG", (long)6L);
            }

            @Test
            void shouldThrowExceptionWithLongInsertedIntoTemplateMessageForFalseExpression() {
                IllegalArgumentException ex = (IllegalArgumentException)Assertions.assertThrows(IllegalArgumentException.class, () -> Validate.isTrue((boolean)false, (String)"MSG %s", (long)6L));
                Assertions.assertEquals((Object)"MSG 6", (Object)ex.getMessage());
            }
        }

        @Nested
        final class WithDoubleTemplate {
            WithDoubleTemplate() {
            }

            @Test
            void shouldNotThrowForTrueExpression() {
                Validate.isTrue((boolean)true, (String)"MSG", (double)7.4);
            }

            @Test
            void shouldThrowExceptionWithDoubleInsertedIntoTemplateMessageForFalseExpression() {
                IllegalArgumentException ex = (IllegalArgumentException)Assertions.assertThrows(IllegalArgumentException.class, () -> Validate.isTrue((boolean)false, (String)"MSG %s", (double)7.4));
                Assertions.assertEquals((Object)"MSG 7.4", (Object)ex.getMessage());
            }
        }
    }

    @Nested
    final class IsInstanceOf {
        IsInstanceOf() {
        }

        @Nested
        final class WithoutMessage {
            WithoutMessage() {
            }

            @Test
            void shouldNotThrowExceptionWhenValueIsInstanceOfClass() {
                Validate.isInstanceOf(String.class, (Object)"hi");
            }

            @Test
            void shouldThrowIllegalArgumentExceptionWithDefaultMessageWhenValueIsNotInstanceOfClass() {
                IllegalArgumentException ex = (IllegalArgumentException)Assertions.assertThrows(IllegalArgumentException.class, () -> Validate.isInstanceOf(List.class, (Object)"hi"));
                Assertions.assertEquals((Object)"Expected type: java.util.List, actual: java.lang.String", (Object)ex.getMessage());
            }
        }

        @Nested
        final class WithMessageTemplate {
            WithMessageTemplate() {
            }

            @Test
            void shouldNotThrowExceptionWhenValueIsInstanceOfClass() {
                Validate.isInstanceOf(String.class, (Object)"hi", (String)"Error %s=%s", (Object[])new Object[]{"Name", "Value"});
            }

            @Test
            void shouldThrowIllegalArgumentExceptionWithGivenMessageWhenValueIsNotInstanceOfClass() {
                IllegalArgumentException ex = (IllegalArgumentException)Assertions.assertThrows(IllegalArgumentException.class, () -> Validate.isInstanceOf(List.class, (Object)"hi", (String)"Error %s=%s", (Object[])new Object[]{"Name", "Value"}));
                Assertions.assertEquals((Object)"Error Name=Value", (Object)ex.getMessage());
            }
        }

        @Nested
        final class WithMessage {
            WithMessage() {
            }

            @Test
            void shouldNotThrowExceptionWhenValueIsInstanceOfClass() {
                Validate.isInstanceOf(String.class, (Object)"hi", (String)"MSG", (Object[])new Object[0]);
            }

            @Test
            void shouldThrowIllegalArgumentExceptionWithGivenMessageWhenValueIsNotInstanceOfClass() {
                IllegalArgumentException ex = (IllegalArgumentException)Assertions.assertThrows(IllegalArgumentException.class, () -> Validate.isInstanceOf(List.class, (Object)"hi", (String)"MSG", (Object[])new Object[0]));
                Assertions.assertEquals((Object)"MSG", (Object)ex.getMessage());
            }
        }
    }

    @Nested
    final class IsAssignable {
        IsAssignable() {
        }

        @Nested
        final class WithoutMessage {
            WithoutMessage() {
            }

            @Test
            void shouldNotThrowExceptionWhenClassIsAssignable() {
                Validate.isAssignableFrom(CharSequence.class, String.class);
            }

            @Test
            void shouldThrowIllegalArgumentExceptionWithDefaultMessageWhenClassIsNotAssignable() {
                IllegalArgumentException ex = (IllegalArgumentException)Assertions.assertThrows(IllegalArgumentException.class, () -> Validate.isAssignableFrom(List.class, String.class));
                Assertions.assertEquals((Object)"Cannot assign a java.lang.String to a java.util.List", (Object)ex.getMessage());
            }

            @Test
            void shouldThrowIllegalArgumentExceptionWithNullSuperType() {
                IllegalArgumentException ex = (IllegalArgumentException)Assertions.assertThrows(IllegalArgumentException.class, () -> Validate.isAssignableFrom(null, String.class));
                Assertions.assertEquals((Object)"Cannot assign a java.lang.String to a null type", (Object)ex.getMessage());
            }

            @Test
            void shouldThrowIllegalArgumentExceptionWithNullType() {
                IllegalArgumentException ex = (IllegalArgumentException)Assertions.assertThrows(IllegalArgumentException.class, () -> Validate.isAssignableFrom(List.class, null));
                Assertions.assertEquals((Object)"Cannot assign a null type to a java.util.List", (Object)ex.getMessage());
            }

            @Test
            void shouldThrowIllegalArgumentExceptionWithNullTypes() {
                IllegalArgumentException ex = (IllegalArgumentException)Assertions.assertThrows(IllegalArgumentException.class, () -> Validate.isAssignableFrom(null, null));
                Assertions.assertEquals((Object)"Cannot assign a null type to a null type", (Object)ex.getMessage());
            }
        }

        @Nested
        final class WithMessage {
            WithMessage() {
            }

            @Test
            void shouldNotThrowExceptionWhenClassIsAssignable() {
                Validate.isAssignableFrom(CharSequence.class, String.class, (String)"MSG", (Object[])new Object[0]);
            }

            @Test
            void shouldThrowIllegalArgumentExceptionWithGiventMessageWhenClassIsNotAssignable() {
                IllegalArgumentException ex = (IllegalArgumentException)Assertions.assertThrows(IllegalArgumentException.class, () -> Validate.isAssignableFrom(List.class, String.class, (String)"MSG", (Object[])new Object[0]));
                Assertions.assertEquals((Object)"MSG", (Object)ex.getMessage());
            }
        }
    }

    @Nested
    final class InclusiveBetween {
        InclusiveBetween() {
        }

        @Nested
        final class WithLong {
            private static final long LOWER_BOUND = 1L;
            private static final long UPPER_BOUND = 3L;

            WithLong() {
            }

            @Nested
            final class WithoutMessage {
                WithoutMessage() {
                }

                @Test
                void shouldNotThrowExceptionWhenValueIsBetweenBounds() {
                    Validate.inclusiveBetween((long)1L, (long)3L, (long)2L);
                }

                @Test
                void shouldNotThrowExceptionWhenValueIsLowerBound() {
                    Validate.inclusiveBetween((long)1L, (long)3L, (long)1L);
                }

                @Test
                void shouldNotThrowExceptionWhenValueIsUpperBound() {
                    Validate.inclusiveBetween((long)1L, (long)3L, (long)3L);
                }

                @Test
                void shouldThrowIllegalArgumentExceptionWithDefaultMessageWhenValueIsAboveUpperBound() {
                    IllegalArgumentException ex = (IllegalArgumentException)Assertions.assertThrows(IllegalArgumentException.class, () -> Validate.inclusiveBetween((long)1L, (long)3L, (long)4L));
                    Assertions.assertEquals((Object)"The value 4 is not in the specified inclusive range of 1 to 3", (Object)ex.getMessage());
                }

                @Test
                void shouldThrowIllegalArgumentExceptionWithDefaultMessageWhenValueIsBelowLowerBound() {
                    IllegalArgumentException ex = (IllegalArgumentException)Assertions.assertThrows(IllegalArgumentException.class, () -> Validate.inclusiveBetween((long)1L, (long)3L, (long)0L));
                    Assertions.assertEquals((Object)"The value 0 is not in the specified inclusive range of 1 to 3", (Object)ex.getMessage());
                }
            }

            @Nested
            final class WithMessage {
                WithMessage() {
                }

                @Test
                void shouldNotThrowExceptionWhenValueIsBetweenBounds() {
                    Validate.inclusiveBetween((long)1L, (long)3L, (long)2L, (String)"MSG");
                }

                @Test
                void shouldNotThrowExceptionWhenValueIsLowerBound() {
                    Validate.inclusiveBetween((long)1L, (long)3L, (long)1L, (String)"MSG");
                }

                @Test
                void shouldNotThrowExceptionWhenValueIsUpperBound() {
                    Validate.inclusiveBetween((long)1L, (long)3L, (long)3L, (String)"MSG");
                }

                @Test
                void shouldThrowIllegalArgumentExceptionWithGivenMessageWhenValueIsAboveUpperBound() {
                    IllegalArgumentException ex = (IllegalArgumentException)Assertions.assertThrows(IllegalArgumentException.class, () -> Validate.inclusiveBetween((long)1L, (long)3L, (long)4L, (String)"MSG"));
                    Assertions.assertEquals((Object)"MSG", (Object)ex.getMessage());
                }

                @Test
                void shouldThrowIllegalArgumentExceptionWithGivenMessageWhenValueIsBelowLowerBound() {
                    IllegalArgumentException ex = (IllegalArgumentException)Assertions.assertThrows(IllegalArgumentException.class, () -> Validate.inclusiveBetween((long)1L, (long)3L, (long)0L, (String)"MSG"));
                    Assertions.assertEquals((Object)"MSG", (Object)ex.getMessage());
                }
            }
        }

        @Nested
        final class WithDouble {
            private static final double LOWER_BOUND = 0.1;
            private static final double UPPER_BOUND = 3.1;

            WithDouble() {
            }

            @Nested
            final class WithoutMessage {
                WithoutMessage() {
                }

                @Test
                void shouldNotThrowExceptionWhenValueIsBetweenBounds() {
                    Validate.inclusiveBetween((double)0.1, (double)3.1, (double)2.1);
                }

                @Test
                void shouldNotThrowExceptionWhenValueIsLowerBound() {
                    Validate.inclusiveBetween((double)0.1, (double)3.1, (double)0.1);
                }

                @Test
                void shouldNotThrowExceptionWhenValueIsUpperBound() {
                    Validate.inclusiveBetween((double)0.1, (double)3.1, (double)3.1);
                }

                @Test
                void shouldThrowIllegalArgumentExceptionWithDefaultMessageWhenValueIsAboveUpperBound() {
                    IllegalArgumentException ex = (IllegalArgumentException)Assertions.assertThrows(IllegalArgumentException.class, () -> Validate.inclusiveBetween((double)0.1, (double)3.1, (double)4.1));
                    Assertions.assertEquals((Object)"The value 4.1 is not in the specified inclusive range of 0.1 to 3.1", (Object)ex.getMessage());
                }

                @Test
                void shouldThrowIllegalArgumentExceptionWithDefaultMessageWhenValueIsBelowLowerBound() {
                    IllegalArgumentException ex = (IllegalArgumentException)Assertions.assertThrows(IllegalArgumentException.class, () -> Validate.inclusiveBetween((double)0.1, (double)3.1, (double)0.01));
                    Assertions.assertEquals((Object)"The value 0.01 is not in the specified inclusive range of 0.1 to 3.1", (Object)ex.getMessage());
                }
            }

            @Nested
            final class WithMessage {
                WithMessage() {
                }

                @Test
                void shouldNotThrowExceptionWhenValueIsBetweenBounds() {
                    Validate.inclusiveBetween((double)0.1, (double)3.1, (double)2.1, (String)"MSG");
                }

                @Test
                void shouldNotThrowExceptionWhenValueIsLowerBound() {
                    Validate.inclusiveBetween((double)0.1, (double)3.1, (double)0.1, (String)"MSG");
                }

                @Test
                void shouldNotThrowExceptionWhenValueIsUpperBound() {
                    Validate.inclusiveBetween((double)0.1, (double)3.1, (double)3.1, (String)"MSG");
                }

                @Test
                void shouldThrowIllegalArgumentExceptionWithGivenMessageWhenValueIsAboveUpperBound() {
                    IllegalArgumentException ex = (IllegalArgumentException)Assertions.assertThrows(IllegalArgumentException.class, () -> Validate.inclusiveBetween((double)0.1, (double)3.1, (double)4.1, (String)"MSG"));
                    Assertions.assertEquals((Object)"MSG", (Object)ex.getMessage());
                }

                @Test
                void shouldThrowIllegalArgumentExceptionWithGivenMessageWhenValueIsBelowLowerBound() {
                    IllegalArgumentException ex = (IllegalArgumentException)Assertions.assertThrows(IllegalArgumentException.class, () -> Validate.inclusiveBetween((double)0.1, (double)3.1, (double)0.01, (String)"MSG"));
                    Assertions.assertEquals((Object)"MSG", (Object)ex.getMessage());
                }
            }
        }

        @Nested
        final class WithComparable {
            private static final String LOWER_BOUND = "1";
            private static final String UPPER_BOUND = "3";

            WithComparable() {
            }

            @Nested
            final class WithoutMessage {
                WithoutMessage() {
                }

                @Test
                void shouldNotThrowExceptionWhenValueIsBetweenBounds() {
                    Validate.inclusiveBetween((Object)WithComparable.LOWER_BOUND, (Object)WithComparable.UPPER_BOUND, (Comparable)((Object)"2"));
                }

                @Test
                void shouldNotThrowExceptionWhenValueIsLowerBound() {
                    Validate.inclusiveBetween((Object)WithComparable.LOWER_BOUND, (Object)WithComparable.UPPER_BOUND, (Comparable)((Object)WithComparable.LOWER_BOUND));
                }

                @Test
                void shouldNotThrowExceptionWhenValueIsUpperBound() {
                    Validate.inclusiveBetween((Object)WithComparable.LOWER_BOUND, (Object)WithComparable.UPPER_BOUND, (Comparable)((Object)WithComparable.UPPER_BOUND));
                }

                @Test
                void shouldThrowIllegalArgumentExceptionWithDefaultMessageWhenValueIsAboveUpperBound() {
                    IllegalArgumentException ex = (IllegalArgumentException)Assertions.assertThrows(IllegalArgumentException.class, () -> Validate.inclusiveBetween((Object)WithComparable.LOWER_BOUND, (Object)WithComparable.UPPER_BOUND, (Comparable)((Object)"4")));
                    Assertions.assertEquals((Object)"The value 4 is not in the specified inclusive range of 1 to 3", (Object)ex.getMessage());
                }

                @Test
                void shouldThrowIllegalArgumentExceptionWithDefaultMessageWhenValueIsBelowLowerBound() {
                    IllegalArgumentException ex = (IllegalArgumentException)Assertions.assertThrows(IllegalArgumentException.class, () -> Validate.inclusiveBetween((Object)WithComparable.LOWER_BOUND, (Object)WithComparable.UPPER_BOUND, (Comparable)((Object)"0")));
                    Assertions.assertEquals((Object)"The value 0 is not in the specified inclusive range of 1 to 3", (Object)ex.getMessage());
                }
            }

            @Nested
            final class WithMessage {
                WithMessage() {
                }

                @Test
                void shouldNotThrowExceptionWhenValueIsBetweenBounds() {
                    Validate.inclusiveBetween((Object)WithComparable.LOWER_BOUND, (Object)WithComparable.UPPER_BOUND, (Comparable)((Object)"2"), (String)"MSG", (Object[])new Object[0]);
                }

                @Test
                void shouldNotThrowExceptionWhenValueIsLowerBound() {
                    Validate.inclusiveBetween((Object)WithComparable.LOWER_BOUND, (Object)WithComparable.UPPER_BOUND, (Comparable)((Object)WithComparable.LOWER_BOUND), (String)"MSG", (Object[])new Object[0]);
                }

                @Test
                void shouldNotThrowExceptionWhenValueIsUpperBound() {
                    Validate.inclusiveBetween((Object)WithComparable.LOWER_BOUND, (Object)WithComparable.UPPER_BOUND, (Comparable)((Object)WithComparable.UPPER_BOUND), (String)"MSG", (Object[])new Object[0]);
                }

                @Test
                void shouldThrowIllegalArgumentExceptionWithGivenMessageWhenValueIsAboveUpperBound() {
                    IllegalArgumentException ex = (IllegalArgumentException)Assertions.assertThrows(IllegalArgumentException.class, () -> Validate.inclusiveBetween((Object)WithComparable.LOWER_BOUND, (Object)WithComparable.UPPER_BOUND, (Comparable)((Object)"4"), (String)"MSG", (Object[])new Object[0]));
                    Assertions.assertEquals((Object)"MSG", (Object)ex.getMessage());
                }

                @Test
                void shouldThrowIllegalArgumentExceptionWithGivenMessageWhenValueIsBelowLowerBound() {
                    IllegalArgumentException ex = (IllegalArgumentException)Assertions.assertThrows(IllegalArgumentException.class, () -> Validate.inclusiveBetween((Object)WithComparable.LOWER_BOUND, (Object)WithComparable.UPPER_BOUND, (Comparable)((Object)"0"), (String)"MSG", (Object[])new Object[0]));
                    Assertions.assertEquals((Object)"MSG", (Object)ex.getMessage());
                }
            }
        }
    }

    @Nested
    final class Finite {
        Finite() {
        }

        @Nested
        final class WithoutMessage {
            WithoutMessage() {
            }

            @Test
            void shouldNotThrowExceptionForFiniteValue() {
                Validate.finite((double)0.0);
            }

            @Test
            void shouldThrowIllegalArgumentExceptionWithDefaultMessageForNaN() {
                IllegalArgumentException ex = (IllegalArgumentException)Assertions.assertThrows(IllegalArgumentException.class, () -> Validate.finite((double)Double.NaN));
                Assertions.assertEquals((Object)"The value is invalid: NaN", (Object)ex.getMessage());
            }

            @Test
            void shouldThrowIllegalArgumentExceptionWithDefaultMessageForNegativeInfinity() {
                IllegalArgumentException ex = (IllegalArgumentException)Assertions.assertThrows(IllegalArgumentException.class, () -> Validate.finite((double)Double.NEGATIVE_INFINITY));
                Assertions.assertEquals((Object)"The value is invalid: -Infinity", (Object)ex.getMessage());
            }

            @Test
            void shouldThrowIllegalArgumentExceptionWithDefaultMessageForPositiveInfinity() {
                IllegalArgumentException ex = (IllegalArgumentException)Assertions.assertThrows(IllegalArgumentException.class, () -> Validate.finite((double)Double.POSITIVE_INFINITY));
                Assertions.assertEquals((Object)"The value is invalid: Infinity", (Object)ex.getMessage());
            }
        }

        @Nested
        final class WithMessage {
            WithMessage() {
            }

            @Test
            void shouldNotThrowExceptionForFiniteValue() {
                Validate.finite((double)0.0, (String)"MSG", (Object[])new Object[0]);
            }

            @Test
            void shouldThrowIllegalArgumentExceptionWithDefaultMessageForNaN() {
                IllegalArgumentException ex = (IllegalArgumentException)Assertions.assertThrows(IllegalArgumentException.class, () -> Validate.finite((double)Double.NaN, (String)"MSG", (Object[])new Object[0]));
                Assertions.assertEquals((Object)"MSG", (Object)ex.getMessage());
            }

            @Test
            void shouldThrowIllegalArgumentExceptionWithDefaultMessageForNegativeInfinity() {
                IllegalArgumentException ex = (IllegalArgumentException)Assertions.assertThrows(IllegalArgumentException.class, () -> Validate.finite((double)Double.NEGATIVE_INFINITY, (String)"MSG", (Object[])new Object[0]));
                Assertions.assertEquals((Object)"MSG", (Object)ex.getMessage());
            }

            @Test
            void shouldThrowIllegalArgumentExceptionWithDefaultMessageForPositiveInfinity() {
                IllegalArgumentException ex = (IllegalArgumentException)Assertions.assertThrows(IllegalArgumentException.class, () -> Validate.finite((double)Double.POSITIVE_INFINITY, (String)"MSG", (Object[])new Object[0]));
                Assertions.assertEquals((Object)"MSG", (Object)ex.getMessage());
            }
        }
    }

    @Nested
    final class ExclusiveBetween {
        ExclusiveBetween() {
        }

        @Nested
        final class WithLong {
            private static final long LOWER_BOUND = 1L;
            private static final long UPPER_BOUND = 3L;

            WithLong() {
            }

            @Nested
            final class WithoutMessage {
                WithoutMessage() {
                }

                @Test
                void shouldNotThrowExceptionWhenValueIsBetweenBounds() {
                    Validate.exclusiveBetween((long)1L, (long)3L, (long)2L);
                }

                @Test
                void shouldThrowIllegalArgumentExceptionWithDefaultMessageWhenValueIsAboveUpperBound() {
                    IllegalArgumentException ex = (IllegalArgumentException)Assertions.assertThrows(IllegalArgumentException.class, () -> Validate.exclusiveBetween((long)1L, (long)3L, (long)4L));
                    Assertions.assertEquals((Object)"The value 4 is not in the specified exclusive range of 1 to 3", (Object)ex.getMessage());
                }

                @Test
                void shouldThrowIllegalArgumentExceptionWithDefaultMessageWhenValueIsBelowLowerBound() {
                    IllegalArgumentException ex = (IllegalArgumentException)Assertions.assertThrows(IllegalArgumentException.class, () -> Validate.exclusiveBetween((long)1L, (long)3L, (long)0L));
                    Assertions.assertEquals((Object)"The value 0 is not in the specified exclusive range of 1 to 3", (Object)ex.getMessage());
                }

                @Test
                void shouldThrowIllegalArgumentExceptionWithDefaultMessageWhenValueIsLowerBound() {
                    IllegalArgumentException ex = (IllegalArgumentException)Assertions.assertThrows(IllegalArgumentException.class, () -> Validate.exclusiveBetween((long)1L, (long)3L, (long)1L));
                    Assertions.assertEquals((Object)"The value 1 is not in the specified exclusive range of 1 to 3", (Object)ex.getMessage());
                }

                @Test
                void shouldThrowIllegalArgumentExceptionWithDefaultMessageWhenValueIsUpperBound() {
                    IllegalArgumentException ex = (IllegalArgumentException)Assertions.assertThrows(IllegalArgumentException.class, () -> Validate.exclusiveBetween((long)1L, (long)3L, (long)3L));
                    Assertions.assertEquals((Object)"The value 3 is not in the specified exclusive range of 1 to 3", (Object)ex.getMessage());
                }
            }

            @Nested
            final class WithMessage {
                WithMessage() {
                }

                @Test
                void shouldNotThrowExceptionWhenValueIsBetweenBounds() {
                    Validate.exclusiveBetween((long)1L, (long)3L, (long)2L, (String)"MSG");
                }

                @Test
                void shouldThrowIllegalArgumentExceptionWithDefaultMessageWhenValueIsAboveUpperBound() {
                    IllegalArgumentException ex = (IllegalArgumentException)Assertions.assertThrows(IllegalArgumentException.class, () -> Validate.exclusiveBetween((long)1L, (long)3L, (long)4L, (String)"MSG"));
                    Assertions.assertEquals((Object)"MSG", (Object)ex.getMessage());
                }

                @Test
                void shouldThrowIllegalArgumentExceptionWithGivenMessageWhenValueIsBelowLowerBound() {
                    IllegalArgumentException ex = (IllegalArgumentException)Assertions.assertThrows(IllegalArgumentException.class, () -> Validate.exclusiveBetween((long)1L, (long)3L, (long)0L, (String)"MSG"));
                    Assertions.assertEquals((Object)"MSG", (Object)ex.getMessage());
                }

                @Test
                void shouldThrowIllegalArgumentExceptionWithGivenMessageWhenValueIsLowerBound() {
                    IllegalArgumentException ex = (IllegalArgumentException)Assertions.assertThrows(IllegalArgumentException.class, () -> Validate.exclusiveBetween((long)1L, (long)3L, (long)1L, (String)"MSG"));
                    Assertions.assertEquals((Object)"MSG", (Object)ex.getMessage());
                }

                @Test
                void shouldThrowIllegalArgumentExceptionWithGivenMessageWhenValueIsUpperBound() {
                    IllegalArgumentException ex = (IllegalArgumentException)Assertions.assertThrows(IllegalArgumentException.class, () -> Validate.exclusiveBetween((long)1L, (long)3L, (long)3L, (String)"MSG"));
                    Assertions.assertEquals((Object)"MSG", (Object)ex.getMessage());
                }
            }
        }

        @Nested
        final class WithDouble {
            private static final double LOWER_BOUND = 0.1;
            private static final double UPPER_BOUND = 3.1;

            WithDouble() {
            }

            @Nested
            final class WithoutMessage {
                WithoutMessage() {
                }

                @Test
                void shouldNotThrowExceptionWhenValueIsBetweenBounds() {
                    Validate.exclusiveBetween((double)0.1, (double)3.1, (double)2.1);
                }

                @Test
                void shouldThrowIllegalArgumentExcdeptionWhenValueIsLowerBound() {
                    IllegalArgumentException ex = (IllegalArgumentException)Assertions.assertThrows(IllegalArgumentException.class, () -> Validate.exclusiveBetween((double)0.1, (double)3.1, (double)0.1));
                    Assertions.assertEquals((Object)"The value 0.1 is not in the specified exclusive range of 0.1 to 3.1", (Object)ex.getMessage());
                }

                @Test
                void shouldThrowIllegalArgumentExcdeptionWhenValueIsUpperBound() {
                    IllegalArgumentException ex = (IllegalArgumentException)Assertions.assertThrows(IllegalArgumentException.class, () -> Validate.exclusiveBetween((double)0.1, (double)3.1, (double)3.1));
                    Assertions.assertEquals((Object)"The value 3.1 is not in the specified exclusive range of 0.1 to 3.1", (Object)ex.getMessage());
                }

                @Test
                void shouldThrowIllegalArgumentExceptionWithDefaultMessageWhenValueIsAboveUpperBound() {
                    IllegalArgumentException ex = (IllegalArgumentException)Assertions.assertThrows(IllegalArgumentException.class, () -> Validate.exclusiveBetween((double)0.1, (double)3.1, (double)4.1));
                    Assertions.assertEquals((Object)"The value 4.1 is not in the specified exclusive range of 0.1 to 3.1", (Object)ex.getMessage());
                }

                @Test
                void shouldThrowIllegalArgumentExceptionWithDefaultMessageWhenValueIsBelowLowerBound() {
                    IllegalArgumentException ex = (IllegalArgumentException)Assertions.assertThrows(IllegalArgumentException.class, () -> Validate.exclusiveBetween((double)0.1, (double)3.1, (double)0.01));
                    Assertions.assertEquals((Object)"The value 0.01 is not in the specified exclusive range of 0.1 to 3.1", (Object)ex.getMessage());
                }
            }

            @Nested
            final class WithMessage {
                WithMessage() {
                }

                @Test
                void shouldNotThrowExceptionWhenValueIsBetweenBounds() {
                    Validate.exclusiveBetween((double)0.1, (double)3.1, (double)2.1, (String)"MSG");
                }

                @Test
                void shouldThrowIllegalArgumentExcdeptionWhenValueIsLowerBound() {
                    IllegalArgumentException ex = (IllegalArgumentException)Assertions.assertThrows(IllegalArgumentException.class, () -> Validate.exclusiveBetween((double)0.1, (double)3.1, (double)0.1, (String)"MSG"));
                    Assertions.assertEquals((Object)"MSG", (Object)ex.getMessage());
                }

                @Test
                void shouldThrowIllegalArgumentExcdeptionWhenValueIsUpperBound() {
                    IllegalArgumentException ex = (IllegalArgumentException)Assertions.assertThrows(IllegalArgumentException.class, () -> Validate.exclusiveBetween((double)0.1, (double)3.1, (double)3.1, (String)"MSG"));
                    Assertions.assertEquals((Object)"MSG", (Object)ex.getMessage());
                }

                @Test
                void shouldThrowIllegalArgumentExceptionWithGivenMessageWhenValueIsAboveUpperBound() {
                    IllegalArgumentException ex = (IllegalArgumentException)Assertions.assertThrows(IllegalArgumentException.class, () -> Validate.exclusiveBetween((double)0.1, (double)3.1, (double)4.1, (String)"MSG"));
                    Assertions.assertEquals((Object)"MSG", (Object)ex.getMessage());
                }

                @Test
                void shouldThrowIllegalArgumentExceptionWithGivenMessageWhenValueIsBelowLowerBound() {
                    IllegalArgumentException ex = (IllegalArgumentException)Assertions.assertThrows(IllegalArgumentException.class, () -> Validate.exclusiveBetween((double)0.1, (double)3.1, (double)0.01, (String)"MSG"));
                    Assertions.assertEquals((Object)"MSG", (Object)ex.getMessage());
                }
            }
        }

        @Nested
        final class WithComparable {
            private static final String LOWER_BOUND = "1";
            private static final String UPPER_BOUND = "3";

            WithComparable() {
            }

            @Nested
            final class WithoutMessage {
                WithoutMessage() {
                }

                @Test
                void shouldNotThrowExceptionWhenValueIsBetweenBounds() {
                    Validate.exclusiveBetween((Object)WithComparable.LOWER_BOUND, (Object)WithComparable.UPPER_BOUND, (Comparable)((Object)"2"));
                }

                @Test
                void shouldThrowIllegalArgumentExceptionWithDefaultMessageWhenValueIsAboveUpperBound() {
                    IllegalArgumentException ex = (IllegalArgumentException)Assertions.assertThrows(IllegalArgumentException.class, () -> Validate.exclusiveBetween((Object)WithComparable.LOWER_BOUND, (Object)WithComparable.UPPER_BOUND, (Comparable)((Object)"4")));
                    Assertions.assertEquals((Object)"The value 4 is not in the specified exclusive range of 1 to 3", (Object)ex.getMessage());
                }

                @Test
                void shouldThrowIllegalArgumentExceptionWithDefaultMessageWhenValueIsBelowLowerBound() {
                    IllegalArgumentException ex = (IllegalArgumentException)Assertions.assertThrows(IllegalArgumentException.class, () -> Validate.exclusiveBetween((Object)WithComparable.LOWER_BOUND, (Object)WithComparable.UPPER_BOUND, (Comparable)((Object)"0")));
                    Assertions.assertEquals((Object)"The value 0 is not in the specified exclusive range of 1 to 3", (Object)ex.getMessage());
                }

                @Test
                void shouldThrowIllegalArgumentExceptionWithDefaultMessageWhenValueIsLowerBound() {
                    IllegalArgumentException ex = (IllegalArgumentException)Assertions.assertThrows(IllegalArgumentException.class, () -> Validate.exclusiveBetween((Object)WithComparable.LOWER_BOUND, (Object)WithComparable.UPPER_BOUND, (Comparable)((Object)WithComparable.LOWER_BOUND)));
                    Assertions.assertEquals((Object)"The value 1 is not in the specified exclusive range of 1 to 3", (Object)ex.getMessage());
                }

                @Test
                void shouldThrowIllegalArgumentExceptionWithDefaultMessageWhenValueIsUpperBound() {
                    IllegalArgumentException ex = (IllegalArgumentException)Assertions.assertThrows(IllegalArgumentException.class, () -> Validate.exclusiveBetween((Object)WithComparable.LOWER_BOUND, (Object)WithComparable.UPPER_BOUND, (Comparable)((Object)WithComparable.UPPER_BOUND)));
                    Assertions.assertEquals((Object)"The value 3 is not in the specified exclusive range of 1 to 3", (Object)ex.getMessage());
                }
            }

            @Nested
            final class WithMessage {
                WithMessage() {
                }

                @Test
                void shouldNotThrowExceptionWhenValueIsBetweenBounds() {
                    Validate.exclusiveBetween((Object)WithComparable.LOWER_BOUND, (Object)WithComparable.UPPER_BOUND, (Comparable)((Object)"2"), (String)"MSG", (Object[])new Object[0]);
                }

                @Test
                void shouldThrowIllegalArgumentExceptionWithDefaultMessageWhenValueIsAboveUpperBound() {
                    IllegalArgumentException ex = (IllegalArgumentException)Assertions.assertThrows(IllegalArgumentException.class, () -> Validate.exclusiveBetween((Object)WithComparable.LOWER_BOUND, (Object)WithComparable.UPPER_BOUND, (Comparable)((Object)"4"), (String)"MSG", (Object[])new Object[0]));
                    Assertions.assertEquals((Object)"MSG", (Object)ex.getMessage());
                }

                @Test
                void shouldThrowIllegalArgumentExceptionWithGivenMessageWhenValueIsBelowLowerBound() {
                    IllegalArgumentException ex = (IllegalArgumentException)Assertions.assertThrows(IllegalArgumentException.class, () -> Validate.exclusiveBetween((Object)WithComparable.LOWER_BOUND, (Object)WithComparable.UPPER_BOUND, (Comparable)((Object)"0"), (String)"MSG", (Object[])new Object[0]));
                    Assertions.assertEquals((Object)"MSG", (Object)ex.getMessage());
                }

                @Test
                void shouldThrowIllegalArgumentExceptionWithGivenMessageWhenValueIsLowerBound() {
                    IllegalArgumentException ex = (IllegalArgumentException)Assertions.assertThrows(IllegalArgumentException.class, () -> Validate.exclusiveBetween((Object)WithComparable.LOWER_BOUND, (Object)WithComparable.UPPER_BOUND, (Comparable)((Object)WithComparable.LOWER_BOUND), (String)"MSG", (Object[])new Object[0]));
                    Assertions.assertEquals((Object)"MSG", (Object)ex.getMessage());
                }

                @Test
                void shouldThrowIllegalArgumentExceptionWithGivenMessageWhenValueIsUpperBound() {
                    IllegalArgumentException ex = (IllegalArgumentException)Assertions.assertThrows(IllegalArgumentException.class, () -> Validate.exclusiveBetween((Object)WithComparable.LOWER_BOUND, (Object)WithComparable.UPPER_BOUND, (Comparable)((Object)WithComparable.UPPER_BOUND), (String)"MSG", (Object[])new Object[0]));
                    Assertions.assertEquals((Object)"MSG", (Object)ex.getMessage());
                }
            }
        }
    }
}

