/*
  Copyright(C) 2002-2007 Pierre Mazire
  
  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.
  
  This program is distributed in the hope that it will be useful, but
  WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
  General Public License for more details.
  
  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
*/

/*
  rommngr.c

  Roms informations functions
*/

#include "common.h"
#include <mamory/readinfo.h>
#include <mamory/rommngr.h>
#include <sortbox/sortbox.h>
#include <mamory/chainlst.h>

void GetSameCRCRoms(FILE *fp,s_GamesList *GamesList)
{
  unsigned int i,j,k,l,NbrDifferentCRCs=0;
  s_SortBox *GLRomsCRCSortBox;
  
  GLRomsCRCSortBox=InitSortBox(SB_NUM,NULL);
  for(i=0;i<GamesList->NbrGames;i++)
    for(j=0;j<GamesList->Games[i]->NbrRoms;j++)
      SortBox_AddOneUint(GLRomsCRCSortBox,
			 GamesList->Games[i]->Roms[j]->Content->CRC,
			 GamesList->Games[i]->Roms[j]);
  
  for (i=0;i<GLRomsCRCSortBox->NbrBoxes;i++)
    {
      for(j=0;j<GLRomsCRCSortBox->Boxes[i]->NbrWords;j++)
	{
	  if(GLRomsCRCSortBox->Boxes[i]->Words[j]->NbrIDs>1)
	    {
	      fprintf(fp,"CRC :%x\n",
		      ROM_INFO(GLRomsCRCSortBox->Boxes[i]->Words[j]->IDs[0])->Content->CRC);
	      NbrDifferentCRCs++;
	      for (k=0;k<GLRomsCRCSortBox->Boxes[i]->Words[j]->NbrIDs;k++)
		{
		  fprintf(fp,"\trom: %s, %i bytes\n",
			  ROM_INFO(GLRomsCRCSortBox->Boxes[i]->Words[j]->IDs[k])->Name,
			  ROM_INFO(GLRomsCRCSortBox->Boxes[i]->Words[j]->IDs[k])->Content->Size);
		  for(l=0;l<ROM_INFO(GLRomsCRCSortBox->Boxes[i]->Words[j]->IDs[k])->Content->NbrAssociatedGames;l++)
		    fprintf(fp,"\t\tin game %s\n",
			    ROM_INFO(GLRomsCRCSortBox->Boxes[i]->Words[j]->IDs[k])->Content->AssociatedGames[l]->Game->Name);
		};
	      
	    };
	};
    };

  fprintf(fp,"\nNbr of different CRCs: %i\n", NbrDifferentCRCs);
  FreeSortBox(GLRomsCRCSortBox);
};


void GetSameNameRoms(FILE *fp,s_GamesList *GamesList)
{
  unsigned int i,j,k,l;
  s_SortBox *GLRomsNameSortBox;

  GLRomsNameSortBox=InitSortBox(SB_ALPHANUM,NULL);
  for(i=0;i<GamesList->NbrGames;i++)
    for(j=0;j<GamesList->Games[i]->NbrRoms;j++)
      SortBox_AddOneWord(GLRomsNameSortBox,
			 GamesList->Games[i]->Roms[j]->Name,
			 GamesList->Games[i]->Roms[j]);
  
  for (i=0;i<GLRomsNameSortBox->NbrBoxes;i++)
    {
      for(j=0;j<GLRomsNameSortBox->Boxes[i]->NbrWords;j++)
	{
	  if(GLRomsNameSortBox->Boxes[i]->Words[j]->NbrIDs>1)
	    {
		  fprintf(fp,"Name :%s\n",
			  ROM_INFO(GLRomsNameSortBox->Boxes[i]->Words[j]->IDs[0])->Name);
		  for (k=0;k<GLRomsNameSortBox->Boxes[i]->Words[j]->NbrIDs;k++)
		    {
		      fprintf(fp,"\tCRC: %x, %i bytes\n",
			      ROM_INFO(GLRomsNameSortBox->Boxes[i]->Words[j]->IDs[k])->Content->CRC,
			      ROM_INFO(GLRomsNameSortBox->Boxes[i]->Words[j]->IDs[k])->Content->Size);
		      for(l=0;l<ROM_INFO(GLRomsNameSortBox->Boxes[i]->Words[j]->IDs[k])->Content->NbrAssociatedGames;l++)
			fprintf(fp,"\t\tin game %s\n",
				ROM_INFO(GLRomsNameSortBox->Boxes[i]->Words[j]->IDs[k])->Content->AssociatedGames[l]->Game->Name);
		    };
	    };	  
	};
    };
  FreeSortBox(GLRomsNameSortBox);
};


s_chainlst *GetDiffMameNewRoms(s_GamesList *GamesList1, 
			       s_GamesList *GamesList2,
			       unsigned int *NbrNewRoms)
{
  unsigned int i,j,remove,nbrdata=1;
  s_SortBox *GL1RomsCRCSortBox;
  s_RomContent **RomContents=NULL;
  s_RomContent *ThisRomContent=NULL;
  s_chainlst *NewRoms=NULL;

  *NbrNewRoms=0;

  GL1RomsCRCSortBox=InitSortBox(SB_NUM,NULL);
  for(i=0;i<GamesList1->NbrRomContents;i++)
    SortBox_AddOneUint(GL1RomsCRCSortBox,
		       GamesList1->RomContents[i]->CRC,
		       GamesList1->RomContents[i]);  

  LPRINTFW(OUTPUT,"Getting New Roms ...");
  // Get New Roms
  for(i=0;i<GamesList2->NbrRomContents;i++)
    {
      RomContents=(s_RomContent**)
	SortBox_FindTheUint(GL1RomsCRCSortBox,
			    GamesList2->RomContents[i]->CRC,
			    (int*)&nbrdata);
	  
      if(nbrdata==0)
	{
	  NewRoms=CLAppend(NewRoms,GamesList2->RomContents[i]);
	 ( *NbrNewRoms)++;
	}
      else
	{
	  for(j=0;j<nbrdata;j++)
	    if(RomContents[j]->Size==GamesList2->RomContents[i]->Size)
	      break;
	  
	  if(j==nbrdata)
	    {
	      NewRoms=CLAppend(NewRoms,GamesList2->RomContents[i]);
	      (*NbrNewRoms)++;
	    };
	  
	  for(j=0;j<nbrdata;j++)
	    RomContents[j]=NULL;
	  XFREE(RomContents);
	};
    };

  if(*NbrNewRoms!=0)
    {
      NewRoms=CLFirst(NewRoms);
      do
	{
	  ThisRomContent=ROM_CONTENT(CLGetData(NewRoms));
	  remove=FALSE;
	  RomContents=(s_RomContent**)
	    SortBox_FindTheUint(GL1RomsCRCSortBox,
				~ThisRomContent->CRC,
				&nbrdata);
	  if(nbrdata!=0)
	    {
	      for(i=0;i<nbrdata;i++)
		if(RomContents[i]->Size==ThisRomContent->Size)
		  break;

	      if(i!=nbrdata)
		{
		  NewRoms=CLRemove(NewRoms,NewRoms->Data);
		  remove=TRUE;
		  (*NbrNewRoms)--;
		};

	      for(i=0;i<nbrdata;i++)
		RomContents[i]=NULL;
	      XFREE(RomContents);
	    }; 
	  
	  if(NewRoms==NULL)
	    break;
	  if(NewRoms->Next!=NULL && remove==FALSE )
	    NewRoms=NewRoms->Next;
	  else
	    {
	      if (NewRoms->Next==NULL)
		break;
	    };
	}while (NewRoms!=NULL);
    };

  FreeSortBox(GL1RomsCRCSortBox);
  LPRINTF(OUTPUT," done");
  return NewRoms;
}  

s_chainlst *GetDiffMameSupprRoms(s_GamesList *GamesList1,
				 s_GamesList *GamesList2,
				 unsigned int *NbrSupprRoms)
{
  unsigned int i,j,remove,nbrdata=1;
  s_SortBox *GL2RomsCRCSortBox;
  s_RomContent **RomContents=NULL;
  s_RomContent *ThisRomContent=NULL;
  s_chainlst *SupprRoms=NULL;

  *NbrSupprRoms=0;

  GL2RomsCRCSortBox=InitSortBox(SB_NUM,NULL);
  for(i=0;i<GamesList2->NbrRomContents;i++)
    SortBox_AddOneUint(GL2RomsCRCSortBox,
		       GamesList2->RomContents[i]->CRC,
		       GamesList2->RomContents[i]);  

  LPRINTFW(OUTPUT,"Getting Suppressed Roms ...");
  // Get Suppressed Roms
  for(i=0;i<GamesList1->NbrRomContents;i++)
    {
      RomContents=(s_RomContent**)
	SortBox_FindTheUint(GL2RomsCRCSortBox,
			    GamesList1->RomContents[i]->CRC,
			    (int*)&nbrdata);
      
      if(nbrdata==0)
	{
	  SupprRoms=CLAppend(SupprRoms,GamesList1->RomContents[i]);
	  (*NbrSupprRoms)++;
	}
      else
	{
	  for(j=0;j<nbrdata;j++)
	    if(RomContents[j]->Size==GamesList1->RomContents[i]->Size)
	      break;
	  
	  if(j==nbrdata)
	    {
	      SupprRoms=CLAppend(SupprRoms,GamesList1->RomContents[i]);
	      (*NbrSupprRoms)++;	
	    };
	  
	  for(j=0;j<nbrdata;j++)
	    RomContents[j]=NULL;
	  XFREE(RomContents);
	};
    };


  if(*NbrSupprRoms!=0)
    {
      SupprRoms=CLFirst(SupprRoms);
      do
	{
	  ThisRomContent=ROM_CONTENT(CLGetData(SupprRoms));
	  remove=FALSE;
	  RomContents=(s_RomContent**)
	    SortBox_FindTheUint(GL2RomsCRCSortBox,
				~ThisRomContent->CRC,
				(int*)&nbrdata);
	  if(nbrdata!=0)
	    {
	      for(i=0;i<nbrdata;i++)
		if(RomContents[i]->Size==ThisRomContent->Size)
		  break;

	      if(i!=nbrdata)
		{
		  SupprRoms=CLRemove(SupprRoms,SupprRoms->Data);
		  remove=TRUE;
		  (*NbrSupprRoms)--;
		};
	      for(i=0;i<nbrdata;i++)
		RomContents[i]=NULL;
	      XFREE(RomContents);
	    }; 
	  
	  if(SupprRoms==NULL)
	    break;
	  if(SupprRoms->Next!=NULL && remove==FALSE)
	    SupprRoms=SupprRoms->Next;
	  else
	    {
	      if(SupprRoms->Next==NULL)
		break;
	    };
	}while (SupprRoms!=NULL);
    };

  FreeSortBox(GL2RomsCRCSortBox);
  LPRINTF(OUTPUT," done");
  return SupprRoms;
}

s_Diff *DiffGamesLists(s_GamesList *GamesList1, s_GamesList *GamesList2,
		       unsigned int OptionFlags)
{
  s_Diff *Diff;

  s_SortBox *GL1GamesSortBox;
  s_SortBox *GL2GamesSortBox;
  s_SortBox *GL1RomsNameSortBox;
  s_SortBox *GL2RomsNameSortBox;
  s_SortBox *GL1RomsCRCSortBox;

  s_DiffGame *DiffGame=NULL;
  s_DiffRom *DiffRom=NULL;
  s_DiffRom *ThisDiffRom=NULL;
  s_GameInfo **Games=NULL;
  s_RomInfo **Roms=NULL;
  s_RomContent *ThisNewRom=NULL, *ThisSupprRom=NULL, **RomContents=NULL;
  int nbrdata=1;
  int nbrdata2=1;
  int i,j,k,l,m;
  unsigned int endoflist;

  Diff=XMALLOC(s_Diff,1);


  Diff->GamesList1=GamesList1;
  Diff->GamesList2=GamesList2;
  Diff->OptionFlags=OptionFlags;
  Diff->NbrNewRoms=0;
  Diff->NewRoms=NULL;
  Diff->NbrSupprRoms=0;
  Diff->SupprRoms=NULL;
  Diff->NbrGames=0;
  Diff->Games=NULL;

  GL1GamesSortBox=InitSortBox(SB_ALPHANUM,NULL);
  for(i=0;i<Diff->GamesList1->NbrGames;i++)
    SortBox_AddOneWord(GL1GamesSortBox,
		       Diff->GamesList1->Games[i]->Name,
		       Diff->GamesList1->Games[i]);

  GL2GamesSortBox=InitSortBox(SB_ALPHANUM,NULL);
  for(i=0;i<Diff->GamesList2->NbrGames;i++)
    SortBox_AddOneWord(GL2GamesSortBox,
		       Diff->GamesList2->Games[i]->Name,
		       Diff->GamesList2->Games[i]);

  GL1RomsNameSortBox=InitSortBox(SB_ALPHANUM,NULL);
  for(i=0;i<Diff->GamesList1->NbrGames;i++)
    for(j=0;j<Diff->GamesList1->Games[i]->NbrRoms;j++)
      SortBox_AddOneWord(GL1RomsNameSortBox,
			 Diff->GamesList1->Games[i]->Roms[j]->Name,
			 Diff->GamesList1->Games[i]->Roms[j]);

  GL2RomsNameSortBox=InitSortBox(SB_ALPHANUM,NULL);
  for(i=0;i<Diff->GamesList2->NbrGames;i++)
    for(j=0;j<Diff->GamesList2->Games[i]->NbrRoms;j++)
      SortBox_AddOneWord(GL2RomsNameSortBox,
			 Diff->GamesList2->Games[i]->Roms[j]->Name,
			 Diff->GamesList2->Games[i]->Roms[j]);  

  GL1RomsCRCSortBox=InitSortBox(SB_NUM,NULL);
  for(i=0;i<Diff->GamesList1->NbrRomContents;i++)
    SortBox_AddOneUint(GL1RomsCRCSortBox,
		       Diff->GamesList1->RomContents[i]->CRC,
		       Diff->GamesList1->RomContents[i]);

  Diff->NewRoms=GetDiffMameNewRoms(Diff->GamesList1,
				   Diff->GamesList2,
				   &Diff->NbrNewRoms);

  Diff->SupprRoms=GetDiffMameSupprRoms(Diff->GamesList1,
				       Diff->GamesList2,
				       &Diff->NbrSupprRoms);

  LPRINTFW(OUTPUT,"Getting Modified Roms ...");
  for(i=0;i<Diff->GamesList2->NbrGames;i++)
    {
      DiffGame=XCALLOC(s_DiffGame,1);

      DiffGame->Game=Diff->GamesList2->Games[i];
      DiffGame->NbrMISSINGRoms=0;
      DiffGame->NbrSAMERoms=0;
      DiffGame->NbrRoms=0;
      DiffGame->Roms=NULL;
      
      Games=(s_GameInfo**)
	SortBox_FindTheWord(GL1GamesSortBox,
			    DiffGame->Game->Name,
			    (int*)&nbrdata);

      if(nbrdata==0)
	{
	  Games=XCALLOC(s_GameInfo*,1);

	  Games[0]=XCALLOC(s_GameInfo,1);

	  Games[0]->NbrRoms=0;
	};

      for(j=0;j<DiffGame->Game->NbrRoms;j++)
	{
	  DiffRom=XCALLOC(s_DiffRom,1);

	  DiffRom->Rom=DiffGame->Game->Roms[j];
	  DiffRom->Type=UNKNOWN;

//	  printf("\t%s\n",DiffRom->Rom->Name);
	  for(k=0;k<Games[0]->NbrRoms;k++)
	    {
	      if(strcmp(DiffGame->Game->Roms[j]->Name,
			Games[0]->Roms[k]->Name)==0)
		{
		  if(DiffGame->Game->Roms[j]->Content->CRC==
		     Games[0]->Roms[k]->Content->CRC         ||
		     DiffGame->Game->Roms[j]->Content->CRC==
		     ~Games[0]->Roms[k]->Content->CRC 
		     ||
		     (!((Games[0]->Roms[k]->Source->Type==TYPE_EXEC ||
			 Games[0]->Roms[k]->Source->Type==TYPE_FILE) 
			&& 
			(DiffGame->Game->Roms[j]->Source->Type==TYPE_EXEC ||
			 DiffGame->Game->Roms[j]->Source->Type==TYPE_FILE)) 
		      &&
		      ((DiffGame->Game->Roms[j]->Content->CRC==0 &&
			(DiffGame->Game->Roms[j]->Source->Type==TYPE_EXEC ||
			 DiffGame->Game->Roms[j]->Source->Type==TYPE_FILE)) ||
		       (Games[0]->Roms[k]->Content->CRC==0 &&
			(Games[0]->Roms[k]->Source->Type==TYPE_EXEC ||
			 Games[0]->Roms[k]->Source->Type==TYPE_FILE)))))
		    {
		      if(DiffGame->Game->Roms[j]->Content->Size==
			 Games[0]->Roms[k]->Content->Size)
			{
			  DiffRom->Type=SAME;
			  DiffRom->Rom->Content->CompSize=Games[0]->Roms[k]->Content->CompSize;
			  DiffRom->SourceRom=Games[0]->Roms[k];
			};
		      break;
		    };
		}
	      else
		{
		  if((DiffGame->Game->Roms[j]->Content->CRC==Games[0]->Roms[k]->Content->CRC ||
		      DiffGame->Game->Roms[j]->Content->CRC==~Games[0]->Roms[k]->Content->CRC) &&
		     DiffGame->Game->Roms[j]->Content->Size==Games[0]->Roms[k]->Content->Size)  
		    {
		      DiffRom->Type=CHANGEDNAME;
		      DiffRom->Rom->Content->CompSize=Games[0]->Roms[k]->Content->CompSize;
		      DiffRom->SourceRom=Games[0]->Roms[k];
		    };
		};
	    };

	  if(DiffRom->Type==UNKNOWN)
	    {
	      endoflist=TRUE;
	      if(Diff->NbrNewRoms!=0)
		{
		  Diff->NewRoms=CLFirst(Diff->NewRoms);
		  do
		    {
		      ThisNewRom=ROM_CONTENT(CLGetData(Diff->NewRoms));
		      if(DiffRom->Rom->Content->CRC==ThisNewRom->CRC &&
			 DiffRom->Rom->Content->Size==ThisNewRom->Size )
			{
			  endoflist=FALSE;
			  break;		 
			};
		      endoflist=TRUE;
		      if(Diff->NewRoms->Next!=NULL)
			Diff->NewRoms=Diff->NewRoms->Next;
		      else
			break;
		    } while(Diff->NewRoms!=NULL);
		};
	      if(endoflist==TRUE)
		// This Rom is not part of the NewRoms list
		{
		  if (DiffRom->Rom->Content->CRC==0)
		    // As the NewRoms list does not take care of NULL CRC Roms
		    // we have to know if this is a new or existing one
		    {
		      Roms=(s_RomInfo**)
			SortBox_FindTheWord(GL1RomsNameSortBox,
					    DiffRom->Rom->Name,
					    (int*)&nbrdata2);
		      // Otherwise, we assume that this rom already exist in 
		      // GamesList1
		      if (nbrdata2==0)
			// no rom with this name in GamesList1, 
			// so it's a new rom that can be synthesized.
			DiffRom->Type=ADDEDTRANSFERT;
		      else
			{			  
			  for(l=0;l<nbrdata2;l++)
			    if(Roms[l]->Content->Size==DiffRom->Rom->Content->Size)
			      break;
			  if(l==nbrdata2)
			    // if it has a different size, it can't be the same
			    // so it's a new rom that can be synthesized
			    DiffRom->Type=ADDEDTRANSFERT;
			  else
			    {
			      // otherwise we have the required rom
			      DiffRom->Type=ADDEDTRANSFERT;
			      DiffRom->Rom->Content->CompSize=Roms[l]->Content->CompSize;
			      DiffRom->SourceRom=Roms[l];
			    };
			};

		      for(l=0;l<nbrdata2;l++)
			Roms[l]=NULL;
		      XFREE(Roms);
		    }
		  else
		    {
		      DiffRom->Type=ADDEDTRANSFERT;

		      // It's an existing Rom, so let's  check where to find it
		      Roms=(s_RomInfo**)
			SortBox_FindTheWord(GL1RomsNameSortBox,
					    DiffRom->Rom->Name,
					    (int*)&nbrdata2);
		      
		      switch(nbrdata2!=0)
			{
			case TRUE:
			  // we found Roms with the same name ...
			  for(l=0;l<nbrdata2;l++)
			    if((Roms[l]->Content->CRC==DiffRom->Rom->Content->CRC ||
				Roms[l]->Content->CRC==~DiffRom->Rom->Content->CRC)	&&
			       Roms[l]->Content->Size==DiffRom->Rom->Content->Size)
			      break;

			  if(l!=nbrdata2)
			    // ... and Roms[l] has the right size and CRC
			    // BINGO !
			    {
			      DiffRom->Rom->Content->CompSize=Roms[l]->Content->CompSize;
			      // est ce que cette rom appartient aux jeux qui
			      // sera en train d'etre modifier pendant la 
			      // synchro ? si oui c'est pas bon car il aura t
			      // effac
			      // mais on pourra le retrouver dans backuppath
			      // donc vaut il mieux chercher une autre source
			      // ou bien ajouter backuppath dans la recherche?
			      // le nom du game pourra etre retrouv a partir 
			      // de DiffRom->SourceRom->GameName; pour ca il
			      // faut creer pour les modes MERGED et FULL une
			      // table de correspondance CloneName=pointeur 
			      // sur Game
			      
			      DiffRom->SourceRom=Roms[l];
			      for(m=0;m<nbrdata2;m++)
				Roms[m]=NULL;
			      XFREE(Roms);
			      nbrdata2=0;	
			      
			      break ;
			    };

			  for(m=0;m<nbrdata2;m++)
			    Roms[m]=NULL;
//			  XFREE(Roms);
			  nbrdata2=0;			  

			case FALSE:
			  // No same name, so let'a have a look at CRCs
			  XFREE(Roms);
			  RomContents=(s_RomContent**)
			    SortBox_FindTheUint(GL1RomsCRCSortBox,
						DiffRom->Rom->Content->CRC,
						(int*)&nbrdata2);
			  if(nbrdata2==0)
			    // if no same CRCs, why not its complement 
			    // (NO_GOOD_DUMP_KNOWN)
			    RomContents=(s_RomContent**)
			      SortBox_FindTheUint(GL1RomsCRCSortBox,
						  ~DiffRom->Rom->Content->CRC,
						  (int*)&nbrdata2); 
			  for(l=0;l<nbrdata2;l++)
			    if(RomContents[l]->Size==DiffRom->Rom->Content->Size)
			      break;

			  if(l!=nbrdata2)
			    // mmmh... seems like RomContents[l] has the 
			    // right CRC and size ...
			    for(m=0;m<RomContents[l]->AssociatedGames[0]->Game->NbrRoms;m++)
			      if((RomContents[l]->AssociatedGames[0]->Game->Roms[m]->Content->CRC==DiffRom->Rom->Content->CRC ||
				  RomContents[l]->AssociatedGames[0]->Game->Roms[m]->Content->CRC==~DiffRom->Rom->Content->CRC) &&
				 RomContents[l]->AssociatedGames[0]->Game->Roms[m]->Content->Size==DiffRom->Rom->Content->Size)
				break;
			  
			  if(m!=RomContents[l]->AssociatedGames[0]->Game->NbrRoms)
			    // ... and RomContents[l] is associated to the
			    // required Rom that just need to have its name changed
			    {
			      DiffRom->SourceRom=RomContents[l]->AssociatedGames[0]->Game->Roms[m];
			      DiffRom->Rom->Content->CompSize=RomContents[l]->CompSize;
			    }
			  else
			    // ... oops ! that's a problem !
			    LPRINTF(WARNING,"corresponding rom not found although it has been described as existing in current games");

			  for(l=0;l<nbrdata2;l++)
			    RomContents[l]=NULL;
			  XFREE(RomContents);
			};
		    };      
		}
	      else
		DiffRom->Type=ADDEDNEW;	       
	    };

	  DiffGame->NbrRoms++;
	  if (DiffRom->Type==SAME)
	    DiffGame->NbrSAMERoms++;

	  if (DiffRom->Type==ADDEDNEW)
	    DiffGame->NbrMISSINGRoms++;

	  DiffGame->Roms=CLAppend(DiffGame->Roms,DiffRom);
	};

      for(j=0;j<Games[0]->NbrRoms;j++)
	{
	  DiffRom=XCALLOC(s_DiffRom,1);

	  DiffRom->Rom=Games[0]->Roms[j];
	  DiffRom->Type=UNKNOWN;

	  endoflist=TRUE;
	  if(DiffGame->NbrRoms!=0)
	    {
	      DiffGame->Roms=CLFirst(DiffGame->Roms);
	      do
		{
		  ThisDiffRom=DIFF_ROM(CLGetData(DiffGame->Roms));
		  if((ThisDiffRom->Type==SAME ||
		      ThisDiffRom->Type==CHANGEDNAME)
		     &&
		     (ThisDiffRom->Rom->Content->CRC==Games[0]->Roms[j]->Content->CRC ||
		      ThisDiffRom->Rom->Content->CRC==~Games[0]->Roms[j]->Content->CRC ||
		      (ThisDiffRom->Rom->Content->CRC==0 && Games[0]->Roms[j]->Content->CRC!=0) ||
		      (ThisDiffRom->Rom->Content->CRC!=0 && Games[0]->Roms[j]->Content->CRC==0))
		     &&
		     ThisDiffRom->Rom->Content->Size==Games[0]->Roms[j]->Content->Size)
		    {
		      switch(ThisDiffRom->Type)
			{
			case SAME:			  
			  if(strcmp(ThisDiffRom->Rom->Name,Games[0]->Roms[j]->Name)!=0)
			    break;
			case CHANGEDNAME:
			  endoflist=FALSE;
			  break;
			};
		      if(endoflist==FALSE)
			break;
		    };
		  endoflist=TRUE;
		  if(DiffGame->Roms->Next!=NULL)
		    DiffGame->Roms=DiffGame->Roms->Next;
		  else
		    break;
		} while(DiffGame->Roms!=NULL && ThisDiffRom->Rom->Source==GamesList2->Sources[0]);
	      if(endoflist==FALSE)
		{		  			
		  DiffRom->Type=ThisDiffRom->Type;

		  if(DiffRom->Rom->Source!=Diff->GamesList1->Sources[0])
		    {
		      if(ThisDiffRom->Type==SAME)
			DiffGame->NbrSAMERoms--;
		      ThisDiffRom->Type=ADDEDTRANSFERT;
		      //DiffRom->Type=SAME;
		    };
		};   
	    };

	  if(DiffRom->Type==UNKNOWN)
	    {
	      endoflist=TRUE;
	      if(Diff->NbrSupprRoms!=0)
		{
		  Diff->SupprRoms=CLFirst(Diff->SupprRoms);
		  do
		    {
		      ThisSupprRom=ROM_CONTENT(CLGetData(Diff->SupprRoms));
		      if(DiffRom->Rom->Content->CRC== ThisSupprRom->CRC &&
			 DiffRom->Rom->Content->Size== ThisSupprRom->Size)
			{
			  endoflist=FALSE;
			  break;	
			};
		      endoflist=TRUE;
		      if(Diff->SupprRoms->Next!=NULL)
			Diff->SupprRoms=Diff->SupprRoms->Next;
		      else
			break;
		    } while(Diff->SupprRoms!=NULL);
		};
	      if(DiffRom->Rom->Source!=GamesList1->Sources[0])
		DiffRom->Type=SAME;
	      else
		{
		  if(endoflist==TRUE)
		    {
		      if (DiffRom->Rom->Content->CRC==0)
			{
			  Roms=(s_RomInfo**)
			    SortBox_FindTheWord(GL2RomsNameSortBox,
						DiffRom->Rom->Name,
						(int*)&nbrdata2);
			  // If there is no equal name in GamesList2, we assume
			  // that this is a suppressed rom
			  // Otherwise, we assume that this rom still exists 
			  // in GamesList2
			  if (nbrdata2==0)
			    DiffRom->Type=SUPPRESSED;
			  else
			    DiffRom->Type=SUPPRTRANSFERT;
			      

			  for(l=0;l<nbrdata2;l++)
			    Roms[l]=NULL;
			  XFREE(Roms);
			}
		      else
			DiffRom->Type=SUPPRTRANSFERT;

		    }
		  else
		    DiffRom->Type=SUPPRESSED; 
		  
		};
	    };
	  
	  if(DiffRom->Type!=SAME && DiffRom->Type!=CHANGEDNAME)
	    {
	      DiffGame->NbrRoms++;
	      if(DiffRom->Type==ADDEDNEW)
		DiffGame->NbrMISSINGRoms++;
	      DiffGame->Roms=CLAppend(DiffGame->Roms,DiffRom); 
	    }
	  else
	    {
	      DiffRom->Rom=NULL;
	      XFREE(DiffRom);
	    }
	};
      
      if(DiffGame->NbrRoms>DiffGame->NbrSAMERoms)
	{
	  Diff->NbrGames++;
	  Diff->Games=CLAppend(Diff->Games,DiffGame);
	}
      else
	{
	  FreeDiffGame(DiffGame);
	  DiffGame=NULL;
	};

      if(nbrdata==0)
	XFREE(Games[0]);


      for(j=0;j<nbrdata;j++)
	Games[j]=NULL;

      XFREE(Games);
    };

//  printf("4\n");
  for(i=0;i<Diff->GamesList1->NbrGames;i++)
    {
      DiffGame=XCALLOC(s_DiffGame,1);

      DiffGame->Game=Diff->GamesList1->Games[i];
      DiffGame->NbrMISSINGRoms=0;
      DiffGame->NbrSAMERoms=0;
      DiffGame->NbrRoms=0;
      DiffGame->Roms=NULL;
      
      Games=(s_GameInfo**)
	SortBox_FindTheWord(GL2GamesSortBox,
			    DiffGame->Game->Name,
			    &nbrdata);
      if(nbrdata!=0)
	{
	  for(j=0;j<nbrdata;j++)
	    Games[j]=NULL;
	  XFREE(Games);
	  XFREE(DiffGame);
	  continue;
	};
     
      for(j=0;j<DiffGame->Game->NbrRoms;j++)
	{
	  DiffRom=XCALLOC(s_DiffRom,1);

	  DiffRom->Rom=DiffGame->Game->Roms[j];
	  DiffRom->Type=UNKNOWN;
	  DiffRom->SourceRom=NULL;

	  endoflist=TRUE;
	  if(Diff->NbrSupprRoms!=0)
	    {
	      Diff->SupprRoms=CLFirst(Diff->SupprRoms);
	      do
		{
		  ThisSupprRom=ROM_CONTENT(CLGetData(Diff->SupprRoms));
		  if(DiffRom->Rom->Content->CRC==ThisSupprRom->CRC &&
		     DiffRom->Rom->Content->Size==ThisSupprRom->Size)
		    {
		      endoflist=FALSE;
		      break;	
		    };
		  endoflist=TRUE;
		  if(Diff->SupprRoms->Next!=NULL)
		    Diff->SupprRoms=Diff->SupprRoms->Next;
		  else
		    break;
		} while(Diff->SupprRoms!=NULL);
	    };
	  if(DiffRom->Rom->Source!=GamesList1->Sources[0])
	    {
	      DiffRom->Type=SAME;
	      XFREE(DiffRom);
	    }
	  else
	    {
	      if(endoflist==TRUE)
		DiffRom->Type=SUPPRTRANSFERT;
	      else
		DiffRom->Type=SUPPRESSED; 

	      DiffGame->NbrRoms++;
	      DiffGame->Roms=CLAppend(DiffGame->Roms,DiffRom); 
	    };
	};

      if(DiffGame->NbrRoms>DiffGame->NbrSAMERoms)
	{
	  Diff->NbrGames++;
	  Diff->Games=CLAppend(Diff->Games,DiffGame);
	}
      else
	{
	  FreeDiffGame(DiffGame);
	  DiffGame=NULL;
	};
      
      for(j=0;j<nbrdata;j++)
	Games[j]=NULL;

      XFREE(Games);
    };

  FreeSortBox(GL1GamesSortBox);
  FreeSortBox(GL2GamesSortBox);
  FreeSortBox(GL1RomsNameSortBox);
  FreeSortBox(GL2RomsNameSortBox);
  FreeSortBox(GL1RomsCRCSortBox);

  LPRINTF(OUTPUT," done");
  return Diff;
}
	    
void FreeDiffGame(s_DiffGame *DiffGame)
{
  s_DiffRom *ThisDiffRom;

  if(DiffGame->NbrRoms!=0)
    {
      DiffGame->Roms=CLFirst(DiffGame->Roms);
      do
	{
	  ThisDiffRom=DIFF_ROM(CLGetData(DiffGame->Roms));
	  ThisDiffRom->Rom=NULL;
	  ThisDiffRom->SourceRom=NULL;
	  XFREE(ThisDiffRom);
	  DiffGame->Roms->Data=NULL;
	  if(DiffGame->Roms->Next!=NULL)
	    DiffGame->Roms=DiffGame->Roms->Next;
	  else
	    break;
	}while (DiffGame->Roms!=NULL);
    };	  
  FreeCL(DiffGame->Roms);
  DiffGame->Roms=NULL;
  XFREE(DiffGame);
};

void FreeDiff(s_Diff *Diff)
{
  s_DiffGame *ThisDiffGame;

  if(Diff!=NULL)
    {
      Diff->GamesList1=NULL;
      Diff->GamesList2=NULL;
      FreeCL(Diff->NewRoms);
      Diff->NbrNewRoms=0;
      FreeCL(Diff->SupprRoms);
      Diff->NbrSupprRoms=0;
      if(Diff->NbrGames!=0)
	{
	  Diff->Games=CLFirst(Diff->Games);
	  do
	    {
	      ThisDiffGame=DIFF_GAME(CLGetData(Diff->Games));
	      FreeDiffGame(ThisDiffGame);
	      Diff->Games->Data=NULL;
	      if(Diff->Games->Next!=NULL)
		Diff->Games=Diff->Games->Next;
	      else
		break;
	    }while (Diff->Games!=NULL);
	};	  
      FreeCL(Diff->Games);
      Diff->Games=NULL;
      Diff->NbrGames=0;
      XFREE(Diff);
    };
};


void StripDiff(s_Diff *Diff)
{
  typedef struct s_Keep
  {
    s_GamesListSource *Source;
    unsigned int NbrGames;
    unsigned char **Games;
  }s_Keep;

  unsigned int NbrKeeps=0;
  struct s_Keep **Keeps=NULL;

  s_DiffGame *ThisDiffGame=NULL;
  s_DiffRom *ThisDiffRom=NULL;

  unsigned int i,j,k,l;
  unsigned erased=0;
  
  FreeCL(Diff->NewRoms);
  Diff->NewRoms=NULL;
  Diff->NbrNewRoms=0;
  FreeCL(Diff->SupprRoms);
  Diff->SupprRoms=NULL;
  Diff->NbrSupprRoms=0;
  
  if(Diff->NbrGames!=0)
    {
      Diff->Games=CLFirst(Diff->Games);
      do
	{
	  ThisDiffGame=DIFF_GAME(CLGetData(Diff->Games));
	  ThisDiffGame->Roms=CLFirst(ThisDiffGame->Roms);
	  do
	    {
	      ThisDiffRom=DIFF_ROM(CLGetData(ThisDiffGame->Roms));

	      for(i=0;i<NbrKeeps;i++)  
		if(ThisDiffRom->Rom->Source==Keeps[i]->Source)
		  break;

	      if(i==NbrKeeps)
		{
		  printf("5\n");
		  Keeps=XREALLOC(Keeps,s_Keep*,NbrKeeps+1);
		  Keeps[NbrKeeps]=XMALLOC(s_Keep,1);
		  Keeps[NbrKeeps]->Source=ThisDiffRom->Rom->Source;
		  Keeps[NbrKeeps]->Games=XCALLOC(unsigned char*,1);
		  Keeps[NbrKeeps]->Games[0]=XSTRDUP(ThisDiffRom->Rom->GameName);
		  Keeps[NbrKeeps]->NbrGames=1;
		  NbrKeeps++;
		}
	      else
		{
		  for(j=0;j<Keeps[i]->NbrGames;j++)
		    if(strcmp(ThisDiffRom->Rom->GameName,Keeps[i]->Games[j])==0)
		      break;
		  
		  if(j==Keeps[i]->NbrGames)
		    {
		      printf("4\n");
		      Keeps[i]->Games=XREALLOC(Keeps[i]->Games,unsigned char*,Keeps[i]->NbrGames+1);
		      Keeps[i]->Games[Keeps[i]->NbrGames]=XSTRDUP(ThisDiffRom->Rom->GameName);
		      Keeps[i]->NbrGames++;
		    };
		}
	      
	      if(ThisDiffRom->SourceRom!=NULL &&
		 (ThisDiffRom->Type==SAME ||
		  ThisDiffRom->Type==CHANGEDNAME ||
		  ThisDiffRom->Type==ADDEDTRANSFERT))
		{
		  for(i=0;i<NbrKeeps;i++)
		    if(ThisDiffRom->SourceRom->Source==Keeps[i]->Source)
		      break;

		  if(i==NbrKeeps)
		    {
		      printf("2\n");
		      Keeps=XREALLOC(Keeps,s_Keep*,NbrKeeps+1);
		      Keeps[NbrKeeps]=XMALLOC(s_Keep,1);
		      Keeps[NbrKeeps]->Source=ThisDiffRom->SourceRom->Source;
		      Keeps[NbrKeeps]->Games=XCALLOC(unsigned char*,1);
		      Keeps[NbrKeeps]->Games[0]=XSTRDUP(ThisDiffRom->SourceRom->GameName);
		      Keeps[NbrKeeps]->NbrGames=1;
		      NbrKeeps++;
		    }
		  else
		    {
		      for(j=0;j<Keeps[i]->NbrGames;j++)
			if(strcmp(ThisDiffRom->SourceRom->GameName,Keeps[i]->Games[j])==0)
			  break;
		      
		      if(j==Keeps[i]->NbrGames)
			{
			  printf("1\n");
			  Keeps[i]->Games=XREALLOC(Keeps[i]->Games,unsigned char*,Keeps[i]->NbrGames+1);
			  Keeps[i]->Games[Keeps[i]->NbrGames]=XSTRDUP(ThisDiffRom->SourceRom->GameName);
			  Keeps[i]->NbrGames++;
			};
		    };
		};
	      
	      if(ThisDiffGame->Roms->Next!=NULL)
		ThisDiffGame->Roms=ThisDiffGame->Roms->Next;
	      else
		break;
	    }while (ThisDiffGame->Roms!=NULL);
	
	  if(Diff->Games->Next!=NULL)
	    Diff->Games=Diff->Games->Next;
	  else
	    break;
	}while (Diff->Games!=NULL);
    };

  for(i=0;i<NbrKeeps;i++)
    {
      printf("%s\n",Keeps[i]->Source->Source);
      for(j=0;j<Keeps[i]->NbrGames;j++)
	printf("\t%s\n",Keeps[i]->Games[j]);
    };

  for(i=0;i<NbrKeeps;i++)
    {
      for(j=0;j<Diff->GamesList1->NbrSources;j++)
	{
	  if(Keeps[i]->Source==Diff->GamesList1->Sources[j])
	    for(k=0;k<Diff->GamesList1->Sources[j]->GamesList->NbrGames;k++)
	      {
		for(l=0;l<Keeps[i]->NbrGames;l++)
		  if(Diff->GamesList1->Sources[j]->GamesList->Games[k]!=NULL &&
		     strcmp(Keeps[i]->Games[l],Diff->GamesList1->Sources[j]->GamesList->Games[k]->Name)==0)
		    break;
		if(l==Keeps[i]->NbrGames)
		  {
		    FreeGameInfo(Diff->GamesList1->Sources[j]->GamesList->Games[k]);
		    Diff->GamesList1->Sources[j]->GamesList->Games[k]=NULL;
		    erased++;
		  };
	      };
	};
    };

  printf("GamesList1: %i\n",erased);
  erased=0;

  for(i=0;i<NbrKeeps;i++)
    {
      for(j=0;j<Diff->GamesList2->NbrSources;j++)
	{
	  if(Keeps[i]->Source==Diff->GamesList2->Sources[j])
	    for(k=0;k<Diff->GamesList2->Sources[j]->GamesList->NbrGames;k++)
	      {
		for(l=0;l<Keeps[i]->NbrGames;l++)
		  if(Diff->GamesList2->Sources[j]->GamesList->Games[k]!=NULL &&
		     strcmp(Keeps[i]->Games[l],Diff->GamesList2->Sources[j]->GamesList->Games[k]->Name)==0)
		    break;
		if(l==Keeps[i]->NbrGames)
		  {
		    FreeGameInfo(Diff->GamesList2->Sources[j]->GamesList->Games[k]);
		    Diff->GamesList2->Sources[j]->GamesList->Games[k]=NULL;
		    erased++;
		  };
	      };
	};
    };

  printf("GamesList1: %i\n",erased);
  erased=0;

  for(i=0;i<NbrKeeps;i++)
    {
      for(j=0;j<Keeps[i]->NbrGames;j++)
	XFREE(Keeps[i]->Games[j]);
      XFREE(Keeps[i]->Games);
      XFREE(Keeps[i]);
    };
  XFREE(Keeps);
	    
  
}  

s_GamesList *MISSINGtoGamesList(s_Diff *Diff)
{
  s_GamesList *GamesList=NULL;
  s_DiffGame *ThisDiffGame=NULL;
  s_DiffRom *ThisDiffRom=NULL;
  s_RomContent **Contents=NULL;
  s_SortBox *RomContentSortBox=NULL;

  unsigned int i,nbrdata;

  GamesList=XMALLOC(s_GamesList,1);

  GamesList->MergedGamesList=TRUE;
  GamesList->NbrSources=0;
  GamesList->Sources=XCALLOC(s_GamesListSource*,
			     Diff->GamesList2->NbrSources);

  for(i=0;i<Diff->GamesList2->NbrSources;i++)
    {
      GamesList->Sources[i]=Diff->GamesList2->Sources[i];
      GamesList->NbrSources++;
    };
      
  GamesList->NbrResources=0;
  GamesList->Resources=NULL;
  GamesList->NbrGames=0;
  GamesList->Games=NULL;
  GamesList->NbrRomContents=0;
  GamesList->RomContents=NULL;
  GamesList->NbrSoundSamples=0;
  GamesList->SoundSamples=NULL;
  GamesList->NbrUnknownTokens=0;

  RomContentSortBox=InitSortBox(SB_NUM,NULL);  

  if(Diff->NbrGames!=0)
    {
      Diff->Games=CLFirst(Diff->Games);
      do
	{
	  ThisDiffGame=DIFF_GAME(CLGetData(Diff->Games));
	  if(ThisDiffGame->NbrMISSINGRoms!=0)
	    {
	      GamesList->Games=XREALLOC(GamesList->Games,
					s_GameInfo*,
					GamesList->NbrGames+1);
	      
	      GamesList->Games[GamesList->NbrGames]=XCALLOC(s_GameInfo,1);
	      
	      GamesList->Games[GamesList->NbrGames]->Name=
		XSTRDUP(ThisDiffGame->Game->Name);
	      printf("%s\n",ThisDiffGame->Game->Name);
	      ThisDiffGame->Roms=CLFirst(ThisDiffGame->Roms);
	      do
		{
		  ThisDiffRom=DIFF_ROM(CLGetData(ThisDiffGame->Roms));
		  printf("\t%s\n",ThisDiffRom->Rom->Name);
		  if(ThisDiffRom->Type==ADDEDNEW)
		    {
		      GamesList->Games[GamesList->NbrGames]->Roms=
			XREALLOC(GamesList->Games[GamesList->NbrGames]->Roms,
				 s_RomInfo*,
				 GamesList->Games[GamesList->NbrGames]->NbrRoms+1);
		      
		      GamesList->Games[GamesList->NbrGames]->Roms[GamesList->Games[GamesList->NbrGames]->NbrRoms]=ThisDiffRom->Rom;
		      GamesList->Games[GamesList->NbrGames]->NbrRoms++;
		      
		      nbrdata=0;
		      if(ThisDiffRom->Rom->Content->CRC!=0)
			Contents=(s_RomContent**)SortBox_FindTheUint(RomContentSortBox,
								     ThisDiffRom->Rom->Content->CRC,
								     (int*)&nbrdata);
		      
		      if(Contents!=NULL)
			for(i=0;i<nbrdata;i++)
			  if (Contents[i]->Size==ThisDiffRom->Rom->Content->Size)
			    break;
		      
		      if(Contents==NULL || (Contents!=NULL && i==nbrdata))
			{
			  if(ThisDiffRom->Rom->Content->CRC!=0)
			    {
			      SortBox_AddOneUint(RomContentSortBox,
						 ThisDiffRom->Rom->Content->CRC,
						 ThisDiffRom->Rom->Content); 
			      
			      GamesList->RomContents=
				XREALLOC(GamesList->RomContents,
					 s_RomContent*,
					 GamesList->NbrRomContents+1);
			      
			      GamesList->RomContents[GamesList->NbrRomContents]=
				ThisDiffRom->Rom->Content;
			      
			      GamesList->NbrRomContents++;
			    };
			};
		      for(i=0;i<nbrdata;i++)
			Contents[i]=NULL;
		      XFREE(Contents);		      
		    };
		  		  
		  if(ThisDiffGame->Roms->Next!=NULL)
		    ThisDiffGame->Roms=ThisDiffGame->Roms->Next;
		  else
		    break;
		}while(ThisDiffGame->Roms!=NULL); 
	      
	      GamesList->NbrGames++;
	    };
	  if(Diff->Games->Next!=NULL)
	    Diff->Games=Diff->Games->Next;
	  else
	    break;
	}while(Diff->Games!=NULL); 
    };

  FreeSortBox(RomContentSortBox);

  return GamesList;
};
