/*
  Copyright(C) 2002-2007 Pierre Mazire
  
  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.
  
  This program is distributed in the hope that it will be useful, but
  WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
  General Public License for more details.
  
  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
*/

/*
  chainlst.c
  
  Chain Lists management functions
*/

#include "common.h"
#include <mamory/chainlst.h>

inline void *CLGetData(s_chainlst *CL)
{
  return CL->Data;
};

unsigned int CLLen(s_chainlst *CL)
{
  unsigned int i=0;

  if (!CL)
    return 0;

  while(CL->Prev!=NULL)
    CL=CL->Prev;

  while(CL->Next!=NULL)
    {
      CL=CL->Next;  
      i++;
    };
  i++;

  return i;
};


s_chainlst *CLFirst(s_chainlst *CL)
{
  if(!CL)
    return NULL;

  while(CL->Prev!=NULL)
    CL=CL->Prev;
  return CL;
};

s_chainlst *CLLast(s_chainlst *CL)
{
  if(!CL)
    return NULL;

  while(CL->Next!=NULL)
    CL=CL->Next;
  return CL;
};  
 
s_chainlst *CLAppend(s_chainlst *CL,void *data)
{
  s_chainlst *newCL;

  newCL=XMALLOC(s_chainlst,1);

  if (!CL)
    {
      newCL->Data=data;
      newCL->Prev=NULL;
      newCL->Next=NULL;
      return newCL;
    };
      
  while(CL->Next!=NULL)
    CL=CL->Next;

  newCL->Data=data;
  newCL->Prev=CL;
  newCL->Next=NULL;

  CL->Next=newCL;

  return newCL;
};


s_chainlst *CLPrepend(s_chainlst *CL,void *data)
{
  s_chainlst *newCL=NULL;

  if (!CL)
    {
      CL=XMALLOC(s_chainlst,1);
      CL->Data=data;
      CL->Prev=NULL;
      CL->Next=NULL;
      return CL;
    };
      
  while(CL->Prev!=NULL)
    CL=CL->Prev;

  newCL=XMALLOC(s_chainlst,1);
  newCL->Data=data;
  newCL->Prev=NULL;
  newCL->Next=CL;

  CL->Prev=newCL;

  return newCL;
};

s_chainlst *CLInsert(s_chainlst *CL,void *data,unsigned int pos)
{
  s_chainlst *newCL;
  unsigned int i=0;

  if (!CL || pos==0)
    return CLPrepend(CL,data);
 
  while(CL->Prev!=NULL)
    CL=CL->Prev;

  while(i<pos && CL!=NULL)
    {
      CL=CL->Next;
      i++;
    };

  if (CL==NULL || CL->Next==NULL)
    return CLAppend(CL,data);

  newCL=XMALLOC(s_chainlst,1);
  newCL->Data=data;
  newCL->Prev=CL;
  newCL->Next=CL->Next;
  CL->Next=newCL;
  newCL->Next->Prev=newCL;

  return newCL;
};
  
s_chainlst *CLRemove(s_chainlst *CL,void *data)
{
  s_chainlst *CLreturn=CL;

  if (!CL)
    return NULL;

  while(CL->Prev!=NULL)
    CL=CL->Prev;

  while(CL!=NULL && CL->Data!=data)
    CL=CL->Next;

  if (!CL)
    return CLreturn;

  if(CL->Prev!=NULL)
    CL->Prev->Next=CL->Next;
  if(CL->Next!=NULL)
    CL->Next->Prev=CL->Prev;
  if(CL->Prev==NULL)
    CLreturn=CL->Next;
  else
    CLreturn=CL->Prev;
  CL->Next=NULL;
  CL->Prev=NULL;
  CL->Data=NULL;
  XFREE(CL);
  return CLreturn;
};

s_chainlst *CLRemoveAll(s_chainlst *CL,void *data)
{
  if (!CL)
    return NULL;

  while(CL->Prev!=NULL)
    CL=CL->Prev;  

  while(CL->Next!=NULL)
    {
      while(CL->Data!=data)
	CL=CL->Next;

      if(!CL)
	return NULL;

      CL->Prev->Next=CL->Next;
      CL->Next->Prev=CL->Prev;
      CL->Next=NULL;
      CL->Prev=NULL;
      CL->Data=NULL;
      XFREE(CL);
    };

  return NULL;
};    

void FreeCL(s_chainlst *CL)
{
  if (CL==NULL) 
    return;
  CL=CLLast(CL);
  
  CL->Data=NULL;
  while(CL->Prev!=NULL)
    {
      CL=CL->Prev;
      CL->Next->Prev=NULL;
      XFREE(CL->Next);
      CL->Data=NULL;
    };

  XFREE(CL);
};
      
