/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.mapshot;

import org.eclipse.core.runtime.Assert;
import org.eclipse.draw2d.Cursors;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Path;
import org.eclipse.swt.widgets.Display;
import org.xmind.gef.draw2d.SizeableImageFigure;
import org.xmind.gef.draw2d.graphics.GraphicsUtils;
import org.xmind.ui.resources.ColorUtils;
import org.xmind.ui.resources.FontUtils;

public final class Button
extends SizeableImageFigure {
    private static final int HIGHTLIGHT_ALPHA = 255;
    private static final int HOVERLIGHT_ALPHA = 140;
    private static final int PREFERRED_WIDTH = 68;
    private static final int PREFERRED_HEIGHT = 28;
    private Rectangle prefBounds;
    private String text;
    private String id;
    private boolean isHover = false;
    private Dimension textSize = null;
    private static final Point TEXT_LOC = new Point();
    private static final Dimension rectBound = new Dimension(68, 28);
    private static final Color FILL_COLOR = ColorUtils.getColor((String)"#D8D8D8");
    private static final Color SEPORATE_COLOR = ColorUtils.getColor((String)"#7F7F7F");
    private static final Color TEXT_COLORr = ColorUtils.getColor((String)"#4A4A4A");

    public Button(String id, String text, Rectangle prefBounds) {
        this.setAlpha(255);
        this.setPreferredSize(prefBounds == null ? rectBound : prefBounds.getSize());
        this.setSize(rectBound);
        this.setCursor(Cursors.HAND);
        this.setOpaque(false);
        this.id = id;
        this.text = text;
        this.prefBounds = prefBounds == null ? null : new Rectangle(prefBounds);
    }

    protected void paintFigure(Graphics graphics) {
        this.drawFigure(graphics);
        this.drawText(graphics);
    }

    private void drawFigure(Graphics graphics) {
        if (this.id.equals("Cancel")) {
            this.drawCancelFigure(graphics);
        } else if (this.id.equals("Save")) {
            this.drawSaveFigure(graphics);
        } else if (this.id.equals("Copy")) {
            this.drawCopyFigure(graphics);
        }
    }

    private void drawCancelFigure(Graphics graphics) {
        org.xmind.gef.draw2d.graphics.Path shape = new org.xmind.gef.draw2d.graphics.Path((Device)Display.getCurrent());
        graphics.setAlpha(255);
        if (this.isHover().booleanValue()) {
            graphics.setAlpha(140);
        }
        graphics.setBackgroundColor(FILL_COLOR);
        graphics.setAntialias(1);
        Rectangle rect = this.getBounds();
        graphics.translate(rect.x, rect.y);
        shape.moveTo((float)((double)rect.height / 2.0), (float)rect.height);
        shape.addArc(new Rectangle(0, 0, rect.height, rect.height), 90.0f, 180.0f);
        shape.moveTo((float)((double)rect.height / 2.0), 0.0f);
        shape.lineTo((float)(rect.width - 1), 0.0f);
        shape.lineTo((float)(rect.width - 1), (float)rect.height);
        shape.lineTo((float)((double)rect.height / 2.0), (float)rect.height);
        graphics.fillPath((Path)shape);
        graphics.setAlpha(255);
        graphics.setForegroundColor(SEPORATE_COLOR);
        graphics.drawLine(rect.width, 0, rect.width, rect.height);
        graphics.translate(-rect.x, -rect.y);
        shape.dispose();
    }

    private void drawSaveFigure(Graphics graphics) {
        org.xmind.gef.draw2d.graphics.Path shape = new org.xmind.gef.draw2d.graphics.Path((Device)Display.getCurrent());
        shape.addRectangle(this.getBounds());
        graphics.setAlpha(255);
        graphics.setAntialias(1);
        if (this.isHover().booleanValue()) {
            graphics.setAlpha(140);
        }
        graphics.setBackgroundColor(FILL_COLOR);
        graphics.fillPath((Path)shape);
        shape.dispose();
    }

    private void drawCopyFigure(Graphics graphics) {
        Rectangle rect = this.getBounds();
        graphics.translate(rect.x, rect.y);
        graphics.setAlpha(255);
        graphics.setAntialias(1);
        org.xmind.gef.draw2d.graphics.Path shape = new org.xmind.gef.draw2d.graphics.Path((Device)Display.getCurrent());
        float circleX = (float)((double)rect.width - (double)rect.height / 2.0);
        shape.moveTo(circleX, (float)rect.height);
        shape.addArc(new Rectangle(rect.width - rect.height, 0, rect.height, rect.height), 270.0f, 180.0f);
        shape.moveTo(circleX, 0.0f);
        shape.lineTo(1.0f, 0.0f);
        shape.lineTo(1.0f, (float)rect.height);
        shape.lineTo(circleX, (float)rect.height);
        if (this.isHover().booleanValue()) {
            graphics.setAlpha(140);
        }
        graphics.setBackgroundColor(FILL_COLOR);
        graphics.fillPath((Path)shape);
        graphics.setAlpha(255);
        graphics.setForegroundColor(SEPORATE_COLOR);
        graphics.drawLine(0, 0, 0, rect.height);
        graphics.translate(-rect.x, -rect.y);
        shape.dispose();
    }

    private void drawText(Graphics graphics) {
        Rectangle rect = this.getBounds();
        Dimension textSize = this.getTextSize();
        Button.TEXT_LOC.x = rect.x + rect.width / 2 - textSize.width / 2;
        Button.TEXT_LOC.y = rect.y + rect.height / 2 - textSize.height / 2;
        graphics.setAntialias(1);
        graphics.setTextAntialias(1);
        graphics.setFont(this.getDefinedFont());
        graphics.setAlpha(255);
        graphics.setBackgroundColor(this.getBackgroundColor());
        graphics.setForegroundColor(TEXT_COLORr);
        graphics.drawText(this.getText(), Button.TEXT_LOC.x, Button.TEXT_LOC.y);
    }

    public Font getDefinedFont() {
        return FontUtils.getNewHeight((Font)this.getFont(), (int)10);
    }

    public void layout(Rectangle parentBounds) {
        if (this.prefBounds != null) {
            Rectangle bounds = this.prefBounds.getTranslated(parentBounds.x, parentBounds.y);
            this.setBounds(bounds);
        }
    }

    public String getText() {
        Assert.isNotNull((Object)this.text);
        return this.text;
    }

    private Dimension getTextSize() {
        this.textSize = GraphicsUtils.getAdvanced().getTextSize(this.getText(), this.getDefinedFont());
        return this.textSize;
    }

    public void setHover(boolean isHover) {
        this.isHover = isHover;
        this.repaint();
    }

    public Boolean isHover() {
        return this.isHover;
    }
}

