/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.iconfinder;

import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.e4.ui.di.Focus;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.model.application.ui.menu.MMenu;
import org.eclipse.e4.ui.model.application.ui.menu.MPopupMenu;
import org.eclipse.e4.ui.services.EMenuService;
import org.eclipse.e4.ui.workbench.modeling.EModelService;
import org.eclipse.e4.ui.workbench.modeling.ESelectionService;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IPartService;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.internal.E4PartWrapper;

public class ModelPart
implements IAdaptable {
    @Inject
    EMenuService menuService;
    @Inject
    private EModelService modelService;
    @Inject
    private ESelectionService selectionService;
    @Inject
    private MPart partModel;
    @Inject
    private IWorkbenchWindow workbenchWindow;
    private ISelectionProvider selectionProvider = null;
    private ISelectionChangedListener selectionChangedListener = new ISelectionChangedListener(){

        public void selectionChanged(SelectionChangedEvent event) {
            ModelPart.this.handleSelectionChanged(event);
        }
    };

    @PostConstruct
    private void postConstruct(Composite parent) {
        this.init();
        this.createContent(parent);
    }

    protected void init() {
    }

    protected void createContent(Composite parent) {
    }

    @PreDestroy
    private void preDestroy() {
        this.dispose();
    }

    protected void dispose() {
    }

    @Focus
    private void delegateSetFocus() {
        IPartService partService;
        this.setFocus();
        if (this.workbenchWindow != null && (partService = this.workbenchWindow.getPartService()) instanceof IPartListener && this.partModel.getTransientData().get("e4Wrapper") instanceof E4PartWrapper) {
            IWorkbenchPart wp = (IWorkbenchPart)this.partModel.getTransientData().get("e4Wrapper");
            ((IPartListener)partService).partActivated(wp);
        }
    }

    protected void setFocus() {
    }

    protected void setSelectionProvider(ISelectionProvider selectionProvider) {
        ISelectionProvider oldSelectionProvider = this.selectionProvider;
        if (selectionProvider == oldSelectionProvider) {
            return;
        }
        if (oldSelectionProvider != null) {
            oldSelectionProvider.removeSelectionChangedListener(this.selectionChangedListener);
        }
        this.selectionProvider = selectionProvider;
        if (selectionProvider != null) {
            selectionProvider.addSelectionChangedListener(this.selectionChangedListener);
        }
        if (this.selectionService != null) {
            this.selectionService.setSelection((Object)(selectionProvider == null ? null : selectionProvider.getSelection()));
        }
    }

    private void handleSelectionChanged(SelectionChangedEvent event) {
        if (this.selectionService != null) {
            this.selectionService.setSelection((Object)event.getSelection());
        }
    }

    public boolean registerContextMenu(Object menuParent, String menuId) {
        if (this.menuService != null) {
            if (this.modelService != null & this.partModel != null) {
                MPopupMenu menuModel = null;
                for (MMenu item : this.partModel.getMenus()) {
                    if (!menuId.equals(item.getElementId()) || !(item instanceof MPopupMenu)) continue;
                    menuModel = (MPopupMenu)item;
                    break;
                }
                if (menuModel == null) {
                    menuModel = (MPopupMenu)this.modelService.createModelElement(MPopupMenu.class);
                    menuModel.setElementId(menuId);
                    menuModel.getTags().add("menuContribution:popup");
                    this.partModel.getMenus().add(menuModel);
                }
            }
            return this.menuService.registerContextMenu(menuParent, menuId);
        }
        return false;
    }

    public <T> T getAdapter(Class<T> adapter) {
        if (EModelService.class.equals(adapter)) {
            return adapter.cast(this.modelService);
        }
        if (MPart.class.equals(adapter)) {
            return adapter.cast(this.partModel);
        }
        if (EMenuService.class.equals(adapter)) {
            return adapter.cast(this.menuService);
        }
        if (IWorkbenchWindow.class.equals(adapter)) {
            return adapter.cast(this.workbenchWindow);
        }
        return null;
    }
}

