/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.gef.ui.internal;

import org.eclipse.core.expressions.PropertyTester;
import org.eclipse.core.runtime.Assert;
import org.xmind.gef.command.ICommandStack;

public class CommandStackPropertyTester
extends PropertyTester {
    private static final String P_CAN_UNDO = "canUndo";
    private static final String P_CAN_REDO = "canRedo";
    private static final String P_IS_DIRTY = "isDirty";

    public boolean test(Object receiver, String property, Object[] args, Object expectedValue) {
        Assert.isLegal((boolean)(receiver instanceof ICommandStack));
        ICommandStack stack = (ICommandStack)receiver;
        if (P_CAN_UNDO.equals(property)) {
            return CommandStackPropertyTester.testBooleanValue(stack.canUndo(), expectedValue);
        }
        if (P_CAN_REDO.equals(property)) {
            return CommandStackPropertyTester.testBooleanValue(stack.canRedo(), expectedValue);
        }
        if (P_IS_DIRTY.equals(property)) {
            return CommandStackPropertyTester.testBooleanValue(stack.isDirty(), expectedValue);
        }
        Assert.isLegal((boolean)false, (String)("Unrecognized property: " + property));
        return false;
    }

    private static boolean testBooleanValue(boolean actualValue, Object expectedValue) {
        if (expectedValue == null || "".equals(expectedValue)) {
            return actualValue;
        }
        if (expectedValue instanceof String) {
            return Boolean.parseBoolean((String)expectedValue) == actualValue;
        }
        if (expectedValue instanceof Boolean) {
            return (Boolean)expectedValue == actualValue;
        }
        Assert.isLegal((boolean)false, (String)("Unrecognized expected value: " + expectedValue));
        return false;
    }
}

