/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.gef.internal.image;

import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import javax.imageio.ImageIO;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.util.Util;
import org.eclipse.swt.graphics.Image;
import org.xmind.gef.image.ImageWriter;
import org.xmind.gef.internal.image.ImageConverter;
import org.xmind.gef.internal.image.SWTImageWriter;

public class PngWriter
extends ImageWriter {
    public PngWriter(Image image, OutputStream output) {
        super(image, output);
    }

    public void write(IProgressMonitor monitor) throws IOException {
        if (Util.isMac()) {
            this.writeOnCarbon(monitor);
        } else {
            ImageIO.write((RenderedImage)ImageConverter.convert(this.getImage()), "png", this.getOutput());
        }
    }

    private void writeOnCarbon(IProgressMonitor monitor) throws IOException {
        File temp = File.createTempFile("EXPORT_", ".png");
        FileOutputStream tempOutput = new FileOutputStream(temp);
        SWTImageWriter tempWriter = new SWTImageWriter(this.getImage(), 0, (OutputStream)tempOutput);
        tempWriter.write(monitor);
        try {
            ImageIO.write((RenderedImage)ImageIO.read(temp), "png", this.getOutput());
        }
        finally {
            temp.delete();
        }
    }
}

