/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.notes;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.resource.DeviceResourceDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.jface.util.SafeRunnable;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.xmind.core.IBoundary;
import org.xmind.core.IRelationship;
import org.xmind.core.ISheet;
import org.xmind.core.ITopic;
import org.xmind.core.event.CoreEvent;
import org.xmind.core.event.CoreEventRegister;
import org.xmind.core.event.ICoreEventListener;
import org.xmind.core.event.ICoreEventRegister;
import org.xmind.core.event.ICoreEventSupport;
import org.xmind.gef.ui.editor.IGraphicalEditor;
import org.xmind.ui.internal.MindMapMessages;
import org.xmind.ui.internal.actions.DeleteNotesAction;
import org.xmind.ui.internal.notes.INotesContentViewer;
import org.xmind.ui.internal.notes.NotesUtils;
import org.xmind.ui.internal.notes.RichDocumentNotesAdapter;
import org.xmind.ui.internal.utils.E4Utils;
import org.xmind.ui.mindmap.MindMapUI;
import org.xmind.ui.resources.ColorUtils;
import org.xmind.ui.resources.FontUtils;
import org.xmind.ui.util.MindMapUtils;
import org.xmind.ui.util.TextFormatter;

public class SheetNotesViewer
implements INotesContentViewer,
ICoreEventListener {
    private static final int EXTRA_WIDTH = 28;
    private ISheet sheet;
    private IBoundary boundary;
    private IRelationship relationship;
    private Composite composite;
    private ScrolledComposite sc;
    private Composite contentComposite;
    private List<Composite> textComposites = new ArrayList<Composite>();
    private List<Control> textControls = new ArrayList<Control>();
    private Map<Composite, ITopic> map = new HashMap<Composite, ITopic>();
    private Composite currentTextComposite;
    private IGraphicalEditor editor;
    private int scClientWidth = 0;
    private DeleteNotesAction deleteNotesAction;
    private ICoreEventRegister notesEventRegister;
    private ICoreEventRegister titleEventRegister;
    private Color originalColor;
    private Color hoverColor = ColorUtils.getColor((String)"#f9f9f9");
    private Color selectColor = ColorUtils.getColor((String)"#f5f5f5");
    private Listener filter;
    private List<Control> controls = new ArrayList<Control>();
    private ResourceManager resources;

    public SheetNotesViewer(IGraphicalEditor editor) {
        this.editor = editor;
    }

    @Override
    public Control createControl(Composite parent) {
        this.resetCollections();
        this.composite = new Composite(parent, 0);
        this.resources = new LocalResourceManager(JFaceResources.getResources(), (Control)this.composite);
        this.composite.setBackground(parent.getDisplay().getSystemColor(1));
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.horizontalSpacing = 0;
        layout.verticalSpacing = 0;
        this.composite.setLayout((Layout)layout);
        this.composite.setLayoutData((Object)new GridData(1808));
        this.createContentArea(this.composite);
        return this.composite;
    }

    private void resetCollections() {
        if (this.textComposites != null) {
            this.textComposites.clear();
        }
        if (this.textControls != null) {
            this.textControls.clear();
        }
        if (this.map != null) {
            this.map.clear();
        }
        if (this.controls != null) {
            this.controls.clear();
        }
    }

    private void createContentArea(Composite parent) {
        this.contentComposite = this.createContentComposite(parent);
        this.deleteNotesAction = new DeleteNotesAction(this);
        this.addMouseFilter();
        this.contentComposite.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                SheetNotesViewer.this.removeMouseFilter();
            }
        });
    }

    private Composite createContentComposite(Composite parent) {
        this.sc = new ScrolledComposite(parent, 512);
        this.sc.setLayoutData((Object)new GridData(1808));
        this.sc.setBackground(parent.getBackground());
        this.sc.setExpandHorizontal(true);
        this.sc.setMinSize(-1, -1);
        Composite composite = new Composite((Composite)this.sc, 0);
        composite.setBackground(parent.getBackground());
        GridLayout gridLayout = new GridLayout(1, false);
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 10;
        gridLayout.marginTop = 0;
        gridLayout.verticalSpacing = 10;
        gridLayout.horizontalSpacing = 0;
        composite.setLayout((Layout)gridLayout);
        this.sc.setContent((Control)composite);
        this.sc.getVerticalBar().setIncrement(17);
        return composite;
    }

    private void showAllNotes(Composite parent) {
        this.sc.setExpandVertical(false);
        List<ITopic> topics = NotesUtils.getAllTopicsWithNotes(this.sheet);
        if (topics.size() == 0) {
            this.sc.setExpandVertical(true);
            this.createNullContent(parent);
            return;
        }
        int i = 0;
        while (i < topics.size() - 1) {
            this.showLabelAndNote(parent, topics.get(i));
            this.createSeparatorLine(parent);
            ++i;
        }
        this.showLabelAndNote(parent, topics.get(topics.size() - 1));
        if (this.sc.getClientArea().width > 0) {
            for (Control textControl : this.textControls) {
                ((GridData)textControl.getLayoutData()).widthHint = this.sc.getClientArea().width - 28;
            }
        }
        this.sc.addListener(11, new Listener(){

            public void handleEvent(Event event) {
                SheetNotesViewer.this.sc.getDisplay().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        if (SheetNotesViewer.this.sc.isDisposed() || SheetNotesViewer.this.contentComposite.isDisposed()) {
                            return;
                        }
                        if (((SheetNotesViewer)(this).SheetNotesViewer.this).sc.getClientArea().width > 0 && SheetNotesViewer.this.scClientWidth != ((SheetNotesViewer)(this).SheetNotesViewer.this).sc.getClientArea().width) {
                            SheetNotesViewer.this.scClientWidth = ((SheetNotesViewer)(this).SheetNotesViewer.this).sc.getClientArea().width;
                            for (Control textControl : SheetNotesViewer.this.textControls) {
                                if (textControl == null || textControl.isDisposed()) continue;
                                ((GridData)textControl.getLayoutData()).widthHint = ((SheetNotesViewer)(this).SheetNotesViewer.this).sc.getClientArea().width - 28;
                            }
                            SheetNotesViewer.this.contentComposite.pack();
                        }
                    }
                });
            }
        });
    }

    private void createNullContent(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setBackground(composite.getParent().getBackground());
        composite.setLayoutData((Object)new GridData(0x1000000, 0x1000000, true, true));
        GridLayout layout = new GridLayout(1, false);
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.verticalSpacing = 20;
        composite.setLayout((Layout)layout);
        Label label = new Label(composite, 0);
        label.setBackground(label.getParent().getBackground());
        label.setLayoutData((Object)new GridData(0x1000000, 0x1000000, false, false));
        label.setImage((Image)this.resources.get((DeviceResourceDescriptor)MindMapUI.getImages().get("notes-empty-bg.png", true)));
        Composite composite2 = new Composite(composite, 0);
        composite2.setBackground(composite2.getParent().getBackground());
        composite2.setLayoutData((Object)new GridData(0x1000000, 0x1000000, false, false));
        GridLayout layout2 = new GridLayout(1, false);
        layout2.marginWidth = 0;
        layout2.marginHeight = 0;
        layout2.verticalSpacing = 0;
        composite2.setLayout((Layout)layout2);
        Label label2 = new Label(composite2, 0);
        label2.setBackground(label2.getParent().getBackground());
        label2.setForeground(ColorUtils.getColor((String)"#aaaaaa"));
        label2.setLayoutData((Object)new GridData(0x1000000, 0x1000000, false, false));
        label2.setText("");
        label2.setFont(FontUtils.getRelativeHeight((String)"org.eclipse.jface.defaultfont", (int)2));
        Label label3 = new Label(composite2, 0);
        label3.setBackground(label3.getParent().getBackground());
        label3.setForeground(ColorUtils.getColor((String)"#aaaaaa"));
        label3.setLayoutData((Object)new GridData(0x1000000, 0x1000000, false, false));
        label3.setText(MindMapMessages.Comments_FirstAdd_text);
        label3.setFont(FontUtils.getRelativeHeight((String)"org.eclipse.jface.defaultfont", (int)2));
    }

    private void addMouseFilter() {
        Display.getCurrent().addFilter(6, this.getFilter());
        Display.getCurrent().addFilter(7, this.getFilter());
    }

    private void removeMouseFilter() {
        Display.getCurrent().removeFilter(6, this.getFilter());
        Display.getCurrent().removeFilter(7, this.getFilter());
    }

    private Listener getFilter() {
        if (this.filter == null) {
            this.filter = new Listener(){

                public void handleEvent(Event event) {
                    if (SheetNotesViewer.this.contentComposite.isDisposed()) {
                        return;
                    }
                    if (event.widget instanceof Control) {
                        Control mouseControl = null;
                        for (Control control : SheetNotesViewer.this.controls) {
                            boolean isAncestor;
                            if (control == null || control.isDisposed() || !(isAncestor = SheetNotesViewer.this.isAncestorOf((Control)((Composite)control), (Control)event.widget))) continue;
                            mouseControl = control;
                            break;
                        }
                        if (mouseControl != null && !mouseControl.isDisposed()) {
                            switch (event.type) {
                                case 6: {
                                    if (!mouseControl.getBackground().equals((Object)SheetNotesViewer.this.originalColor)) break;
                                    SheetNotesViewer.this.setRecursiveBackgroundColor(mouseControl, SheetNotesViewer.this.hoverColor, null);
                                    ((Composite)mouseControl).layout();
                                    break;
                                }
                                case 7: {
                                    if (!mouseControl.getBackground().equals((Object)SheetNotesViewer.this.hoverColor)) break;
                                    SheetNotesViewer.this.setRecursiveBackgroundColor(mouseControl, SheetNotesViewer.this.originalColor, null);
                                    ((Composite)mouseControl).layout();
                                }
                            }
                        }
                    }
                }
            };
        }
        return this.filter;
    }

    private boolean isAncestorOf(Control composite, Control control) {
        if (control == composite) {
            return true;
        }
        Composite parent = control.getParent();
        while (parent != null && parent != composite && !(parent instanceof Shell)) {
            parent = parent.getParent();
        }
        return parent == composite;
    }

    private void showLabelAndNote(Composite parent, ITopic topic) {
        Composite composite = new Composite(parent, 0);
        composite.setBackground(parent.getBackground());
        this.originalColor = composite.getBackground();
        composite.setLayoutData((Object)new GridData(4, 128, true, false));
        GridLayout layout = new GridLayout(1, false);
        layout.marginWidth = 5;
        layout.marginLeft = 0;
        layout.marginRight = 0;
        layout.marginHeight = 8;
        layout.horizontalSpacing = 0;
        layout.verticalSpacing = 5;
        composite.setLayout((Layout)layout);
        this.createTopicLabel(composite, topic);
        this.createSingleNotes(composite, topic);
        this.createContextMenu(composite, topic);
        this.controls.add((Control)composite);
    }

    private void createContextMenu(Composite control, ITopic topic) {
        this.setRecursionContextMenu((Control)control, this.getContextMenu((Control)control, topic));
    }

    private void setRecursionContextMenu(Control control, Menu contextMenu) {
        if (control != null && !control.isDisposed()) {
            control.setMenu(contextMenu);
        }
        if (control instanceof Composite) {
            Control[] children;
            Control[] controlArray = children = ((Composite)control).getChildren();
            int n = children.length;
            int n2 = 0;
            while (n2 < n) {
                Control child = controlArray[n2];
                this.setRecursionContextMenu(child, contextMenu);
                ++n2;
            }
        }
    }

    private Menu getContextMenu(Control control, final ITopic topic) {
        MenuManager menuManager = new MenuManager();
        menuManager.add((IAction)new Action(MindMapMessages.Notes_Edit_text){

            public void run() {
                MindMapUtils.reveal(SheetNotesViewer.this.editor, topic);
            }
        });
        menuManager.add((IAction)new Action(MindMapMessages.Notes_Delete_text){

            public void run() {
                DeleteNotesAction deleteNotesAction2 = new DeleteNotesAction(SheetNotesViewer.this);
                deleteNotesAction2.setSelection((ISelection)new StructuredSelection((Object)topic));
                if (deleteNotesAction2.isEnabled()) {
                    deleteNotesAction2.run();
                }
            }
        });
        return menuManager.createContextMenu((Control)control.getShell());
    }

    private void createSeparatorLine(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setBackground(parent.getBackground());
        composite.setLayoutData((Object)new GridData(4, 128, true, false));
        GridLayout layout = new GridLayout(1, false);
        layout.marginWidth = 9;
        layout.marginLeft = 14;
        layout.marginRight = 0;
        layout.marginHeight = 0;
        composite.setLayout((Layout)layout);
        Label sep = new Label(composite, 258);
        sep.setLayoutData((Object)new GridData(768));
        sep.setBackground(ColorConstants.black);
    }

    private void createTopicLabel(Composite parent, ITopic topic) {
        Composite c = new Composite(parent, 0);
        c.setBackground(parent.getBackground());
        c.setLayoutData((Object)new GridData(1808));
        GridLayout layout = new GridLayout(2, false);
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.horizontalSpacing = 3;
        c.setLayout((Layout)layout);
        Label imageLabel = new Label(c, 16384);
        GridData data1 = new GridData(16384, 0x1000000, false, false);
        imageLabel.setLayoutData((Object)data1);
        imageLabel.setBackground(c.getBackground());
        Image image = (Image)this.resources.get((DeviceResourceDescriptor)MindMapUI.getImages().getTopicIcon(topic, true));
        imageLabel.setImage(image);
        Label label = new Label(c, 16640);
        label.setBackground(parent.getBackground());
        label.setForeground(ColorUtils.getColor((String)"#515151"));
        GridData data = new GridData(1808);
        data.horizontalIndent = 0;
        label.setLayoutData((Object)data);
        label.setFont(FontUtils.getBold((Font)FontUtils.getRelativeHeight((String)"org.eclipse.jface.defaultfont", (int)1)));
        label.setText(String.valueOf(TextFormatter.removeNewLineCharacter((String)topic.getTitleText())) + ":");
    }

    private void createSingleNotes(Composite parent, ITopic topic) {
        Composite composite = new Composite(parent, 0);
        composite.setBackground(parent.getBackground());
        GridData data = new GridData(1808);
        data.horizontalIndent = 18;
        composite.setLayoutData((Object)data);
        GridLayout layout = new GridLayout(1, false);
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        composite.setLayout((Layout)layout);
        StyledText text = this.createText(composite, topic);
        final Composite composite2 = parent;
        this.textComposites.add(composite2);
        this.map.put(composite2, topic);
        this.textControls.add((Control)text);
        MouseAdapter mouseListener = new MouseAdapter(){

            public void mouseDown(MouseEvent e) {
                if (composite2 == null || composite2.isDisposed()) {
                    return;
                }
                if (!composite2.isFocusControl()) {
                    composite2.forceFocus();
                }
            }

            public void mouseDoubleClick(MouseEvent e) {
                SheetNotesViewer.this.reveal(composite2);
            }
        };
        final KeyListener keyListener = new KeyListener(){

            public void keyPressed(KeyEvent e) {
                if (e.keyCode == 0x1000002) {
                    SheetNotesViewer.this.moveDown();
                } else if (e.keyCode == 0x1000001) {
                    SheetNotesViewer.this.moveUp();
                } else if (e.keyCode == 13) {
                    SheetNotesViewer.this.reveal(SheetNotesViewer.this.currentTextComposite);
                } else if (e.keyCode == 127) {
                    SheetNotesViewer.this.deleteNotesAction.run();
                }
            }

            public void keyReleased(KeyEvent e) {
            }
        };
        FocusListener focusListener = new FocusListener(){

            public void focusLost(FocusEvent e) {
                SheetNotesViewer.this.setRecursiveBackgroundColor((Control)composite2, SheetNotesViewer.this.originalColor, null);
                composite2.removeKeyListener(keyListener);
                SheetNotesViewer.this.setCurrentTextComposite(null);
            }

            public void focusGained(FocusEvent e) {
                SheetNotesViewer.this.setRecursiveBackgroundColor((Control)composite2, SheetNotesViewer.this.selectColor, null);
                composite2.addKeyListener(keyListener);
                SheetNotesViewer.this.sc.showControl((Control)composite2);
                SheetNotesViewer.this.setCurrentTextComposite(composite2);
            }
        };
        this.addMosuseListener((Control)composite2, (MouseListener)mouseListener);
        composite2.addFocusListener(focusListener);
    }

    private void setRecursiveBackgroundColor(Control control, Color background, Control excludeControl) {
        if (control == excludeControl) {
            return;
        }
        control.setBackground(background);
        if (control instanceof Composite) {
            Control[] children;
            Control[] controlArray = children = ((Composite)control).getChildren();
            int n = children.length;
            int n2 = 0;
            while (n2 < n) {
                Control child = controlArray[n2];
                this.setRecursiveBackgroundColor(child, background, excludeControl);
                ++n2;
            }
        }
    }

    private void setCurrentTextComposite(Composite composite) {
        if (composite != this.currentTextComposite) {
            this.currentTextComposite = composite;
            this.updateDeleteAction();
        }
    }

    private void updateDeleteAction() {
        ITopic topic = this.getCurrentTopic(this.currentTextComposite);
        this.deleteNotesAction.setSelection((ISelection)(topic == null ? null : new StructuredSelection((Object)topic)));
    }

    private StyledText createText(Composite parent, ITopic topic) {
        StyledText text = new StyledText(parent, 74);
        text.setBackground(parent.getBackground());
        text.setLayoutData((Object)new GridData(1808));
        text.setEnabled(false);
        text.setFont(FontUtils.getRelativeHeight((String)"org.eclipse.jface.defaultfont", (int)0));
        RichDocumentNotesAdapter adapter = new RichDocumentNotesAdapter(topic);
        text.setText(adapter.getDocument().get());
        text.setForeground(ColorUtils.getColor((String)"#9a9a9a"));
        return text;
    }

    private void reveal(Composite composite) {
        MindMapUtils.reveal(this.editor, this.getCurrentTopic(composite));
        SafeRunner.run((ISafeRunnable)new SafeRunnable(){

            public void run() throws Exception {
                E4Utils.showPart("org.xmind.ui.command.showModelPart", PlatformUI.getWorkbench().getActiveWorkbenchWindow(), "org.xmind.ui.modelPart.notes", null, "org.xmind.ui.stack.right");
            }
        });
    }

    private void addMosuseListener(Control c, MouseListener ml) {
        c.addMouseListener(ml);
        if (c instanceof Composite) {
            Control[] controlArray = ((Composite)c).getChildren();
            int n = controlArray.length;
            int n2 = 0;
            while (n2 < n) {
                Control cc = controlArray[n2];
                this.addMosuseListener(cc, ml);
                ++n2;
            }
        }
    }

    private void moveDown() {
        if (this.currentTextComposite == null) {
            return;
        }
        int index = this.textComposites.indexOf(this.currentTextComposite);
        if (index < 0 || index >= this.textComposites.size() - 1) {
            return;
        }
        this.textComposites.get(index + 1).forceFocus();
    }

    private void moveUp() {
        if (this.currentTextComposite == null) {
            return;
        }
        int index = this.textComposites.indexOf(this.currentTextComposite);
        if (index <= 0 || index > this.textComposites.size() - 1) {
            return;
        }
        this.textComposites.get(index - 1).forceFocus();
    }

    private ITopic getCurrentTopic(Composite currentComposite) {
        if (this.map == null || this.map.size() == 0) {
            return null;
        }
        return this.map.get(currentComposite);
    }

    @Override
    public void setInput(Object input) {
        if (input instanceof ISheet || input instanceof IBoundary || input instanceof IRelationship) {
            ISheet sheet = null;
            if (input instanceof ISheet) {
                if (this.sheet == input) {
                    return;
                }
                sheet = (ISheet)input;
            } else if (input instanceof IBoundary) {
                if (this.boundary == input) {
                    return;
                }
                this.unhookBoundary();
                this.boundary = (IBoundary)input;
                sheet = this.boundary.getOwnedSheet();
                this.hookBoundary();
            } else if (input instanceof IRelationship) {
                if (this.relationship == input) {
                    return;
                }
                this.unhookRelationship();
                this.relationship = (IRelationship)input;
                sheet = this.relationship.getOwnedSheet();
                this.hookRelationship();
            }
            if (sheet != this.sheet) {
                this.unhookSheet();
                this.unhookTitle();
                this.sheet = sheet;
                this.hookTitle();
                this.hookSheet();
                this.update();
            }
        }
    }

    private void update() {
        Control[] children;
        if (this.contentComposite.isDisposed()) {
            return;
        }
        this.resetCollections();
        this.contentComposite.setRedraw(false);
        Control[] controlArray = children = this.contentComposite.getChildren();
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            Control child = controlArray[n2];
            child.dispose();
            ++n2;
        }
        this.showAllNotes(this.contentComposite);
        this.contentComposite.pack();
        this.contentComposite.layout(true, true);
        this.contentComposite.setRedraw(true);
    }

    private void hookSheet() {
        if (this.notesEventRegister == null) {
            this.notesEventRegister = new CoreEventRegister((ICoreEventSupport)this.sheet.getAdapter(ICoreEventSupport.class), (ICoreEventListener)this);
        }
        this.notesEventRegister.register("topicNotes");
    }

    private void unhookSheet() {
        if (this.notesEventRegister != null) {
            this.notesEventRegister.unregisterAll();
            this.notesEventRegister = null;
        }
    }

    private void hookBoundary() {
        if (this.notesEventRegister == null) {
            this.notesEventRegister = new CoreEventRegister((ICoreEventSupport)this.boundary.getAdapter(ICoreEventSupport.class), (ICoreEventListener)this);
        }
        this.notesEventRegister.register("topicNotes");
    }

    private void unhookBoundary() {
        if (this.notesEventRegister != null) {
            this.notesEventRegister.unregisterAll();
            this.notesEventRegister = null;
        }
    }

    private void hookRelationship() {
        if (this.notesEventRegister == null) {
            this.notesEventRegister = new CoreEventRegister((ICoreEventSupport)this.relationship.getAdapter(ICoreEventSupport.class), (ICoreEventListener)this);
        }
        this.notesEventRegister.register("topicNotes");
    }

    private void unhookRelationship() {
        if (this.notesEventRegister != null) {
            this.notesEventRegister.unregisterAll();
            this.notesEventRegister = null;
        }
    }

    private void hookTitle() {
        if (this.titleEventRegister == null) {
            this.titleEventRegister = new CoreEventRegister((ICoreEventSupport)this.sheet.getAdapter(ICoreEventSupport.class), (ICoreEventListener)this);
        }
        this.titleEventRegister.register("titleText");
    }

    private void unhookTitle() {
        if (this.titleEventRegister != null) {
            this.titleEventRegister.unregisterAll();
            this.titleEventRegister = null;
        }
    }

    public void handleCoreEvent(final CoreEvent event) {
        PlatformUI.getWorkbench().getDisplay().syncExec(new Runnable(){

            @Override
            public void run() {
                String eventType = event.getType();
                if ("topicNotes".equals(eventType) || "titleText".endsWith(eventType)) {
                    SheetNotesViewer.this.update();
                }
            }
        });
    }

    @Override
    public void dispose() {
        this.unhookSheet();
        this.unhookTitle();
        this.composite.dispose();
    }

    public void setEditor(IGraphicalEditor editor) {
        this.editor = editor;
    }

    public IGraphicalEditor getEditor() {
        return this.editor;
    }

    @Override
    public Control getControl() {
        return this.composite;
    }
}

