/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.commands;

import java.util.Collection;
import org.xmind.core.IImage;
import org.xmind.core.ITopic;
import org.xmind.core.util.Point;
import org.xmind.gef.ISourceProvider;
import org.xmind.gef.command.ModifyCommand;

public class ModifyImageSizeCommand
extends ModifyCommand {
    public ModifyImageSizeCommand(IImage image, int width, int height) {
        super((Object)image, (Object)new Point(width, height));
    }

    public ModifyImageSizeCommand(ITopic topic, int width, int height) {
        super((Object)topic, (Object)new Point(width, height));
    }

    public ModifyImageSizeCommand(Collection<? extends IImage> images, int width, int height) {
        super(images, (Object)new Point(width, height));
    }

    public ModifyImageSizeCommand(ISourceProvider topicOrImageProvider, int width, int height) {
        super(topicOrImageProvider, (Object)new Point(width, height));
    }

    protected Object getValue(Object source) {
        IImage image = this.getImage(source);
        if (image != null) {
            int width = image.getWidth();
            int height = image.getHeight();
            return new Point(width, height);
        }
        return null;
    }

    protected void setValue(Object source, Object value) {
        IImage image = this.getImage(source);
        if (image != null) {
            if (value == null) {
                image.setSize(-1, -1);
            } else if (value instanceof Point) {
                Point size = (Point)value;
                image.setSize(size.x, size.y);
            }
        }
    }

    private IImage getImage(Object source) {
        if (source instanceof IImage) {
            return (IImage)source;
        }
        if (source instanceof ITopic) {
            return ((ITopic)source).getImage();
        }
        return null;
    }
}

