/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.browser;

import java.net.MalformedURLException;
import java.net.URL;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.browser.IWebBrowser;
import org.xmind.core.command.Command;
import org.xmind.core.command.CommandJob;
import org.xmind.core.command.ICommand;
import org.xmind.ui.browser.IBrowser;
import org.xmind.ui.internal.browser.BrowserMessages;
import org.xmind.ui.internal.browser.BrowserUtil;

public class InternalWorkbenchBrowser
implements IBrowser {
    private IWebBrowser impl;

    public InternalWorkbenchBrowser(String browserClientId, String name, String tooltip) throws PartInitException {
        this.impl = PlatformUI.getWorkbench().getBrowserSupport().createBrowser(32, browserClientId, name, tooltip);
    }

    public void close() {
        this.impl.close();
    }

    public String getClientId() {
        return this.impl.getId();
    }

    public void openURL(String url) throws PartInitException {
        URL theURL;
        Command command = Command.parseURI((String)url);
        if (command != null) {
            new CommandJob((ICommand)command, null).schedule();
            return;
        }
        url = BrowserUtil.normalizeURL(url);
        try {
            theURL = new URL(url);
        }
        catch (MalformedURLException malformedURLException) {
            throw new PartInitException(BrowserMessages.InternalWebBrowser_ErrorCouldNotLaunchWebBrowser_message);
        }
        this.impl.openURL(theURL);
    }

    public void setText(String text) throws PartInitException {
    }
}

