/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.preference;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExecutableExtension;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.resource.DeviceResourceDescriptor;
import org.eclipse.jface.resource.FontDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.PlatformUI;
import org.xmind.ui.preference.IPreferenceSection;
import org.xmind.ui.resources.FontUtils;

public class MultiSectionPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage,
IExecutableExtension {
    private String pageId = null;
    private List<IPreferenceSection> pageSections = new ArrayList<IPreferenceSection>();
    private List<IConfigurationElement> elments = new ArrayList<IConfigurationElement>();

    protected Control createContents(Composite parent) {
        if (this.pageId != null) {
            IExtension[] iExtensionArray = Platform.getExtensionRegistry().getExtensionPoint("org.xmind.ui.toolkit.preferencePageSections").getExtensions();
            int n = iExtensionArray.length;
            int n2 = 0;
            while (n2 < n) {
                IExtension extension = iExtensionArray[n2];
                IConfigurationElement[] iConfigurationElementArray = extension.getConfigurationElements();
                int n3 = iConfigurationElementArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    IConfigurationElement element = iConfigurationElementArray[n4];
                    String sectionPageId = element.getAttribute("pageId");
                    if (this.pageId.equals(sectionPageId)) {
                        this.elments.add(element);
                    }
                    ++n4;
                }
                ++n2;
            }
        }
        return this.createSectionControlAsIndex(parent);
    }

    private Composite createSectionControlAsIndex(Composite parent) {
        Collections.sort(this.elments, new IndexComparator());
        Composite container = new Composite(parent, 0);
        GridLayoutFactory.fillDefaults().applyTo(container);
        for (IConfigurationElement element : this.elments) {
            this.createSectionControl(container, element);
        }
        return container;
    }

    private void createSectionControl(Composite parent, IConfigurationElement element) {
        Object prefPage;
        String labelName = element.getAttribute("label");
        if (labelName != null && !"".equals(labelName)) {
            Label label = new Label(parent, 0);
            label.setText(labelName);
            this.configLabelFont(label);
        }
        Composite sectionContent = new Composite(parent, 0);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)sectionContent);
        GridLayoutFactory.fillDefaults().extendedMargins(0, 0, 0, 15).applyTo(sectionContent);
        try {
            prefPage = element.createExecutableExtension("class");
        }
        catch (CoreException e) {
            e.printStackTrace();
            return;
        }
        if (!(prefPage instanceof IWorkbenchPreferencePage)) {
            return;
        }
        if (!(prefPage instanceof IPreferenceSection)) {
            return;
        }
        this.pageSections.add((IPreferenceSection)prefPage);
        ((IWorkbenchPreferencePage)prefPage).init(PlatformUI.getWorkbench());
        ((IWorkbenchPreferencePage)prefPage).createControl(sectionContent);
    }

    private void configLabelFont(Label label) {
        LocalResourceManager resource = new LocalResourceManager(JFaceResources.getResources(), (Control)label);
        FontData[] fontData = Display.getDefault().getSystemFont().getFontData();
        label.setFont((Font)resource.get((DeviceResourceDescriptor)FontDescriptor.createFrom((FontData[])FontUtils.bold(fontData, true))));
    }

    public void setInitializationData(IConfigurationElement config, String propertyName, Object data) throws CoreException {
        this.pageId = config.getAttribute("id");
    }

    public void init(IWorkbench workbench) {
    }

    public boolean performCancel() {
        if (this.pageSections != null && this.pageSections.size() > 0) {
            for (IPreferenceSection pageSection : this.pageSections) {
                if (pageSection.cancel()) continue;
                return false;
            }
        }
        return true;
    }

    protected void performApply() {
        this.performOk();
    }

    protected void performDefaults() {
        super.performDefaults();
        if (this.pageSections != null && this.pageSections.size() > 0) {
            for (IPreferenceSection pageSection : this.pageSections) {
                pageSection.excuteDefault();
            }
        }
    }

    public boolean performOk() {
        if (this.pageSections != null && this.pageSections.size() > 0) {
            for (IPreferenceSection pageSection : this.pageSections) {
                if (pageSection.ok()) continue;
                return false;
            }
        }
        return true;
    }

    private class IndexComparator
    implements Comparator {
        private IndexComparator() {
        }

        public int compare(Object o1, Object o2) {
            IConfigurationElement element1 = (IConfigurationElement)o1;
            IConfigurationElement element2 = (IConfigurationElement)o2;
            String indexString1 = element1.getAttribute("index");
            String indexString2 = element2.getAttribute("index");
            int index1 = Integer.MAX_VALUE;
            int index2 = Integer.MAX_VALUE;
            if (indexString1 != null && !"".equals(indexString1)) {
                index1 = Integer.parseInt(indexString1);
            }
            if (indexString2 != null && !"".equals(indexString2)) {
                index2 = Integer.parseInt(indexString2);
            }
            return new Integer(index1).compareTo(new Integer(index2));
        }
    }
}

