/*
 * Decompiled with CFR 0.152.
 */
package com.thoughtworks.xstream.core;

import com.thoughtworks.xstream.converters.ConversionException;
import com.thoughtworks.xstream.converters.Converter;
import com.thoughtworks.xstream.converters.ConverterLookup;
import com.thoughtworks.xstream.converters.ConverterRegistry;
import com.thoughtworks.xstream.core.Caching;
import com.thoughtworks.xstream.core.util.PrioritizedList;
import com.thoughtworks.xstream.mapper.Mapper;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.WeakHashMap;

public class DefaultConverterLookup
implements ConverterLookup,
ConverterRegistry,
Caching {
    private final PrioritizedList converters = new PrioritizedList();
    private transient Map typeToConverterMap;

    public DefaultConverterLookup() {
        this.readResolve();
    }

    public DefaultConverterLookup(Mapper mapper) {
    }

    public Converter lookupConverterForType(Class type) {
        Converter cachedConverter = (Converter)this.typeToConverterMap.get(type);
        if (cachedConverter != null) {
            return cachedConverter;
        }
        LinkedHashMap<String, String> errors = new LinkedHashMap<String, String>();
        Iterator iterator = this.converters.iterator();
        while (iterator.hasNext()) {
            Converter converter = (Converter)iterator.next();
            try {
                if (!converter.canConvert(type)) continue;
                this.typeToConverterMap.put(type, converter);
                return converter;
            }
            catch (RuntimeException e) {
                errors.put(converter.getClass().getName(), e.getMessage());
            }
            catch (LinkageError e) {
                errors.put(converter.getClass().getName(), e.getMessage());
            }
        }
        ConversionException exception = new ConversionException(errors.isEmpty() ? "No converter specified" : "No converter available");
        exception.add("type", type.getName());
        for (Map.Entry entry : errors.entrySet()) {
            exception.add("converter", entry.getKey().toString());
            exception.add("message", entry.getValue().toString());
        }
        throw exception;
    }

    public void registerConverter(Converter converter, int priority) {
        this.converters.add(converter, priority);
        Iterator iter = this.typeToConverterMap.keySet().iterator();
        while (iter.hasNext()) {
            Class type = (Class)iter.next();
            try {
                if (!converter.canConvert(type)) continue;
                iter.remove();
            }
            catch (RuntimeException runtimeException) {
            }
            catch (LinkageError linkageError) {}
        }
    }

    public void flushCache() {
        this.typeToConverterMap.clear();
        Iterator iterator = this.converters.iterator();
        while (iterator.hasNext()) {
            Converter converter = (Converter)iterator.next();
            if (!(converter instanceof Caching)) continue;
            ((Caching)((Object)converter)).flushCache();
        }
    }

    private Object readResolve() {
        this.typeToConverterMap = Collections.synchronizedMap(new WeakHashMap());
        return this;
    }
}

