#include "webmon.h"
#include <stdio.h>
#include <string.h>
#include <sys/socket.h>
#include <sys/types.h>
#include <netdb.h>
#include <openssl/md5.h>
#include <pthread.h>

#define HTTPHEADERS "Connection: close\r\nAccept: text/*, image/jpeg, image/png, image/*, */*\r\nUser-Agent: Mozilla/5.0 (compatible; MSIE 6.0; Beware the Krell) GKWebmon "

void clear_entry(int i)
{
  
  if (wi[i].urlData) {
    free(wi[i].urlData);
    wi[i].urlData = NULL;
  }
  wi[i].use       = 0;	/* mark as unused */
  wi[i].updated   = 0;
  wi[i].flagged   = 0;
  wi[i].server    = NULL;
  wi[i].port      = 80;	/* 80 as default port */
  wi[i].user      = NULL;
  wi[i].password  = NULL;
  wi[i].page      = NULL;
  memset(wi[i].init_md5, 0, 33);
  memset(wi[i].new_md5, 0, 33);
}

static const char base64_chars[] =
"ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/=";

static size_t base64Encode(unsigned char *dest, size_t srclen, const char *src)
{
  size_t outlen;
  unsigned int   istate, val = 0;

  /* Loop converting each 3 input bytes into 4 output characters.	*/
  for (outlen = 0, istate = 0; srclen; srclen--) {
    switch (istate) {			
    case 0:				/* 1st of 3			*/
      *dest++ = base64_chars[*src >> 2];
      outlen++;
      val = (*src++ & 3) << 4;
      break;
    case 1:				/* 2nd of 3			*/
      *dest++ = base64_chars[val | (*src >> 4)];
      outlen++;
      val = (*src++ & 15) << 2;
      break;
    case 2:				/* 3rd of 3			*/
      *dest++ = base64_chars[val | (*src >> 6)];
      outlen++;
      *dest++ = base64_chars[*src++ & 63];
      outlen++;
      break;
    }
    istate = ((istate + 1) % 3);
  }

  /* Fixup remaining output if didn't have a multiple of 3 bytes.	*/  
  if (istate == 1){			/* Had final 8 bits		*/
    *dest++ = base64_chars[val];
    *dest++ = '=';
    *dest++ = '=';
    outlen += 3;
  }
  else if (istate == 2)	{		/* Had final 16 bits		*/
    *dest++ = base64_chars[val];
    *dest++ = '=';
    outlen += 2;
  }
  *dest = '\0';
  return (outlen);
}

void parse_url_to_config_struct(int i, gchar * instr)
{
  char *p, *q, *r;

#ifdef DEBUG
  fprintf(stderr, "parse_url %d = %s\n", i, instr);
#endif

  /* URL format: protocol://username:password@host:port/path */

  clear_entry(i);

  if ((strncmp(instr, "http://", 7))) {
    /* since this is a webmonitor we will only support HTTP */
    return;
  }

  wi[i].use = 1;		/* mark as inuse */
  wi[i].urlData = strdup(instr);

  p = strstr(wi[i].urlData, "//"); /* must be there */
  p += 2;

  if ((q = strchr(p, '/'))) { /* is there a path? */
    *q++ = '\0';
    wi[i].page = q;
  } else {
    wi[i].page = "";
  }
  if ((q = strrchr(p, '@'))) { /* user [and password] ? */
    *q = '\0';
    if ((r = strchr(p, ':'))) { /* password present? */
      *r++ = '\0';
      wi[i].password = r;
    }
    wi[i].user = p;
    p = q+1;
  }

  if ((q = strchr(p, ':'))) {
    *q++ = '\0';
    wi[i].port = atoi(q);	/* the number r is pointing on to wi.port */
  }
  wi[i].server = p;
}

char *addToString(char *s, char *n)
{
  s = realloc(s, strlen(s) + strlen(n) + 1);
  return strcat(s, n);
}
/* return malloc'd url string for given config entry */
char *make_url_from_config_struct(int i)
{
  char *url = malloc(1);
  url[0] = '\0';
  url = addToString(url, "http://");
  if (wi[i].user && wi[i].user[0]) {
    url = addToString(url, wi[i].user);
    if (wi[i].password && wi[i].password[0]) {
      url = addToString(url, ":");
      url = addToString(url, wi[i].password);
    }
    url = addToString(url, "@");
  }
  url = addToString(url, wi[i].server);
  if (wi[i].port != 80) {
    char p[20];
    url = addToString(url, ":");
    sprintf(p, "%d", wi[i].port);
    url = addToString(url, p);
  }
  if (!(wi[i].page[0] == '/'))
    url = addToString(url, "/");
  url = addToString(url, wi[i].page);
#ifdef DEBUG
  fprintf(stderr, "url %d is %s\n", i, url);
#endif

  return url;
}

void set_config_default(void)
{
  int i;

  updatetime = 24;		/* update every 24 hours (default) */

  for (i = 0; i < 20; i++) {
    clear_entry(i);
  }
}

void *get_page_and_send_data_to_md5_check(void *arg)
{
  struct sockaddr_in sin;
  struct hostent *hent;
  int fd;
  unsigned char *datap, *dp;
  gchar *sendstr;
  char authInfo[100];
  int len;
  char buf[BUFSIZE];
  int num;

  num = (int) arg;

  if ((hent = gethostbyname(wi[num].server)) == NULL) {
    /* we wont do anything with errors right now */
    return NULL;
  }
  
  if ((fd = socket(PF_INET, SOCK_STREAM, IPPROTO_TCP)) == -1) {
    /* we wont do anything with errors right now */
    return NULL;
  }
  sin.sin_family = PF_INET;
  sin.sin_port = htons(wi[num].port);
  sin.sin_addr = *((struct in_addr *) hent->h_addr);
  memset(&(sin.sin_zero), '\0', 8);

  if (connect(fd, (struct sockaddr *) &sin, sizeof(struct sockaddr)) ==  -1) {
    /* we wont do anything with errors right now */
    return NULL;
  }
  memset(authInfo, 0, sizeof(authInfo));
  
  if (wi[num].user && wi[num].password) {
    gchar *upw = g_strdup_printf("%s:%s", wi[num].user, wi[num].password);
    base64Encode(authInfo, strlen(upw), upw);
    free(upw);
  }
  if (*authInfo) {
    sendstr = g_strdup_printf("GET /%s HTTP/1.1\r\nHost: %s\r\n%s%s\r\nAuthorization: BASIC %s\r\n\r\n",
			      wi[num].page, wi[num].server, 
			      HTTPHEADERS, VERSION, authInfo);
  } else {
    sendstr = g_strdup_printf("GET /%s HTTP/1.1\r\nHost: %s\r\n%s%s\r\n\r\n",
			      wi[num].page, wi[num].server,
			      HTTPHEADERS, VERSION);
  }
  datap = dp = (unsigned char *) malloc(MALLOCSIZE);
  /* this is where we will store the data until we check MD5 */
  memset(datap, 0, MALLOCSIZE);	/* null the malloc() area */

  if ((send(fd, sendstr, strlen(sendstr), 0)) == -1) {
#ifdef DEBUG
    fprintf(stderr, "Error sending data\n");
#endif
    return NULL;
  }
  while ((len = recv(fd, buf, BUFSIZE, 0)) > 0) {
    if (len == -1)
      return NULL;
    if (dp - datap + len > MALLOCSIZE - 1)
      break;		/* we cant store more data than MALLOCSIZE */
    memcpy(dp, buf, len);
    dp += len;
  }
  /* now we have stored the data in the malloc() area, data begins at datap */
#ifdef DEBUG
  fprintf(stderr, "REQUEST= '%s'\n",sendstr);
#endif
#ifdef DEBUG
  fprintf(stderr, "DATA=%s\n",datap);
#endif
  get_md5_to_webinfo_element(num, datap);
  free(sendstr);
  free(datap);
  return NULL;
}

void get_md5_to_webinfo_element(int num, const unsigned char *datap)
{
  /* this function will get the MD5 from the data starting at datap */

  MD5_CTX ctx;
  unsigned char digest[16];
  char output[40];
  unsigned char *p;
  int i;

#ifdef DEBUG
  fprintf(stderr, "In get_md5\n");
#endif
  /* the webserver has sent us an header */
  /* get past the header */
  if (!(p = (unsigned char *) strstr((const char *) datap, "\r\n\r\n"))) {
    /* this should never happen, but just in case we will return */
#ifdef DEBUG
    fprintf(stderr, "Error: no data from %s\n", wi[num].server);
#endif
    return;
  }
  p += 4;
  /* the page starts at p */
  MD5_Init(&ctx);
  MD5_Final(digest, &ctx);
  MD5(p, strlen((char *) p), digest);
  for (i = 0; i < 16; i++) {
    sprintf(output + 2 * i, "%.2x", digest[i]);
  }
#ifdef DEBUG
  fprintf(stderr, "MD5 = %s\n", output);
#endif

  /* now we have the MD5sum from the data in output */
  /* If there is no initial MD5 put it there, otherwise into 'new' value */
  if (!(wi[num].init_md5[0])) {
#ifdef DEBUG
    fprintf(stderr, "setting initial MD5 for %d\n", num);
#endif
    strncpy(wi[num].init_md5, output, 32);
    /* we need to mark the config as changed so that gkrellm will save it */
    gkrellm_config_modified();
  } else {
#ifdef DEBUG
    fprintf(stderr, "setting 'new' MD5 for %d\n", num);
#endif
    strncpy(wi[num].new_md5, output, 32);
    wi[num].updated = 1;
  }
}


void start_thread(void *arg)
{
  pthread_t tid;
  int ret;
  pthread_attr_t tattr;
  pthread_attr_setdetachstate(&tattr, PTHREAD_CREATE_DETACHED);
  ret = pthread_create(&tid, NULL, get_page_and_send_data_to_md5_check, arg);
  return;
}

