// Copyright 2023 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/storageinsights/v1/storageinsights.proto

#include "google/cloud/storageinsights/v1/storage_insights_client.h"
#include <memory>

namespace google {
namespace cloud {
namespace storageinsights_v1 {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

StorageInsightsClient::StorageInsightsClient(
    std::shared_ptr<StorageInsightsConnection> connection, Options opts)
    : connection_(std::move(connection)),
      options_(
          internal::MergeOptions(std::move(opts), connection_->options())) {}
StorageInsightsClient::~StorageInsightsClient() = default;

StreamRange<google::cloud::storageinsights::v1::ReportConfig>
StorageInsightsClient::ListReportConfigs(std::string const& parent,
                                         Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::storageinsights::v1::ListReportConfigsRequest request;
  request.set_parent(parent);
  return connection_->ListReportConfigs(request);
}

StreamRange<google::cloud::storageinsights::v1::ReportConfig>
StorageInsightsClient::ListReportConfigs(
    google::cloud::storageinsights::v1::ListReportConfigsRequest request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->ListReportConfigs(std::move(request));
}

StatusOr<google::cloud::storageinsights::v1::ReportConfig>
StorageInsightsClient::GetReportConfig(std::string const& name, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::storageinsights::v1::GetReportConfigRequest request;
  request.set_name(name);
  return connection_->GetReportConfig(request);
}

StatusOr<google::cloud::storageinsights::v1::ReportConfig>
StorageInsightsClient::GetReportConfig(
    google::cloud::storageinsights::v1::GetReportConfigRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->GetReportConfig(request);
}

StatusOr<google::cloud::storageinsights::v1::ReportConfig>
StorageInsightsClient::CreateReportConfig(
    std::string const& parent,
    google::cloud::storageinsights::v1::ReportConfig const& report_config,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::storageinsights::v1::CreateReportConfigRequest request;
  request.set_parent(parent);
  *request.mutable_report_config() = report_config;
  return connection_->CreateReportConfig(request);
}

StatusOr<google::cloud::storageinsights::v1::ReportConfig>
StorageInsightsClient::CreateReportConfig(
    google::cloud::storageinsights::v1::CreateReportConfigRequest const&
        request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->CreateReportConfig(request);
}

StatusOr<google::cloud::storageinsights::v1::ReportConfig>
StorageInsightsClient::UpdateReportConfig(
    google::cloud::storageinsights::v1::ReportConfig const& report_config,
    google::protobuf::FieldMask const& update_mask, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::storageinsights::v1::UpdateReportConfigRequest request;
  *request.mutable_report_config() = report_config;
  *request.mutable_update_mask() = update_mask;
  return connection_->UpdateReportConfig(request);
}

StatusOr<google::cloud::storageinsights::v1::ReportConfig>
StorageInsightsClient::UpdateReportConfig(
    google::cloud::storageinsights::v1::UpdateReportConfigRequest const&
        request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->UpdateReportConfig(request);
}

Status StorageInsightsClient::DeleteReportConfig(std::string const& name,
                                                 Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::storageinsights::v1::DeleteReportConfigRequest request;
  request.set_name(name);
  return connection_->DeleteReportConfig(request);
}

Status StorageInsightsClient::DeleteReportConfig(
    google::cloud::storageinsights::v1::DeleteReportConfigRequest const&
        request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->DeleteReportConfig(request);
}

StreamRange<google::cloud::storageinsights::v1::ReportDetail>
StorageInsightsClient::ListReportDetails(std::string const& parent,
                                         Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::storageinsights::v1::ListReportDetailsRequest request;
  request.set_parent(parent);
  return connection_->ListReportDetails(request);
}

StreamRange<google::cloud::storageinsights::v1::ReportDetail>
StorageInsightsClient::ListReportDetails(
    google::cloud::storageinsights::v1::ListReportDetailsRequest request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->ListReportDetails(std::move(request));
}

StatusOr<google::cloud::storageinsights::v1::ReportDetail>
StorageInsightsClient::GetReportDetail(std::string const& name, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::storageinsights::v1::GetReportDetailRequest request;
  request.set_name(name);
  return connection_->GetReportDetail(request);
}

StatusOr<google::cloud::storageinsights::v1::ReportDetail>
StorageInsightsClient::GetReportDetail(
    google::cloud::storageinsights::v1::GetReportDetailRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->GetReportDetail(request);
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace storageinsights_v1
}  // namespace cloud
}  // namespace google
