// Copyright 2023 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/run/v2/job.proto

#include "google/cloud/run/v2/jobs_connection.h"
#include "google/cloud/run/v2/internal/jobs_connection_impl.h"
#include "google/cloud/run/v2/internal/jobs_option_defaults.h"
#include "google/cloud/run/v2/internal/jobs_stub_factory.h"
#include "google/cloud/run/v2/internal/jobs_tracing_connection.h"
#include "google/cloud/run/v2/jobs_options.h"
#include "google/cloud/background_threads.h"
#include "google/cloud/common_options.h"
#include "google/cloud/credentials.h"
#include "google/cloud/grpc_options.h"
#include "google/cloud/internal/pagination_range.h"
#include <memory>

namespace google {
namespace cloud {
namespace run_v2 {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

JobsConnection::~JobsConnection() = default;

future<StatusOr<google::cloud::run::v2::Job>> JobsConnection::CreateJob(
    google::cloud::run::v2::CreateJobRequest const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::run::v2::Job>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

StatusOr<google::cloud::run::v2::Job> JobsConnection::GetJob(
    google::cloud::run::v2::GetJobRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

StreamRange<google::cloud::run::v2::Job> JobsConnection::ListJobs(
    google::cloud::run::v2::
        ListJobsRequest) {  // NOLINT(performance-unnecessary-value-param)
  return google::cloud::internal::MakeUnimplementedPaginationRange<
      StreamRange<google::cloud::run::v2::Job>>();
}

future<StatusOr<google::cloud::run::v2::Job>> JobsConnection::UpdateJob(
    google::cloud::run::v2::UpdateJobRequest const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::run::v2::Job>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

future<StatusOr<google::cloud::run::v2::Job>> JobsConnection::DeleteJob(
    google::cloud::run::v2::DeleteJobRequest const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::run::v2::Job>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

future<StatusOr<google::cloud::run::v2::Execution>> JobsConnection::RunJob(
    google::cloud::run::v2::RunJobRequest const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::run::v2::Execution>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

StatusOr<google::iam::v1::Policy> JobsConnection::GetIamPolicy(
    google::iam::v1::GetIamPolicyRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

StatusOr<google::iam::v1::Policy> JobsConnection::SetIamPolicy(
    google::iam::v1::SetIamPolicyRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

StatusOr<google::iam::v1::TestIamPermissionsResponse>
JobsConnection::TestIamPermissions(
    google::iam::v1::TestIamPermissionsRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

std::shared_ptr<JobsConnection> MakeJobsConnection(Options options) {
  internal::CheckExpectedOptions<CommonOptionList, GrpcOptionList,
                                 UnifiedCredentialsOptionList,
                                 JobsPolicyOptionList>(options, __func__);
  options = run_v2_internal::JobsDefaultOptions(std::move(options));
  auto background = internal::MakeBackgroundThreadsFactory(options)();
  auto stub = run_v2_internal::CreateDefaultJobsStub(background->cq(), options);
  return run_v2_internal::MakeJobsTracingConnection(
      std::make_shared<run_v2_internal::JobsConnectionImpl>(
          std::move(background), std::move(stub), std::move(options)));
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace run_v2
}  // namespace cloud
}  // namespace google
