// Copyright 2023 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/recaptchaenterprise/v1/recaptchaenterprise.proto

#ifndef GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_RECAPTCHAENTERPRISE_V1_RECAPTCHA_ENTERPRISE_CONNECTION_H
#define GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_RECAPTCHAENTERPRISE_V1_RECAPTCHA_ENTERPRISE_CONNECTION_H

#include "google/cloud/recaptchaenterprise/v1/internal/recaptcha_enterprise_retry_traits.h"
#include "google/cloud/recaptchaenterprise/v1/recaptcha_enterprise_connection_idempotency_policy.h"
#include "google/cloud/backoff_policy.h"
#include "google/cloud/internal/retry_policy_impl.h"
#include "google/cloud/options.h"
#include "google/cloud/status_or.h"
#include "google/cloud/stream_range.h"
#include "google/cloud/version.h"
#include <google/cloud/recaptchaenterprise/v1/recaptchaenterprise.pb.h>
#include <memory>

namespace google {
namespace cloud {
namespace recaptchaenterprise_v1 {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

/// The retry policy for `RecaptchaEnterpriseServiceConnection`.
class RecaptchaEnterpriseServiceRetryPolicy
    : public ::google::cloud::RetryPolicy {
 public:
  /// Creates a new instance of the policy, reset to the initial state.
  virtual std::unique_ptr<RecaptchaEnterpriseServiceRetryPolicy> clone()
      const = 0;
};

/**
 * A retry policy for `RecaptchaEnterpriseServiceConnection` based on counting
 * errors.
 *
 * This policy stops retrying if:
 * - An RPC returns a non-transient error.
 * - More than a prescribed number of transient failures is detected.
 *
 * In this class the following status codes are treated as transient errors:
 * - [`kUnavailable`](@ref google::cloud::StatusCode)
 */
class RecaptchaEnterpriseServiceLimitedErrorCountRetryPolicy
    : public RecaptchaEnterpriseServiceRetryPolicy {
 public:
  /**
   * Create an instance that tolerates up to @p maximum_failures transient
   * errors.
   *
   * @note Disable the retry loop by providing an instance of this policy with
   *     @p maximum_failures == 0.
   */
  explicit RecaptchaEnterpriseServiceLimitedErrorCountRetryPolicy(
      int maximum_failures)
      : impl_(maximum_failures) {}

  RecaptchaEnterpriseServiceLimitedErrorCountRetryPolicy(
      RecaptchaEnterpriseServiceLimitedErrorCountRetryPolicy&& rhs) noexcept
      : RecaptchaEnterpriseServiceLimitedErrorCountRetryPolicy(
            rhs.maximum_failures()) {}
  RecaptchaEnterpriseServiceLimitedErrorCountRetryPolicy(
      RecaptchaEnterpriseServiceLimitedErrorCountRetryPolicy const&
          rhs) noexcept
      : RecaptchaEnterpriseServiceLimitedErrorCountRetryPolicy(
            rhs.maximum_failures()) {}

  int maximum_failures() const { return impl_.maximum_failures(); }

  bool OnFailure(Status const& status) override {
    return impl_.OnFailure(status);
  }
  bool IsExhausted() const override { return impl_.IsExhausted(); }
  bool IsPermanentFailure(Status const& status) const override {
    return impl_.IsPermanentFailure(status);
  }
  std::unique_ptr<RecaptchaEnterpriseServiceRetryPolicy> clone()
      const override {
    return std::make_unique<
        RecaptchaEnterpriseServiceLimitedErrorCountRetryPolicy>(
        maximum_failures());
  }

  // This is provided only for backwards compatibility.
  using BaseType = RecaptchaEnterpriseServiceRetryPolicy;

 private:
  google::cloud::internal::LimitedErrorCountRetryPolicy<
      recaptchaenterprise_v1_internal::RecaptchaEnterpriseServiceRetryTraits>
      impl_;
};

/**
 * A retry policy for `RecaptchaEnterpriseServiceConnection` based on elapsed
 * time.
 *
 * This policy stops retrying if:
 * - An RPC returns a non-transient error.
 * - The elapsed time in the retry loop exceeds a prescribed duration.
 *
 * In this class the following status codes are treated as transient errors:
 * - [`kUnavailable`](@ref google::cloud::StatusCode)
 */
class RecaptchaEnterpriseServiceLimitedTimeRetryPolicy
    : public RecaptchaEnterpriseServiceRetryPolicy {
 public:
  /**
   * Constructor given a `std::chrono::duration<>` object.
   *
   * @tparam DurationRep a placeholder to match the `Rep` tparam for @p
   *     duration's type. The semantics of this template parameter are
   *     documented in `std::chrono::duration<>`. In brief, the underlying
   *     arithmetic type used to store the number of ticks. For our purposes it
   *     is simply a formal parameter.
   * @tparam DurationPeriod a placeholder to match the `Period` tparam for @p
   *     duration's type. The semantics of this template parameter are
   *     documented in `std::chrono::duration<>`. In brief, the length of the
   *     tick in seconds, expressed as a `std::ratio<>`. For our purposes it is
   *     simply a formal parameter.
   * @param maximum_duration the maximum time allowed before the policy expires.
   *     While the application can express this time in any units they desire,
   *     the class truncates to milliseconds.
   *
   * @see https://en.cppreference.com/w/cpp/chrono/duration for more information
   *     about `std::chrono::duration`.
   */
  template <typename DurationRep, typename DurationPeriod>
  explicit RecaptchaEnterpriseServiceLimitedTimeRetryPolicy(
      std::chrono::duration<DurationRep, DurationPeriod> maximum_duration)
      : impl_(maximum_duration) {}

  RecaptchaEnterpriseServiceLimitedTimeRetryPolicy(
      RecaptchaEnterpriseServiceLimitedTimeRetryPolicy&& rhs) noexcept
      : RecaptchaEnterpriseServiceLimitedTimeRetryPolicy(
            rhs.maximum_duration()) {}
  RecaptchaEnterpriseServiceLimitedTimeRetryPolicy(
      RecaptchaEnterpriseServiceLimitedTimeRetryPolicy const& rhs) noexcept
      : RecaptchaEnterpriseServiceLimitedTimeRetryPolicy(
            rhs.maximum_duration()) {}

  std::chrono::milliseconds maximum_duration() const {
    return impl_.maximum_duration();
  }

  bool OnFailure(Status const& status) override {
    return impl_.OnFailure(status);
  }
  bool IsExhausted() const override { return impl_.IsExhausted(); }
  bool IsPermanentFailure(Status const& status) const override {
    return impl_.IsPermanentFailure(status);
  }
  std::unique_ptr<RecaptchaEnterpriseServiceRetryPolicy> clone()
      const override {
    return std::make_unique<RecaptchaEnterpriseServiceLimitedTimeRetryPolicy>(
        maximum_duration());
  }

  // This is provided only for backwards compatibility.
  using BaseType = RecaptchaEnterpriseServiceRetryPolicy;

 private:
  google::cloud::internal::LimitedTimeRetryPolicy<
      recaptchaenterprise_v1_internal::RecaptchaEnterpriseServiceRetryTraits>
      impl_;
};

/**
 * The `RecaptchaEnterpriseServiceConnection` object for
 * `RecaptchaEnterpriseServiceClient`.
 *
 * This interface defines virtual methods for each of the user-facing overload
 * sets in `RecaptchaEnterpriseServiceClient`. This allows users to inject
 * custom behavior (e.g., with a Google Mock object) when writing tests that use
 * objects of type `RecaptchaEnterpriseServiceClient`.
 *
 * To create a concrete instance, see
 * `MakeRecaptchaEnterpriseServiceConnection()`.
 *
 * For mocking, see
 * `recaptchaenterprise_v1_mocks::MockRecaptchaEnterpriseServiceConnection`.
 */
class RecaptchaEnterpriseServiceConnection {
 public:
  virtual ~RecaptchaEnterpriseServiceConnection() = 0;

  virtual Options options() { return Options{}; }

  virtual StatusOr<google::cloud::recaptchaenterprise::v1::Assessment>
  CreateAssessment(
      google::cloud::recaptchaenterprise::v1::CreateAssessmentRequest const&
          request);

  virtual StatusOr<
      google::cloud::recaptchaenterprise::v1::AnnotateAssessmentResponse>
  AnnotateAssessment(
      google::cloud::recaptchaenterprise::v1::AnnotateAssessmentRequest const&
          request);

  virtual StatusOr<google::cloud::recaptchaenterprise::v1::Key> CreateKey(
      google::cloud::recaptchaenterprise::v1::CreateKeyRequest const& request);

  virtual StreamRange<google::cloud::recaptchaenterprise::v1::Key> ListKeys(
      google::cloud::recaptchaenterprise::v1::ListKeysRequest request);

  virtual StatusOr<
      google::cloud::recaptchaenterprise::v1::RetrieveLegacySecretKeyResponse>
  RetrieveLegacySecretKey(google::cloud::recaptchaenterprise::v1::
                              RetrieveLegacySecretKeyRequest const& request);

  virtual StatusOr<google::cloud::recaptchaenterprise::v1::Key> GetKey(
      google::cloud::recaptchaenterprise::v1::GetKeyRequest const& request);

  virtual StatusOr<google::cloud::recaptchaenterprise::v1::Key> UpdateKey(
      google::cloud::recaptchaenterprise::v1::UpdateKeyRequest const& request);

  virtual Status DeleteKey(
      google::cloud::recaptchaenterprise::v1::DeleteKeyRequest const& request);

  virtual StatusOr<google::cloud::recaptchaenterprise::v1::Key> MigrateKey(
      google::cloud::recaptchaenterprise::v1::MigrateKeyRequest const& request);

  virtual StatusOr<google::cloud::recaptchaenterprise::v1::Metrics> GetMetrics(
      google::cloud::recaptchaenterprise::v1::GetMetricsRequest const& request);

  virtual StatusOr<google::cloud::recaptchaenterprise::v1::FirewallPolicy>
  CreateFirewallPolicy(
      google::cloud::recaptchaenterprise::v1::CreateFirewallPolicyRequest const&
          request);

  virtual StreamRange<google::cloud::recaptchaenterprise::v1::FirewallPolicy>
  ListFirewallPolicies(
      google::cloud::recaptchaenterprise::v1::ListFirewallPoliciesRequest
          request);

  virtual StatusOr<google::cloud::recaptchaenterprise::v1::FirewallPolicy>
  GetFirewallPolicy(
      google::cloud::recaptchaenterprise::v1::GetFirewallPolicyRequest const&
          request);

  virtual StatusOr<google::cloud::recaptchaenterprise::v1::FirewallPolicy>
  UpdateFirewallPolicy(
      google::cloud::recaptchaenterprise::v1::UpdateFirewallPolicyRequest const&
          request);

  virtual Status DeleteFirewallPolicy(
      google::cloud::recaptchaenterprise::v1::DeleteFirewallPolicyRequest const&
          request);

  virtual StreamRange<
      google::cloud::recaptchaenterprise::v1::RelatedAccountGroup>
  ListRelatedAccountGroups(
      google::cloud::recaptchaenterprise::v1::ListRelatedAccountGroupsRequest
          request);

  virtual StreamRange<
      google::cloud::recaptchaenterprise::v1::RelatedAccountGroupMembership>
  ListRelatedAccountGroupMemberships(
      google::cloud::recaptchaenterprise::v1::
          ListRelatedAccountGroupMembershipsRequest request);

  virtual StreamRange<
      google::cloud::recaptchaenterprise::v1::RelatedAccountGroupMembership>
  SearchRelatedAccountGroupMemberships(
      google::cloud::recaptchaenterprise::v1::
          SearchRelatedAccountGroupMembershipsRequest request);
};

/**
 * A factory function to construct an object of type
 * `RecaptchaEnterpriseServiceConnection`.
 *
 * The returned connection object should not be used directly; instead it
 * should be passed as an argument to the constructor of
 * RecaptchaEnterpriseServiceClient.
 *
 * The optional @p options argument may be used to configure aspects of the
 * returned `RecaptchaEnterpriseServiceConnection`. Expected options are any of
 * the types in the following option lists:
 *
 * - `google::cloud::CommonOptionList`
 * - `google::cloud::GrpcOptionList`
 * - `google::cloud::UnifiedCredentialsOptionList`
 * -
 * `google::cloud::recaptchaenterprise_v1::RecaptchaEnterpriseServicePolicyOptionList`
 *
 * @note Unexpected options will be ignored. To log unexpected options instead,
 *     set `GOOGLE_CLOUD_CPP_ENABLE_CLOG=yes` in the environment.
 *
 * @param options (optional) Configure the
 * `RecaptchaEnterpriseServiceConnection` created by this function.
 */
std::shared_ptr<RecaptchaEnterpriseServiceConnection>
MakeRecaptchaEnterpriseServiceConnection(Options options = {});

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace recaptchaenterprise_v1
}  // namespace cloud
}  // namespace google

#endif  // GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_RECAPTCHAENTERPRISE_V1_RECAPTCHA_ENTERPRISE_CONNECTION_H
