// Copyright 2023 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/osconfig/v1/osconfig_zonal_service.proto

#include "google/cloud/osconfig/v1/os_config_zonal_connection_idempotency_policy.h"
#include <memory>

namespace google {
namespace cloud {
namespace osconfig_v1 {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

using ::google::cloud::Idempotency;

OsConfigZonalServiceConnectionIdempotencyPolicy::
    ~OsConfigZonalServiceConnectionIdempotencyPolicy() = default;

std::unique_ptr<OsConfigZonalServiceConnectionIdempotencyPolicy>
OsConfigZonalServiceConnectionIdempotencyPolicy::clone() const {
  return std::make_unique<OsConfigZonalServiceConnectionIdempotencyPolicy>(
      *this);
}

Idempotency
OsConfigZonalServiceConnectionIdempotencyPolicy::CreateOSPolicyAssignment(
    google::cloud::osconfig::v1::CreateOSPolicyAssignmentRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency
OsConfigZonalServiceConnectionIdempotencyPolicy::UpdateOSPolicyAssignment(
    google::cloud::osconfig::v1::UpdateOSPolicyAssignmentRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency
OsConfigZonalServiceConnectionIdempotencyPolicy::GetOSPolicyAssignment(
    google::cloud::osconfig::v1::GetOSPolicyAssignmentRequest const&) {
  return Idempotency::kIdempotent;
}

Idempotency
OsConfigZonalServiceConnectionIdempotencyPolicy::ListOSPolicyAssignments(
    google::cloud::osconfig::v1::ListOSPolicyAssignmentsRequest) {  // NOLINT
  return Idempotency::kIdempotent;
}

Idempotency OsConfigZonalServiceConnectionIdempotencyPolicy::
    ListOSPolicyAssignmentRevisions(
        google::cloud::osconfig::v1::
            ListOSPolicyAssignmentRevisionsRequest) {  // NOLINT
  return Idempotency::kIdempotent;
}

Idempotency
OsConfigZonalServiceConnectionIdempotencyPolicy::DeleteOSPolicyAssignment(
    google::cloud::osconfig::v1::DeleteOSPolicyAssignmentRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency
OsConfigZonalServiceConnectionIdempotencyPolicy::GetOSPolicyAssignmentReport(
    google::cloud::osconfig::v1::GetOSPolicyAssignmentReportRequest const&) {
  return Idempotency::kIdempotent;
}

Idempotency
OsConfigZonalServiceConnectionIdempotencyPolicy::ListOSPolicyAssignmentReports(
    google::cloud::osconfig::v1::
        ListOSPolicyAssignmentReportsRequest) {  // NOLINT
  return Idempotency::kIdempotent;
}

Idempotency OsConfigZonalServiceConnectionIdempotencyPolicy::GetInventory(
    google::cloud::osconfig::v1::GetInventoryRequest const&) {
  return Idempotency::kIdempotent;
}

Idempotency OsConfigZonalServiceConnectionIdempotencyPolicy::ListInventories(
    google::cloud::osconfig::v1::ListInventoriesRequest) {  // NOLINT
  return Idempotency::kIdempotent;
}

Idempotency
OsConfigZonalServiceConnectionIdempotencyPolicy::GetVulnerabilityReport(
    google::cloud::osconfig::v1::GetVulnerabilityReportRequest const&) {
  return Idempotency::kIdempotent;
}

Idempotency
OsConfigZonalServiceConnectionIdempotencyPolicy::ListVulnerabilityReports(
    google::cloud::osconfig::v1::ListVulnerabilityReportsRequest) {  // NOLINT
  return Idempotency::kIdempotent;
}

std::unique_ptr<OsConfigZonalServiceConnectionIdempotencyPolicy>
MakeDefaultOsConfigZonalServiceConnectionIdempotencyPolicy() {
  return std::make_unique<OsConfigZonalServiceConnectionIdempotencyPolicy>();
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace osconfig_v1
}  // namespace cloud
}  // namespace google
