// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/orgpolicy/v2/orgpolicy.proto

#include "google/cloud/orgpolicy/v2/internal/org_policy_tracing_connection.h"
#include "google/cloud/internal/opentelemetry.h"
#include "google/cloud/internal/traced_stream_range.h"
#include <memory>

namespace google {
namespace cloud {
namespace orgpolicy_v2_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

#ifdef GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY

OrgPolicyTracingConnection::OrgPolicyTracingConnection(
    std::shared_ptr<orgpolicy_v2::OrgPolicyConnection> child)
    : child_(std::move(child)) {}

StreamRange<google::cloud::orgpolicy::v2::Constraint>
OrgPolicyTracingConnection::ListConstraints(
    google::cloud::orgpolicy::v2::ListConstraintsRequest request) {
  auto span =
      internal::MakeSpan("orgpolicy_v2::OrgPolicyConnection::ListConstraints");
  internal::OTelScope scope(span);
  auto sr = child_->ListConstraints(std::move(request));
  return internal::MakeTracedStreamRange<
      google::cloud::orgpolicy::v2::Constraint>(std::move(span), std::move(sr));
}

StreamRange<google::cloud::orgpolicy::v2::Policy>
OrgPolicyTracingConnection::ListPolicies(
    google::cloud::orgpolicy::v2::ListPoliciesRequest request) {
  auto span =
      internal::MakeSpan("orgpolicy_v2::OrgPolicyConnection::ListPolicies");
  internal::OTelScope scope(span);
  auto sr = child_->ListPolicies(std::move(request));
  return internal::MakeTracedStreamRange<google::cloud::orgpolicy::v2::Policy>(
      std::move(span), std::move(sr));
}

StatusOr<google::cloud::orgpolicy::v2::Policy>
OrgPolicyTracingConnection::GetPolicy(
    google::cloud::orgpolicy::v2::GetPolicyRequest const& request) {
  auto span =
      internal::MakeSpan("orgpolicy_v2::OrgPolicyConnection::GetPolicy");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->GetPolicy(request));
}

StatusOr<google::cloud::orgpolicy::v2::Policy>
OrgPolicyTracingConnection::GetEffectivePolicy(
    google::cloud::orgpolicy::v2::GetEffectivePolicyRequest const& request) {
  auto span = internal::MakeSpan(
      "orgpolicy_v2::OrgPolicyConnection::GetEffectivePolicy");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->GetEffectivePolicy(request));
}

StatusOr<google::cloud::orgpolicy::v2::Policy>
OrgPolicyTracingConnection::CreatePolicy(
    google::cloud::orgpolicy::v2::CreatePolicyRequest const& request) {
  auto span =
      internal::MakeSpan("orgpolicy_v2::OrgPolicyConnection::CreatePolicy");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->CreatePolicy(request));
}

StatusOr<google::cloud::orgpolicy::v2::Policy>
OrgPolicyTracingConnection::UpdatePolicy(
    google::cloud::orgpolicy::v2::UpdatePolicyRequest const& request) {
  auto span =
      internal::MakeSpan("orgpolicy_v2::OrgPolicyConnection::UpdatePolicy");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->UpdatePolicy(request));
}

Status OrgPolicyTracingConnection::DeletePolicy(
    google::cloud::orgpolicy::v2::DeletePolicyRequest const& request) {
  auto span =
      internal::MakeSpan("orgpolicy_v2::OrgPolicyConnection::DeletePolicy");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->DeletePolicy(request));
}

#endif  // GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY

std::shared_ptr<orgpolicy_v2::OrgPolicyConnection>
MakeOrgPolicyTracingConnection(
    std::shared_ptr<orgpolicy_v2::OrgPolicyConnection> conn) {
#ifdef GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY
  if (internal::TracingEnabled(conn->options())) {
    conn = std::make_shared<OrgPolicyTracingConnection>(std::move(conn));
  }
#endif  // GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY
  return conn;
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace orgpolicy_v2_internal
}  // namespace cloud
}  // namespace google
