// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/monitoring/metricsscope/v1/metrics_scopes.proto

#include "google/cloud/monitoring/metricsscope/v1/internal/metrics_scopes_tracing_connection.h"
#include "google/cloud/internal/opentelemetry.h"
#include <memory>

namespace google {
namespace cloud {
namespace monitoring_metricsscope_v1_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

#ifdef GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY

MetricsScopesTracingConnection::MetricsScopesTracingConnection(
    std::shared_ptr<monitoring_metricsscope_v1::MetricsScopesConnection> child)
    : child_(std::move(child)) {}

StatusOr<google::monitoring::metricsscope::v1::MetricsScope>
MetricsScopesTracingConnection::GetMetricsScope(
    google::monitoring::metricsscope::v1::GetMetricsScopeRequest const&
        request) {
  auto span = internal::MakeSpan(
      "monitoring_metricsscope_v1::MetricsScopesConnection::GetMetricsScope");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->GetMetricsScope(request));
}

StatusOr<google::monitoring::metricsscope::v1::
             ListMetricsScopesByMonitoredProjectResponse>
MetricsScopesTracingConnection::ListMetricsScopesByMonitoredProject(
    google::monitoring::metricsscope::v1::
        ListMetricsScopesByMonitoredProjectRequest const& request) {
  auto span = internal::MakeSpan(
      "monitoring_metricsscope_v1::MetricsScopesConnection::"
      "ListMetricsScopesByMonitoredProject");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(
      *span, child_->ListMetricsScopesByMonitoredProject(request));
}

future<StatusOr<google::monitoring::metricsscope::v1::MonitoredProject>>
MetricsScopesTracingConnection::CreateMonitoredProject(
    google::monitoring::metricsscope::v1::CreateMonitoredProjectRequest const&
        request) {
  auto span = internal::MakeSpan(
      "monitoring_metricsscope_v1::MetricsScopesConnection::"
      "CreateMonitoredProject");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span),
                           child_->CreateMonitoredProject(request));
}

future<StatusOr<google::monitoring::metricsscope::v1::OperationMetadata>>
MetricsScopesTracingConnection::DeleteMonitoredProject(
    google::monitoring::metricsscope::v1::DeleteMonitoredProjectRequest const&
        request) {
  auto span = internal::MakeSpan(
      "monitoring_metricsscope_v1::MetricsScopesConnection::"
      "DeleteMonitoredProject");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span),
                           child_->DeleteMonitoredProject(request));
}

#endif  // GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY

std::shared_ptr<monitoring_metricsscope_v1::MetricsScopesConnection>
MakeMetricsScopesTracingConnection(
    std::shared_ptr<monitoring_metricsscope_v1::MetricsScopesConnection> conn) {
#ifdef GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY
  if (internal::TracingEnabled(conn->options())) {
    conn = std::make_shared<MetricsScopesTracingConnection>(std::move(conn));
  }
#endif  // GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY
  return conn;
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace monitoring_metricsscope_v1_internal
}  // namespace cloud
}  // namespace google
