// Copyright 2023 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/logging/v2/logging_metrics.proto

#ifndef GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_LOGGING_V2_METRICS_SERVICE_V2_CONNECTION_H
#define GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_LOGGING_V2_METRICS_SERVICE_V2_CONNECTION_H

#include "google/cloud/logging/v2/internal/metrics_service_v2_retry_traits.h"
#include "google/cloud/logging/v2/metrics_service_v2_connection_idempotency_policy.h"
#include "google/cloud/backoff_policy.h"
#include "google/cloud/internal/retry_policy_impl.h"
#include "google/cloud/options.h"
#include "google/cloud/status_or.h"
#include "google/cloud/stream_range.h"
#include "google/cloud/version.h"
#include <google/logging/v2/logging_metrics.pb.h>
#include <memory>

namespace google {
namespace cloud {
namespace logging_v2 {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

/// The retry policy for `MetricsServiceV2Connection`.
class MetricsServiceV2RetryPolicy : public ::google::cloud::RetryPolicy {
 public:
  /// Creates a new instance of the policy, reset to the initial state.
  virtual std::unique_ptr<MetricsServiceV2RetryPolicy> clone() const = 0;
};

/**
 * A retry policy for `MetricsServiceV2Connection` based on counting errors.
 *
 * This policy stops retrying if:
 * - An RPC returns a non-transient error.
 * - More than a prescribed number of transient failures is detected.
 *
 * In this class the following status codes are treated as transient errors:
 * - [`kUnavailable`](@ref google::cloud::StatusCode)
 */
class MetricsServiceV2LimitedErrorCountRetryPolicy
    : public MetricsServiceV2RetryPolicy {
 public:
  /**
   * Create an instance that tolerates up to @p maximum_failures transient
   * errors.
   *
   * @note Disable the retry loop by providing an instance of this policy with
   *     @p maximum_failures == 0.
   */
  explicit MetricsServiceV2LimitedErrorCountRetryPolicy(int maximum_failures)
      : impl_(maximum_failures) {}

  MetricsServiceV2LimitedErrorCountRetryPolicy(
      MetricsServiceV2LimitedErrorCountRetryPolicy&& rhs) noexcept
      : MetricsServiceV2LimitedErrorCountRetryPolicy(rhs.maximum_failures()) {}
  MetricsServiceV2LimitedErrorCountRetryPolicy(
      MetricsServiceV2LimitedErrorCountRetryPolicy const& rhs) noexcept
      : MetricsServiceV2LimitedErrorCountRetryPolicy(rhs.maximum_failures()) {}

  int maximum_failures() const { return impl_.maximum_failures(); }

  bool OnFailure(Status const& status) override {
    return impl_.OnFailure(status);
  }
  bool IsExhausted() const override { return impl_.IsExhausted(); }
  bool IsPermanentFailure(Status const& status) const override {
    return impl_.IsPermanentFailure(status);
  }
  std::unique_ptr<MetricsServiceV2RetryPolicy> clone() const override {
    return std::make_unique<MetricsServiceV2LimitedErrorCountRetryPolicy>(
        maximum_failures());
  }

  // This is provided only for backwards compatibility.
  using BaseType = MetricsServiceV2RetryPolicy;

 private:
  google::cloud::internal::LimitedErrorCountRetryPolicy<
      logging_v2_internal::MetricsServiceV2RetryTraits>
      impl_;
};

/**
 * A retry policy for `MetricsServiceV2Connection` based on elapsed time.
 *
 * This policy stops retrying if:
 * - An RPC returns a non-transient error.
 * - The elapsed time in the retry loop exceeds a prescribed duration.
 *
 * In this class the following status codes are treated as transient errors:
 * - [`kUnavailable`](@ref google::cloud::StatusCode)
 */
class MetricsServiceV2LimitedTimeRetryPolicy
    : public MetricsServiceV2RetryPolicy {
 public:
  /**
   * Constructor given a `std::chrono::duration<>` object.
   *
   * @tparam DurationRep a placeholder to match the `Rep` tparam for @p
   *     duration's type. The semantics of this template parameter are
   *     documented in `std::chrono::duration<>`. In brief, the underlying
   *     arithmetic type used to store the number of ticks. For our purposes it
   *     is simply a formal parameter.
   * @tparam DurationPeriod a placeholder to match the `Period` tparam for @p
   *     duration's type. The semantics of this template parameter are
   *     documented in `std::chrono::duration<>`. In brief, the length of the
   *     tick in seconds, expressed as a `std::ratio<>`. For our purposes it is
   *     simply a formal parameter.
   * @param maximum_duration the maximum time allowed before the policy expires.
   *     While the application can express this time in any units they desire,
   *     the class truncates to milliseconds.
   *
   * @see https://en.cppreference.com/w/cpp/chrono/duration for more information
   *     about `std::chrono::duration`.
   */
  template <typename DurationRep, typename DurationPeriod>
  explicit MetricsServiceV2LimitedTimeRetryPolicy(
      std::chrono::duration<DurationRep, DurationPeriod> maximum_duration)
      : impl_(maximum_duration) {}

  MetricsServiceV2LimitedTimeRetryPolicy(
      MetricsServiceV2LimitedTimeRetryPolicy&& rhs) noexcept
      : MetricsServiceV2LimitedTimeRetryPolicy(rhs.maximum_duration()) {}
  MetricsServiceV2LimitedTimeRetryPolicy(
      MetricsServiceV2LimitedTimeRetryPolicy const& rhs) noexcept
      : MetricsServiceV2LimitedTimeRetryPolicy(rhs.maximum_duration()) {}

  std::chrono::milliseconds maximum_duration() const {
    return impl_.maximum_duration();
  }

  bool OnFailure(Status const& status) override {
    return impl_.OnFailure(status);
  }
  bool IsExhausted() const override { return impl_.IsExhausted(); }
  bool IsPermanentFailure(Status const& status) const override {
    return impl_.IsPermanentFailure(status);
  }
  std::unique_ptr<MetricsServiceV2RetryPolicy> clone() const override {
    return std::make_unique<MetricsServiceV2LimitedTimeRetryPolicy>(
        maximum_duration());
  }

  // This is provided only for backwards compatibility.
  using BaseType = MetricsServiceV2RetryPolicy;

 private:
  google::cloud::internal::LimitedTimeRetryPolicy<
      logging_v2_internal::MetricsServiceV2RetryTraits>
      impl_;
};

/**
 * The `MetricsServiceV2Connection` object for `MetricsServiceV2Client`.
 *
 * This interface defines virtual methods for each of the user-facing overload
 * sets in `MetricsServiceV2Client`. This allows users to inject custom behavior
 * (e.g., with a Google Mock object) when writing tests that use objects of type
 * `MetricsServiceV2Client`.
 *
 * To create a concrete instance, see `MakeMetricsServiceV2Connection()`.
 *
 * For mocking, see `logging_v2_mocks::MockMetricsServiceV2Connection`.
 */
class MetricsServiceV2Connection {
 public:
  virtual ~MetricsServiceV2Connection() = 0;

  virtual Options options() { return Options{}; }

  virtual StreamRange<google::logging::v2::LogMetric> ListLogMetrics(
      google::logging::v2::ListLogMetricsRequest request);

  virtual StatusOr<google::logging::v2::LogMetric> GetLogMetric(
      google::logging::v2::GetLogMetricRequest const& request);

  virtual StatusOr<google::logging::v2::LogMetric> CreateLogMetric(
      google::logging::v2::CreateLogMetricRequest const& request);

  virtual StatusOr<google::logging::v2::LogMetric> UpdateLogMetric(
      google::logging::v2::UpdateLogMetricRequest const& request);

  virtual Status DeleteLogMetric(
      google::logging::v2::DeleteLogMetricRequest const& request);
};

/**
 * A factory function to construct an object of type
 * `MetricsServiceV2Connection`.
 *
 * The returned connection object should not be used directly; instead it
 * should be passed as an argument to the constructor of MetricsServiceV2Client.
 *
 * The optional @p options argument may be used to configure aspects of the
 * returned `MetricsServiceV2Connection`. Expected options are any of the types
 * in the following option lists:
 *
 * - `google::cloud::CommonOptionList`
 * - `google::cloud::GrpcOptionList`
 * - `google::cloud::UnifiedCredentialsOptionList`
 * - `google::cloud::logging_v2::MetricsServiceV2PolicyOptionList`
 *
 * @note Unexpected options will be ignored. To log unexpected options instead,
 *     set `GOOGLE_CLOUD_CPP_ENABLE_CLOG=yes` in the environment.
 *
 * @param options (optional) Configure the `MetricsServiceV2Connection` created
 * by this function.
 */
std::shared_ptr<MetricsServiceV2Connection> MakeMetricsServiceV2Connection(
    Options options = {});

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace logging_v2
}  // namespace cloud
}  // namespace google

#endif  // GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_LOGGING_V2_METRICS_SERVICE_V2_CONNECTION_H
