// Copyright 2023 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/logging/v2/logging_metrics.proto

#include "google/cloud/logging/v2/metrics_service_v2_connection.h"
#include "google/cloud/logging/v2/internal/metrics_service_v2_connection_impl.h"
#include "google/cloud/logging/v2/internal/metrics_service_v2_option_defaults.h"
#include "google/cloud/logging/v2/internal/metrics_service_v2_stub_factory.h"
#include "google/cloud/logging/v2/internal/metrics_service_v2_tracing_connection.h"
#include "google/cloud/logging/v2/metrics_service_v2_options.h"
#include "google/cloud/background_threads.h"
#include "google/cloud/common_options.h"
#include "google/cloud/credentials.h"
#include "google/cloud/grpc_options.h"
#include "google/cloud/internal/pagination_range.h"
#include <memory>

namespace google {
namespace cloud {
namespace logging_v2 {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

MetricsServiceV2Connection::~MetricsServiceV2Connection() = default;

StreamRange<google::logging::v2::LogMetric>
MetricsServiceV2Connection::ListLogMetrics(
    google::logging::v2::
        ListLogMetricsRequest) {  // NOLINT(performance-unnecessary-value-param)
  return google::cloud::internal::MakeUnimplementedPaginationRange<
      StreamRange<google::logging::v2::LogMetric>>();
}

StatusOr<google::logging::v2::LogMetric>
MetricsServiceV2Connection::GetLogMetric(
    google::logging::v2::GetLogMetricRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

StatusOr<google::logging::v2::LogMetric>
MetricsServiceV2Connection::CreateLogMetric(
    google::logging::v2::CreateLogMetricRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

StatusOr<google::logging::v2::LogMetric>
MetricsServiceV2Connection::UpdateLogMetric(
    google::logging::v2::UpdateLogMetricRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

Status MetricsServiceV2Connection::DeleteLogMetric(
    google::logging::v2::DeleteLogMetricRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

std::shared_ptr<MetricsServiceV2Connection> MakeMetricsServiceV2Connection(
    Options options) {
  internal::CheckExpectedOptions<CommonOptionList, GrpcOptionList,
                                 UnifiedCredentialsOptionList,
                                 MetricsServiceV2PolicyOptionList>(options,
                                                                   __func__);
  options =
      logging_v2_internal::MetricsServiceV2DefaultOptions(std::move(options));
  auto background = internal::MakeBackgroundThreadsFactory(options)();
  auto stub = logging_v2_internal::CreateDefaultMetricsServiceV2Stub(
      background->cq(), options);
  return logging_v2_internal::MakeMetricsServiceV2TracingConnection(
      std::make_shared<logging_v2_internal::MetricsServiceV2ConnectionImpl>(
          std::move(background), std::move(stub), std::move(options)));
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace logging_v2
}  // namespace cloud
}  // namespace google
