// Copyright 2023 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/logging/v2/logging_metrics.proto

#ifndef GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_LOGGING_V2_INTERNAL_METRICS_SERVICE_V2_STUB_H
#define GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_LOGGING_V2_INTERNAL_METRICS_SERVICE_V2_STUB_H

#include "google/cloud/status_or.h"
#include "google/cloud/version.h"
#include <google/logging/v2/logging_metrics.grpc.pb.h>
#include <memory>

namespace google {
namespace cloud {
namespace logging_v2_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

class MetricsServiceV2Stub {
 public:
  virtual ~MetricsServiceV2Stub() = 0;

  virtual StatusOr<google::logging::v2::ListLogMetricsResponse> ListLogMetrics(
      grpc::ClientContext& context,
      google::logging::v2::ListLogMetricsRequest const& request) = 0;

  virtual StatusOr<google::logging::v2::LogMetric> GetLogMetric(
      grpc::ClientContext& context,
      google::logging::v2::GetLogMetricRequest const& request) = 0;

  virtual StatusOr<google::logging::v2::LogMetric> CreateLogMetric(
      grpc::ClientContext& context,
      google::logging::v2::CreateLogMetricRequest const& request) = 0;

  virtual StatusOr<google::logging::v2::LogMetric> UpdateLogMetric(
      grpc::ClientContext& context,
      google::logging::v2::UpdateLogMetricRequest const& request) = 0;

  virtual Status DeleteLogMetric(
      grpc::ClientContext& context,
      google::logging::v2::DeleteLogMetricRequest const& request) = 0;
};

class DefaultMetricsServiceV2Stub : public MetricsServiceV2Stub {
 public:
  explicit DefaultMetricsServiceV2Stub(
      std::unique_ptr<google::logging::v2::MetricsServiceV2::StubInterface>
          grpc_stub)
      : grpc_stub_(std::move(grpc_stub)) {}

  StatusOr<google::logging::v2::ListLogMetricsResponse> ListLogMetrics(
      grpc::ClientContext& context,
      google::logging::v2::ListLogMetricsRequest const& request) override;

  StatusOr<google::logging::v2::LogMetric> GetLogMetric(
      grpc::ClientContext& context,
      google::logging::v2::GetLogMetricRequest const& request) override;

  StatusOr<google::logging::v2::LogMetric> CreateLogMetric(
      grpc::ClientContext& context,
      google::logging::v2::CreateLogMetricRequest const& request) override;

  StatusOr<google::logging::v2::LogMetric> UpdateLogMetric(
      grpc::ClientContext& context,
      google::logging::v2::UpdateLogMetricRequest const& request) override;

  Status DeleteLogMetric(
      grpc::ClientContext& context,
      google::logging::v2::DeleteLogMetricRequest const& request) override;

 private:
  std::unique_ptr<google::logging::v2::MetricsServiceV2::StubInterface>
      grpc_stub_;
};

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace logging_v2_internal
}  // namespace cloud
}  // namespace google

#endif  // GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_LOGGING_V2_INTERNAL_METRICS_SERVICE_V2_STUB_H
