// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/iam/v2/policy.proto

#include "google/cloud/iam/v2/internal/policies_option_defaults.h"
#include "google/cloud/iam/v2/policies_connection.h"
#include "google/cloud/iam/v2/policies_options.h"
#include "google/cloud/internal/populate_common_options.h"
#include "google/cloud/internal/populate_grpc_options.h"
#include <memory>

namespace google {
namespace cloud {
namespace iam_v2_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

namespace {
auto constexpr kBackoffScaling = 2.0;
}  // namespace

Options PoliciesDefaultOptions(Options options) {
  options = google::cloud::internal::PopulateCommonOptions(
      std::move(options), "GOOGLE_CLOUD_CPP_POLICIES_ENDPOINT", "",
      "GOOGLE_CLOUD_CPP_POLICIES_AUTHORITY", "iam.googleapis.com");
  options =
      google::cloud::internal::PopulateGrpcOptions(std::move(options), "");
  if (!options.has<iam_v2::PoliciesRetryPolicyOption>()) {
    options.set<iam_v2::PoliciesRetryPolicyOption>(
        iam_v2::PoliciesLimitedTimeRetryPolicy(std::chrono::minutes(30))
            .clone());
  }
  if (!options.has<iam_v2::PoliciesBackoffPolicyOption>()) {
    options.set<iam_v2::PoliciesBackoffPolicyOption>(
        ExponentialBackoffPolicy(
            std::chrono::seconds(0), std::chrono::seconds(1),
            std::chrono::minutes(5), kBackoffScaling, kBackoffScaling)
            .clone());
  }
  if (!options.has<iam_v2::PoliciesPollingPolicyOption>()) {
    options.set<iam_v2::PoliciesPollingPolicyOption>(
        GenericPollingPolicy<iam_v2::PoliciesRetryPolicyOption::Type,
                             iam_v2::PoliciesBackoffPolicyOption::Type>(
            options.get<iam_v2::PoliciesRetryPolicyOption>()->clone(),
            ExponentialBackoffPolicy(std::chrono::seconds(1),
                                     std::chrono::minutes(5), kBackoffScaling)
                .clone())
            .clone());
  }
  if (!options.has<iam_v2::PoliciesConnectionIdempotencyPolicyOption>()) {
    options.set<iam_v2::PoliciesConnectionIdempotencyPolicyOption>(
        iam_v2::MakeDefaultPoliciesConnectionIdempotencyPolicy());
  }

  return options;
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace iam_v2_internal
}  // namespace cloud
}  // namespace google
