// Copyright 2023 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/gkebackup/v1/gkebackup.proto

#include "google/cloud/gkebackup/v1/backup_for_gke_client.h"
#include <memory>

namespace google {
namespace cloud {
namespace gkebackup_v1 {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

BackupForGKEClient::BackupForGKEClient(
    std::shared_ptr<BackupForGKEConnection> connection, Options opts)
    : connection_(std::move(connection)),
      options_(
          internal::MergeOptions(std::move(opts), connection_->options())) {}
BackupForGKEClient::~BackupForGKEClient() = default;

future<StatusOr<google::cloud::gkebackup::v1::BackupPlan>>
BackupForGKEClient::CreateBackupPlan(
    std::string const& parent,
    google::cloud::gkebackup::v1::BackupPlan const& backup_plan,
    std::string const& backup_plan_id, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::gkebackup::v1::CreateBackupPlanRequest request;
  request.set_parent(parent);
  *request.mutable_backup_plan() = backup_plan;
  request.set_backup_plan_id(backup_plan_id);
  return connection_->CreateBackupPlan(request);
}

future<StatusOr<google::cloud::gkebackup::v1::BackupPlan>>
BackupForGKEClient::CreateBackupPlan(
    google::cloud::gkebackup::v1::CreateBackupPlanRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->CreateBackupPlan(request);
}

StreamRange<google::cloud::gkebackup::v1::BackupPlan>
BackupForGKEClient::ListBackupPlans(std::string const& parent, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::gkebackup::v1::ListBackupPlansRequest request;
  request.set_parent(parent);
  return connection_->ListBackupPlans(request);
}

StreamRange<google::cloud::gkebackup::v1::BackupPlan>
BackupForGKEClient::ListBackupPlans(
    google::cloud::gkebackup::v1::ListBackupPlansRequest request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->ListBackupPlans(std::move(request));
}

StatusOr<google::cloud::gkebackup::v1::BackupPlan>
BackupForGKEClient::GetBackupPlan(std::string const& name, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::gkebackup::v1::GetBackupPlanRequest request;
  request.set_name(name);
  return connection_->GetBackupPlan(request);
}

StatusOr<google::cloud::gkebackup::v1::BackupPlan>
BackupForGKEClient::GetBackupPlan(
    google::cloud::gkebackup::v1::GetBackupPlanRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->GetBackupPlan(request);
}

future<StatusOr<google::cloud::gkebackup::v1::BackupPlan>>
BackupForGKEClient::UpdateBackupPlan(
    google::cloud::gkebackup::v1::BackupPlan const& backup_plan,
    google::protobuf::FieldMask const& update_mask, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::gkebackup::v1::UpdateBackupPlanRequest request;
  *request.mutable_backup_plan() = backup_plan;
  *request.mutable_update_mask() = update_mask;
  return connection_->UpdateBackupPlan(request);
}

future<StatusOr<google::cloud::gkebackup::v1::BackupPlan>>
BackupForGKEClient::UpdateBackupPlan(
    google::cloud::gkebackup::v1::UpdateBackupPlanRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->UpdateBackupPlan(request);
}

future<StatusOr<google::cloud::gkebackup::v1::OperationMetadata>>
BackupForGKEClient::DeleteBackupPlan(std::string const& name, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::gkebackup::v1::DeleteBackupPlanRequest request;
  request.set_name(name);
  return connection_->DeleteBackupPlan(request);
}

future<StatusOr<google::cloud::gkebackup::v1::OperationMetadata>>
BackupForGKEClient::DeleteBackupPlan(
    google::cloud::gkebackup::v1::DeleteBackupPlanRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->DeleteBackupPlan(request);
}

future<StatusOr<google::cloud::gkebackup::v1::Backup>>
BackupForGKEClient::CreateBackup(
    std::string const& parent,
    google::cloud::gkebackup::v1::Backup const& backup,
    std::string const& backup_id, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::gkebackup::v1::CreateBackupRequest request;
  request.set_parent(parent);
  *request.mutable_backup() = backup;
  request.set_backup_id(backup_id);
  return connection_->CreateBackup(request);
}

future<StatusOr<google::cloud::gkebackup::v1::Backup>>
BackupForGKEClient::CreateBackup(
    google::cloud::gkebackup::v1::CreateBackupRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->CreateBackup(request);
}

StreamRange<google::cloud::gkebackup::v1::Backup>
BackupForGKEClient::ListBackups(std::string const& parent, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::gkebackup::v1::ListBackupsRequest request;
  request.set_parent(parent);
  return connection_->ListBackups(request);
}

StreamRange<google::cloud::gkebackup::v1::Backup>
BackupForGKEClient::ListBackups(
    google::cloud::gkebackup::v1::ListBackupsRequest request, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->ListBackups(std::move(request));
}

StatusOr<google::cloud::gkebackup::v1::Backup> BackupForGKEClient::GetBackup(
    std::string const& name, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::gkebackup::v1::GetBackupRequest request;
  request.set_name(name);
  return connection_->GetBackup(request);
}

StatusOr<google::cloud::gkebackup::v1::Backup> BackupForGKEClient::GetBackup(
    google::cloud::gkebackup::v1::GetBackupRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->GetBackup(request);
}

future<StatusOr<google::cloud::gkebackup::v1::Backup>>
BackupForGKEClient::UpdateBackup(
    google::cloud::gkebackup::v1::Backup const& backup,
    google::protobuf::FieldMask const& update_mask, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::gkebackup::v1::UpdateBackupRequest request;
  *request.mutable_backup() = backup;
  *request.mutable_update_mask() = update_mask;
  return connection_->UpdateBackup(request);
}

future<StatusOr<google::cloud::gkebackup::v1::Backup>>
BackupForGKEClient::UpdateBackup(
    google::cloud::gkebackup::v1::UpdateBackupRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->UpdateBackup(request);
}

future<StatusOr<google::cloud::gkebackup::v1::OperationMetadata>>
BackupForGKEClient::DeleteBackup(std::string const& name, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::gkebackup::v1::DeleteBackupRequest request;
  request.set_name(name);
  return connection_->DeleteBackup(request);
}

future<StatusOr<google::cloud::gkebackup::v1::OperationMetadata>>
BackupForGKEClient::DeleteBackup(
    google::cloud::gkebackup::v1::DeleteBackupRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->DeleteBackup(request);
}

StreamRange<google::cloud::gkebackup::v1::VolumeBackup>
BackupForGKEClient::ListVolumeBackups(std::string const& parent, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::gkebackup::v1::ListVolumeBackupsRequest request;
  request.set_parent(parent);
  return connection_->ListVolumeBackups(request);
}

StreamRange<google::cloud::gkebackup::v1::VolumeBackup>
BackupForGKEClient::ListVolumeBackups(
    google::cloud::gkebackup::v1::ListVolumeBackupsRequest request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->ListVolumeBackups(std::move(request));
}

StatusOr<google::cloud::gkebackup::v1::VolumeBackup>
BackupForGKEClient::GetVolumeBackup(std::string const& name, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::gkebackup::v1::GetVolumeBackupRequest request;
  request.set_name(name);
  return connection_->GetVolumeBackup(request);
}

StatusOr<google::cloud::gkebackup::v1::VolumeBackup>
BackupForGKEClient::GetVolumeBackup(
    google::cloud::gkebackup::v1::GetVolumeBackupRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->GetVolumeBackup(request);
}

future<StatusOr<google::cloud::gkebackup::v1::RestorePlan>>
BackupForGKEClient::CreateRestorePlan(
    std::string const& parent,
    google::cloud::gkebackup::v1::RestorePlan const& restore_plan,
    std::string const& restore_plan_id, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::gkebackup::v1::CreateRestorePlanRequest request;
  request.set_parent(parent);
  *request.mutable_restore_plan() = restore_plan;
  request.set_restore_plan_id(restore_plan_id);
  return connection_->CreateRestorePlan(request);
}

future<StatusOr<google::cloud::gkebackup::v1::RestorePlan>>
BackupForGKEClient::CreateRestorePlan(
    google::cloud::gkebackup::v1::CreateRestorePlanRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->CreateRestorePlan(request);
}

StreamRange<google::cloud::gkebackup::v1::RestorePlan>
BackupForGKEClient::ListRestorePlans(std::string const& parent, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::gkebackup::v1::ListRestorePlansRequest request;
  request.set_parent(parent);
  return connection_->ListRestorePlans(request);
}

StreamRange<google::cloud::gkebackup::v1::RestorePlan>
BackupForGKEClient::ListRestorePlans(
    google::cloud::gkebackup::v1::ListRestorePlansRequest request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->ListRestorePlans(std::move(request));
}

StatusOr<google::cloud::gkebackup::v1::RestorePlan>
BackupForGKEClient::GetRestorePlan(std::string const& name, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::gkebackup::v1::GetRestorePlanRequest request;
  request.set_name(name);
  return connection_->GetRestorePlan(request);
}

StatusOr<google::cloud::gkebackup::v1::RestorePlan>
BackupForGKEClient::GetRestorePlan(
    google::cloud::gkebackup::v1::GetRestorePlanRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->GetRestorePlan(request);
}

future<StatusOr<google::cloud::gkebackup::v1::RestorePlan>>
BackupForGKEClient::UpdateRestorePlan(
    google::cloud::gkebackup::v1::RestorePlan const& restore_plan,
    google::protobuf::FieldMask const& update_mask, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::gkebackup::v1::UpdateRestorePlanRequest request;
  *request.mutable_restore_plan() = restore_plan;
  *request.mutable_update_mask() = update_mask;
  return connection_->UpdateRestorePlan(request);
}

future<StatusOr<google::cloud::gkebackup::v1::RestorePlan>>
BackupForGKEClient::UpdateRestorePlan(
    google::cloud::gkebackup::v1::UpdateRestorePlanRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->UpdateRestorePlan(request);
}

future<StatusOr<google::cloud::gkebackup::v1::OperationMetadata>>
BackupForGKEClient::DeleteRestorePlan(std::string const& name, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::gkebackup::v1::DeleteRestorePlanRequest request;
  request.set_name(name);
  return connection_->DeleteRestorePlan(request);
}

future<StatusOr<google::cloud::gkebackup::v1::OperationMetadata>>
BackupForGKEClient::DeleteRestorePlan(
    google::cloud::gkebackup::v1::DeleteRestorePlanRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->DeleteRestorePlan(request);
}

future<StatusOr<google::cloud::gkebackup::v1::Restore>>
BackupForGKEClient::CreateRestore(
    std::string const& parent,
    google::cloud::gkebackup::v1::Restore const& restore,
    std::string const& restore_id, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::gkebackup::v1::CreateRestoreRequest request;
  request.set_parent(parent);
  *request.mutable_restore() = restore;
  request.set_restore_id(restore_id);
  return connection_->CreateRestore(request);
}

future<StatusOr<google::cloud::gkebackup::v1::Restore>>
BackupForGKEClient::CreateRestore(
    google::cloud::gkebackup::v1::CreateRestoreRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->CreateRestore(request);
}

StreamRange<google::cloud::gkebackup::v1::Restore>
BackupForGKEClient::ListRestores(std::string const& parent, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::gkebackup::v1::ListRestoresRequest request;
  request.set_parent(parent);
  return connection_->ListRestores(request);
}

StreamRange<google::cloud::gkebackup::v1::Restore>
BackupForGKEClient::ListRestores(
    google::cloud::gkebackup::v1::ListRestoresRequest request, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->ListRestores(std::move(request));
}

StatusOr<google::cloud::gkebackup::v1::Restore> BackupForGKEClient::GetRestore(
    std::string const& name, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::gkebackup::v1::GetRestoreRequest request;
  request.set_name(name);
  return connection_->GetRestore(request);
}

StatusOr<google::cloud::gkebackup::v1::Restore> BackupForGKEClient::GetRestore(
    google::cloud::gkebackup::v1::GetRestoreRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->GetRestore(request);
}

future<StatusOr<google::cloud::gkebackup::v1::Restore>>
BackupForGKEClient::UpdateRestore(
    google::cloud::gkebackup::v1::Restore const& restore,
    google::protobuf::FieldMask const& update_mask, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::gkebackup::v1::UpdateRestoreRequest request;
  *request.mutable_restore() = restore;
  *request.mutable_update_mask() = update_mask;
  return connection_->UpdateRestore(request);
}

future<StatusOr<google::cloud::gkebackup::v1::Restore>>
BackupForGKEClient::UpdateRestore(
    google::cloud::gkebackup::v1::UpdateRestoreRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->UpdateRestore(request);
}

future<StatusOr<google::cloud::gkebackup::v1::OperationMetadata>>
BackupForGKEClient::DeleteRestore(std::string const& name, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::gkebackup::v1::DeleteRestoreRequest request;
  request.set_name(name);
  return connection_->DeleteRestore(request);
}

future<StatusOr<google::cloud::gkebackup::v1::OperationMetadata>>
BackupForGKEClient::DeleteRestore(
    google::cloud::gkebackup::v1::DeleteRestoreRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->DeleteRestore(request);
}

StreamRange<google::cloud::gkebackup::v1::VolumeRestore>
BackupForGKEClient::ListVolumeRestores(std::string const& parent,
                                       Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::gkebackup::v1::ListVolumeRestoresRequest request;
  request.set_parent(parent);
  return connection_->ListVolumeRestores(request);
}

StreamRange<google::cloud::gkebackup::v1::VolumeRestore>
BackupForGKEClient::ListVolumeRestores(
    google::cloud::gkebackup::v1::ListVolumeRestoresRequest request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->ListVolumeRestores(std::move(request));
}

StatusOr<google::cloud::gkebackup::v1::VolumeRestore>
BackupForGKEClient::GetVolumeRestore(std::string const& name, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::gkebackup::v1::GetVolumeRestoreRequest request;
  request.set_name(name);
  return connection_->GetVolumeRestore(request);
}

StatusOr<google::cloud::gkebackup::v1::VolumeRestore>
BackupForGKEClient::GetVolumeRestore(
    google::cloud::gkebackup::v1::GetVolumeRestoreRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->GetVolumeRestore(request);
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace gkebackup_v1
}  // namespace cloud
}  // namespace google
