// Copyright 2023 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/essentialcontacts/v1/service.proto

#include "google/cloud/essentialcontacts/v1/essential_contacts_client.h"
#include <memory>

namespace google {
namespace cloud {
namespace essentialcontacts_v1 {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

EssentialContactsServiceClient::EssentialContactsServiceClient(
    std::shared_ptr<EssentialContactsServiceConnection> connection,
    Options opts)
    : connection_(std::move(connection)),
      options_(
          internal::MergeOptions(std::move(opts), connection_->options())) {}
EssentialContactsServiceClient::~EssentialContactsServiceClient() = default;

StatusOr<google::cloud::essentialcontacts::v1::Contact>
EssentialContactsServiceClient::CreateContact(
    std::string const& parent,
    google::cloud::essentialcontacts::v1::Contact const& contact,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::essentialcontacts::v1::CreateContactRequest request;
  request.set_parent(parent);
  *request.mutable_contact() = contact;
  return connection_->CreateContact(request);
}

StatusOr<google::cloud::essentialcontacts::v1::Contact>
EssentialContactsServiceClient::CreateContact(
    google::cloud::essentialcontacts::v1::CreateContactRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->CreateContact(request);
}

StatusOr<google::cloud::essentialcontacts::v1::Contact>
EssentialContactsServiceClient::UpdateContact(
    google::cloud::essentialcontacts::v1::Contact const& contact,
    google::protobuf::FieldMask const& update_mask, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::essentialcontacts::v1::UpdateContactRequest request;
  *request.mutable_contact() = contact;
  *request.mutable_update_mask() = update_mask;
  return connection_->UpdateContact(request);
}

StatusOr<google::cloud::essentialcontacts::v1::Contact>
EssentialContactsServiceClient::UpdateContact(
    google::cloud::essentialcontacts::v1::UpdateContactRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->UpdateContact(request);
}

StreamRange<google::cloud::essentialcontacts::v1::Contact>
EssentialContactsServiceClient::ListContacts(std::string const& parent,
                                             Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::essentialcontacts::v1::ListContactsRequest request;
  request.set_parent(parent);
  return connection_->ListContacts(request);
}

StreamRange<google::cloud::essentialcontacts::v1::Contact>
EssentialContactsServiceClient::ListContacts(
    google::cloud::essentialcontacts::v1::ListContactsRequest request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->ListContacts(std::move(request));
}

StatusOr<google::cloud::essentialcontacts::v1::Contact>
EssentialContactsServiceClient::GetContact(std::string const& name,
                                           Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::essentialcontacts::v1::GetContactRequest request;
  request.set_name(name);
  return connection_->GetContact(request);
}

StatusOr<google::cloud::essentialcontacts::v1::Contact>
EssentialContactsServiceClient::GetContact(
    google::cloud::essentialcontacts::v1::GetContactRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->GetContact(request);
}

Status EssentialContactsServiceClient::DeleteContact(std::string const& name,
                                                     Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::essentialcontacts::v1::DeleteContactRequest request;
  request.set_name(name);
  return connection_->DeleteContact(request);
}

Status EssentialContactsServiceClient::DeleteContact(
    google::cloud::essentialcontacts::v1::DeleteContactRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->DeleteContact(request);
}

StreamRange<google::cloud::essentialcontacts::v1::Contact>
EssentialContactsServiceClient::ComputeContacts(
    google::cloud::essentialcontacts::v1::ComputeContactsRequest request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->ComputeContacts(std::move(request));
}

Status EssentialContactsServiceClient::SendTestMessage(
    google::cloud::essentialcontacts::v1::SendTestMessageRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->SendTestMessage(request);
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace essentialcontacts_v1
}  // namespace cloud
}  // namespace google
