// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/dialogflow/v2/participant.proto

#include "google/cloud/dialogflow_es/internal/participants_tracing_stub.h"
#include "google/cloud/internal/async_read_write_stream_tracing.h"
#include "google/cloud/internal/grpc_opentelemetry.h"

namespace google {
namespace cloud {
namespace dialogflow_es_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

#ifdef GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY

ParticipantsTracingStub::ParticipantsTracingStub(
    std::shared_ptr<ParticipantsStub> child)
    : child_(std::move(child)), propagator_(internal::MakePropagator()) {}

StatusOr<google::cloud::dialogflow::v2::Participant>
ParticipantsTracingStub::CreateParticipant(
    grpc::ClientContext& context,
    google::cloud::dialogflow::v2::CreateParticipantRequest const& request) {
  auto span = internal::MakeSpanGrpc("google.cloud.dialogflow.v2.Participants",
                                     "CreateParticipant");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->CreateParticipant(context, request));
}

StatusOr<google::cloud::dialogflow::v2::Participant>
ParticipantsTracingStub::GetParticipant(
    grpc::ClientContext& context,
    google::cloud::dialogflow::v2::GetParticipantRequest const& request) {
  auto span = internal::MakeSpanGrpc("google.cloud.dialogflow.v2.Participants",
                                     "GetParticipant");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->GetParticipant(context, request));
}

StatusOr<google::cloud::dialogflow::v2::ListParticipantsResponse>
ParticipantsTracingStub::ListParticipants(
    grpc::ClientContext& context,
    google::cloud::dialogflow::v2::ListParticipantsRequest const& request) {
  auto span = internal::MakeSpanGrpc("google.cloud.dialogflow.v2.Participants",
                                     "ListParticipants");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->ListParticipants(context, request));
}

StatusOr<google::cloud::dialogflow::v2::Participant>
ParticipantsTracingStub::UpdateParticipant(
    grpc::ClientContext& context,
    google::cloud::dialogflow::v2::UpdateParticipantRequest const& request) {
  auto span = internal::MakeSpanGrpc("google.cloud.dialogflow.v2.Participants",
                                     "UpdateParticipant");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->UpdateParticipant(context, request));
}

StatusOr<google::cloud::dialogflow::v2::AnalyzeContentResponse>
ParticipantsTracingStub::AnalyzeContent(
    grpc::ClientContext& context,
    google::cloud::dialogflow::v2::AnalyzeContentRequest const& request) {
  auto span = internal::MakeSpanGrpc("google.cloud.dialogflow.v2.Participants",
                                     "AnalyzeContent");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->AnalyzeContent(context, request));
}

std::unique_ptr<AsyncStreamingReadWriteRpc<
    google::cloud::dialogflow::v2::StreamingAnalyzeContentRequest,
    google::cloud::dialogflow::v2::StreamingAnalyzeContentResponse>>
ParticipantsTracingStub::AsyncStreamingAnalyzeContent(
    CompletionQueue const& cq, std::shared_ptr<grpc::ClientContext> context) {
  auto span = internal::MakeSpanGrpc("google.cloud.dialogflow.v2.Participants",
                                     "StreamingAnalyzeContent");
  internal::OTelScope scope(span);
  internal::InjectTraceContext(*context, *propagator_);
  auto stream = child_->AsyncStreamingAnalyzeContent(cq, context);
  return std::make_unique<internal::AsyncStreamingReadWriteRpcTracing<
      google::cloud::dialogflow::v2::StreamingAnalyzeContentRequest,
      google::cloud::dialogflow::v2::StreamingAnalyzeContentResponse>>(
      std::move(context), std::move(stream), std::move(span));
}

StatusOr<google::cloud::dialogflow::v2::SuggestArticlesResponse>
ParticipantsTracingStub::SuggestArticles(
    grpc::ClientContext& context,
    google::cloud::dialogflow::v2::SuggestArticlesRequest const& request) {
  auto span = internal::MakeSpanGrpc("google.cloud.dialogflow.v2.Participants",
                                     "SuggestArticles");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->SuggestArticles(context, request));
}

StatusOr<google::cloud::dialogflow::v2::SuggestFaqAnswersResponse>
ParticipantsTracingStub::SuggestFaqAnswers(
    grpc::ClientContext& context,
    google::cloud::dialogflow::v2::SuggestFaqAnswersRequest const& request) {
  auto span = internal::MakeSpanGrpc("google.cloud.dialogflow.v2.Participants",
                                     "SuggestFaqAnswers");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->SuggestFaqAnswers(context, request));
}

StatusOr<google::cloud::dialogflow::v2::SuggestSmartRepliesResponse>
ParticipantsTracingStub::SuggestSmartReplies(
    grpc::ClientContext& context,
    google::cloud::dialogflow::v2::SuggestSmartRepliesRequest const& request) {
  auto span = internal::MakeSpanGrpc("google.cloud.dialogflow.v2.Participants",
                                     "SuggestSmartReplies");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->SuggestSmartReplies(context, request));
}

#endif  // GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY

std::shared_ptr<ParticipantsStub> MakeParticipantsTracingStub(
    std::shared_ptr<ParticipantsStub> stub) {
#ifdef GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY
  return std::make_shared<ParticipantsTracingStub>(std::move(stub));
#else
  return stub;
#endif  // GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace dialogflow_es_internal
}  // namespace cloud
}  // namespace google
