// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/datacatalog/v1/datacatalog.proto

#include "google/cloud/datacatalog/v1/internal/data_catalog_logging_decorator.h"
#include "google/cloud/internal/log_wrapper.h"
#include "google/cloud/status_or.h"
#include <google/cloud/datacatalog/v1/datacatalog.grpc.pb.h>
#include <memory>

namespace google {
namespace cloud {
namespace datacatalog_v1_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

DataCatalogLogging::DataCatalogLogging(std::shared_ptr<DataCatalogStub> child,
                                       TracingOptions tracing_options,
                                       std::set<std::string> const& components)
    : child_(std::move(child)),
      tracing_options_(std::move(tracing_options)),
      stream_logging_(components.find("rpc-streams") != components.end()) {}

StatusOr<google::cloud::datacatalog::v1::SearchCatalogResponse>
DataCatalogLogging::SearchCatalog(
    grpc::ClientContext& context,
    google::cloud::datacatalog::v1::SearchCatalogRequest const& request) {
  return google::cloud::internal::LogWrapper(
      [this](
          grpc::ClientContext& context,
          google::cloud::datacatalog::v1::SearchCatalogRequest const& request) {
        return child_->SearchCatalog(context, request);
      },
      context, request, __func__, tracing_options_);
}

StatusOr<google::cloud::datacatalog::v1::EntryGroup>
DataCatalogLogging::CreateEntryGroup(
    grpc::ClientContext& context,
    google::cloud::datacatalog::v1::CreateEntryGroupRequest const& request) {
  return google::cloud::internal::LogWrapper(
      [this](grpc::ClientContext& context,
             google::cloud::datacatalog::v1::CreateEntryGroupRequest const&
                 request) {
        return child_->CreateEntryGroup(context, request);
      },
      context, request, __func__, tracing_options_);
}

StatusOr<google::cloud::datacatalog::v1::EntryGroup>
DataCatalogLogging::GetEntryGroup(
    grpc::ClientContext& context,
    google::cloud::datacatalog::v1::GetEntryGroupRequest const& request) {
  return google::cloud::internal::LogWrapper(
      [this](
          grpc::ClientContext& context,
          google::cloud::datacatalog::v1::GetEntryGroupRequest const& request) {
        return child_->GetEntryGroup(context, request);
      },
      context, request, __func__, tracing_options_);
}

StatusOr<google::cloud::datacatalog::v1::EntryGroup>
DataCatalogLogging::UpdateEntryGroup(
    grpc::ClientContext& context,
    google::cloud::datacatalog::v1::UpdateEntryGroupRequest const& request) {
  return google::cloud::internal::LogWrapper(
      [this](grpc::ClientContext& context,
             google::cloud::datacatalog::v1::UpdateEntryGroupRequest const&
                 request) {
        return child_->UpdateEntryGroup(context, request);
      },
      context, request, __func__, tracing_options_);
}

Status DataCatalogLogging::DeleteEntryGroup(
    grpc::ClientContext& context,
    google::cloud::datacatalog::v1::DeleteEntryGroupRequest const& request) {
  return google::cloud::internal::LogWrapper(
      [this](grpc::ClientContext& context,
             google::cloud::datacatalog::v1::DeleteEntryGroupRequest const&
                 request) {
        return child_->DeleteEntryGroup(context, request);
      },
      context, request, __func__, tracing_options_);
}

StatusOr<google::cloud::datacatalog::v1::ListEntryGroupsResponse>
DataCatalogLogging::ListEntryGroups(
    grpc::ClientContext& context,
    google::cloud::datacatalog::v1::ListEntryGroupsRequest const& request) {
  return google::cloud::internal::LogWrapper(
      [this](grpc::ClientContext& context,
             google::cloud::datacatalog::v1::ListEntryGroupsRequest const&
                 request) { return child_->ListEntryGroups(context, request); },
      context, request, __func__, tracing_options_);
}

StatusOr<google::cloud::datacatalog::v1::Entry> DataCatalogLogging::CreateEntry(
    grpc::ClientContext& context,
    google::cloud::datacatalog::v1::CreateEntryRequest const& request) {
  return google::cloud::internal::LogWrapper(
      [this](
          grpc::ClientContext& context,
          google::cloud::datacatalog::v1::CreateEntryRequest const& request) {
        return child_->CreateEntry(context, request);
      },
      context, request, __func__, tracing_options_);
}

StatusOr<google::cloud::datacatalog::v1::Entry> DataCatalogLogging::UpdateEntry(
    grpc::ClientContext& context,
    google::cloud::datacatalog::v1::UpdateEntryRequest const& request) {
  return google::cloud::internal::LogWrapper(
      [this](
          grpc::ClientContext& context,
          google::cloud::datacatalog::v1::UpdateEntryRequest const& request) {
        return child_->UpdateEntry(context, request);
      },
      context, request, __func__, tracing_options_);
}

Status DataCatalogLogging::DeleteEntry(
    grpc::ClientContext& context,
    google::cloud::datacatalog::v1::DeleteEntryRequest const& request) {
  return google::cloud::internal::LogWrapper(
      [this](
          grpc::ClientContext& context,
          google::cloud::datacatalog::v1::DeleteEntryRequest const& request) {
        return child_->DeleteEntry(context, request);
      },
      context, request, __func__, tracing_options_);
}

StatusOr<google::cloud::datacatalog::v1::Entry> DataCatalogLogging::GetEntry(
    grpc::ClientContext& context,
    google::cloud::datacatalog::v1::GetEntryRequest const& request) {
  return google::cloud::internal::LogWrapper(
      [this](grpc::ClientContext& context,
             google::cloud::datacatalog::v1::GetEntryRequest const& request) {
        return child_->GetEntry(context, request);
      },
      context, request, __func__, tracing_options_);
}

StatusOr<google::cloud::datacatalog::v1::Entry> DataCatalogLogging::LookupEntry(
    grpc::ClientContext& context,
    google::cloud::datacatalog::v1::LookupEntryRequest const& request) {
  return google::cloud::internal::LogWrapper(
      [this](
          grpc::ClientContext& context,
          google::cloud::datacatalog::v1::LookupEntryRequest const& request) {
        return child_->LookupEntry(context, request);
      },
      context, request, __func__, tracing_options_);
}

StatusOr<google::cloud::datacatalog::v1::ListEntriesResponse>
DataCatalogLogging::ListEntries(
    grpc::ClientContext& context,
    google::cloud::datacatalog::v1::ListEntriesRequest const& request) {
  return google::cloud::internal::LogWrapper(
      [this](
          grpc::ClientContext& context,
          google::cloud::datacatalog::v1::ListEntriesRequest const& request) {
        return child_->ListEntries(context, request);
      },
      context, request, __func__, tracing_options_);
}

StatusOr<google::cloud::datacatalog::v1::EntryOverview>
DataCatalogLogging::ModifyEntryOverview(
    grpc::ClientContext& context,
    google::cloud::datacatalog::v1::ModifyEntryOverviewRequest const& request) {
  return google::cloud::internal::LogWrapper(
      [this](grpc::ClientContext& context,
             google::cloud::datacatalog::v1::ModifyEntryOverviewRequest const&
                 request) {
        return child_->ModifyEntryOverview(context, request);
      },
      context, request, __func__, tracing_options_);
}

StatusOr<google::cloud::datacatalog::v1::Contacts>
DataCatalogLogging::ModifyEntryContacts(
    grpc::ClientContext& context,
    google::cloud::datacatalog::v1::ModifyEntryContactsRequest const& request) {
  return google::cloud::internal::LogWrapper(
      [this](grpc::ClientContext& context,
             google::cloud::datacatalog::v1::ModifyEntryContactsRequest const&
                 request) {
        return child_->ModifyEntryContacts(context, request);
      },
      context, request, __func__, tracing_options_);
}

StatusOr<google::cloud::datacatalog::v1::TagTemplate>
DataCatalogLogging::CreateTagTemplate(
    grpc::ClientContext& context,
    google::cloud::datacatalog::v1::CreateTagTemplateRequest const& request) {
  return google::cloud::internal::LogWrapper(
      [this](grpc::ClientContext& context,
             google::cloud::datacatalog::v1::CreateTagTemplateRequest const&
                 request) {
        return child_->CreateTagTemplate(context, request);
      },
      context, request, __func__, tracing_options_);
}

StatusOr<google::cloud::datacatalog::v1::TagTemplate>
DataCatalogLogging::GetTagTemplate(
    grpc::ClientContext& context,
    google::cloud::datacatalog::v1::GetTagTemplateRequest const& request) {
  return google::cloud::internal::LogWrapper(
      [this](grpc::ClientContext& context,
             google::cloud::datacatalog::v1::GetTagTemplateRequest const&
                 request) { return child_->GetTagTemplate(context, request); },
      context, request, __func__, tracing_options_);
}

StatusOr<google::cloud::datacatalog::v1::TagTemplate>
DataCatalogLogging::UpdateTagTemplate(
    grpc::ClientContext& context,
    google::cloud::datacatalog::v1::UpdateTagTemplateRequest const& request) {
  return google::cloud::internal::LogWrapper(
      [this](grpc::ClientContext& context,
             google::cloud::datacatalog::v1::UpdateTagTemplateRequest const&
                 request) {
        return child_->UpdateTagTemplate(context, request);
      },
      context, request, __func__, tracing_options_);
}

Status DataCatalogLogging::DeleteTagTemplate(
    grpc::ClientContext& context,
    google::cloud::datacatalog::v1::DeleteTagTemplateRequest const& request) {
  return google::cloud::internal::LogWrapper(
      [this](grpc::ClientContext& context,
             google::cloud::datacatalog::v1::DeleteTagTemplateRequest const&
                 request) {
        return child_->DeleteTagTemplate(context, request);
      },
      context, request, __func__, tracing_options_);
}

StatusOr<google::cloud::datacatalog::v1::TagTemplateField>
DataCatalogLogging::CreateTagTemplateField(
    grpc::ClientContext& context,
    google::cloud::datacatalog::v1::CreateTagTemplateFieldRequest const&
        request) {
  return google::cloud::internal::LogWrapper(
      [this](
          grpc::ClientContext& context,
          google::cloud::datacatalog::v1::CreateTagTemplateFieldRequest const&
              request) {
        return child_->CreateTagTemplateField(context, request);
      },
      context, request, __func__, tracing_options_);
}

StatusOr<google::cloud::datacatalog::v1::TagTemplateField>
DataCatalogLogging::UpdateTagTemplateField(
    grpc::ClientContext& context,
    google::cloud::datacatalog::v1::UpdateTagTemplateFieldRequest const&
        request) {
  return google::cloud::internal::LogWrapper(
      [this](
          grpc::ClientContext& context,
          google::cloud::datacatalog::v1::UpdateTagTemplateFieldRequest const&
              request) {
        return child_->UpdateTagTemplateField(context, request);
      },
      context, request, __func__, tracing_options_);
}

StatusOr<google::cloud::datacatalog::v1::TagTemplateField>
DataCatalogLogging::RenameTagTemplateField(
    grpc::ClientContext& context,
    google::cloud::datacatalog::v1::RenameTagTemplateFieldRequest const&
        request) {
  return google::cloud::internal::LogWrapper(
      [this](
          grpc::ClientContext& context,
          google::cloud::datacatalog::v1::RenameTagTemplateFieldRequest const&
              request) {
        return child_->RenameTagTemplateField(context, request);
      },
      context, request, __func__, tracing_options_);
}

StatusOr<google::cloud::datacatalog::v1::TagTemplateField>
DataCatalogLogging::RenameTagTemplateFieldEnumValue(
    grpc::ClientContext& context,
    google::cloud::datacatalog::v1::
        RenameTagTemplateFieldEnumValueRequest const& request) {
  return google::cloud::internal::LogWrapper(
      [this](grpc::ClientContext& context,
             google::cloud::datacatalog::v1::
                 RenameTagTemplateFieldEnumValueRequest const& request) {
        return child_->RenameTagTemplateFieldEnumValue(context, request);
      },
      context, request, __func__, tracing_options_);
}

Status DataCatalogLogging::DeleteTagTemplateField(
    grpc::ClientContext& context,
    google::cloud::datacatalog::v1::DeleteTagTemplateFieldRequest const&
        request) {
  return google::cloud::internal::LogWrapper(
      [this](
          grpc::ClientContext& context,
          google::cloud::datacatalog::v1::DeleteTagTemplateFieldRequest const&
              request) {
        return child_->DeleteTagTemplateField(context, request);
      },
      context, request, __func__, tracing_options_);
}

StatusOr<google::cloud::datacatalog::v1::Tag> DataCatalogLogging::CreateTag(
    grpc::ClientContext& context,
    google::cloud::datacatalog::v1::CreateTagRequest const& request) {
  return google::cloud::internal::LogWrapper(
      [this](grpc::ClientContext& context,
             google::cloud::datacatalog::v1::CreateTagRequest const& request) {
        return child_->CreateTag(context, request);
      },
      context, request, __func__, tracing_options_);
}

StatusOr<google::cloud::datacatalog::v1::Tag> DataCatalogLogging::UpdateTag(
    grpc::ClientContext& context,
    google::cloud::datacatalog::v1::UpdateTagRequest const& request) {
  return google::cloud::internal::LogWrapper(
      [this](grpc::ClientContext& context,
             google::cloud::datacatalog::v1::UpdateTagRequest const& request) {
        return child_->UpdateTag(context, request);
      },
      context, request, __func__, tracing_options_);
}

Status DataCatalogLogging::DeleteTag(
    grpc::ClientContext& context,
    google::cloud::datacatalog::v1::DeleteTagRequest const& request) {
  return google::cloud::internal::LogWrapper(
      [this](grpc::ClientContext& context,
             google::cloud::datacatalog::v1::DeleteTagRequest const& request) {
        return child_->DeleteTag(context, request);
      },
      context, request, __func__, tracing_options_);
}

StatusOr<google::cloud::datacatalog::v1::ListTagsResponse>
DataCatalogLogging::ListTags(
    grpc::ClientContext& context,
    google::cloud::datacatalog::v1::ListTagsRequest const& request) {
  return google::cloud::internal::LogWrapper(
      [this](grpc::ClientContext& context,
             google::cloud::datacatalog::v1::ListTagsRequest const& request) {
        return child_->ListTags(context, request);
      },
      context, request, __func__, tracing_options_);
}

future<StatusOr<google::longrunning::Operation>>
DataCatalogLogging::AsyncReconcileTags(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context, Options const& options,
    google::cloud::datacatalog::v1::ReconcileTagsRequest const& request) {
  return google::cloud::internal::LogWrapper(
      [this](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context, Options const& options,
          google::cloud::datacatalog::v1::ReconcileTagsRequest const& request) {
        return child_->AsyncReconcileTags(cq, std::move(context), options,
                                          request);
      },
      cq, std::move(context), options, request, __func__, tracing_options_);
}

StatusOr<google::cloud::datacatalog::v1::StarEntryResponse>
DataCatalogLogging::StarEntry(
    grpc::ClientContext& context,
    google::cloud::datacatalog::v1::StarEntryRequest const& request) {
  return google::cloud::internal::LogWrapper(
      [this](grpc::ClientContext& context,
             google::cloud::datacatalog::v1::StarEntryRequest const& request) {
        return child_->StarEntry(context, request);
      },
      context, request, __func__, tracing_options_);
}

StatusOr<google::cloud::datacatalog::v1::UnstarEntryResponse>
DataCatalogLogging::UnstarEntry(
    grpc::ClientContext& context,
    google::cloud::datacatalog::v1::UnstarEntryRequest const& request) {
  return google::cloud::internal::LogWrapper(
      [this](
          grpc::ClientContext& context,
          google::cloud::datacatalog::v1::UnstarEntryRequest const& request) {
        return child_->UnstarEntry(context, request);
      },
      context, request, __func__, tracing_options_);
}

StatusOr<google::iam::v1::Policy> DataCatalogLogging::SetIamPolicy(
    grpc::ClientContext& context,
    google::iam::v1::SetIamPolicyRequest const& request) {
  return google::cloud::internal::LogWrapper(
      [this](grpc::ClientContext& context,
             google::iam::v1::SetIamPolicyRequest const& request) {
        return child_->SetIamPolicy(context, request);
      },
      context, request, __func__, tracing_options_);
}

StatusOr<google::iam::v1::Policy> DataCatalogLogging::GetIamPolicy(
    grpc::ClientContext& context,
    google::iam::v1::GetIamPolicyRequest const& request) {
  return google::cloud::internal::LogWrapper(
      [this](grpc::ClientContext& context,
             google::iam::v1::GetIamPolicyRequest const& request) {
        return child_->GetIamPolicy(context, request);
      },
      context, request, __func__, tracing_options_);
}

StatusOr<google::iam::v1::TestIamPermissionsResponse>
DataCatalogLogging::TestIamPermissions(
    grpc::ClientContext& context,
    google::iam::v1::TestIamPermissionsRequest const& request) {
  return google::cloud::internal::LogWrapper(
      [this](grpc::ClientContext& context,
             google::iam::v1::TestIamPermissionsRequest const& request) {
        return child_->TestIamPermissions(context, request);
      },
      context, request, __func__, tracing_options_);
}

future<StatusOr<google::longrunning::Operation>>
DataCatalogLogging::AsyncImportEntries(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context, Options const& options,
    google::cloud::datacatalog::v1::ImportEntriesRequest const& request) {
  return google::cloud::internal::LogWrapper(
      [this](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context, Options const& options,
          google::cloud::datacatalog::v1::ImportEntriesRequest const& request) {
        return child_->AsyncImportEntries(cq, std::move(context), options,
                                          request);
      },
      cq, std::move(context), options, request, __func__, tracing_options_);
}

future<StatusOr<google::longrunning::Operation>>
DataCatalogLogging::AsyncGetOperation(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context, Options const& options,
    google::longrunning::GetOperationRequest const& request) {
  return google::cloud::internal::LogWrapper(
      [this](google::cloud::CompletionQueue& cq,
             std::shared_ptr<grpc::ClientContext> context,
             Options const& options,
             google::longrunning::GetOperationRequest const& request) {
        return child_->AsyncGetOperation(cq, std::move(context), options,
                                         request);
      },
      cq, std::move(context), options, request, __func__, tracing_options_);
}

future<Status> DataCatalogLogging::AsyncCancelOperation(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context, Options const& options,
    google::longrunning::CancelOperationRequest const& request) {
  return google::cloud::internal::LogWrapper(
      [this](google::cloud::CompletionQueue& cq,
             std::shared_ptr<grpc::ClientContext> context,
             Options const& options,
             google::longrunning::CancelOperationRequest const& request) {
        return child_->AsyncCancelOperation(cq, std::move(context), options,
                                            request);
      },
      cq, std::move(context), options, request, __func__, tracing_options_);
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace datacatalog_v1_internal
}  // namespace cloud
}  // namespace google
