// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/binaryauthorization/v1/service.proto

#include "google/cloud/binaryauthorization/v1/internal/binauthz_management_service_v1_auth_decorator.h"
#include <google/cloud/binaryauthorization/v1/service.grpc.pb.h>
#include <memory>

namespace google {
namespace cloud {
namespace binaryauthorization_v1_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

BinauthzManagementServiceV1Auth::BinauthzManagementServiceV1Auth(
    std::shared_ptr<google::cloud::internal::GrpcAuthenticationStrategy> auth,
    std::shared_ptr<BinauthzManagementServiceV1Stub> child)
    : auth_(std::move(auth)), child_(std::move(child)) {}

StatusOr<google::cloud::binaryauthorization::v1::Policy>
BinauthzManagementServiceV1Auth::GetPolicy(
    grpc::ClientContext& context,
    google::cloud::binaryauthorization::v1::GetPolicyRequest const& request) {
  auto status = auth_->ConfigureContext(context);
  if (!status.ok()) return status;
  return child_->GetPolicy(context, request);
}

StatusOr<google::cloud::binaryauthorization::v1::Policy>
BinauthzManagementServiceV1Auth::UpdatePolicy(
    grpc::ClientContext& context,
    google::cloud::binaryauthorization::v1::UpdatePolicyRequest const&
        request) {
  auto status = auth_->ConfigureContext(context);
  if (!status.ok()) return status;
  return child_->UpdatePolicy(context, request);
}

StatusOr<google::cloud::binaryauthorization::v1::Attestor>
BinauthzManagementServiceV1Auth::CreateAttestor(
    grpc::ClientContext& context,
    google::cloud::binaryauthorization::v1::CreateAttestorRequest const&
        request) {
  auto status = auth_->ConfigureContext(context);
  if (!status.ok()) return status;
  return child_->CreateAttestor(context, request);
}

StatusOr<google::cloud::binaryauthorization::v1::Attestor>
BinauthzManagementServiceV1Auth::GetAttestor(
    grpc::ClientContext& context,
    google::cloud::binaryauthorization::v1::GetAttestorRequest const& request) {
  auto status = auth_->ConfigureContext(context);
  if (!status.ok()) return status;
  return child_->GetAttestor(context, request);
}

StatusOr<google::cloud::binaryauthorization::v1::Attestor>
BinauthzManagementServiceV1Auth::UpdateAttestor(
    grpc::ClientContext& context,
    google::cloud::binaryauthorization::v1::UpdateAttestorRequest const&
        request) {
  auto status = auth_->ConfigureContext(context);
  if (!status.ok()) return status;
  return child_->UpdateAttestor(context, request);
}

StatusOr<google::cloud::binaryauthorization::v1::ListAttestorsResponse>
BinauthzManagementServiceV1Auth::ListAttestors(
    grpc::ClientContext& context,
    google::cloud::binaryauthorization::v1::ListAttestorsRequest const&
        request) {
  auto status = auth_->ConfigureContext(context);
  if (!status.ok()) return status;
  return child_->ListAttestors(context, request);
}

Status BinauthzManagementServiceV1Auth::DeleteAttestor(
    grpc::ClientContext& context,
    google::cloud::binaryauthorization::v1::DeleteAttestorRequest const&
        request) {
  auto status = auth_->ConfigureContext(context);
  if (!status.ok()) return status;
  return child_->DeleteAttestor(context, request);
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace binaryauthorization_v1_internal
}  // namespace cloud
}  // namespace google
