// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/billing/budgets/v1/budget_service.proto

#include "google/cloud/billing/budgets/v1/budget_client.h"
#include <memory>

namespace google {
namespace cloud {
namespace billing_budgets_v1 {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

BudgetServiceClient::BudgetServiceClient(
    std::shared_ptr<BudgetServiceConnection> connection, Options opts)
    : connection_(std::move(connection)),
      options_(
          internal::MergeOptions(std::move(opts), connection_->options())) {}
BudgetServiceClient::~BudgetServiceClient() = default;

StatusOr<google::cloud::billing::budgets::v1::Budget>
BudgetServiceClient::CreateBudget(
    std::string const& parent,
    google::cloud::billing::budgets::v1::Budget const& budget, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::billing::budgets::v1::CreateBudgetRequest request;
  request.set_parent(parent);
  *request.mutable_budget() = budget;
  return connection_->CreateBudget(request);
}

StatusOr<google::cloud::billing::budgets::v1::Budget>
BudgetServiceClient::CreateBudget(
    google::cloud::billing::budgets::v1::CreateBudgetRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->CreateBudget(request);
}

StatusOr<google::cloud::billing::budgets::v1::Budget>
BudgetServiceClient::UpdateBudget(
    google::cloud::billing::budgets::v1::Budget const& budget,
    google::protobuf::FieldMask const& update_mask, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::billing::budgets::v1::UpdateBudgetRequest request;
  *request.mutable_budget() = budget;
  *request.mutable_update_mask() = update_mask;
  return connection_->UpdateBudget(request);
}

StatusOr<google::cloud::billing::budgets::v1::Budget>
BudgetServiceClient::UpdateBudget(
    google::cloud::billing::budgets::v1::UpdateBudgetRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->UpdateBudget(request);
}

StatusOr<google::cloud::billing::budgets::v1::Budget>
BudgetServiceClient::GetBudget(std::string const& name, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::billing::budgets::v1::GetBudgetRequest request;
  request.set_name(name);
  return connection_->GetBudget(request);
}

StatusOr<google::cloud::billing::budgets::v1::Budget>
BudgetServiceClient::GetBudget(
    google::cloud::billing::budgets::v1::GetBudgetRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->GetBudget(request);
}

StreamRange<google::cloud::billing::budgets::v1::Budget>
BudgetServiceClient::ListBudgets(std::string const& parent, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::billing::budgets::v1::ListBudgetsRequest request;
  request.set_parent(parent);
  return connection_->ListBudgets(request);
}

StreamRange<google::cloud::billing::budgets::v1::Budget>
BudgetServiceClient::ListBudgets(
    google::cloud::billing::budgets::v1::ListBudgetsRequest request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->ListBudgets(std::move(request));
}

Status BudgetServiceClient::DeleteBudget(std::string const& name,
                                         Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::billing::budgets::v1::DeleteBudgetRequest request;
  request.set_name(name);
  return connection_->DeleteBudget(request);
}

Status BudgetServiceClient::DeleteBudget(
    google::cloud::billing::budgets::v1::DeleteBudgetRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->DeleteBudget(request);
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace billing_budgets_v1
}  // namespace cloud
}  // namespace google
