// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/asset/v1/asset_service.proto

#ifndef GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_ASSET_V1_ASSET_CLIENT_H
#define GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_ASSET_V1_ASSET_CLIENT_H

#include "google/cloud/asset/v1/asset_connection.h"
#include "google/cloud/future.h"
#include "google/cloud/options.h"
#include "google/cloud/polling_policy.h"
#include "google/cloud/status_or.h"
#include "google/cloud/version.h"
#include <google/longrunning/operations.grpc.pb.h>
#include <map>
#include <memory>

namespace google {
namespace cloud {
namespace asset_v1 {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

///
/// Asset service definition.
///
/// @par Equality
///
/// Instances of this class created via copy-construction or copy-assignment
/// always compare equal. Instances created with equal
/// `std::shared_ptr<*Connection>` objects compare equal. Objects that compare
/// equal share the same underlying resources.
///
/// @par Performance
///
/// Creating a new instance of this class is a relatively expensive operation,
/// new objects establish new connections to the service. In contrast,
/// copy-construction, move-construction, and the corresponding assignment
/// operations are relatively efficient as the copies share all underlying
/// resources.
///
/// @par Thread Safety
///
/// Concurrent access to different instances of this class, even if they compare
/// equal, is guaranteed to work. Two or more threads operating on the same
/// instance of this class is not guaranteed to work. Since copy-construction
/// and move-construction is a relatively efficient operation, consider using
/// such a copy when using this class from multiple threads.
///
class AssetServiceClient {
 public:
  explicit AssetServiceClient(
      std::shared_ptr<AssetServiceConnection> connection, Options opts = {});
  ~AssetServiceClient();

  ///@{
  /// @name Copy and move support
  AssetServiceClient(AssetServiceClient const&) = default;
  AssetServiceClient& operator=(AssetServiceClient const&) = default;
  AssetServiceClient(AssetServiceClient&&) = default;
  AssetServiceClient& operator=(AssetServiceClient&&) = default;
  ///@}

  ///@{
  /// @name Equality
  friend bool operator==(AssetServiceClient const& a,
                         AssetServiceClient const& b) {
    return a.connection_ == b.connection_;
  }
  friend bool operator!=(AssetServiceClient const& a,
                         AssetServiceClient const& b) {
    return !(a == b);
  }
  ///@}

  // clang-format off
  ///
  /// Exports assets with time and resource types to a given Cloud Storage
  /// location/BigQuery table. For Cloud Storage location destinations, the
  /// output format is newline-delimited JSON. Each line represents a
  /// [google.cloud.asset.v1.Asset][google.cloud.asset.v1.Asset] in the JSON
  /// format; for BigQuery table destinations, the output table stores the fields
  /// in asset Protobuf as columns. This API implements the
  /// [google.longrunning.Operation][google.longrunning.Operation] API, which
  /// allows you to keep track of the export. We recommend intervals of at least
  /// 2 seconds with exponential retry to poll the export operation result. For
  /// regular-size resource parent, the export operation usually finishes within
  /// 5 minutes.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.asset.v1.ExportAssetsRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.asset.v1.ExportAssetsResponse] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.asset.v1.Asset]: @googleapis_reference_link{google/cloud/asset/v1/assets.proto#L96}
  /// [google.cloud.asset.v1.ExportAssetsRequest]: @googleapis_reference_link{google/cloud/asset/v1/asset_service.proto#L329}
  /// [google.cloud.asset.v1.ExportAssetsResponse]: @googleapis_reference_link{google/cloud/asset/v1/asset_service.proto#L399}
  /// [google.longrunning.Operation]: @googleapis_reference_link{google/longrunning/operations.proto#L128}
  ///
  // clang-format on
  future<StatusOr<google::cloud::asset::v1::ExportAssetsResponse>> ExportAssets(
      google::cloud::asset::v1::ExportAssetsRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// Lists assets with time and resource types and returns paged results in
  /// response.
  ///
  /// @param parent  Required. Name of the organization, folder, or project the assets belong
  ///  to. Format: "organizations/[organization-number]" (such as
  ///  "organizations/123"), "projects/[project-id]" (such as
  ///  "projects/my-project-id"), "projects/[project-number]" (such as
  ///  "projects/12345"), or "folders/[folder-number]" (such as "folders/12345").
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [StreamRange](@ref google::cloud::StreamRange)
  ///     to iterate of the results. See the documentation of this type for
  ///     details. In brief, this class has `begin()` and `end()` member
  ///     functions returning a iterator class meeting the
  ///     [input iterator requirements]. The value type for this iterator is a
  ///     [`StatusOr`] as the iteration may fail even after some values are
  ///     retrieved successfully, for example, if there is a network disconnect.
  ///     An empty set of results does not indicate an error, it indicates
  ///     that there are no resources meeting the request criteria.
  ///     On a successful iteration the `StatusOr<T>` contains elements of type
  ///     [google.cloud.asset.v1.Asset], or rather,
  ///     the C++ class generated by Protobuf from that type. Please consult the
  ///     Protobuf documentation for details on the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.asset.v1.Asset]: @googleapis_reference_link{google/cloud/asset/v1/assets.proto#L96}
  /// [google.cloud.asset.v1.ListAssetsRequest]: @googleapis_reference_link{google/cloud/asset/v1/asset_service.proto#L415}
  ///
  // clang-format on
  StreamRange<google::cloud::asset::v1::Asset> ListAssets(
      std::string const& parent, Options opts = {});

  // clang-format off
  ///
  /// Lists assets with time and resource types and returns paged results in
  /// response.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.asset.v1.ListAssetsRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [StreamRange](@ref google::cloud::StreamRange)
  ///     to iterate of the results. See the documentation of this type for
  ///     details. In brief, this class has `begin()` and `end()` member
  ///     functions returning a iterator class meeting the
  ///     [input iterator requirements]. The value type for this iterator is a
  ///     [`StatusOr`] as the iteration may fail even after some values are
  ///     retrieved successfully, for example, if there is a network disconnect.
  ///     An empty set of results does not indicate an error, it indicates
  ///     that there are no resources meeting the request criteria.
  ///     On a successful iteration the `StatusOr<T>` contains elements of type
  ///     [google.cloud.asset.v1.Asset], or rather,
  ///     the C++ class generated by Protobuf from that type. Please consult the
  ///     Protobuf documentation for details on the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.asset.v1.Asset]: @googleapis_reference_link{google/cloud/asset/v1/assets.proto#L96}
  /// [google.cloud.asset.v1.ListAssetsRequest]: @googleapis_reference_link{google/cloud/asset/v1/asset_service.proto#L415}
  ///
  // clang-format on
  StreamRange<google::cloud::asset::v1::Asset> ListAssets(
      google::cloud::asset::v1::ListAssetsRequest request, Options opts = {});

  // clang-format off
  ///
  /// Batch gets the update history of assets that overlap a time window.
  /// For IAM_POLICY content, this API outputs history when the asset and its
  /// attached IAM POLICY both exist. This can create gaps in the output history.
  /// Otherwise, this API outputs history with asset in both non-delete or
  /// deleted status.
  /// If a specified asset does not exist, this API returns an INVALID_ARGUMENT
  /// error.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.asset.v1.BatchGetAssetsHistoryRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.asset.v1.BatchGetAssetsHistoryResponse])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.asset.v1.BatchGetAssetsHistoryRequest]: @googleapis_reference_link{google/cloud/asset/v1/asset_service.proto#L501}
  /// [google.cloud.asset.v1.BatchGetAssetsHistoryResponse]: @googleapis_reference_link{google/cloud/asset/v1/asset_service.proto#L554}
  ///
  // clang-format on
  StatusOr<google::cloud::asset::v1::BatchGetAssetsHistoryResponse>
  BatchGetAssetsHistory(
      google::cloud::asset::v1::BatchGetAssetsHistoryRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// Creates a feed in a parent project/folder/organization to listen to its
  /// asset updates.
  ///
  /// @param parent  Required. The name of the project/folder/organization where this feed
  ///  should be created in. It can only be an organization number (such as
  ///  "organizations/123"), a folder number (such as "folders/123"), a project ID
  ///  (such as "projects/my-project-id"), or a project number (such as
  ///  "projects/12345").
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.asset.v1.Feed])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.asset.v1.CreateFeedRequest]: @googleapis_reference_link{google/cloud/asset/v1/asset_service.proto#L560}
  /// [google.cloud.asset.v1.Feed]: @googleapis_reference_link{google/cloud/asset/v1/asset_service.proto#L810}
  ///
  // clang-format on
  StatusOr<google::cloud::asset::v1::Feed> CreateFeed(std::string const& parent,
                                                      Options opts = {});

  // clang-format off
  ///
  /// Creates a feed in a parent project/folder/organization to listen to its
  /// asset updates.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.asset.v1.CreateFeedRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.asset.v1.Feed])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.asset.v1.CreateFeedRequest]: @googleapis_reference_link{google/cloud/asset/v1/asset_service.proto#L560}
  /// [google.cloud.asset.v1.Feed]: @googleapis_reference_link{google/cloud/asset/v1/asset_service.proto#L810}
  ///
  // clang-format on
  StatusOr<google::cloud::asset::v1::Feed> CreateFeed(
      google::cloud::asset::v1::CreateFeedRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// Gets details about an asset feed.
  ///
  /// @param name  Required. The name of the Feed and it must be in the format of:
  ///  projects/project_number/feeds/feed_id
  ///  folders/folder_number/feeds/feed_id
  ///  organizations/organization_number/feeds/feed_id
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.asset.v1.Feed])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.asset.v1.Feed]: @googleapis_reference_link{google/cloud/asset/v1/asset_service.proto#L810}
  /// [google.cloud.asset.v1.GetFeedRequest]: @googleapis_reference_link{google/cloud/asset/v1/asset_service.proto#L580}
  ///
  // clang-format on
  StatusOr<google::cloud::asset::v1::Feed> GetFeed(std::string const& name,
                                                   Options opts = {});

  // clang-format off
  ///
  /// Gets details about an asset feed.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.asset.v1.GetFeedRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.asset.v1.Feed])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.asset.v1.Feed]: @googleapis_reference_link{google/cloud/asset/v1/asset_service.proto#L810}
  /// [google.cloud.asset.v1.GetFeedRequest]: @googleapis_reference_link{google/cloud/asset/v1/asset_service.proto#L580}
  ///
  // clang-format on
  StatusOr<google::cloud::asset::v1::Feed> GetFeed(
      google::cloud::asset::v1::GetFeedRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// Lists all asset feeds in a parent project/folder/organization.
  ///
  /// @param parent  Required. The parent project/folder/organization whose feeds are to be
  ///  listed. It can only be using project/folder/organization number (such as
  ///  "folders/12345"), or a project ID (such as "projects/my-project-id").
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.asset.v1.ListFeedsResponse])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.asset.v1.ListFeedsRequest]: @googleapis_reference_link{google/cloud/asset/v1/asset_service.proto#L592}
  /// [google.cloud.asset.v1.ListFeedsResponse]: @googleapis_reference_link{google/cloud/asset/v1/asset_service.proto#L599}
  ///
  // clang-format on
  StatusOr<google::cloud::asset::v1::ListFeedsResponse> ListFeeds(
      std::string const& parent, Options opts = {});

  // clang-format off
  ///
  /// Lists all asset feeds in a parent project/folder/organization.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.asset.v1.ListFeedsRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.asset.v1.ListFeedsResponse])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.asset.v1.ListFeedsRequest]: @googleapis_reference_link{google/cloud/asset/v1/asset_service.proto#L592}
  /// [google.cloud.asset.v1.ListFeedsResponse]: @googleapis_reference_link{google/cloud/asset/v1/asset_service.proto#L599}
  ///
  // clang-format on
  StatusOr<google::cloud::asset::v1::ListFeedsResponse> ListFeeds(
      google::cloud::asset::v1::ListFeedsRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// Updates an asset feed configuration.
  ///
  /// @param feed  Required. The new values of feed details. It must match an existing feed
  ///  and the field `name` must be in the format of:
  ///  projects/project_number/feeds/feed_id or
  ///  folders/folder_number/feeds/feed_id or
  ///  organizations/organization_number/feeds/feed_id.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.asset.v1.Feed])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.asset.v1.Feed]: @googleapis_reference_link{google/cloud/asset/v1/asset_service.proto#L810}
  /// [google.cloud.asset.v1.UpdateFeedRequest]: @googleapis_reference_link{google/cloud/asset/v1/asset_service.proto#L605}
  ///
  // clang-format on
  StatusOr<google::cloud::asset::v1::Feed> UpdateFeed(
      google::cloud::asset::v1::Feed const& feed, Options opts = {});

  // clang-format off
  ///
  /// Updates an asset feed configuration.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.asset.v1.UpdateFeedRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.asset.v1.Feed])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.asset.v1.Feed]: @googleapis_reference_link{google/cloud/asset/v1/asset_service.proto#L810}
  /// [google.cloud.asset.v1.UpdateFeedRequest]: @googleapis_reference_link{google/cloud/asset/v1/asset_service.proto#L605}
  ///
  // clang-format on
  StatusOr<google::cloud::asset::v1::Feed> UpdateFeed(
      google::cloud::asset::v1::UpdateFeedRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// Deletes an asset feed.
  ///
  /// @param name  Required. The name of the feed and it must be in the format of:
  ///  projects/project_number/feeds/feed_id
  ///  folders/folder_number/feeds/feed_id
  ///  organizations/organization_number/feeds/feed_id
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [`Status`] object. If the request failed, the
  ///     status contains the details of the failure.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.asset.v1.DeleteFeedRequest]: @googleapis_reference_link{google/cloud/asset/v1/asset_service.proto#L620}
  ///
  // clang-format on
  Status DeleteFeed(std::string const& name, Options opts = {});

  // clang-format off
  ///
  /// Deletes an asset feed.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.asset.v1.DeleteFeedRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [`Status`] object. If the request failed, the
  ///     status contains the details of the failure.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.asset.v1.DeleteFeedRequest]: @googleapis_reference_link{google/cloud/asset/v1/asset_service.proto#L620}
  ///
  // clang-format on
  Status DeleteFeed(google::cloud::asset::v1::DeleteFeedRequest const& request,
                    Options opts = {});

  // clang-format off
  ///
  /// Searches all Google Cloud resources within the specified scope, such as a
  /// project, folder, or organization. The caller must be granted the
  /// `cloudasset.assets.searchAllResources` permission on the desired scope,
  /// otherwise the request will be rejected.
  ///
  /// @param scope  Required. A scope can be a project, a folder, or an organization. The
  ///  search is limited to the resources within the `scope`. The caller must be
  ///  granted the
  ///  [`cloudasset.assets.searchAllResources`](https://cloud.google.com/asset-inventory/docs/access-control#required_permissions)
  ///  permission on the desired scope.
  ///  @n
  ///  The allowed values are:
  ///  @n
  ///  * projects/{PROJECT_ID} (e.g., "projects/foo-bar")
  ///  * projects/{PROJECT_NUMBER} (e.g., "projects/12345678")
  ///  * folders/{FOLDER_NUMBER} (e.g., "folders/1234567")
  ///  * organizations/{ORGANIZATION_NUMBER} (e.g., "organizations/123456")
  /// @param query  Optional. The query statement. See [how to construct a
  ///  query](https://cloud.google.com/asset-inventory/docs/searching-resources#how_to_construct_a_query)
  ///  for more information. If not specified or empty, it will search all the
  ///  resources within the specified `scope`.
  ///  @n
  ///  For more information, see [SearchAllResourcesRequest][google.cloud.asset.v1.SearchAllResourcesRequest].
  /// @param asset_types  Optional. A list of asset types that this request searches for. If empty,
  ///  it will search all the [searchable asset
  ///  types](https://cloud.google.com/asset-inventory/docs/supported-asset-types#searchable_asset_types).
  ///  @n
  ///  Regular expressions are also supported. For example:
  ///  @n
  ///  * "compute.googleapis.com.*" snapshots resources whose asset type starts
  ///  with "compute.googleapis.com".
  ///  * ".*Instance" snapshots resources whose asset type ends with "Instance".
  ///  * ".*Instance.*" snapshots resources whose asset type contains "Instance".
  ///  @n
  ///  See [RE2](https://github.com/google/re2/wiki/Syntax) for all supported
  ///  regular expression syntax. If the regular expression does not match any
  ///  supported asset type, an INVALID_ARGUMENT error will be returned.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [StreamRange](@ref google::cloud::StreamRange)
  ///     to iterate of the results. See the documentation of this type for
  ///     details. In brief, this class has `begin()` and `end()` member
  ///     functions returning a iterator class meeting the
  ///     [input iterator requirements]. The value type for this iterator is a
  ///     [`StatusOr`] as the iteration may fail even after some values are
  ///     retrieved successfully, for example, if there is a network disconnect.
  ///     An empty set of results does not indicate an error, it indicates
  ///     that there are no resources meeting the request criteria.
  ///     On a successful iteration the `StatusOr<T>` contains elements of type
  ///     [google.cloud.asset.v1.ResourceSearchResult], or rather,
  ///     the C++ class generated by Protobuf from that type. Please consult the
  ///     Protobuf documentation for details on the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.asset.v1.ResourceSearchResult]: @googleapis_reference_link{google/cloud/asset/v1/assets.proto#L345}
  /// [google.cloud.asset.v1.SearchAllResourcesRequest]: @googleapis_reference_link{google/cloud/asset/v1/asset_service.proto#L889}
  ///
  // clang-format on
  StreamRange<google::cloud::asset::v1::ResourceSearchResult>
  SearchAllResources(std::string const& scope, std::string const& query,
                     std::vector<std::string> const& asset_types,
                     Options opts = {});

  // clang-format off
  ///
  /// Searches all Google Cloud resources within the specified scope, such as a
  /// project, folder, or organization. The caller must be granted the
  /// `cloudasset.assets.searchAllResources` permission on the desired scope,
  /// otherwise the request will be rejected.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.asset.v1.SearchAllResourcesRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [StreamRange](@ref google::cloud::StreamRange)
  ///     to iterate of the results. See the documentation of this type for
  ///     details. In brief, this class has `begin()` and `end()` member
  ///     functions returning a iterator class meeting the
  ///     [input iterator requirements]. The value type for this iterator is a
  ///     [`StatusOr`] as the iteration may fail even after some values are
  ///     retrieved successfully, for example, if there is a network disconnect.
  ///     An empty set of results does not indicate an error, it indicates
  ///     that there are no resources meeting the request criteria.
  ///     On a successful iteration the `StatusOr<T>` contains elements of type
  ///     [google.cloud.asset.v1.ResourceSearchResult], or rather,
  ///     the C++ class generated by Protobuf from that type. Please consult the
  ///     Protobuf documentation for details on the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.asset.v1.ResourceSearchResult]: @googleapis_reference_link{google/cloud/asset/v1/assets.proto#L345}
  /// [google.cloud.asset.v1.SearchAllResourcesRequest]: @googleapis_reference_link{google/cloud/asset/v1/asset_service.proto#L889}
  ///
  // clang-format on
  StreamRange<google::cloud::asset::v1::ResourceSearchResult>
  SearchAllResources(
      google::cloud::asset::v1::SearchAllResourcesRequest request,
      Options opts = {});

  // clang-format off
  ///
  /// Searches all IAM policies within the specified scope, such as a project,
  /// folder, or organization. The caller must be granted the
  /// `cloudasset.assets.searchAllIamPolicies` permission on the desired scope,
  /// otherwise the request will be rejected.
  ///
  /// @param scope  Required. A scope can be a project, a folder, or an organization. The
  ///  search is limited to the IAM policies within the `scope`. The caller must
  ///  be granted the
  ///  [`cloudasset.assets.searchAllIamPolicies`](https://cloud.google.com/asset-inventory/docs/access-control#required_permissions)
  ///  permission on the desired scope.
  ///  @n
  ///  The allowed values are:
  ///  @n
  ///  * projects/{PROJECT_ID} (e.g., "projects/foo-bar")
  ///  * projects/{PROJECT_NUMBER} (e.g., "projects/12345678")
  ///  * folders/{FOLDER_NUMBER} (e.g., "folders/1234567")
  ///  * organizations/{ORGANIZATION_NUMBER} (e.g., "organizations/123456")
  /// @param query  Optional. The query statement. See [how to construct a
  ///  query](https://cloud.google.com/asset-inventory/docs/searching-iam-policies#how_to_construct_a_query)
  ///  for more information. If not specified or empty, it will search all the
  ///  IAM policies within the specified `scope`. Note that the query string is
  ///  compared against each IAM policy binding, including its principals,
  ///  roles, and IAM conditions. The returned IAM policies will only
  ///  contain the bindings that match your query. To learn more about the IAM
  ///  policy structure, see the [IAM policy
  ///  documentation](https://cloud.google.com/iam/help/allow-policies/structure).
  ///  @n
  ///  For more information, see [SearchAllIamPoliciesRequest][google.cloud.asset.v1.SearchAllIamPoliciesRequest].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [StreamRange](@ref google::cloud::StreamRange)
  ///     to iterate of the results. See the documentation of this type for
  ///     details. In brief, this class has `begin()` and `end()` member
  ///     functions returning a iterator class meeting the
  ///     [input iterator requirements]. The value type for this iterator is a
  ///     [`StatusOr`] as the iteration may fail even after some values are
  ///     retrieved successfully, for example, if there is a network disconnect.
  ///     An empty set of results does not indicate an error, it indicates
  ///     that there are no resources meeting the request criteria.
  ///     On a successful iteration the `StatusOr<T>` contains elements of type
  ///     [google.cloud.asset.v1.IamPolicySearchResult], or rather,
  ///     the C++ class generated by Protobuf from that type. Please consult the
  ///     Protobuf documentation for details on the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.asset.v1.IamPolicySearchResult]: @googleapis_reference_link{google/cloud/asset/v1/assets.proto#L760}
  /// [google.cloud.asset.v1.SearchAllIamPoliciesRequest]: @googleapis_reference_link{google/cloud/asset/v1/asset_service.proto#L1078}
  ///
  // clang-format on
  StreamRange<google::cloud::asset::v1::IamPolicySearchResult>
  SearchAllIamPolicies(std::string const& scope, std::string const& query,
                       Options opts = {});

  // clang-format off
  ///
  /// Searches all IAM policies within the specified scope, such as a project,
  /// folder, or organization. The caller must be granted the
  /// `cloudasset.assets.searchAllIamPolicies` permission on the desired scope,
  /// otherwise the request will be rejected.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.asset.v1.SearchAllIamPoliciesRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [StreamRange](@ref google::cloud::StreamRange)
  ///     to iterate of the results. See the documentation of this type for
  ///     details. In brief, this class has `begin()` and `end()` member
  ///     functions returning a iterator class meeting the
  ///     [input iterator requirements]. The value type for this iterator is a
  ///     [`StatusOr`] as the iteration may fail even after some values are
  ///     retrieved successfully, for example, if there is a network disconnect.
  ///     An empty set of results does not indicate an error, it indicates
  ///     that there are no resources meeting the request criteria.
  ///     On a successful iteration the `StatusOr<T>` contains elements of type
  ///     [google.cloud.asset.v1.IamPolicySearchResult], or rather,
  ///     the C++ class generated by Protobuf from that type. Please consult the
  ///     Protobuf documentation for details on the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.asset.v1.IamPolicySearchResult]: @googleapis_reference_link{google/cloud/asset/v1/assets.proto#L760}
  /// [google.cloud.asset.v1.SearchAllIamPoliciesRequest]: @googleapis_reference_link{google/cloud/asset/v1/asset_service.proto#L1078}
  ///
  // clang-format on
  StreamRange<google::cloud::asset::v1::IamPolicySearchResult>
  SearchAllIamPolicies(
      google::cloud::asset::v1::SearchAllIamPoliciesRequest request,
      Options opts = {});

  // clang-format off
  ///
  /// Analyzes IAM policies to answer which identities have what accesses on
  /// which resources.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.asset.v1.AnalyzeIamPolicyRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.asset.v1.AnalyzeIamPolicyResponse])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.asset.v1.AnalyzeIamPolicyRequest]: @googleapis_reference_link{google/cloud/asset/v1/asset_service.proto#L1389}
  /// [google.cloud.asset.v1.AnalyzeIamPolicyResponse]: @googleapis_reference_link{google/cloud/asset/v1/asset_service.proto#L1429}
  ///
  // clang-format on
  StatusOr<google::cloud::asset::v1::AnalyzeIamPolicyResponse> AnalyzeIamPolicy(
      google::cloud::asset::v1::AnalyzeIamPolicyRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// Analyzes IAM policies asynchronously to answer which identities have what
  /// accesses on which resources, and writes the analysis results to a Google
  /// Cloud Storage or a BigQuery destination. For Cloud Storage destination, the
  /// output format is the JSON format that represents a
  /// [AnalyzeIamPolicyResponse][google.cloud.asset.v1.AnalyzeIamPolicyResponse].
  /// This method implements the
  /// [google.longrunning.Operation][google.longrunning.Operation], which allows
  /// you to track the operation status. We recommend intervals of at least 2
  /// seconds with exponential backoff retry to poll the operation result. The
  /// metadata contains the metadata for the long-running operation.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.asset.v1.AnalyzeIamPolicyLongrunningRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.asset.v1.AnalyzeIamPolicyLongrunningResponse] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.asset.v1.AnalyzeIamPolicyLongrunningRequest]: @googleapis_reference_link{google/cloud/asset/v1/asset_service.proto#L1545}
  /// [google.cloud.asset.v1.AnalyzeIamPolicyLongrunningResponse]: @googleapis_reference_link{google/cloud/asset/v1/asset_service.proto#L1576}
  /// [google.cloud.asset.v1.AnalyzeIamPolicyResponse]: @googleapis_reference_link{google/cloud/asset/v1/asset_service.proto#L1429}
  /// [google.longrunning.Operation]: @googleapis_reference_link{google/longrunning/operations.proto#L128}
  ///
  // clang-format on
  future<
      StatusOr<google::cloud::asset::v1::AnalyzeIamPolicyLongrunningResponse>>
  AnalyzeIamPolicyLongrunning(
      google::cloud::asset::v1::AnalyzeIamPolicyLongrunningRequest const&
          request,
      Options opts = {});

  // clang-format off
  ///
  /// Analyze moving a resource to a specified destination without kicking off
  /// the actual move. The analysis is best effort depending on the user's
  /// permissions of viewing different hierarchical policies and configurations.
  /// The policies and configuration are subject to change before the actual
  /// resource migration takes place.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.asset.v1.AnalyzeMoveRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.asset.v1.AnalyzeMoveResponse])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.asset.v1.AnalyzeMoveRequest]: @googleapis_reference_link{google/cloud/asset/v1/asset_service.proto#L1759}
  /// [google.cloud.asset.v1.AnalyzeMoveResponse]: @googleapis_reference_link{google/cloud/asset/v1/asset_service.proto#L1794}
  ///
  // clang-format on
  StatusOr<google::cloud::asset::v1::AnalyzeMoveResponse> AnalyzeMove(
      google::cloud::asset::v1::AnalyzeMoveRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// Issue a job that queries assets using a SQL statement compatible with
  /// [BigQuery SQL](https://cloud.google.com/bigquery/docs/introduction-sql).
  ///
  /// If the query execution finishes within timeout and there's no pagination,
  /// the full query results will be returned in the `QueryAssetsResponse`.
  ///
  /// Otherwise, full query results can be obtained by issuing extra requests
  /// with the `job_reference` from the a previous `QueryAssets` call.
  ///
  /// Note, the query result has approximately 10 GB limitation enforced by
  /// [BigQuery](https://cloud.google.com/bigquery/docs/best-practices-performance-output).
  /// Queries return larger results will result in errors.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.asset.v1.QueryAssetsRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.asset.v1.QueryAssetsResponse])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.asset.v1.QueryAssetsRequest]: @googleapis_reference_link{google/cloud/asset/v1/asset_service.proto#L1865}
  /// [google.cloud.asset.v1.QueryAssetsResponse]: @googleapis_reference_link{google/cloud/asset/v1/asset_service.proto#L1951}
  ///
  // clang-format on
  StatusOr<google::cloud::asset::v1::QueryAssetsResponse> QueryAssets(
      google::cloud::asset::v1::QueryAssetsRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// Creates a saved query in a parent project/folder/organization.
  ///
  /// @param parent  Required. The name of the project/folder/organization where this
  ///  saved_query should be created in. It can only be an organization number
  ///  (such as "organizations/123"), a folder number (such as "folders/123"), a
  ///  project ID (such as "projects/my-project-id"), or a project number (such as
  ///  "projects/12345").
  /// @param saved_query  Required. The saved_query details. The `name` field must be empty as it
  ///  will be generated based on the parent and saved_query_id.
  /// @param saved_query_id  Required. The ID to use for the saved query, which must be unique in the
  ///  specified parent. It will become the final component of the saved query's
  ///  resource name.
  ///  @n
  ///  This value should be 4-63 characters, and valid characters
  ///  are `[a-z][0-9]-`.
  ///  @n
  ///  Notice that this field is required in the saved query creation, and the
  ///  `name` field of the `saved_query` will be ignored.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.asset.v1.SavedQuery])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.asset.v1.CreateSavedQueryRequest]: @googleapis_reference_link{google/cloud/asset/v1/asset_service.proto#L1636}
  /// [google.cloud.asset.v1.SavedQuery]: @googleapis_reference_link{google/cloud/asset/v1/asset_service.proto#L1579}
  ///
  // clang-format on
  StatusOr<google::cloud::asset::v1::SavedQuery> CreateSavedQuery(
      std::string const& parent,
      google::cloud::asset::v1::SavedQuery const& saved_query,
      std::string const& saved_query_id, Options opts = {});

  // clang-format off
  ///
  /// Creates a saved query in a parent project/folder/organization.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.asset.v1.CreateSavedQueryRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.asset.v1.SavedQuery])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.asset.v1.CreateSavedQueryRequest]: @googleapis_reference_link{google/cloud/asset/v1/asset_service.proto#L1636}
  /// [google.cloud.asset.v1.SavedQuery]: @googleapis_reference_link{google/cloud/asset/v1/asset_service.proto#L1579}
  ///
  // clang-format on
  StatusOr<google::cloud::asset::v1::SavedQuery> CreateSavedQuery(
      google::cloud::asset::v1::CreateSavedQueryRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// Gets details about a saved query.
  ///
  /// @param name  Required. The name of the saved query and it must be in the format of:
  ///  @n
  ///  * projects/project_number/savedQueries/saved_query_id
  ///  * folders/folder_number/savedQueries/saved_query_id
  ///  * organizations/organization_number/savedQueries/saved_query_id
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.asset.v1.SavedQuery])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.asset.v1.GetSavedQueryRequest]: @googleapis_reference_link{google/cloud/asset/v1/asset_service.proto#L1666}
  /// [google.cloud.asset.v1.SavedQuery]: @googleapis_reference_link{google/cloud/asset/v1/asset_service.proto#L1579}
  ///
  // clang-format on
  StatusOr<google::cloud::asset::v1::SavedQuery> GetSavedQuery(
      std::string const& name, Options opts = {});

  // clang-format off
  ///
  /// Gets details about a saved query.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.asset.v1.GetSavedQueryRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.asset.v1.SavedQuery])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.asset.v1.GetSavedQueryRequest]: @googleapis_reference_link{google/cloud/asset/v1/asset_service.proto#L1666}
  /// [google.cloud.asset.v1.SavedQuery]: @googleapis_reference_link{google/cloud/asset/v1/asset_service.proto#L1579}
  ///
  // clang-format on
  StatusOr<google::cloud::asset::v1::SavedQuery> GetSavedQuery(
      google::cloud::asset::v1::GetSavedQueryRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// Lists all saved queries in a parent project/folder/organization.
  ///
  /// @param parent  Required. The parent project/folder/organization whose savedQueries are to
  ///  be listed. It can only be using project/folder/organization number (such as
  ///  "folders/12345"), or a project ID (such as "projects/my-project-id").
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [StreamRange](@ref google::cloud::StreamRange)
  ///     to iterate of the results. See the documentation of this type for
  ///     details. In brief, this class has `begin()` and `end()` member
  ///     functions returning a iterator class meeting the
  ///     [input iterator requirements]. The value type for this iterator is a
  ///     [`StatusOr`] as the iteration may fail even after some values are
  ///     retrieved successfully, for example, if there is a network disconnect.
  ///     An empty set of results does not indicate an error, it indicates
  ///     that there are no resources meeting the request criteria.
  ///     On a successful iteration the `StatusOr<T>` contains elements of type
  ///     [google.cloud.asset.v1.SavedQuery], or rather,
  ///     the C++ class generated by Protobuf from that type. Please consult the
  ///     Protobuf documentation for details on the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.asset.v1.ListSavedQueriesRequest]: @googleapis_reference_link{google/cloud/asset/v1/asset_service.proto#L1681}
  /// [google.cloud.asset.v1.SavedQuery]: @googleapis_reference_link{google/cloud/asset/v1/asset_service.proto#L1579}
  ///
  // clang-format on
  StreamRange<google::cloud::asset::v1::SavedQuery> ListSavedQueries(
      std::string const& parent, Options opts = {});

  // clang-format off
  ///
  /// Lists all saved queries in a parent project/folder/organization.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.asset.v1.ListSavedQueriesRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [StreamRange](@ref google::cloud::StreamRange)
  ///     to iterate of the results. See the documentation of this type for
  ///     details. In brief, this class has `begin()` and `end()` member
  ///     functions returning a iterator class meeting the
  ///     [input iterator requirements]. The value type for this iterator is a
  ///     [`StatusOr`] as the iteration may fail even after some values are
  ///     retrieved successfully, for example, if there is a network disconnect.
  ///     An empty set of results does not indicate an error, it indicates
  ///     that there are no resources meeting the request criteria.
  ///     On a successful iteration the `StatusOr<T>` contains elements of type
  ///     [google.cloud.asset.v1.SavedQuery], or rather,
  ///     the C++ class generated by Protobuf from that type. Please consult the
  ///     Protobuf documentation for details on the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.asset.v1.ListSavedQueriesRequest]: @googleapis_reference_link{google/cloud/asset/v1/asset_service.proto#L1681}
  /// [google.cloud.asset.v1.SavedQuery]: @googleapis_reference_link{google/cloud/asset/v1/asset_service.proto#L1579}
  ///
  // clang-format on
  StreamRange<google::cloud::asset::v1::SavedQuery> ListSavedQueries(
      google::cloud::asset::v1::ListSavedQueriesRequest request,
      Options opts = {});

  // clang-format off
  ///
  /// Updates a saved query.
  ///
  /// @param saved_query  Required. The saved query to update.
  ///  @n
  ///  The saved query's `name` field is used to identify the one to update,
  ///  which has format as below:
  ///  @n
  ///  * projects/project_number/savedQueries/saved_query_id
  ///  * folders/folder_number/savedQueries/saved_query_id
  ///  * organizations/organization_number/savedQueries/saved_query_id
  /// @param update_mask  Required. The list of fields to update.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.asset.v1.SavedQuery])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.asset.v1.SavedQuery]: @googleapis_reference_link{google/cloud/asset/v1/asset_service.proto#L1579}
  /// [google.cloud.asset.v1.UpdateSavedQueryRequest]: @googleapis_reference_link{google/cloud/asset/v1/asset_service.proto#L1726}
  ///
  // clang-format on
  StatusOr<google::cloud::asset::v1::SavedQuery> UpdateSavedQuery(
      google::cloud::asset::v1::SavedQuery const& saved_query,
      google::protobuf::FieldMask const& update_mask, Options opts = {});

  // clang-format off
  ///
  /// Updates a saved query.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.asset.v1.UpdateSavedQueryRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.asset.v1.SavedQuery])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.asset.v1.SavedQuery]: @googleapis_reference_link{google/cloud/asset/v1/asset_service.proto#L1579}
  /// [google.cloud.asset.v1.UpdateSavedQueryRequest]: @googleapis_reference_link{google/cloud/asset/v1/asset_service.proto#L1726}
  ///
  // clang-format on
  StatusOr<google::cloud::asset::v1::SavedQuery> UpdateSavedQuery(
      google::cloud::asset::v1::UpdateSavedQueryRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// Deletes a saved query.
  ///
  /// @param name  Required. The name of the saved query to delete. It must be in the format
  ///  of:
  ///  @n
  ///  * projects/project_number/savedQueries/saved_query_id
  ///  * folders/folder_number/savedQueries/saved_query_id
  ///  * organizations/organization_number/savedQueries/saved_query_id
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [`Status`] object. If the request failed, the
  ///     status contains the details of the failure.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.asset.v1.DeleteSavedQueryRequest]: @googleapis_reference_link{google/cloud/asset/v1/asset_service.proto#L1743}
  ///
  // clang-format on
  Status DeleteSavedQuery(std::string const& name, Options opts = {});

  // clang-format off
  ///
  /// Deletes a saved query.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.asset.v1.DeleteSavedQueryRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [`Status`] object. If the request failed, the
  ///     status contains the details of the failure.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.asset.v1.DeleteSavedQueryRequest]: @googleapis_reference_link{google/cloud/asset/v1/asset_service.proto#L1743}
  ///
  // clang-format on
  Status DeleteSavedQuery(
      google::cloud::asset::v1::DeleteSavedQueryRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// Gets effective IAM policies for a batch of resources.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.asset.v1.BatchGetEffectiveIamPoliciesRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.asset.v1.BatchGetEffectiveIamPoliciesResponse])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.asset.v1.BatchGetEffectiveIamPoliciesRequest]: @googleapis_reference_link{google/cloud/asset/v1/asset_service.proto#L2036}
  /// [google.cloud.asset.v1.BatchGetEffectiveIamPoliciesResponse]: @googleapis_reference_link{google/cloud/asset/v1/asset_service.proto#L2066}
  ///
  // clang-format on
  StatusOr<google::cloud::asset::v1::BatchGetEffectiveIamPoliciesResponse>
  BatchGetEffectiveIamPolicies(
      google::cloud::asset::v1::BatchGetEffectiveIamPoliciesRequest const&
          request,
      Options opts = {});

  // clang-format off
  ///
  /// Analyzes organization policies under a scope.
  ///
  /// @param scope  Required. The organization to scope the request. Only organization
  ///  policies within the scope will be analyzed.
  ///  @n
  ///  * organizations/{ORGANIZATION_NUMBER} (e.g., "organizations/123456")
  /// @param constraint  Required. The name of the constraint to analyze organization policies for.
  ///  The response only contains analyzed organization policies for the provided
  ///  constraint.
  /// @param filter  The expression to filter
  ///  [AnalyzeOrgPoliciesResponse.org_policy_results][google.cloud.asset.v1.AnalyzeOrgPoliciesResponse.org_policy_results].
  ///  The only supported field is `consolidated_policy.attached_resource`, and
  ///  the only supported operator is `=`.
  ///  @n
  ///  Example:
  ///  consolidated_policy.attached_resource="//cloudresourcemanager.googleapis.com/folders/001"
  ///  will return the org policy results of"folders/001".
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [StreamRange](@ref google::cloud::StreamRange)
  ///     to iterate of the results. See the documentation of this type for
  ///     details. In brief, this class has `begin()` and `end()` member
  ///     functions returning a iterator class meeting the
  ///     [input iterator requirements]. The value type for this iterator is a
  ///     [`StatusOr`] as the iteration may fail even after some values are
  ///     retrieved successfully, for example, if there is a network disconnect.
  ///     An empty set of results does not indicate an error, it indicates
  ///     that there are no resources meeting the request criteria.
  ///     On a successful iteration the `StatusOr<T>` contains elements of type
  ///     [google.cloud.asset.v1.AnalyzeOrgPoliciesResponse.OrgPolicyResult], or rather,
  ///     the C++ class generated by Protobuf from that type. Please consult the
  ///     Protobuf documentation for details on the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.asset.v1.AnalyzeOrgPoliciesRequest]: @googleapis_reference_link{google/cloud/asset/v1/asset_service.proto#L2344}
  /// [google.cloud.asset.v1.AnalyzeOrgPoliciesResponse.OrgPolicyResult]: @googleapis_reference_link{google/cloud/asset/v1/asset_service.proto#L2379}
  ///
  // clang-format on
  StreamRange<
      google::cloud::asset::v1::AnalyzeOrgPoliciesResponse::OrgPolicyResult>
  AnalyzeOrgPolicies(std::string const& scope, std::string const& constraint,
                     std::string const& filter, Options opts = {});

  // clang-format off
  ///
  /// Analyzes organization policies under a scope.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.asset.v1.AnalyzeOrgPoliciesRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [StreamRange](@ref google::cloud::StreamRange)
  ///     to iterate of the results. See the documentation of this type for
  ///     details. In brief, this class has `begin()` and `end()` member
  ///     functions returning a iterator class meeting the
  ///     [input iterator requirements]. The value type for this iterator is a
  ///     [`StatusOr`] as the iteration may fail even after some values are
  ///     retrieved successfully, for example, if there is a network disconnect.
  ///     An empty set of results does not indicate an error, it indicates
  ///     that there are no resources meeting the request criteria.
  ///     On a successful iteration the `StatusOr<T>` contains elements of type
  ///     [google.cloud.asset.v1.AnalyzeOrgPoliciesResponse.OrgPolicyResult], or rather,
  ///     the C++ class generated by Protobuf from that type. Please consult the
  ///     Protobuf documentation for details on the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.asset.v1.AnalyzeOrgPoliciesRequest]: @googleapis_reference_link{google/cloud/asset/v1/asset_service.proto#L2344}
  /// [google.cloud.asset.v1.AnalyzeOrgPoliciesResponse.OrgPolicyResult]: @googleapis_reference_link{google/cloud/asset/v1/asset_service.proto#L2379}
  ///
  // clang-format on
  StreamRange<
      google::cloud::asset::v1::AnalyzeOrgPoliciesResponse::OrgPolicyResult>
  AnalyzeOrgPolicies(
      google::cloud::asset::v1::AnalyzeOrgPoliciesRequest request,
      Options opts = {});

  // clang-format off
  ///
  /// Analyzes organization policies governed containers (projects, folders or
  /// organization) under a scope.
  ///
  /// @param scope  Required. The organization to scope the request. Only organization
  ///  policies within the scope will be analyzed. The output containers will
  ///  also be limited to the ones governed by those in-scope organization
  ///  policies.
  ///  @n
  ///  * organizations/{ORGANIZATION_NUMBER} (e.g., "organizations/123456")
  /// @param constraint  Required. The name of the constraint to analyze governed containers for.
  ///  The analysis only contains organization policies for the provided
  ///  constraint.
  /// @param filter  The expression to filter the governed containers in result.
  ///  The only supported field is `parent`, and the only supported operator is
  ///  `=`.
  ///  @n
  ///  Example:
  ///  parent="//cloudresourcemanager.googleapis.com/folders/001" will return all
  ///  containers under "folders/001".
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [StreamRange](@ref google::cloud::StreamRange)
  ///     to iterate of the results. See the documentation of this type for
  ///     details. In brief, this class has `begin()` and `end()` member
  ///     functions returning a iterator class meeting the
  ///     [input iterator requirements]. The value type for this iterator is a
  ///     [`StatusOr`] as the iteration may fail even after some values are
  ///     retrieved successfully, for example, if there is a network disconnect.
  ///     An empty set of results does not indicate an error, it indicates
  ///     that there are no resources meeting the request criteria.
  ///     On a successful iteration the `StatusOr<T>` contains elements of type
  ///     [google.cloud.asset.v1.AnalyzeOrgPolicyGovernedContainersResponse.GovernedContainer], or rather,
  ///     the C++ class generated by Protobuf from that type. Please consult the
  ///     Protobuf documentation for details on the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.asset.v1.AnalyzeOrgPolicyGovernedContainersRequest]: @googleapis_reference_link{google/cloud/asset/v1/asset_service.proto#L2412}
  /// [google.cloud.asset.v1.AnalyzeOrgPolicyGovernedContainersResponse.GovernedContainer]: @googleapis_reference_link{google/cloud/asset/v1/asset_service.proto#L2450}
  ///
  // clang-format on
  StreamRange<google::cloud::asset::v1::
                  AnalyzeOrgPolicyGovernedContainersResponse::GovernedContainer>
  AnalyzeOrgPolicyGovernedContainers(std::string const& scope,
                                     std::string const& constraint,
                                     std::string const& filter,
                                     Options opts = {});

  // clang-format off
  ///
  /// Analyzes organization policies governed containers (projects, folders or
  /// organization) under a scope.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.asset.v1.AnalyzeOrgPolicyGovernedContainersRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [StreamRange](@ref google::cloud::StreamRange)
  ///     to iterate of the results. See the documentation of this type for
  ///     details. In brief, this class has `begin()` and `end()` member
  ///     functions returning a iterator class meeting the
  ///     [input iterator requirements]. The value type for this iterator is a
  ///     [`StatusOr`] as the iteration may fail even after some values are
  ///     retrieved successfully, for example, if there is a network disconnect.
  ///     An empty set of results does not indicate an error, it indicates
  ///     that there are no resources meeting the request criteria.
  ///     On a successful iteration the `StatusOr<T>` contains elements of type
  ///     [google.cloud.asset.v1.AnalyzeOrgPolicyGovernedContainersResponse.GovernedContainer], or rather,
  ///     the C++ class generated by Protobuf from that type. Please consult the
  ///     Protobuf documentation for details on the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.asset.v1.AnalyzeOrgPolicyGovernedContainersRequest]: @googleapis_reference_link{google/cloud/asset/v1/asset_service.proto#L2412}
  /// [google.cloud.asset.v1.AnalyzeOrgPolicyGovernedContainersResponse.GovernedContainer]: @googleapis_reference_link{google/cloud/asset/v1/asset_service.proto#L2450}
  ///
  // clang-format on
  StreamRange<google::cloud::asset::v1::
                  AnalyzeOrgPolicyGovernedContainersResponse::GovernedContainer>
  AnalyzeOrgPolicyGovernedContainers(
      google::cloud::asset::v1::AnalyzeOrgPolicyGovernedContainersRequest
          request,
      Options opts = {});

  // clang-format off
  ///
  /// Analyzes organization policies governed assets (Google Cloud resources or
  /// policies) under a scope. This RPC supports custom constraints and the
  /// following 10 canned constraints:
  ///
  /// * storage.uniformBucketLevelAccess
  /// * iam.disableServiceAccountKeyCreation
  /// * iam.allowedPolicyMemberDomains
  /// * compute.vmExternalIpAccess
  /// * appengine.enforceServiceAccountActAsCheck
  /// * gcp.resourceLocations
  /// * compute.trustedImageProjects
  /// * compute.skipDefaultNetworkCreation
  /// * compute.requireOsLogin
  /// * compute.disableNestedVirtualization
  ///
  /// This RPC only returns either resources of types supported by [searchable
  /// asset
  /// types](https://cloud.google.com/asset-inventory/docs/supported-asset-types#searchable_asset_types),
  /// or IAM policies.
  ///
  /// @param scope  Required. The organization to scope the request. Only organization
  ///  policies within the scope will be analyzed. The output assets will
  ///  also be limited to the ones governed by those in-scope organization
  ///  policies.
  ///  @n
  ///  * organizations/{ORGANIZATION_NUMBER} (e.g., "organizations/123456")
  /// @param constraint  Required. The name of the constraint to analyze governed assets for. The
  ///  analysis only contains analyzed organization policies for the provided
  ///  constraint.
  /// @param filter  The expression to filter the governed assets in result. The only supported
  ///  fields for governed resources are `governed_resource.project` and
  ///  `governed_resource.folders`. The only supported fields for governed iam
  ///  policies are `governed_iam_policy.project` and
  ///  `governed_iam_policy.folders`. The only supported operator is `=`.
  ///  @n
  ///  Example 1: governed_resource.project="projects/12345678" filter will return
  ///  all governed resources under projects/12345678 including the project
  ///  ifself, if applicable.
  ///  @n
  ///  Example 2: governed_iam_policy.folders="folders/12345678" filter will
  ///  return all governed iam policies under folders/12345678, if applicable.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [StreamRange](@ref google::cloud::StreamRange)
  ///     to iterate of the results. See the documentation of this type for
  ///     details. In brief, this class has `begin()` and `end()` member
  ///     functions returning a iterator class meeting the
  ///     [input iterator requirements]. The value type for this iterator is a
  ///     [`StatusOr`] as the iteration may fail even after some values are
  ///     retrieved successfully, for example, if there is a network disconnect.
  ///     An empty set of results does not indicate an error, it indicates
  ///     that there are no resources meeting the request criteria.
  ///     On a successful iteration the `StatusOr<T>` contains elements of type
  ///     [google.cloud.asset.v1.AnalyzeOrgPolicyGovernedAssetsResponse.GovernedAsset], or rather,
  ///     the C++ class generated by Protobuf from that type. Please consult the
  ///     Protobuf documentation for details on the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.asset.v1.AnalyzeOrgPolicyGovernedAssetsRequest]: @googleapis_reference_link{google/cloud/asset/v1/asset_service.proto#L2491}
  /// [google.cloud.asset.v1.AnalyzeOrgPolicyGovernedAssetsResponse.GovernedAsset]: @googleapis_reference_link{google/cloud/asset/v1/asset_service.proto#L2594}
  ///
  // clang-format on
  StreamRange<google::cloud::asset::v1::AnalyzeOrgPolicyGovernedAssetsResponse::
                  GovernedAsset>
  AnalyzeOrgPolicyGovernedAssets(std::string const& scope,
                                 std::string const& constraint,
                                 std::string const& filter, Options opts = {});

  // clang-format off
  ///
  /// Analyzes organization policies governed assets (Google Cloud resources or
  /// policies) under a scope. This RPC supports custom constraints and the
  /// following 10 canned constraints:
  ///
  /// * storage.uniformBucketLevelAccess
  /// * iam.disableServiceAccountKeyCreation
  /// * iam.allowedPolicyMemberDomains
  /// * compute.vmExternalIpAccess
  /// * appengine.enforceServiceAccountActAsCheck
  /// * gcp.resourceLocations
  /// * compute.trustedImageProjects
  /// * compute.skipDefaultNetworkCreation
  /// * compute.requireOsLogin
  /// * compute.disableNestedVirtualization
  ///
  /// This RPC only returns either resources of types supported by [searchable
  /// asset
  /// types](https://cloud.google.com/asset-inventory/docs/supported-asset-types#searchable_asset_types),
  /// or IAM policies.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.asset.v1.AnalyzeOrgPolicyGovernedAssetsRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [StreamRange](@ref google::cloud::StreamRange)
  ///     to iterate of the results. See the documentation of this type for
  ///     details. In brief, this class has `begin()` and `end()` member
  ///     functions returning a iterator class meeting the
  ///     [input iterator requirements]. The value type for this iterator is a
  ///     [`StatusOr`] as the iteration may fail even after some values are
  ///     retrieved successfully, for example, if there is a network disconnect.
  ///     An empty set of results does not indicate an error, it indicates
  ///     that there are no resources meeting the request criteria.
  ///     On a successful iteration the `StatusOr<T>` contains elements of type
  ///     [google.cloud.asset.v1.AnalyzeOrgPolicyGovernedAssetsResponse.GovernedAsset], or rather,
  ///     the C++ class generated by Protobuf from that type. Please consult the
  ///     Protobuf documentation for details on the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.asset.v1.AnalyzeOrgPolicyGovernedAssetsRequest]: @googleapis_reference_link{google/cloud/asset/v1/asset_service.proto#L2491}
  /// [google.cloud.asset.v1.AnalyzeOrgPolicyGovernedAssetsResponse.GovernedAsset]: @googleapis_reference_link{google/cloud/asset/v1/asset_service.proto#L2594}
  ///
  // clang-format on
  StreamRange<google::cloud::asset::v1::AnalyzeOrgPolicyGovernedAssetsResponse::
                  GovernedAsset>
  AnalyzeOrgPolicyGovernedAssets(
      google::cloud::asset::v1::AnalyzeOrgPolicyGovernedAssetsRequest request,
      Options opts = {});

 private:
  std::shared_ptr<AssetServiceConnection> connection_;
  Options options_;
};

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace asset_v1
}  // namespace cloud
}  // namespace google

#endif  // GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_ASSET_V1_ASSET_CLIENT_H
