// Copyright 2023 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/aiplatform/v1/vizier_service.proto

#ifndef GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_AIPLATFORM_V1_VIZIER_CONNECTION_IDEMPOTENCY_POLICY_H
#define GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_AIPLATFORM_V1_VIZIER_CONNECTION_IDEMPOTENCY_POLICY_H

#include "google/cloud/idempotency.h"
#include "google/cloud/version.h"
#include <google/cloud/aiplatform/v1/vizier_service.grpc.pb.h>
#include <memory>

namespace google {
namespace cloud {
namespace aiplatform_v1 {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

class VizierServiceConnectionIdempotencyPolicy {
 public:
  virtual ~VizierServiceConnectionIdempotencyPolicy();

  /// Create a new copy of this object.
  virtual std::unique_ptr<VizierServiceConnectionIdempotencyPolicy> clone()
      const;

  virtual google::cloud::Idempotency CreateStudy(
      google::cloud::aiplatform::v1::CreateStudyRequest const& request);

  virtual google::cloud::Idempotency GetStudy(
      google::cloud::aiplatform::v1::GetStudyRequest const& request);

  virtual google::cloud::Idempotency ListStudies(
      google::cloud::aiplatform::v1::ListStudiesRequest request);

  virtual google::cloud::Idempotency DeleteStudy(
      google::cloud::aiplatform::v1::DeleteStudyRequest const& request);

  virtual google::cloud::Idempotency LookupStudy(
      google::cloud::aiplatform::v1::LookupStudyRequest const& request);

  virtual google::cloud::Idempotency SuggestTrials(
      google::cloud::aiplatform::v1::SuggestTrialsRequest const& request);

  virtual google::cloud::Idempotency CreateTrial(
      google::cloud::aiplatform::v1::CreateTrialRequest const& request);

  virtual google::cloud::Idempotency GetTrial(
      google::cloud::aiplatform::v1::GetTrialRequest const& request);

  virtual google::cloud::Idempotency ListTrials(
      google::cloud::aiplatform::v1::ListTrialsRequest request);

  virtual google::cloud::Idempotency AddTrialMeasurement(
      google::cloud::aiplatform::v1::AddTrialMeasurementRequest const& request);

  virtual google::cloud::Idempotency CompleteTrial(
      google::cloud::aiplatform::v1::CompleteTrialRequest const& request);

  virtual google::cloud::Idempotency DeleteTrial(
      google::cloud::aiplatform::v1::DeleteTrialRequest const& request);

  virtual google::cloud::Idempotency CheckTrialEarlyStoppingState(
      google::cloud::aiplatform::v1::CheckTrialEarlyStoppingStateRequest const&
          request);

  virtual google::cloud::Idempotency StopTrial(
      google::cloud::aiplatform::v1::StopTrialRequest const& request);

  virtual google::cloud::Idempotency ListOptimalTrials(
      google::cloud::aiplatform::v1::ListOptimalTrialsRequest const& request);
};

std::unique_ptr<VizierServiceConnectionIdempotencyPolicy>
MakeDefaultVizierServiceConnectionIdempotencyPolicy();

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace aiplatform_v1
}  // namespace cloud
}  // namespace google

#endif  // GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_AIPLATFORM_V1_VIZIER_CONNECTION_IDEMPOTENCY_POLICY_H
