// Copyright 2023 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/aiplatform/v1/pipeline_service.proto

#ifndef GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_AIPLATFORM_V1_PIPELINE_CONNECTION_IDEMPOTENCY_POLICY_H
#define GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_AIPLATFORM_V1_PIPELINE_CONNECTION_IDEMPOTENCY_POLICY_H

#include "google/cloud/idempotency.h"
#include "google/cloud/version.h"
#include <google/cloud/aiplatform/v1/pipeline_service.grpc.pb.h>
#include <memory>

namespace google {
namespace cloud {
namespace aiplatform_v1 {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

class PipelineServiceConnectionIdempotencyPolicy {
 public:
  virtual ~PipelineServiceConnectionIdempotencyPolicy();

  /// Create a new copy of this object.
  virtual std::unique_ptr<PipelineServiceConnectionIdempotencyPolicy> clone()
      const;

  virtual google::cloud::Idempotency CreateTrainingPipeline(
      google::cloud::aiplatform::v1::CreateTrainingPipelineRequest const&
          request);

  virtual google::cloud::Idempotency GetTrainingPipeline(
      google::cloud::aiplatform::v1::GetTrainingPipelineRequest const& request);

  virtual google::cloud::Idempotency ListTrainingPipelines(
      google::cloud::aiplatform::v1::ListTrainingPipelinesRequest request);

  virtual google::cloud::Idempotency DeleteTrainingPipeline(
      google::cloud::aiplatform::v1::DeleteTrainingPipelineRequest const&
          request);

  virtual google::cloud::Idempotency CancelTrainingPipeline(
      google::cloud::aiplatform::v1::CancelTrainingPipelineRequest const&
          request);

  virtual google::cloud::Idempotency CreatePipelineJob(
      google::cloud::aiplatform::v1::CreatePipelineJobRequest const& request);

  virtual google::cloud::Idempotency GetPipelineJob(
      google::cloud::aiplatform::v1::GetPipelineJobRequest const& request);

  virtual google::cloud::Idempotency ListPipelineJobs(
      google::cloud::aiplatform::v1::ListPipelineJobsRequest request);

  virtual google::cloud::Idempotency DeletePipelineJob(
      google::cloud::aiplatform::v1::DeletePipelineJobRequest const& request);

  virtual google::cloud::Idempotency CancelPipelineJob(
      google::cloud::aiplatform::v1::CancelPipelineJobRequest const& request);
};

std::unique_ptr<PipelineServiceConnectionIdempotencyPolicy>
MakeDefaultPipelineServiceConnectionIdempotencyPolicy();

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace aiplatform_v1
}  // namespace cloud
}  // namespace google

#endif  // GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_AIPLATFORM_V1_PIPELINE_CONNECTION_IDEMPOTENCY_POLICY_H
