/*
 * Decompiled with CFR 0.152.
 */
package org.virtuslab.yaml.internal.load.reader;

import java.io.Serializable;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CoderResult;
import scala.runtime.LazyRef;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.Nothing$;

public final class UrlDecoder$
implements Serializable {
    public static final UrlDecoder$ MODULE$ = new UrlDecoder$();

    private UrlDecoder$() {
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(UrlDecoder$.class);
    }

    public String decode(String s) {
        LazyRef lazyRef = new LazyRef();
        LazyRef lazyRef2 = new LazyRef();
        Charset charset = Charset.defaultCharset();
        int len = s.length();
        CharBuffer charBuffer = CharBuffer.allocate(len);
        int i = 0;
        while (i < len) {
            char c = s.charAt(i);
            if ('+' == c) {
                charBuffer.append(' ');
                ++i;
                continue;
            }
            if ('%' == c) {
                if (i + 3 > len) {
                    throw this.throwIllegalHex$1();
                }
                CharsetDecoder decoder = this.charsetDecoder$1(lazyRef, charset);
                ByteBuffer buffer = this.byteBuffer$1(lazyRef2, len);
                buffer.clear();
                decoder.reset();
                while (i + 3 <= len && s.charAt(i) == '%') {
                    int c1 = Character.digit(s.charAt(i + 1), 16);
                    int c2 = Character.digit(s.charAt(i + 2), 16);
                    if (c1 < 0 || c2 < 0) {
                        throw this.throwIllegalHex$1();
                    }
                    buffer.put((byte)((c1 << 4) + c2));
                    i += 3;
                }
                buffer.flip();
                CoderResult decodeResult = decoder.decode(buffer, charBuffer, true);
                CoderResult flushResult = decoder.flush(charBuffer);
                if (!decodeResult.isError() && !flushResult.isError()) continue;
                throw this.throwIllegalHex$1();
            }
            char c2 = c;
            charBuffer.append(c2);
            ++i;
        }
        charBuffer.flip();
        return charBuffer.toString();
    }

    private final CharsetDecoder charsetDecoder$lzyINIT1$1(LazyRef charsetDecoder$lzy1$1, Charset charset$1) {
        CharsetDecoder charsetDecoder;
        LazyRef lazyRef = charsetDecoder$lzy1$1;
        synchronized (lazyRef) {
            charsetDecoder = (CharsetDecoder)(charsetDecoder$lzy1$1.initialized() ? charsetDecoder$lzy1$1.value() : charsetDecoder$lzy1$1.initialize(charset$1.newDecoder()));
        }
        return charsetDecoder;
    }

    private final CharsetDecoder charsetDecoder$1(LazyRef charsetDecoder$lzy1$2, Charset charset$2) {
        return (CharsetDecoder)(charsetDecoder$lzy1$2.initialized() ? charsetDecoder$lzy1$2.value() : this.charsetDecoder$lzyINIT1$1(charsetDecoder$lzy1$2, charset$2));
    }

    private final ByteBuffer byteBuffer$lzyINIT1$1(LazyRef byteBuffer$lzy1$1, int len$1) {
        ByteBuffer byteBuffer;
        LazyRef lazyRef = byteBuffer$lzy1$1;
        synchronized (lazyRef) {
            byteBuffer = (ByteBuffer)(byteBuffer$lzy1$1.initialized() ? byteBuffer$lzy1$1.value() : byteBuffer$lzy1$1.initialize(ByteBuffer.allocate(len$1 / 3)));
        }
        return byteBuffer;
    }

    private final ByteBuffer byteBuffer$1(LazyRef byteBuffer$lzy1$2, int len$2) {
        return (ByteBuffer)(byteBuffer$lzy1$2.initialized() ? byteBuffer$lzy1$2.value() : this.byteBuffer$lzyINIT1$1(byteBuffer$lzy1$2, len$2));
    }

    private final Nothing$ throwIllegalHex$1() {
        throw new IllegalArgumentException("URLDecoder: Illegal hex characters in escape (%) pattern");
    }
}

