/*
 * Decompiled with CFR 0.152.
 */
package org.rogach.scallop.tokenize;

public class StringView {
    private final String underlying;
    private final int offset;

    public StringView(String underlying, int offset) {
        this.underlying = underlying;
        this.offset = offset;
    }

    public StringView substring(int beginIndex) {
        return new StringView(this.underlying, this.offset + beginIndex);
    }

    public String extract(int beginIndex, int endIndex) {
        return this.underlying.substring(this.offset + beginIndex, this.offset + endIndex);
    }

    public int length() {
        return this.underlying.length() - this.offset;
    }

    public char charAt(int index) {
        return this.underlying.charAt(this.offset + index);
    }

    public int indexOf(int ch, int fromIndex) {
        int index = this.underlying.indexOf(ch, this.offset + fromIndex);
        return index == -1 ? index : index - this.offset;
    }

    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("StringView(");
        b.append(this.underlying, this.offset, this.underlying.length());
        b.append(")");
        return b.toString();
    }
}

