/*
 * Decompiled with CFR 0.152.
 */
package org.mvel;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.mvel.ErrorDetail;
import org.mvel.integration.Interceptor;

public class ParserContext {
    private String sourceFile;
    private int lineCount = 1;
    private int lineOffset;
    protected Map<String, Class> imports;
    protected Map<String, Interceptor> interceptors;
    private Map<String, Class> variables;
    private Map<String, Class> inputs;
    private List<ErrorDetail> errorList;
    private Object rootParser;
    private boolean compiled = false;
    private boolean strictTypeEnforcement = false;
    private boolean fatalError = false;
    private boolean retainParserState = false;
    private boolean debugSymbols = false;

    public ParserContext() {
    }

    public ParserContext(boolean debugSymbols) {
        this.debugSymbols = debugSymbols;
    }

    public ParserContext(Object rootParser) {
        this.rootParser = rootParser;
    }

    public ParserContext(Map<String, Class> imports, Map<String, Interceptor> interceptors, String sourceFile) {
        this.imports = imports;
        this.interceptors = interceptors;
        this.sourceFile = sourceFile;
    }

    public boolean hasVarOrInput(String name) {
        return this.variables != null && this.variables.containsKey(name) || this.inputs != null && this.inputs.containsKey(name);
    }

    public Class getVarOrInputType(String name) {
        if (this.variables != null && this.variables.containsKey(name)) {
            return this.variables.get(name);
        }
        if (this.inputs != null && this.inputs.containsKey(name)) {
            return this.inputs.get(name);
        }
        return Object.class;
    }

    public int getLineCount() {
        return this.lineCount;
    }

    public void setLineCount(int lineCount) {
        this.lineCount = lineCount;
    }

    public int getLineOffset() {
        return this.lineOffset;
    }

    public void setLineOffset(int lineOffset) {
        this.lineOffset = lineOffset;
    }

    public void setLineAndOffset(int lineCount, int lineOffset) {
        this.lineCount = lineCount;
        this.lineOffset = lineOffset;
    }

    public Class getImport(String name) {
        return this.imports != null ? this.imports.get(name) : null;
    }

    public boolean hasImport(String name) {
        return this.imports != null && this.imports.containsKey(name);
    }

    public void addImport(String name, Class cls) {
        if (this.imports == null) {
            this.imports = new HashMap<String, Class>();
        }
        this.imports.put(name, cls);
    }

    public void initializeTables() {
        if (this.variables == null) {
            this.variables = new HashMap<String, Class>();
        }
        if (this.inputs == null) {
            this.inputs = new HashMap<String, Class>();
        }
    }

    public void addVariable(String name, Class type) {
        if (this.variables.containsKey(name)) {
            return;
        }
        if (type == null) {
            type = Object.class;
        }
        this.variables.put(name, type);
    }

    public void addInput(String name, Class type) {
        if (this.inputs == null) {
            this.inputs = new HashMap<String, Class>();
        }
        if (this.inputs.containsKey(name)) {
            return;
        }
        if (type == null) {
            type = Object.class;
        }
        this.inputs.put(name, type);
    }

    public void processTables() {
        for (String name : this.variables.keySet()) {
            this.inputs.remove(name);
        }
    }

    public Map<String, Class> getInputs() {
        return this.inputs;
    }

    public void setInputs(Map<String, Class> inputs) {
        this.inputs = inputs;
    }

    public List<ErrorDetail> getErrorList() {
        return this.errorList;
    }

    public void setErrorList(List<ErrorDetail> errorList) {
        this.errorList = errorList;
    }

    public void addError(ErrorDetail errorDetail) {
        if (this.errorList == null) {
            this.errorList = new ArrayList<ErrorDetail>();
        }
        if (errorDetail.isCritical()) {
            this.fatalError = true;
        }
        this.errorList.add(errorDetail);
    }

    public boolean isFatalError() {
        return this.fatalError;
    }

    public void setFatalError(boolean fatalError) {
        this.fatalError = fatalError;
    }

    public boolean isStrictTypeEnforcement() {
        return this.strictTypeEnforcement;
    }

    public void setStrictTypeEnforcement(boolean strictTypeEnforcement) {
        this.strictTypeEnforcement = strictTypeEnforcement;
    }

    public boolean isRetainParserState() {
        return this.retainParserState;
    }

    public void setRetainParserState(boolean retainParserState) {
        this.retainParserState = retainParserState;
    }

    public Object getRootParser() {
        return this.rootParser;
    }

    public void setRootParser(Object rootParser) {
        this.rootParser = rootParser;
    }

    public String getSourceFile() {
        return this.sourceFile;
    }

    public void setSourceFile(String sourceFile) {
        if (sourceFile != null) {
            this.sourceFile = sourceFile;
        }
    }

    public Map<String, Interceptor> getInterceptors() {
        return this.interceptors;
    }

    public void setInterceptors(Map<String, Interceptor> interceptors) {
        this.interceptors = interceptors;
    }

    public Map<String, Class> getImports() {
        return this.imports;
    }

    public void setImports(Map<String, Class> imports) {
        if (imports == null) {
            return;
        }
        if (this.imports != null) {
            this.imports.putAll(imports);
        } else {
            this.imports = imports;
        }
    }

    public Map<String, Class> getVariables() {
        return this.variables;
    }

    public void setVariables(Map<String, Class> variables) {
        this.variables = variables;
    }

    public boolean isCompiled() {
        return this.compiled;
    }

    public void setCompiled(boolean compiled) {
        this.compiled = compiled;
    }

    public boolean isDebugSymbols() {
        return this.debugSymbols;
    }

    public void setDebugSymbols(boolean debugSymbols) {
        this.debugSymbols = debugSymbols;
    }
}

