/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.core.io.websocket.log;

import com.google.gson.Gson;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jetty.websocket.servlet.ServletUpgradeRequest;
import org.eclipse.jetty.websocket.servlet.ServletUpgradeResponse;
import org.openhab.core.io.websocket.WebSocketAdapter;
import org.openhab.core.io.websocket.log.LogWebSocket;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.log.LogListener;
import org.osgi.service.log.LogReaderService;

@NonNullByDefault
@Component(immediate=true, service={WebSocketAdapter.class})
public class LogWebSocketAdapter
implements WebSocketAdapter {
    public static final String ADAPTER_ID = "logs";
    private final Gson gson = new Gson();
    private final Set<LogWebSocket> webSockets = new CopyOnWriteArraySet<LogWebSocket>();
    private final LogReaderService logReaderService;

    @Activate
    public LogWebSocketAdapter(@Reference LogReaderService logReaderService) {
        this.logReaderService = logReaderService;
    }

    @Deactivate
    public void deactivate() {
        this.webSockets.forEach(arg_0 -> ((LogReaderService)this.logReaderService).removeLogListener(arg_0));
    }

    public void registerListener(LogWebSocket eventWebSocket) {
        this.webSockets.add(eventWebSocket);
        this.logReaderService.addLogListener((LogListener)eventWebSocket);
    }

    public void unregisterListener(LogWebSocket eventWebSocket) {
        this.logReaderService.removeLogListener((LogListener)eventWebSocket);
        this.webSockets.remove(eventWebSocket);
    }

    @Override
    public String getId() {
        return ADAPTER_ID;
    }

    @Override
    public Object createWebSocket(ServletUpgradeRequest servletUpgradeRequest, ServletUpgradeResponse servletUpgradeResponse) {
        return new LogWebSocket(this.gson, this);
    }
}

